/*
 * Copyright (c) 2023. Helge Eichhorn and the LOX contributors
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, you can obtain one at https://mozilla.org/MPL/2.0/.
 */

use crate::nutation::iau2000::LuniSolarCoefficients;

#[rustfmt::skip]
// @formatter:off (sometimes RustRover ignores the rustfmt skip)
pub(super) static COEFFICIENTS: [LuniSolarCoefficients; 678] = [
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  0.0,  d:  0.0,  om:  1.0, sin_psi: -172064161.0,    sin_psi_t: -174666.0,   cos_psi:  33386.0,    cos_eps:  92052331.0, cos_eps_t:  9086.0, sin_eps:  15377.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  2.0,  d: -2.0,  om:  2.0, sin_psi: -13170906.0,     sin_psi_t: -1675.0,     cos_psi: -13696.0,    cos_eps:  5730336.0,  cos_eps_t: -3015.0, sin_eps: -4587.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi: -2276413.0,      sin_psi_t: -234.0,      cos_psi:  2796.0,     cos_eps:  978459.0,   cos_eps_t: -485.0,  sin_eps:  1374.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  0.0,  d:  0.0,  om:  2.0, sin_psi: 2074554.0,       sin_psi_t:  207.0,      cos_psi:  -698.0,     cos_eps: -897492.0,   cos_eps_t:  470.0,  sin_eps: -291.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  0.0,  d:  0.0,  om:  0.0, sin_psi: 1475877.0,       sin_psi_t: -3633.0,     cos_psi: 11817.0,     cos_eps: 73871.0,     cos_eps_t: -184.0,  sin_eps:-1924.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  2.0,  d: -2.0,  om:  2.0, sin_psi: -516821.0,       sin_psi_t:  1226.0,     cos_psi:  -524.0,     cos_eps: 224386.0,    cos_eps_t: -677.0,  sin_eps: -174.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  0.0,  d:  0.0,  om:  0.0, sin_psi:  711159.0,       sin_psi_t:   73.0,      cos_psi:  -872.0,     cos_eps:   -6750.0,   cos_eps_t:  0.0,    sin_eps:  358.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  1.0, sin_psi: -387298.0,       sin_psi_t: -367.0,      cos_psi:   380.0,     cos_eps:  200728.0,   cos_eps_t: 18.0,    sin_eps:  318.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi: -301461.0,       sin_psi_t:  -36.0,      cos_psi:   816.0,     cos_eps:  129025.0,   cos_eps_t:-63.0,    sin_eps:  367.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -1.0, f:  2.0,  d: -2.0,  om:  2.0, sin_psi:  215829.0,       sin_psi_t: -494.0,      cos_psi:   111.0,     cos_eps:  -95929.0,   cos_eps_t:299.0,    sin_eps:  132.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  2.0,  d: -2.0,  om:  1.0, sin_psi:  128227.0,       sin_psi_t:  137.0,      cos_psi:   181.0,     cos_eps:  -68982.0,   cos_eps_t: -9.0,    sin_eps:   39.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:  123457.0,       sin_psi_t:   11.0,      cos_psi:    19.0,     cos_eps:  -53311.0,   cos_eps_t: 32.0,    sin_eps:   -4.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:  156994.0,       sin_psi_t:   10.0,      cos_psi:  -168.0,     cos_eps:   -1235.0,   cos_eps_t:  0.0,    sin_eps:   82.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  0.0,  d:  0.0,  om:  1.0, sin_psi:   63110.0,       sin_psi_t:   63.0,      cos_psi:    27.0,     cos_eps:  -33228.0,   cos_eps_t:  0.0,    sin_eps:   -9.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  0.0,  d:  0.0,  om:  1.0, sin_psi:  -57976.0,       sin_psi_t:  -63.0,      cos_psi:  -189.0,     cos_eps:   31429.0,   cos_eps_t:  0.0,    sin_eps:  -75.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:  -59641.0,       sin_psi_t:  -11.0,      cos_psi:   149.0,     cos_eps:   25543.0,   cos_eps_t:-11.0,    sin_eps:   66.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  1.0, sin_psi:  -51613.0,       sin_psi_t:  -42.0,      cos_psi:   129.0,     cos_eps:   26366.0,   cos_eps_t:  0.0,    sin_eps:   78.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  1.0, sin_psi:   45893.0,       sin_psi_t:   50.0,      cos_psi:    31.0,     cos_eps:  -24236.0,   cos_eps_t:-10.0,    sin_eps:   20.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:   63384.0,       sin_psi_t:   11.0,      cos_psi:  -150.0,     cos_eps:   -1220.0,   cos_eps_t:  0.0,    sin_eps:   29.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:  -38571.0,       sin_psi_t:   -1.0,      cos_psi:   158.0,     cos_eps:   16452.0,   cos_eps_t:-11.0,    sin_eps:   68.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -2.0, f:  2.0,  d: -2.0,  om:  2.0, sin_psi:   32481.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:  -13870.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:  -47722.0,       sin_psi_t:    0.0,      cos_psi:   -18.0,     cos_eps:     477.0,   cos_eps_t:  0.0,    sin_eps:  -25.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:  -31046.0,       sin_psi_t:   -1.0,      cos_psi:   131.0,     cos_eps:   13238.0,   cos_eps_t:-11.0,    sin_eps:   59.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  2.0,  d: -2.0,  om:  2.0, sin_psi:   28593.0,       sin_psi_t:    0.0,      cos_psi:    -1.0,     cos_eps:  -12338.0,   cos_eps_t: 10.0,    sin_eps:   -3.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  1.0, sin_psi:   20441.0,       sin_psi_t:   21.0,      cos_psi:    10.0,     cos_eps:  -10758.0,   cos_eps_t:  0.0,    sin_eps:   -3.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  0.0,  d:  0.0,  om:  0.0, sin_psi:   29243.0,       sin_psi_t:    0.0,      cos_psi:   -74.0,     cos_eps:    -609.0,   cos_eps_t:  0.0,    sin_eps:   13.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  0.0, sin_psi:   25887.0,       sin_psi_t:    0.0,      cos_psi:   -66.0,     cos_eps:    -550.0,   cos_eps_t:  0.0,    sin_eps:   11.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  0.0,  d:  0.0,  om:  1.0, sin_psi:  -14053.0,       sin_psi_t:  -25.0,      cos_psi:    79.0,     cos_eps:    8551.0,   cos_eps_t: -2.0,    sin_eps:  -45.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  0.0,  d:  2.0,  om:  1.0, sin_psi:   15164.0,       sin_psi_t:   10.0,      cos_psi:    11.0,     cos_eps:   -8001.0,   cos_eps_t:  0.0,    sin_eps:   -1.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  2.0, f:  2.0,  d: -2.0,  om:  2.0, sin_psi:  -15794.0,       sin_psi_t:   72.0,      cos_psi:   -16.0,     cos_eps:    6850.0,   cos_eps_t:-42.0,    sin_eps:   -5.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f: -2.0,  d:  2.0,  om:  0.0, sin_psi:   21783.0,       sin_psi_t:    0.0,      cos_psi:    13.0,     cos_eps:    -167.0,   cos_eps_t:  0.0,    sin_eps:   13.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  0.0,  d: -2.0,  om:  1.0, sin_psi:  -12873.0,       sin_psi_t:  -10.0,      cos_psi:   -37.0,     cos_eps:    6953.0,   cos_eps_t:  0.0,    sin_eps:  -14.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -1.0, f:  0.0,  d:  0.0,  om:  1.0, sin_psi:  -12654.0,       sin_psi_t:   11.0,      cos_psi:    63.0,     cos_eps:    6415.0,   cos_eps_t:  0.0,    sin_eps:   26.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  2.0,  d:  2.0,  om:  1.0, sin_psi:  -10204.0,       sin_psi_t:    0.0,      cos_psi:    25.0,     cos_eps:    5222.0,   cos_eps_t:  0.0,    sin_eps:   15.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  2.0, f:  0.0,  d:  0.0,  om:  0.0, sin_psi:   16707.0,       sin_psi_t:  -85.0,      cos_psi:   -10.0,     cos_eps:     168.0,   cos_eps_t: -1.0,    sin_eps:   10.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:   -7691.0,       sin_psi_t:    0.0,      cos_psi:    44.0,     cos_eps:    3268.0,   cos_eps_t:  0.0,    sin_eps:   19.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  0.0, sin_psi:  -11024.0,       sin_psi_t:    0.0,      cos_psi:   -14.0,     cos_eps:     104.0,   cos_eps_t:  0.0,    sin_eps:    2.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:    7566.0,       sin_psi_t:  -21.0,      cos_psi:   -11.0,     cos_eps:   -3250.0,   cos_eps_t:  0.0,    sin_eps:   -5.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  2.0,  d:  2.0,  om:  1.0, sin_psi:   -6637.0,       sin_psi_t:  -11.0,      cos_psi:    25.0,     cos_eps:    3353.0,   cos_eps_t:  0.0,    sin_eps:   14.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -1.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:   -7141.0,       sin_psi_t:   21.0,      cos_psi:     8.0,     cos_eps:    3070.0,   cos_eps_t:  0.0,    sin_eps:    4.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  0.0,  d:  2.0,  om:  1.0, sin_psi:   -6302.0,       sin_psi_t:  -11.0,      cos_psi:     2.0,     cos_eps:    3272.0,   cos_eps_t:  0.0,    sin_eps:    4.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  2.0,  d: -2.0,  om:  1.0, sin_psi:    5800.0,       sin_psi_t:   10.0,      cos_psi:     2.0,     cos_eps:   -3045.0,   cos_eps_t:  0.0,    sin_eps:   -1.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  2.0,  d: -2.0,  om:  2.0, sin_psi:    6443.0,       sin_psi_t:    0.0,      cos_psi:    -7.0,     cos_eps:   -2768.0,   cos_eps_t:  0.0,    sin_eps:   -4.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  0.0,  d:  2.0,  om:  1.0, sin_psi:   -5774.0,       sin_psi_t:  -11.0,      cos_psi:   -15.0,     cos_eps:    3041.0,   cos_eps_t:  0.0,    sin_eps:   -5.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  1.0, sin_psi:   -5350.0,       sin_psi_t:    0.0,      cos_psi:    21.0,     cos_eps:    2695.0,   cos_eps_t:  0.0,    sin_eps:   12.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -1.0, f:  2.0,  d: -2.0,  om:  1.0, sin_psi:   -4752.0,       sin_psi_t:  -11.0,      cos_psi:    -3.0,     cos_eps:    2719.0,   cos_eps_t:  0.0,    sin_eps:   -3.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  0.0,  d: -2.0,  om:  1.0, sin_psi:   -4940.0,       sin_psi_t:  -11.0,      cos_psi:   -21.0,     cos_eps:    2720.0,   cos_eps_t:  0.0,    sin_eps:   -9.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -1.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:    7350.0,       sin_psi_t:    0.0,      cos_psi:    -8.0,     cos_eps:     -51.0,   cos_eps_t:  0.0,    sin_eps:    4.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  0.0,  d: -2.0,  om:  1.0, sin_psi:    4065.0,       sin_psi_t:    0.0,      cos_psi:     6.0,     cos_eps:   -2206.0,   cos_eps_t:  0.0,    sin_eps:    1.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:    6579.0,       sin_psi_t:    0.0,      cos_psi:   -24.0,     cos_eps:    -199.0,   cos_eps_t:  0.0,    sin_eps:    2.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  2.0,  d: -2.0,  om:  1.0, sin_psi:    3579.0,       sin_psi_t:    0.0,      cos_psi:     5.0,     cos_eps:   -1900.0,   cos_eps_t:  0.0,    sin_eps:    1.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -1.0, f:  0.0,  d:  0.0,  om:  0.0, sin_psi:    4725.0,       sin_psi_t:    0.0,      cos_psi:    -6.0,     cos_eps:     -41.0,   cos_eps_t:  0.0,    sin_eps:    3.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:   -3075.0,       sin_psi_t:    0.0,      cos_psi:    -2.0,     cos_eps:    1313.0,   cos_eps_t:  0.0,    sin_eps:   -1.0},
    LuniSolarCoefficients{ l:  3.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:   -2904.0,       sin_psi_t:    0.0,      cos_psi:    15.0,     cos_eps:    1233.0,   cos_eps_t:  0.0,    sin_eps:    7.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -1.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:    4348.0,       sin_psi_t:    0.0,      cos_psi:   -10.0,     cos_eps:     -81.0,   cos_eps_t:  0.0,    sin_eps:    2.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -1.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:   -2878.0,       sin_psi_t:    0.0,      cos_psi:     8.0,     cos_eps:    1232.0,   cos_eps_t:  0.0,    sin_eps:    4.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  0.0,  d:  1.0,  om:  0.0, sin_psi:   -4230.0,       sin_psi_t:    0.0,      cos_psi:     5.0,     cos_eps:     -20.0,   cos_eps_t:  0.0,    sin_eps:   -2.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -1.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:   -2819.0,       sin_psi_t:    0.0,      cos_psi:     7.0,     cos_eps:    1207.0,   cos_eps_t:  0.0,    sin_eps:    3.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  0.0, sin_psi:   -4056.0,       sin_psi_t:    0.0,      cos_psi:     5.0,     cos_eps:      40.0,   cos_eps_t:  0.0,    sin_eps:   -2.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -1.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:   -2647.0,       sin_psi_t:    0.0,      cos_psi:    11.0,     cos_eps:    1129.0,   cos_eps_t:  0.0,    sin_eps:    5.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  0.0,  d:  0.0,  om:  1.0, sin_psi:   -2294.0,       sin_psi_t:    0.0,      cos_psi:   -10.0,     cos_eps:    1266.0,   cos_eps_t:  0.0,    sin_eps:   -4.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  1.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:    2481.0,       sin_psi_t:    0.0,      cos_psi:    -7.0,     cos_eps:   -1062.0,   cos_eps_t:  0.0,    sin_eps:   -3.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  0.0,  d:  0.0,  om:  1.0, sin_psi:    2179.0,       sin_psi_t:    0.0,      cos_psi:    -2.0,     cos_eps:   -1129.0,   cos_eps_t:  0.0,    sin_eps:   -2.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  1.0, f:  0.0,  d:  1.0,  om:  0.0, sin_psi:    3276.0,       sin_psi_t:    0.0,      cos_psi:     1.0,     cos_eps:      -9.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  1.0, f:  0.0,  d:  0.0,  om:  0.0, sin_psi:   -3389.0,       sin_psi_t:    0.0,      cos_psi:     5.0,     cos_eps:      35.0,   cos_eps_t:  0.0,    sin_eps:   -2.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  0.0, sin_psi:    3339.0,       sin_psi_t:    0.0,      cos_psi:   -13.0,     cos_eps:    -107.0,   cos_eps_t:  0.0,    sin_eps:    1.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  2.0,  d: -2.0,  om:  1.0, sin_psi:   -1987.0,       sin_psi_t:    0.0,      cos_psi:    -6.0,     cos_eps:    1073.0,   cos_eps_t:  0.0,    sin_eps:   -2.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  0.0,  d:  0.0,  om:  2.0, sin_psi:   -1981.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     854.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  0.0,  d:  1.0,  om:  0.0, sin_psi:    4026.0,       sin_psi_t:    0.0,      cos_psi:  -353.0,     cos_eps:    -553.0,   cos_eps_t:  0.0,    sin_eps: -139.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  2.0,  d:  1.0,  om:  2.0, sin_psi:    1660.0,       sin_psi_t:    0.0,      cos_psi:    -5.0,     cos_eps:    -710.0,   cos_eps_t:  0.0,    sin_eps:   -2.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  2.0,  d:  4.0,  om:  2.0, sin_psi:   -1521.0,       sin_psi_t:    0.0,      cos_psi:     9.0,     cos_eps:     647.0,   cos_eps_t:  0.0,    sin_eps:    4.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  1.0, f:  0.0,  d:  1.0,  om:  1.0, sin_psi:    1314.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:    -700.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -2.0, f:  2.0,  d: -2.0,  om:  1.0, sin_psi:   -1283.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     672.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  2.0,  d:  2.0,  om:  1.0, sin_psi:   -1331.0,       sin_psi_t:    0.0,      cos_psi:     8.0,     cos_eps:     663.0,   cos_eps_t:  0.0,    sin_eps:    4.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:    1383.0,       sin_psi_t:    0.0,      cos_psi:    -2.0,     cos_eps:    -594.0,   cos_eps_t:  0.0,    sin_eps:   -2.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  0.0,  d:  0.0,  om:  2.0, sin_psi:    1405.0,       sin_psi_t:    0.0,      cos_psi:     4.0,     cos_eps:    -610.0,   cos_eps_t:  0.0,    sin_eps:    2.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  1.0, f:  2.0,  d: -2.0,  om:  2.0, sin_psi:    1290.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:    -556.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  2.0,  d:  4.0,  om:  2.0, sin_psi:   -1214.0,       sin_psi_t:    0.0,      cos_psi:     5.0,     cos_eps:     518.0,   cos_eps_t:  0.0,    sin_eps:    2.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  4.0,  d:  0.0,  om:  2.0, sin_psi:    1146.0,       sin_psi_t:    0.0,      cos_psi:    -3.0,     cos_eps:    -490.0,   cos_eps_t:  0.0,    sin_eps:   -1.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  2.0,  d: -2.0,  om:  1.0, sin_psi:    1019.0,       sin_psi_t:    0.0,      cos_psi:    -1.0,     cos_eps:    -527.0,   cos_eps_t:  0.0,    sin_eps:   -1.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:   -1100.0,       sin_psi_t:    0.0,      cos_psi:     9.0,     cos_eps:     465.0,   cos_eps_t:  0.0,    sin_eps:    4.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  0.0,  d:  2.0,  om:  1.0, sin_psi:    -970.0,       sin_psi_t:    0.0,      cos_psi:     2.0,     cos_eps:     496.0,   cos_eps_t:  0.0,    sin_eps:    1.0},
    LuniSolarCoefficients{ l:  3.0,    lp:  0.0, f:  0.0,  d:  0.0,  om:  0.0, sin_psi:    1575.0,       sin_psi_t:    0.0,      cos_psi:    -6.0,     cos_eps:     -50.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  3.0,    lp:  0.0, f:  2.0,  d: -2.0,  om:  2.0, sin_psi:     934.0,       sin_psi_t:    0.0,      cos_psi:    -3.0,     cos_eps:    -399.0,   cos_eps_t:  0.0,    sin_eps:   -1.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  4.0,  d: -2.0,  om:  2.0, sin_psi:     922.0,       sin_psi_t:    0.0,      cos_psi:    -1.0,     cos_eps:    -395.0,   cos_eps_t:  0.0,    sin_eps:   -1.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  2.0,  d:  0.0,  om:  1.0, sin_psi:     815.0,       sin_psi_t:    0.0,      cos_psi:    -1.0,     cos_eps:    -422.0,   cos_eps_t:  0.0,    sin_eps:   -1.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f: -2.0,  d:  2.0,  om:  1.0, sin_psi:     834.0,       sin_psi_t:    0.0,      cos_psi:     2.0,     cos_eps:    -440.0,   cos_eps_t:  0.0,    sin_eps:    1.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  2.0,  d: -2.0,  om:  3.0, sin_psi:    1248.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:    -170.0,   cos_eps_t:  0.0,    sin_eps:    1.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  0.0,  d:  4.0,  om:  0.0, sin_psi:    1338.0,       sin_psi_t:    0.0,      cos_psi:    -5.0,     cos_eps:     -39.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f: -2.0,  d:  0.0,  om:  1.0, sin_psi:     716.0,       sin_psi_t:    0.0,      cos_psi:    -2.0,     cos_eps:    -389.0,   cos_eps_t:  0.0,    sin_eps:   -1.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  0.0,  d:  4.0,  om:  0.0, sin_psi:    1282.0,       sin_psi_t:    0.0,      cos_psi:    -3.0,     cos_eps:     -23.0,   cos_eps_t:  0.0,    sin_eps:    1.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -1.0, f:  0.0,  d:  2.0,  om:  1.0, sin_psi:     742.0,       sin_psi_t:    0.0,      cos_psi:     1.0,     cos_eps:    -391.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  0.0,  d:  1.0,  om:  1.0, sin_psi:    1020.0,       sin_psi_t:    0.0,      cos_psi:   -25.0,     cos_eps:    -495.0,   cos_eps_t:  0.0,    sin_eps:  -10.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  0.0,  d:  0.0,  om:  2.0, sin_psi:     715.0,       sin_psi_t:    0.0,      cos_psi:    -4.0,     cos_eps:    -326.0,   cos_eps_t:  0.0,    sin_eps:    2.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f: -2.0,  d:  0.0,  om:  1.0, sin_psi:    -666.0,       sin_psi_t:    0.0,      cos_psi:    -3.0,     cos_eps:     369.0,   cos_eps_t:  0.0,    sin_eps:   -1.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -1.0, f:  2.0,  d:  0.0,  om:  1.0, sin_psi:    -667.0,       sin_psi_t:    0.0,      cos_psi:     1.0,     cos_eps:     346.0,   cos_eps_t:  0.0,    sin_eps:    1.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  2.0,  d: -1.0,  om:  2.0, sin_psi:    -704.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     304.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  2.0,  d:  4.0,  om:  2.0, sin_psi:    -694.0,       sin_psi_t:    0.0,      cos_psi:     5.0,     cos_eps:     294.0,   cos_eps_t:  0.0,    sin_eps:    2.0},
    LuniSolarCoefficients{ l: -2.0,    lp: -1.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:   -1014.0,       sin_psi_t:    0.0,      cos_psi:    -1.0,     cos_eps:       4.0,   cos_eps_t:  0.0,    sin_eps:   -1.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  1.0, f:  0.0,  d: -2.0,  om:  1.0, sin_psi:    -585.0,       sin_psi_t:    0.0,      cos_psi:    -2.0,     cos_eps:     316.0,   cos_eps_t:  0.0,    sin_eps:   -1.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  1.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:    -949.0,       sin_psi_t:    0.0,      cos_psi:     1.0,     cos_eps:       8.0,   cos_eps_t:  0.0,    sin_eps:   -1.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  1.0, f:  0.0,  d:  1.0,  om:  2.0, sin_psi:    -595.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     258.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -1.0, f:  0.0,  d:  0.0,  om:  1.0, sin_psi:     528.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:    -279.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -1.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:    -590.0,       sin_psi_t:    0.0,      cos_psi:     4.0,     cos_eps:     252.0,   cos_eps_t:  0.0,    sin_eps:    2.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  1.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:     570.0,       sin_psi_t:    0.0,      cos_psi:    -2.0,     cos_eps:    -244.0,   cos_eps_t:  0.0,    sin_eps:   -1.0},
    LuniSolarCoefficients{ l:  3.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  1.0, sin_psi:    -502.0,       sin_psi_t:    0.0,      cos_psi:     3.0,     cos_eps:     250.0,   cos_eps_t:  0.0,    sin_eps:    2.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f: -2.0,  d:  2.0,  om:  0.0, sin_psi:    -875.0,       sin_psi_t:    0.0,      cos_psi:     1.0,     cos_eps:      29.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  0.0,  d: -2.0,  om:  1.0, sin_psi:    -492.0,       sin_psi_t:    0.0,      cos_psi:    -3.0,     cos_eps:     275.0,   cos_eps_t:  0.0,    sin_eps:   -1.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:     535.0,       sin_psi_t:    0.0,      cos_psi:    -2.0,     cos_eps:    -228.0,   cos_eps_t:  0.0,    sin_eps:   -1.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -1.0, f:  2.0,  d:  2.0,  om:  1.0, sin_psi:    -467.0,       sin_psi_t:    0.0,      cos_psi:     1.0,     cos_eps:     240.0,   cos_eps_t:  0.0,    sin_eps:    1.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -1.0, f:  0.0,  d:  0.0,  om:  2.0, sin_psi:     591.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:    -253.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  2.0,  d: -4.0,  om:  1.0, sin_psi:    -453.0,       sin_psi_t:    0.0,      cos_psi:    -1.0,     cos_eps:     244.0,   cos_eps_t:  0.0,    sin_eps:   -1.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f: -2.0,  d:  2.0,  om:  0.0, sin_psi:     766.0,       sin_psi_t:    0.0,      cos_psi:     1.0,     cos_eps:       9.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -1.0, f:  2.0,  d:  2.0,  om:  1.0, sin_psi:    -446.0,       sin_psi_t:    0.0,      cos_psi:     2.0,     cos_eps:     225.0,   cos_eps_t:  0.0,    sin_eps:    1.0},
    LuniSolarCoefficients{ l:  2.0,    lp: -1.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:    -488.0,       sin_psi_t:    0.0,      cos_psi:     2.0,     cos_eps:     207.0,   cos_eps_t:  0.0,    sin_eps:    1.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  0.0,  d:  2.0,  om:  2.0, sin_psi:    -468.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     201.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -1.0, f:  2.0,  d:  0.0,  om:  1.0, sin_psi:    -421.0,       sin_psi_t:    0.0,      cos_psi:     1.0,     cos_eps:     216.0,   cos_eps_t:  0.0,    sin_eps:    1.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  1.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:     463.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:    -200.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:    -673.0,       sin_psi_t:    0.0,      cos_psi:     2.0,     cos_eps:      14.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -1.0, f: -2.0,  d:  2.0,  om:  0.0, sin_psi:     658.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  3.0, f:  2.0,  d: -2.0,  om:  2.0, sin_psi:    -438.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     188.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  0.0,  d:  1.0,  om:  1.0, sin_psi:    -390.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     205.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  2.0,  d:  2.0,  om:  0.0, sin_psi:     639.0,       sin_psi_t:  -11.0,      cos_psi:    -2.0,     cos_eps:     -19.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  1.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:     412.0,       sin_psi_t:    0.0,      cos_psi:    -2.0,     cos_eps:    -176.0,   cos_eps_t:  0.0,    sin_eps:   -1.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  1.0, f:  0.0,  d:  0.0,  om:  1.0, sin_psi:    -361.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     189.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  1.0, f:  2.0,  d:  0.0,  om:  1.0, sin_psi:     360.0,       sin_psi_t:    0.0,      cos_psi:    -1.0,     cos_eps:    -185.0,   cos_eps_t:  0.0,    sin_eps:   -1.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:     588.0,       sin_psi_t:    0.0,      cos_psi:    -3.0,     cos_eps:     -24.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f: -2.0,  d:  2.0,  om:  0.0, sin_psi:    -578.0,       sin_psi_t:    0.0,      cos_psi:     1.0,     cos_eps:       5.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  0.0,  d:  2.0,  om:  2.0, sin_psi:    -396.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     171.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  0.0,  d:  1.0,  om:  0.0, sin_psi:     565.0,       sin_psi_t:    0.0,      cos_psi:    -1.0,     cos_eps:      -6.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  0.0,  d: -2.0,  om:  1.0, sin_psi:    -335.0,       sin_psi_t:    0.0,      cos_psi:    -1.0,     cos_eps:     184.0,   cos_eps_t:  0.0,    sin_eps:   -1.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  2.0,  d: -2.0,  om:  2.0, sin_psi:     357.0,       sin_psi_t:    0.0,      cos_psi:     1.0,     cos_eps:    -154.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  0.0,  d: -1.0,  om:  1.0, sin_psi:     321.0,       sin_psi_t:    0.0,      cos_psi:     1.0,     cos_eps:    -174.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  1.0, f:  0.0,  d:  0.0,  om:  1.0, sin_psi:    -301.0,       sin_psi_t:    0.0,      cos_psi:    -1.0,     cos_eps:     162.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  2.0,  d: -1.0,  om:  2.0, sin_psi:    -334.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     144.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -1.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:     493.0,       sin_psi_t:    0.0,      cos_psi:    -2.0,     cos_eps:     -15.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  0.0,  d:  4.0,  om:  0.0, sin_psi:     494.0,       sin_psi_t:    0.0,      cos_psi:    -2.0,     cos_eps:     -19.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  2.0,  d:  1.0,  om:  2.0, sin_psi:     337.0,       sin_psi_t:    0.0,      cos_psi:    -1.0,     cos_eps:    -143.0,   cos_eps_t:  0.0,    sin_eps:   -1.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  2.0,  d:  1.0,  om:  1.0, sin_psi:     280.0,       sin_psi_t:    0.0,      cos_psi:    -1.0,     cos_eps:    -144.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  0.0,  d: -2.0,  om:  2.0, sin_psi:     309.0,       sin_psi_t:    0.0,      cos_psi:     1.0,     cos_eps:    -134.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  2.0,  d:  4.0,  om:  1.0, sin_psi:    -263.0,       sin_psi_t:    0.0,      cos_psi:     2.0,     cos_eps:     131.0,   cos_eps_t:  0.0,    sin_eps:    1.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f: -2.0,  d:  0.0,  om:  1.0, sin_psi:     253.0,       sin_psi_t:    0.0,      cos_psi:     1.0,     cos_eps:    -138.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  1.0, f:  2.0,  d: -2.0,  om:  1.0, sin_psi:     245.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:    -128.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  2.0,  d:  2.0,  om:  0.0, sin_psi:     416.0,       sin_psi_t:    0.0,      cos_psi:    -2.0,     cos_eps:     -17.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  2.0,  d: -1.0,  om:  1.0, sin_psi:    -229.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     128.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  2.0,  d:  2.0,  om:  1.0, sin_psi:     231.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:    -120.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  4.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:    -259.0,       sin_psi_t:    0.0,      cos_psi:     2.0,     cos_eps:     109.0,   cos_eps_t:  0.0,    sin_eps:    1.0},
    LuniSolarCoefficients{ l:  2.0,    lp: -1.0, f:  0.0,  d:  0.0,  om:  0.0, sin_psi:     375.0,       sin_psi_t:    0.0,      cos_psi:    -1.0,     cos_eps:      -8.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  1.0, f:  2.0,  d: -2.0,  om:  2.0, sin_psi:     252.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:    -108.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  2.0,  d:  1.0,  om:  2.0, sin_psi:    -245.0,       sin_psi_t:    0.0,      cos_psi:     1.0,     cos_eps:     104.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  4.0,  d: -2.0,  om:  2.0, sin_psi:     243.0,       sin_psi_t:    0.0,      cos_psi:    -1.0,     cos_eps:    -104.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -1.0, f:  0.0,  d:  0.0,  om:  1.0, sin_psi:     208.0,       sin_psi_t:    0.0,      cos_psi:     1.0,     cos_eps:    -112.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  0.0,  d:  2.0,  om:  1.0, sin_psi:     199.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:    -102.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  2.0,  d:  4.0,  om:  1.0, sin_psi:    -208.0,       sin_psi_t:    0.0,      cos_psi:     1.0,     cos_eps:     105.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  0.0, sin_psi:     335.0,       sin_psi_t:    0.0,      cos_psi:    -2.0,     cos_eps:     -14.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  0.0,  d:  1.0,  om:  0.0, sin_psi:    -325.0,       sin_psi_t:    0.0,      cos_psi:     1.0,     cos_eps:       7.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  0.0,  d:  4.0,  om:  1.0, sin_psi:    -187.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      96.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  4.0,  d:  0.0,  om:  1.0, sin_psi:     197.0,       sin_psi_t:    0.0,      cos_psi:    -1.0,     cos_eps:    -100.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  2.0,  d:  2.0,  om:  1.0, sin_psi:    -192.0,       sin_psi_t:    0.0,      cos_psi:     2.0,     cos_eps:      94.0,   cos_eps_t:  0.0,    sin_eps:    1.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  2.0,  d: -3.0,  om:  2.0, sin_psi:    -188.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      83.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -2.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:     276.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  1.0, f:  0.0,  d:  0.0,  om:  0.0, sin_psi:    -286.0,       sin_psi_t:    0.0,      cos_psi:     1.0,     cos_eps:       6.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  4.0,  d:  0.0,  om:  2.0, sin_psi:     186.0,       sin_psi_t:    0.0,      cos_psi:    -1.0,     cos_eps:     -79.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  0.0,  d:  0.0,  om:  3.0, sin_psi:    -219.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      43.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  3.0, f:  0.0,  d:  0.0,  om:  0.0, sin_psi:     276.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  2.0,  d: -4.0,  om:  1.0, sin_psi:    -153.0,       sin_psi_t:    0.0,      cos_psi:    -1.0,     cos_eps:      84.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -1.0, f:  0.0,  d:  2.0,  om:  1.0, sin_psi:    -156.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      81.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  0.0,  d:  4.0,  om:  1.0, sin_psi:    -154.0,       sin_psi_t:    0.0,      cos_psi:     1.0,     cos_eps:      78.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -1.0, f:  2.0,  d:  4.0,  om:  2.0, sin_psi:    -174.0,       sin_psi_t:    0.0,      cos_psi:     1.0,     cos_eps:      75.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  2.0,  d:  4.0,  om:  2.0, sin_psi:    -163.0,       sin_psi_t:    0.0,      cos_psi:     2.0,     cos_eps:      69.0,   cos_eps_t:  0.0,    sin_eps:    1.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  2.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:    -228.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp: -1.0, f:  2.0,  d:  0.0,  om:  1.0, sin_psi:      91.0,       sin_psi_t:    0.0,      cos_psi:    -4.0,     cos_eps:     -54.0,   cos_eps_t:  0.0,    sin_eps:   -2.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  0.0,  d:  2.0,  om:  2.0, sin_psi:     175.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -75.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -1.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:    -159.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      69.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  4.0,  d: -2.0,  om:  1.0, sin_psi:     141.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -72.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  3.0,    lp:  0.0, f:  2.0,  d: -2.0,  om:  1.0, sin_psi:     147.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -75.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp: -1.0, f:  0.0,  d:  2.0,  om:  1.0, sin_psi:    -132.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      69.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  0.0,  d: -1.0,  om:  1.0, sin_psi:     159.0,       sin_psi_t:    0.0,      cos_psi:   -28.0,     cos_eps:     -54.0,   cos_eps_t:  0.0,    sin_eps:   11.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -2.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:     213.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -4.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  0.0,  d:  4.0,  om:  1.0, sin_psi:     123.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -64.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -3.0,    lp:  0.0, f:  0.0,  d:  0.0,  om:  1.0, sin_psi:    -118.0,       sin_psi_t:    0.0,      cos_psi:    -1.0,     cos_eps:      66.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  1.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:     144.0,       sin_psi_t:    0.0,      cos_psi:    -1.0,     cos_eps:     -61.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  2.0,  d:  4.0,  om:  1.0, sin_psi:    -121.0,       sin_psi_t:    0.0,      cos_psi:     1.0,     cos_eps:      60.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  3.0,    lp:  0.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:    -134.0,       sin_psi_t:    0.0,      cos_psi:     1.0,     cos_eps:      56.0,   cos_eps_t:  0.0,    sin_eps:    1.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  1.0, f:  2.0,  d: -2.0,  om:  1.0, sin_psi:    -105.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      57.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  0.0,  d: -4.0,  om:  1.0, sin_psi:    -102.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      56.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  0.0,  d: -2.0,  om:  2.0, sin_psi:     120.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -52.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  2.0,  d: -4.0,  om:  1.0, sin_psi:     101.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -54.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  1.0, f:  0.0,  d:  2.0,  om:  1.0, sin_psi:    -113.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      59.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  2.0,  d: -1.0,  om:  1.0, sin_psi:    -106.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      61.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -2.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:    -129.0,       sin_psi_t:    0.0,      cos_psi:     1.0,     cos_eps:      55.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  0.0,  d:  2.0,  om:  1.0, sin_psi:    -114.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      57.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  4.0,    lp:  0.0, f:  2.0,  d: -2.0,  om:  2.0, sin_psi:     113.0,       sin_psi_t:    0.0,      cos_psi:    -1.0,     cos_eps:     -49.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  0.0,  d: -2.0,  om:  2.0, sin_psi:    -102.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      44.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  2.0, f:  0.0,  d:  0.0,  om:  1.0, sin_psi:     -94.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      51.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  0.0,  d: -4.0,  om:  1.0, sin_psi:    -100.0,       sin_psi_t:    0.0,      cos_psi:    -1.0,     cos_eps:      56.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  2.0, f:  2.0,  d: -2.0,  om:  1.0, sin_psi:      87.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -47.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -3.0,    lp:  0.0, f:  0.0,  d:  4.0,  om:  0.0, sin_psi:     161.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  1.0, f:  2.0,  d:  0.0,  om:  1.0, sin_psi:      96.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -50.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -1.0, f:  0.0,  d:  4.0,  om:  0.0, sin_psi:     151.0,       sin_psi_t:    0.0,      cos_psi:    -1.0,     cos_eps:      -5.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -2.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:    -104.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      44.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp: -1.0, f:  2.0,  d:  4.0,  om:  2.0, sin_psi:    -110.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      48.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -1.0, f:  2.0,  d:  2.0,  om:  1.0, sin_psi:    -100.0,       sin_psi_t:    0.0,      cos_psi:     1.0,     cos_eps:      50.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  1.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:      92.0,       sin_psi_t:    0.0,      cos_psi:    -5.0,     cos_eps:      12.0,   cos_eps_t:  0.0,    sin_eps:   -2.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  1.0, f:  2.0,  d:  0.0,  om:  1.0, sin_psi:      82.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -45.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  1.0, f:  0.0,  d: -2.0,  om:  1.0, sin_psi:      82.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -45.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -3.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  1.0, sin_psi:     -78.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      41.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  2.0,  d: -2.0,  om:  1.0, sin_psi:     -77.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      43.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  1.0, f:  0.0,  d:  2.0,  om:  2.0, sin_psi:       2.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      54.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -1.0, f:  2.0,  d: -1.0,  om:  2.0, sin_psi:      94.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -40.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  4.0,  d: -2.0,  om:  2.0, sin_psi:     -93.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      40.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -2.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:     -83.0,       sin_psi_t:    0.0,      cos_psi:    10.0,     cos_eps:      40.0,   cos_eps_t:  0.0,    sin_eps:   -2.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  2.0,  d:  1.0,  om:  2.0, sin_psi:      83.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -36.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  0.0,  d:  0.0,  om:  2.0, sin_psi:     -91.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      39.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  3.0, sin_psi:     128.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  4.0,  d:  0.0,  om:  2.0, sin_psi:     -79.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      34.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f: -2.0,  d:  0.0,  om:  1.0, sin_psi:     -83.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      47.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  1.0, f:  2.0,  d:  2.0,  om:  1.0, sin_psi:      84.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -44.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  3.0,    lp:  0.0, f:  0.0,  d:  0.0,  om:  1.0, sin_psi:      83.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -43.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  2.0,  d:  3.0,  om:  2.0, sin_psi:      91.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -39.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp: -1.0, f:  2.0,  d:  0.0,  om:  1.0, sin_psi:     -77.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      39.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  2.0,  d:  2.0,  om:  1.0, sin_psi:      84.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -43.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -1.0, f:  2.0,  d:  4.0,  om:  2.0, sin_psi:     -92.0,       sin_psi_t:    0.0,      cos_psi:     1.0,     cos_eps:      39.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp: -1.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:     -92.0,       sin_psi_t:    0.0,      cos_psi:     1.0,     cos_eps:      39.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  2.0, f: -2.0,  d:  2.0,  om:  0.0, sin_psi:     -94.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -1.0, f:  2.0,  d: -1.0,  om:  1.0, sin_psi:      68.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -36.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -2.0, f:  0.0,  d:  0.0,  om:  1.0, sin_psi:     -61.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      32.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  2.0,  d: -4.0,  om:  2.0, sin_psi:      71.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -31.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -1.0, f:  0.0,  d: -2.0,  om:  1.0, sin_psi:      62.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -34.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -1.0, f:  2.0,  d:  0.0,  om:  1.0, sin_psi:     -63.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      33.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -1.0, f:  2.0,  d: -2.0,  om:  2.0, sin_psi:     -73.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      32.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp: -1.0, f:  0.0,  d:  4.0,  om:  0.0, sin_psi:     115.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  0.0,  d:  3.0,  om:  0.0, sin_psi:    -103.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp: -1.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:      63.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -28.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  2.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:      74.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -32.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  1.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:    -103.0,       sin_psi_t:    0.0,      cos_psi:    -3.0,     cos_eps:       3.0,   cos_eps_t:  0.0,    sin_eps:   -1.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  2.0,  d: -1.0,  om:  2.0, sin_psi:     -69.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      30.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  2.0,  d:  1.0,  om:  1.0, sin_psi:      57.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -29.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  4.0,    lp:  0.0, f:  0.0,  d:  0.0,  om:  0.0, sin_psi:      94.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -4.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  1.0, f:  2.0,  d:  0.0,  om:  1.0, sin_psi:      64.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -33.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  3.0,    lp: -1.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:     -63.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      26.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  2.0, f:  0.0,  d:  2.0,  om:  1.0, sin_psi:     -38.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      20.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  2.0,  d: -3.0,  om:  1.0, sin_psi:     -43.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      24.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  1.0, f:  2.0,  d: -4.0,  om:  1.0, sin_psi:     -45.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      23.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -1.0, f:  2.0,  d: -2.0,  om:  1.0, sin_psi:      47.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -24.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -1.0, f:  0.0,  d: -1.0,  om:  1.0, sin_psi:     -48.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      25.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -1.0, f:  0.0,  d: -2.0,  om:  1.0, sin_psi:      45.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -26.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  0.0,  d:  0.0,  om:  2.0, sin_psi:      56.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -25.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f: -2.0,  d:  2.0,  om:  0.0, sin_psi:      88.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f: -2.0,  d:  4.0,  om:  0.0, sin_psi:     -75.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -2.0, f:  0.0,  d:  0.0,  om:  0.0, sin_psi:      85.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  0.0,  d:  1.0,  om:  1.0, sin_psi:      49.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -26.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  2.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:     -74.0,       sin_psi_t:    0.0,      cos_psi:    -3.0,     cos_eps:      -1.0,   cos_eps_t:  0.0,    sin_eps:   -1.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -1.0, f:  2.0,  d: -2.0,  om:  1.0, sin_psi:     -39.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      21.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  2.0, f:  2.0,  d: -2.0,  om:  2.0, sin_psi:      45.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -20.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp: -1.0, f:  2.0,  d: -2.0,  om:  2.0, sin_psi:      51.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -22.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  2.0,  d: -1.0,  om:  1.0, sin_psi:     -40.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      21.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  1.0, f:  2.0,  d: -2.0,  om:  1.0, sin_psi:      41.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -21.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  0.0,  d: -2.0,  om:  1.0, sin_psi:     -42.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      24.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -2.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:     -51.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      22.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  2.0,  d:  1.0,  om:  1.0, sin_psi:     -42.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      22.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  4.0,  d: -2.0,  om:  1.0, sin_psi:      39.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -21.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  4.0,  d:  2.0,  om:  2.0, sin_psi:      46.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -18.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  1.0, f:  2.0,  d:  1.0,  om:  2.0, sin_psi:     -53.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      22.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  0.0,  d:  4.0,  om:  0.0, sin_psi:      82.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -4.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  2.0,  d:  2.0,  om:  0.0, sin_psi:      81.0,       sin_psi_t:    0.0,      cos_psi:    -1.0,     cos_eps:      -4.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  2.0,  d:  1.0,  om:  2.0, sin_psi:      47.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -19.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  3.0,    lp:  1.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:      53.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -23.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  4.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  1.0, sin_psi:     -45.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      22.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp: -1.0, f:  2.0,  d:  0.0,  om:  0.0, sin_psi:     -44.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f: -2.0,  d:  2.0,  om:  1.0, sin_psi:     -33.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      16.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f: -2.0,  d:  1.0,  om:  0.0, sin_psi:     -61.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -1.0, f: -2.0,  d:  2.0,  om:  1.0, sin_psi:      28.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -15.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp: -1.0, f:  0.0,  d: -2.0,  om:  1.0, sin_psi:     -38.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      19.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  2.0,  d: -1.0,  om:  2.0, sin_psi:     -33.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      21.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  2.0,  d: -3.0,  om:  2.0, sin_psi:     -60.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  2.0,  d: -2.0,  om:  3.0, sin_psi:      48.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -10.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  2.0,  d: -3.0,  om:  1.0, sin_psi:      27.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -14.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f: -2.0,  d:  2.0,  om:  1.0, sin_psi:      38.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -20.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  2.0,  d: -4.0,  om:  2.0, sin_psi:      31.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -13.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  1.0, f:  0.0,  d:  0.0,  om:  1.0, sin_psi:     -29.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      15.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  0.0,  d: -1.0,  om:  1.0, sin_psi:      28.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -15.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  2.0,  d: -4.0,  om:  2.0, sin_psi:     -32.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      15.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  4.0,  d: -4.0,  om:  4.0, sin_psi:      45.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -8.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  4.0,  d: -4.0,  om:  2.0, sin_psi:     -44.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      19.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -2.0, f:  0.0,  d:  2.0,  om:  1.0, sin_psi:      28.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -15.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  0.0,  d:  3.0,  om:  0.0, sin_psi:     -51.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f: -2.0,  d:  2.0,  om:  1.0, sin_psi:     -36.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      20.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -3.0,    lp:  0.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:      44.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -19.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -3.0,    lp:  0.0, f:  2.0,  d:  2.0,  om:  1.0, sin_psi:      26.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -14.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  2.0,  d:  2.0,  om:  0.0, sin_psi:     -60.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp: -1.0, f:  0.0,  d:  0.0,  om:  1.0, sin_psi:      35.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -18.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  1.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:     -27.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      11.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  1.0, f:  0.0,  d:  1.0,  om:  0.0, sin_psi:      47.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  4.0,  d: -2.0,  om:  2.0, sin_psi:      36.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -15.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  1.0, f:  0.0,  d: -2.0,  om:  1.0, sin_psi:     -36.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      20.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  0.0,  d: -4.0,  om:  1.0, sin_psi:     -35.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      19.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -1.0, f:  0.0,  d:  2.0,  om:  1.0, sin_psi:     -37.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      19.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  1.0, f:  0.0,  d:  2.0,  om:  1.0, sin_psi:      32.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -16.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  2.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:      35.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -14.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  3.0,    lp:  1.0, f:  2.0,  d: -2.0,  om:  2.0, sin_psi:      32.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -13.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -1.0, f:  0.0,  d:  4.0,  om:  0.0, sin_psi:      65.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp: -1.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:      47.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  4.0,  d:  0.0,  om:  1.0, sin_psi:      32.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -16.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  4.0,  d: -2.0,  om:  2.0, sin_psi:      37.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -16.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -1.0, f:  2.0,  d:  4.0,  om:  1.0, sin_psi:     -30.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      15.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  0.0,  d:  4.0,  om:  1.0, sin_psi:     -32.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      16.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -2.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:     -31.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      13.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  2.0,  d:  3.0,  om:  2.0, sin_psi:      37.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -16.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  1.0, f:  2.0,  d:  4.0,  om:  2.0, sin_psi:      31.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -13.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  3.0,    lp:  0.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:      49.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  4.0,  d:  2.0,  om:  2.0, sin_psi:      32.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -13.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  1.0, f:  2.0,  d:  2.0,  om:  1.0, sin_psi:      23.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -12.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  2.0,  d:  6.0,  om:  2.0, sin_psi:     -43.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      18.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  1.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:      26.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -11.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  2.0,  d:  6.0,  om:  2.0, sin_psi:     -32.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      14.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  2.0,  d:  4.0,  om:  1.0, sin_psi:     -29.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      14.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  2.0,  d:  4.0,  om:  2.0, sin_psi:     -27.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      12.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  1.0, f: -2.0,  d:  1.0,  om:  0.0, sin_psi:      30.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -3.0,    lp:  1.0, f:  2.0,  d:  1.0,  om:  2.0, sin_psi:     -11.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       5.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f: -2.0,  d:  0.0,  om:  2.0, sin_psi:     -21.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      10.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  0.0,  d:  1.0,  om:  2.0, sin_psi:     -34.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      15.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -4.0,    lp:  0.0, f:  2.0,  d:  2.0,  om:  1.0, sin_psi:     -10.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       6.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -1.0, f:  0.0,  d:  1.0,  om:  0.0, sin_psi:     -36.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f: -2.0,  d:  2.0,  om:  2.0, sin_psi:      -9.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       4.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  0.0,  d: -1.0,  om:  2.0, sin_psi:     -12.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       5.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -1.0, f:  2.0,  d: -2.0,  om:  3.0, sin_psi:     -21.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       5.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  1.0, f:  2.0,  d:  0.0,  om:  0.0, sin_psi:     -29.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  2.0,  d: -2.0,  om:  4.0, sin_psi:     -15.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp: -2.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:     -20.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f: -2.0,  d:  4.0,  om:  0.0, sin_psi:      28.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:   -2.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -2.0, f: -2.0,  d:  2.0,  om:  0.0, sin_psi:      17.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  2.0, f:  0.0,  d: -2.0,  om:  1.0, sin_psi:     -22.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      12.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  3.0,    lp:  0.0, f:  0.0,  d: -4.0,  om:  1.0, sin_psi:     -14.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       7.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  1.0, f:  2.0,  d: -2.0,  om:  2.0, sin_psi:      24.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -11.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -1.0, f:  2.0,  d: -4.0,  om:  1.0, sin_psi:      11.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -6.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  1.0, f:  0.0,  d: -2.0,  om:  2.0, sin_psi:      14.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -6.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -3.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  0.0, sin_psi:      24.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -3.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:      18.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -8.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  0.0,  d:  1.0,  om:  0.0, sin_psi:     -38.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f: -2.0,  d:  1.0,  om:  0.0, sin_psi:     -31.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -3.0,    lp:  0.0, f:  0.0,  d:  2.0,  om:  1.0, sin_psi:     -16.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       8.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -1.0, f: -2.0,  d:  2.0,  om:  0.0, sin_psi:      29.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  2.0,  d: -4.0,  om:  1.0, sin_psi:     -18.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      10.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  1.0, f:  0.0,  d: -4.0,  om:  1.0, sin_psi:     -10.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       5.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  2.0, f:  0.0,  d: -2.0,  om:  1.0, sin_psi:     -17.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      10.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  0.0,  d: -3.0,  om:  1.0, sin_psi:       9.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -4.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  2.0,  d: -2.0,  om:  2.0, sin_psi:      16.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -6.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp: -1.0, f:  0.0,  d:  0.0,  om:  1.0, sin_psi:      22.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -12.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -4.0,    lp:  0.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:      20.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  1.0, f:  0.0,  d: -4.0,  om:  1.0, sin_psi:     -13.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       6.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  2.0,  d: -4.0,  om:  1.0, sin_psi:     -17.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       9.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  4.0,  d: -4.0,  om:  1.0, sin_psi:     -14.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       8.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  3.0, f:  2.0,  d: -2.0,  om:  2.0, sin_psi:       0.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -7.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -3.0,    lp: -1.0, f:  0.0,  d:  4.0,  om:  0.0, sin_psi:      14.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -3.0,    lp:  0.0, f:  0.0,  d:  4.0,  om:  1.0, sin_psi:      19.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -10.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -1.0, f: -2.0,  d:  2.0,  om:  0.0, sin_psi:     -34.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -1.0, f:  0.0,  d:  2.0,  om:  2.0, sin_psi:     -20.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       8.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -2.0, f:  0.0,  d:  0.0,  om:  1.0, sin_psi:       9.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -5.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -1.0, f:  0.0,  d:  0.0,  om:  2.0, sin_psi:     -18.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       7.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  0.0,  d:  1.0,  om:  2.0, sin_psi:      13.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -6.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -1.0, f:  2.0,  d:  0.0,  om:  0.0, sin_psi:      17.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -2.0, f:  2.0,  d: -2.0,  om:  2.0, sin_psi:     -12.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       5.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -1.0, f:  2.0,  d: -1.0,  om:  1.0, sin_psi:      15.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -8.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  3.0, sin_psi:     -11.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  1.0, f:  0.0,  d:  0.0,  om:  2.0, sin_psi:      13.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -5.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  1.0, f:  2.0,  d:  0.0,  om:  0.0, sin_psi:     -18.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  2.0, f:  0.0,  d:  0.0,  om:  0.0, sin_psi:     -35.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  2.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:       9.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -4.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  4.0,  d: -2.0,  om:  1.0, sin_psi:     -19.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      10.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  3.0,    lp:  0.0, f:  2.0,  d: -4.0,  om:  2.0, sin_psi:     -26.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      11.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  2.0, f:  2.0,  d: -2.0,  om:  1.0, sin_psi:       8.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -4.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  4.0,  d: -4.0,  om:  2.0, sin_psi:     -10.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       4.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp: -1.0, f:  0.0,  d:  4.0,  om:  1.0, sin_psi:      10.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -6.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -1.0, f:  0.0,  d:  2.0,  om:  2.0, sin_psi:     -21.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       9.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  1.0, f:  0.0,  d:  4.0,  om:  0.0, sin_psi:     -15.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp: -1.0, f:  2.0,  d:  2.0,  om:  1.0, sin_psi:       9.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -5.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f: -2.0,  d:  2.0,  om:  0.0, sin_psi:     -29.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  0.0,  d:  1.0,  om:  1.0, sin_psi:     -19.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      10.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  0.0,  d:  2.0,  om:  2.0, sin_psi:      12.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -5.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -1.0, f:  2.0,  d: -1.0,  om:  2.0, sin_psi:      22.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -9.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  4.0,  d:  0.0,  om:  1.0, sin_psi:     -10.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       5.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  1.0, f:  0.0,  d:  0.0,  om:  1.0, sin_psi:     -20.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      11.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  2.0,  d:  0.0,  om:  0.0, sin_psi:     -20.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -1.0, f:  4.0,  d: -2.0,  om:  2.0, sin_psi:     -17.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       7.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  4.0,  d: -2.0,  om:  4.0, sin_psi:      15.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  2.0, f:  2.0,  d:  0.0,  om:  1.0, sin_psi:       8.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -4.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -3.0,    lp:  0.0, f:  0.0,  d:  6.0,  om:  0.0, sin_psi:      14.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -1.0, f:  0.0,  d:  4.0,  om:  1.0, sin_psi:     -12.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       6.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -2.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:      25.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  0.0,  d:  4.0,  om:  2.0, sin_psi:     -13.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       6.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -2.0, f:  2.0,  d:  2.0,  om:  1.0, sin_psi:     -14.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       8.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  0.0,  d: -2.0,  om:  2.0, sin_psi:      13.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -5.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f: -2.0,  d: -2.0,  om:  1.0, sin_psi:     -17.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       9.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f: -2.0,  d: -2.0,  om:  1.0, sin_psi:     -12.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       6.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f: -2.0,  d:  0.0,  om:  1.0, sin_psi:     -10.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       5.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  0.0,  d:  3.0,  om:  1.0, sin_psi:      10.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -6.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  0.0,  d:  3.0,  om:  0.0, sin_psi:     -15.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  1.0, f:  0.0,  d:  4.0,  om:  0.0, sin_psi:     -22.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -1.0, f:  2.0,  d:  2.0,  om:  0.0, sin_psi:      28.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  2.0,  d:  3.0,  om:  2.0, sin_psi:      15.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -7.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  0.0,  d:  2.0,  om:  2.0, sin_psi:      23.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -10.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -1.0, f:  2.0,  d:  1.0,  om:  2.0, sin_psi:      12.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -5.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  3.0,    lp: -1.0, f:  0.0,  d:  0.0,  om:  0.0, sin_psi:      29.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  0.0,  d:  1.0,  om:  0.0, sin_psi:     -25.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -1.0, f:  2.0,  d:  0.0,  om:  0.0, sin_psi:      22.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  2.0,  d:  1.0,  om:  0.0, sin_psi:     -18.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  3.0, sin_psi:      15.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  3.0,    lp:  1.0, f:  0.0,  d:  0.0,  om:  0.0, sin_psi:     -23.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  3.0,    lp: -1.0, f:  2.0,  d: -2.0,  om:  2.0, sin_psi:      12.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -5.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  2.0,  d: -1.0,  om:  1.0, sin_psi:      -8.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       4.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  1.0, f:  2.0,  d:  0.0,  om:  0.0, sin_psi:     -19.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  4.0,  d: -1.0,  om:  2.0, sin_psi:     -10.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       4.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  2.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:      21.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -9.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  0.0,  d:  6.0,  om:  0.0, sin_psi:      23.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -1.0, f:  0.0,  d:  4.0,  om:  1.0, sin_psi:     -16.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       8.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp: -1.0, f:  2.0,  d:  4.0,  om:  1.0, sin_psi:     -19.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       9.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -2.0, f:  2.0,  d:  2.0,  om:  1.0, sin_psi:     -22.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      10.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -1.0, f:  2.0,  d:  2.0,  om:  0.0, sin_psi:      27.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  2.0,  d:  3.0,  om:  1.0, sin_psi:      16.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -8.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  1.0, f:  2.0,  d:  4.0,  om:  2.0, sin_psi:      19.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -8.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  0.0,  d:  2.0,  om:  2.0, sin_psi:       9.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -4.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp: -2.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:      -9.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       4.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  1.0, f:  2.0,  d:  3.0,  om:  2.0, sin_psi:      -9.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       4.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  3.0,    lp:  0.0, f:  2.0,  d: -1.0,  om:  2.0, sin_psi:      -8.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       4.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  4.0,    lp:  0.0, f:  2.0,  d: -2.0,  om:  1.0, sin_psi:      18.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -9.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  0.0,  d:  6.0,  om:  0.0, sin_psi:      16.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -2.0, f:  2.0,  d:  4.0,  om:  2.0, sin_psi:     -10.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       4.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -3.0,    lp:  0.0, f:  2.0,  d:  6.0,  om:  2.0, sin_psi:     -23.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       9.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  2.0,  d:  4.0,  om:  0.0, sin_psi:      16.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  3.0,    lp:  0.0, f:  0.0,  d:  2.0,  om:  1.0, sin_psi:     -12.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       6.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  3.0,    lp: -1.0, f:  2.0,  d:  0.0,  om:  1.0, sin_psi:      -8.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       4.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  3.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  0.0, sin_psi:      30.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  4.0,  d:  0.0,  om:  2.0, sin_psi:      24.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:     -10.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  5.0,    lp:  0.0, f:  2.0,  d: -2.0,  om:  2.0, sin_psi:      10.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -4.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -1.0, f:  2.0,  d:  4.0,  om:  1.0, sin_psi:     -16.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       7.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp: -1.0, f:  2.0,  d:  2.0,  om:  1.0, sin_psi:     -16.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       7.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  2.0,  d:  4.0,  om:  2.0, sin_psi:      17.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -7.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -1.0, f:  2.0,  d:  4.0,  om:  2.0, sin_psi:     -24.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      10.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  3.0,    lp: -1.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:     -12.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       5.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  3.0,    lp:  0.0, f:  2.0,  d:  2.0,  om:  1.0, sin_psi:     -24.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      11.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  5.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:     -23.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       9.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  2.0,  d:  6.0,  om:  2.0, sin_psi:     -13.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       5.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  4.0,    lp:  0.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:     -15.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       7.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -1.0, f:  1.0,  d: -1.0,  om:  1.0, sin_psi:       0.0,       sin_psi_t:    0.0,      cos_psi: -1988.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:-1679.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  1.0,  d:  0.0,  om:  3.0, sin_psi:       0.0,       sin_psi_t:    0.0,      cos_psi:   -63.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:  -27.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -2.0, f:  2.0,  d: -2.0,  om:  3.0, sin_psi:      -4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f: -1.0,  d:  0.0,  om:  1.0, sin_psi:       0.0,       sin_psi_t:    0.0,      cos_psi:     5.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    4.0},
    LuniSolarCoefficients{ l:  2.0,    lp: -2.0, f:  0.0,  d: -2.0,  om:  1.0, sin_psi:       5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  1.0,  d:  0.0,  om:  2.0, sin_psi:       0.0,       sin_psi_t:    0.0,      cos_psi:   364.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:  176.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  1.0,  d:  0.0,  om:  1.0, sin_psi:       0.0,       sin_psi_t:    0.0,      cos_psi: -1044.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps: -891.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -1.0, f:  2.0,  d: -1.0,  om:  2.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  2.0, f:  0.0,  d:  2.0,  om:  2.0, sin_psi:       4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  1.0,  d:  0.0,  om:  0.0, sin_psi:       0.0,       sin_psi_t:    0.0,      cos_psi:   330.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -4.0,    lp:  1.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:       5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -3.0,    lp:  0.0, f:  2.0,  d:  1.0,  om:  1.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp: -1.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f: -2.0,  d:  1.0,  om:  1.0, sin_psi:      -5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp: -1.0, f: -2.0,  d:  0.0,  om:  1.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -4.0,    lp:  0.0, f:  2.0,  d:  2.0,  om:  0.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -3.0,    lp:  1.0, f:  0.0,  d:  3.0,  om:  0.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f: -1.0,  d:  2.0,  om:  0.0, sin_psi:       0.0,       sin_psi_t:    0.0,      cos_psi:     5.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -2.0, f:  0.0,  d:  0.0,  om:  2.0, sin_psi:       0.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -2.0, f:  0.0,  d:  0.0,  om:  2.0, sin_psi:       4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -3.0,    lp:  0.0, f:  0.0,  d:  3.0,  om:  0.0, sin_psi:       6.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp: -1.0, f:  0.0,  d:  2.0,  om:  2.0, sin_psi:       5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f: -2.0,  d:  3.0,  om:  0.0, sin_psi:      -7.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -4.0,    lp:  0.0, f:  0.0,  d:  4.0,  om:  0.0, sin_psi:     -12.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  1.0, f: -2.0,  d:  0.0,  om:  1.0, sin_psi:       5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp: -1.0, f:  0.0,  d: -2.0,  om:  2.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  1.0,  d: -1.0,  om:  0.0, sin_psi:      -5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  2.0, f:  0.0,  d:  1.0,  om:  0.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  1.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:      -7.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  1.0, f:  0.0,  d: -1.0,  om:  1.0, sin_psi:       7.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -4.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  1.0,  d: -2.0,  om:  1.0, sin_psi:       0.0,       sin_psi_t:    0.0,      cos_psi:   -12.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:  -10.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  2.0, f:  0.0,  d:  0.0,  om:  2.0, sin_psi:       4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -1.0, f:  2.0,  d: -3.0,  om:  1.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  1.0, f:  2.0,  d: -1.0,  om:  1.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  4.0,  d: -2.0,  om:  2.0, sin_psi:      -7.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  4.0,  d: -2.0,  om:  1.0, sin_psi:      -4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp: -2.0, f:  0.0,  d:  2.0,  om:  1.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f: -2.0,  d:  4.0,  om:  0.0, sin_psi:       0.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  2.0, f:  2.0,  d: -4.0,  om:  1.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  1.0, f:  2.0,  d: -4.0,  om:  2.0, sin_psi:       7.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  2.0, f:  2.0,  d: -2.0,  om:  1.0, sin_psi:      -4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  0.0,  d: -3.0,  om:  1.0, sin_psi:       4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  2.0, f:  0.0,  d:  0.0,  om:  1.0, sin_psi:      -5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  0.0,  d: -2.0,  om:  0.0, sin_psi:       5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -1.0, f:  2.0,  d: -2.0,  om:  2.0, sin_psi:      -5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  1.0, f:  0.0,  d:  0.0,  om:  2.0, sin_psi:       5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  0.0,  d: -1.0,  om:  2.0, sin_psi:      -8.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  1.0, f:  0.0,  d:  1.0,  om:  0.0, sin_psi:       9.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -2.0, f:  0.0,  d: -2.0,  om:  1.0, sin_psi:       6.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f: -2.0,  d:  0.0,  om:  2.0, sin_psi:      -5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -3.0,    lp:  1.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  1.0, f: -2.0,  d:  2.0,  om:  0.0, sin_psi:      -7.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -1.0, f:  0.0,  d:  0.0,  om:  2.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -3.0,    lp:  0.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:       5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -3.0,    lp: -1.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  2.0,  d: -6.0,  om:  1.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  2.0,  d: -4.0,  om:  2.0, sin_psi:       4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  0.0,  d: -4.0,  om:  2.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  1.0, f:  2.0,  d: -2.0,  om:  1.0, sin_psi:      -5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -1.0, f:  2.0,  d: -4.0,  om:  1.0, sin_psi:       4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  0.0,  d: -2.0,  om:  2.0, sin_psi:       9.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  0.0,  d: -2.0,  om:  0.0, sin_psi:       4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f: -2.0,  d: -2.0,  om:  1.0, sin_psi:       4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -4.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  1.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -1.0, f:  0.0,  d: -1.0,  om:  1.0, sin_psi:      -4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f: -2.0,  d:  0.0,  om:  2.0, sin_psi:       9.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -3.0,    lp:  0.0, f:  0.0,  d:  1.0,  om:  0.0, sin_psi:      -4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f: -2.0,  d:  1.0,  om:  0.0, sin_psi:      -4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f: -2.0,  d:  2.0,  om:  1.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f: -4.0,  d:  2.0,  om:  0.0, sin_psi:       8.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp: -1.0, f: -2.0,  d:  2.0,  om:  0.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  2.0,  d: -6.0,  om:  1.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  2.0,  d: -4.0,  om:  2.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  0.0,  d: -4.0,  om:  2.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  1.0, f:  2.0,  d: -4.0,  om:  2.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  1.0, f:  2.0,  d: -4.0,  om:  1.0, sin_psi:       6.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  4.0,  d: -4.0,  om:  4.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  4.0,  d: -4.0,  om:  2.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -1.0, f: -2.0,  d:  4.0,  om:  0.0, sin_psi:      -7.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -3.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:       9.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f: -2.0,  d:  4.0,  om:  1.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp: -1.0, f:  0.0,  d:  3.0,  om:  0.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f: -2.0,  d:  3.0,  om:  0.0, sin_psi:      -4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  0.0,  d:  3.0,  om:  1.0, sin_psi:      -5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -1.0, f:  0.0,  d:  1.0,  om:  0.0, sin_psi:     -13.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -3.0,    lp:  0.0, f:  2.0,  d:  2.0,  om:  0.0, sin_psi:      -7.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  1.0, f: -2.0,  d:  2.0,  om:  0.0, sin_psi:      10.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  1.0, f:  0.0,  d:  2.0,  om:  2.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -2.0, f:  2.0,  d: -2.0,  om:  1.0, sin_psi:      10.0,       sin_psi_t:    0.0,      cos_psi:    13.0,     cos_eps:       6.0,   cos_eps_t:  0.0,    sin_eps:   -5.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  1.0,  d:  0.0,  om:  2.0, sin_psi:       0.0,       sin_psi_t:    0.0,      cos_psi:    30.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:   14.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  1.0,  d:  0.0,  om:  1.0, sin_psi:       0.0,       sin_psi_t:    0.0,      cos_psi:  -162.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps: -138.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  1.0,  d:  0.0,  om:  0.0, sin_psi:       0.0,       sin_psi_t:    0.0,      cos_psi:    75.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  2.0, f:  0.0,  d:  2.0,  om:  1.0, sin_psi:      -7.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       4.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:      -4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:       4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  0.0,  d: -1.0,  om:  1.0, sin_psi:       5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  3.0,    lp:  0.0, f:  0.0,  d: -2.0,  om:  1.0, sin_psi:       5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  2.0,  d: -2.0,  om:  3.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  2.0, f:  0.0,  d:  0.0,  om:  1.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  2.0,  d: -3.0,  om:  2.0, sin_psi:      -4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  1.0, f:  4.0,  d: -2.0,  om:  2.0, sin_psi:      -5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp: -2.0, f:  0.0,  d:  4.0,  om:  0.0, sin_psi:       6.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -3.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:       9.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f: -2.0,  d:  4.0,  om:  0.0, sin_psi:       5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -1.0, f:  0.0,  d:  3.0,  om:  0.0, sin_psi:      -7.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  0.0,  d:  4.0,  om:  2.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  0.0,  d:  3.0,  om:  1.0, sin_psi:      -4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp: -2.0, f:  0.0,  d:  0.0,  om:  0.0, sin_psi:       7.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -1.0, f:  0.0,  d:  1.0,  om:  0.0, sin_psi:      -4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:       4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -2.0, f:  2.0,  d:  0.0,  om:  1.0, sin_psi:      -6.0,       sin_psi_t:    0.0,      cos_psi:    -3.0,     cos_eps:       3.0,   cos_eps_t:  0.0,    sin_eps:    1.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  1.0,  d:  2.0,  om:  1.0, sin_psi:       0.0,       sin_psi_t:    0.0,      cos_psi:    -3.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:   -2.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  1.0, f:  0.0,  d:  3.0,  om:  0.0, sin_psi:      11.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -1.0, f:  2.0,  d:  1.0,  om:  2.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -1.0, f:  2.0,  d:  0.0,  om:  0.0, sin_psi:      11.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  1.0, f:  2.0,  d:  2.0,  om:  1.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp: -2.0, f:  2.0,  d: -2.0,  om:  2.0, sin_psi:      -1.0,       sin_psi_t:    0.0,      cos_psi:     3.0,     cos_eps:       3.0,   cos_eps_t:  0.0,    sin_eps:   -1.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  1.0, f:  0.0,  d:  1.0,  om:  1.0, sin_psi:       4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  1.0,  d:  0.0,  om:  1.0, sin_psi:       0.0,       sin_psi_t:    0.0,      cos_psi:   -13.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:  -11.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  1.0,  d:  0.0,  om:  0.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     6.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  2.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:      -7.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp: -1.0, f:  2.0,  d: -2.0,  om:  1.0, sin_psi:       5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -1.0, f:  4.0,  d: -2.0,  om:  1.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  4.0,  d: -2.0,  om:  3.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  4.0,  d: -2.0,  om:  1.0, sin_psi:       5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  4.0,    lp:  0.0, f:  2.0,  d: -4.0,  om:  2.0, sin_psi:      -7.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  2.0, f:  2.0,  d: -2.0,  om:  2.0, sin_psi:       8.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  4.0,  d: -4.0,  om:  2.0, sin_psi:      -4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -2.0, f:  0.0,  d:  4.0,  om:  0.0, sin_psi:      11.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -3.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -3.0,    lp:  0.0, f:  2.0,  d:  4.0,  om:  2.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -3.0,    lp:  0.0, f:  2.0,  d: -2.0,  om:  1.0, sin_psi:      -4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -1.0, f:  0.0,  d: -2.0,  om:  1.0, sin_psi:       8.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -4.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -3.0,    lp:  0.0, f:  0.0,  d:  0.0,  om:  2.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -3.0,    lp:  0.0, f: -2.0,  d:  2.0,  om:  0.0, sin_psi:      11.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  0.0,  d: -4.0,  om:  1.0, sin_psi:      -6.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  1.0, f:  0.0,  d: -2.0,  om:  1.0, sin_psi:      -4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -4.0,    lp:  0.0, f:  0.0,  d:  0.0,  om:  1.0, sin_psi:      -8.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       4.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  0.0,  d: -4.0,  om:  1.0, sin_psi:      -7.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -3.0,    lp:  0.0, f:  0.0,  d: -2.0,  om:  1.0, sin_psi:      -4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  0.0,  d:  3.0,  om:  2.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  1.0, f:  0.0,  d:  4.0,  om:  1.0, sin_psi:       6.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -2.0, f:  2.0,  d:  0.0,  om:  1.0, sin_psi:      -6.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  0.0,  d:  3.0,  om:  0.0, sin_psi:       6.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  2.0,  d:  2.0,  om:  3.0, sin_psi:       6.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:       5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:      -5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  1.0, f:  2.0,  d:  2.0,  om:  0.0, sin_psi:      -4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  3.0,    lp:  0.0, f:  0.0,  d:  0.0,  om:  2.0, sin_psi:      -4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  1.0, f:  0.0,  d:  1.0,  om:  0.0, sin_psi:       4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp: -1.0, f:  2.0,  d: -1.0,  om:  2.0, sin_psi:       6.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  1.0, sin_psi:      -4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  3.0,  d:  0.0,  om:  3.0, sin_psi:       0.0,       sin_psi_t:    0.0,      cos_psi:   -26.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:  -11.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  3.0,  d:  0.0,  om:  2.0, sin_psi:       0.0,       sin_psi_t:    0.0,      cos_psi:   -10.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:   -5.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  2.0, f:  2.0,  d:  2.0,  om:  1.0, sin_psi:       5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  4.0,  d:  0.0,  om:  0.0, sin_psi:     -13.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  2.0, f:  2.0,  d:  0.0,  om:  1.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  3.0,    lp:  1.0, f:  2.0,  d: -2.0,  om:  1.0, sin_psi:       4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  1.0, f:  4.0,  d: -2.0,  om:  2.0, sin_psi:       7.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp: -1.0, f:  0.0,  d:  6.0,  om:  0.0, sin_psi:       4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -2.0, f:  0.0,  d:  4.0,  om:  0.0, sin_psi:       5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  0.0,  d:  6.0,  om:  1.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp: -2.0, f:  2.0,  d:  4.0,  om:  2.0, sin_psi:      -6.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -3.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:      -5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  0.0,  d:  4.0,  om:  2.0, sin_psi:      -7.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -1.0, f:  2.0,  d:  3.0,  om:  2.0, sin_psi:       5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  2.0,  d:  4.0,  om:  0.0, sin_psi:      13.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp: -1.0, f:  0.0,  d:  2.0,  om:  1.0, sin_psi:      -4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  0.0,  d:  3.0,  om:  0.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  0.0,  d:  4.0,  om:  1.0, sin_psi:       5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  0.0,  d:  4.0,  om:  0.0, sin_psi:     -11.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -1.0, f:  2.0,  d:  1.0,  om:  2.0, sin_psi:       5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  2.0,  d:  2.0,  om:  3.0, sin_psi:       4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:       4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:      -4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  4.0,  d:  2.0,  om:  1.0, sin_psi:       6.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  1.0, f:  0.0,  d:  2.0,  om:  1.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  1.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:     -12.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp: -1.0, f:  2.0,  d:  0.0,  om:  0.0, sin_psi:       4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  2.0,  d:  1.0,  om:  0.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  2.0,  d:  2.0,  om:  0.0, sin_psi:      -4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  3.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  3.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  3.0,  d:  0.0,  om:  3.0, sin_psi:       0.0,       sin_psi_t:    0.0,      cos_psi:    -5.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:   -2.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  1.0, f:  2.0,  d:  1.0,  om:  1.0, sin_psi:      -7.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       4.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  2.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:       6.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  1.0, f:  2.0,  d:  0.0,  om:  0.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  4.0,  d: -2.0,  om:  1.0, sin_psi:       5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  4.0,    lp:  1.0, f:  2.0,  d: -2.0,  om:  2.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -1.0, f:  0.0,  d:  6.0,  om:  0.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -3.0,    lp: -1.0, f:  2.0,  d:  6.0,  om:  2.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  0.0,  d:  6.0,  om:  1.0, sin_psi:      -5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -3.0,    lp:  0.0, f:  2.0,  d:  6.0,  om:  1.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -1.0, f:  0.0,  d:  4.0,  om:  1.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -1.0, f:  0.0,  d:  4.0,  om:  0.0, sin_psi:      12.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  2.0,  d:  5.0,  om:  2.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -2.0, f:  2.0,  d:  2.0,  om:  1.0, sin_psi:      -4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  3.0,    lp: -1.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:       4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -1.0, f:  2.0,  d:  2.0,  om:  0.0, sin_psi:       6.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  2.0,  d:  3.0,  om:  1.0, sin_psi:       5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  1.0, f:  2.0,  d:  4.0,  om:  1.0, sin_psi:       4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  1.0, f:  2.0,  d:  3.0,  om:  2.0, sin_psi:      -6.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  4.0,  d:  2.0,  om:  1.0, sin_psi:       4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  2.0,  d:  1.0,  om:  1.0, sin_psi:       6.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  5.0,    lp:  0.0, f:  0.0,  d:  0.0,  om:  0.0, sin_psi:       6.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  1.0, f:  2.0,  d:  1.0,  om:  2.0, sin_psi:      -6.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  4.0,  d:  0.0,  om:  1.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  3.0,    lp:  1.0, f:  2.0,  d:  0.0,  om:  1.0, sin_psi:       7.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -4.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  3.0,    lp:  0.0, f:  4.0,  d: -2.0,  om:  2.0, sin_psi:       4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp: -1.0, f:  2.0,  d:  6.0,  om:  2.0, sin_psi:      -5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  0.0,  d:  6.0,  om:  0.0, sin_psi:       5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp: -2.0, f:  2.0,  d:  4.0,  om:  2.0, sin_psi:      -6.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -2.0,    lp:  0.0, f:  2.0,  d:  6.0,  om:  1.0, sin_psi:      -6.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  0.0,  d:  4.0,  om:  1.0, sin_psi:      -4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  0.0,  d:  4.0,  om:  0.0, sin_psi:      10.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp: -2.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:      -4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  2.0,  d:  4.0,  om:  0.0, sin_psi:       7.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  0.0, f:  2.0,  d:  3.0,  om:  2.0, sin_psi:       7.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -3.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  4.0,    lp:  0.0, f:  0.0,  d:  2.0,  om:  0.0, sin_psi:       4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  2.0,  d:  2.0,  om:  0.0, sin_psi:      11.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       0.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  0.0,    lp:  0.0, f:  4.0,  d:  2.0,  om:  2.0, sin_psi:       5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  4.0,    lp: -1.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:      -6.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  3.0,    lp:  0.0, f:  2.0,  d:  1.0,  om:  2.0, sin_psi:       4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  1.0, f:  2.0,  d:  2.0,  om:  1.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  4.0,    lp:  1.0, f:  2.0,  d:  0.0,  om:  2.0, sin_psi:       5.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp: -1.0, f:  2.0,  d:  6.0,  om:  2.0, sin_psi:      -4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l: -1.0,    lp:  0.0, f:  2.0,  d:  6.0,  om:  1.0, sin_psi:      -4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp: -1.0, f:  2.0,  d:  4.0,  om:  1.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  1.0,    lp:  1.0, f:  2.0,  d:  4.0,  om:  2.0, sin_psi:       4.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -2.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  3.0,    lp:  1.0, f:  2.0,  d:  2.0,  om:  2.0, sin_psi:       3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:      -1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  5.0,    lp:  0.0, f:  2.0,  d:  0.0,  om:  1.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp: -1.0, f:  2.0,  d:  4.0,  om:  2.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       1.0,   cos_eps_t:  0.0,    sin_eps:    0.0},
    LuniSolarCoefficients{ l:  2.0,    lp:  0.0, f:  2.0,  d:  4.0,  om:  1.0, sin_psi:      -3.0,       sin_psi_t:    0.0,      cos_psi:     0.0,     cos_eps:       2.0,   cos_eps_t:  0.0,    sin_eps:    0.0}
];
// @formatter:on
