/*
 * Copyright (c) 2023. Helge Eichhorn and the LOX contributors
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, you can obtain one at https://mozilla.org/MPL/2.0/.
 */

use super::PlanetaryCoefficients;

#[rustfmt::skip]
// @formatter:off (sometimes RustRover ignores the rustfmt skip)
pub(super) static COEFFICIENTS: [PlanetaryCoefficients; 687] = [
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   8.0, mars: -16.0,  jupiter:  4.0,    saturn:  5.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:  1440.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -8.0, mars:  16.0,  jupiter: -4.0,    saturn: -5.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    56.0, cos_psi: -117.0,  sin_eps:   -42.0, cos_eps:  -40.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   8.0, mars: -16.0,  jupiter:  4.0,    saturn:  5.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   125.0, cos_psi:  -43.0,  sin_eps:     0.0, cos_eps:  -54.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus: -1.0, neptune:  2.0,    pa:  2.0, sin_psi:     0.0, cos_psi:    5.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -4.0, mars:   8.0,  jupiter: -1.0,    saturn: -5.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     3.0, cos_psi:   -7.0,  sin_eps:    -3.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   4.0, mars:  -8.0,  jupiter:  3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   3.0, mars:  -8.0,  jupiter:  3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:  -114.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   61.0},
    PlanetaryCoefficients{ l: -1.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  10.0, earth:  -3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:  -219.0, cos_psi:   89.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter: -2.0,    saturn:  6.0, uranus: -3.0, neptune:  0.0,    pa:  2.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   4.0, mars:  -8.0,  jupiter:  3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:  -462.0, cos_psi: 1604.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -5.0, mars:   8.0,  jupiter: -3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    99.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:  -53.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -4.0, mars:   8.0,  jupiter: -3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   4.0, mars:  -8.0,  jupiter:  1.0,    saturn:  5.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:    6.0,  sin_eps:     2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -5.0, earth:   6.0, mars:   4.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  2.0,    saturn: -5.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   -12.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  2.0,    saturn: -5.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    14.0, cos_psi: -218.0,  sin_eps:   117.0, cos_eps:    8.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  2.0,    saturn: -5.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    31.0, cos_psi: -481.0,  sin_eps:  -257.0, cos_eps:  -17.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  2.0,    saturn: -5.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:  -491.0, cos_psi:  128.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter: -2.0,    saturn:  5.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi: -3084.0, cos_psi: 5123.0,  sin_eps:  2735.0, cos_eps: 1647.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter: -2.0,    saturn:  5.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi: -1444.0, cos_psi: 2409.0,  sin_eps: -1286.0, cos_eps: -771.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter: -2.0,    saturn:  5.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    11.0, cos_psi:  -24.0,  sin_eps:   -11.0, cos_eps:   -9.0},
    PlanetaryCoefficients{ l:  2.0,   f: -1.0,  d: -1.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   3.0, mars:  -7.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    26.0, cos_psi:   -9.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  1.0,   f:  0.0,  d: -2.0,  om:  0.0, mercury:  0.0,    venus:  19.0, earth: -21.0, mars:   3.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   103.0, cos_psi:  -60.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   2.0, earth:  -4.0, mars:   0.0,  jupiter: -3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:  -13.0,  sin_eps:    -7.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  1.0,   f:  0.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -26.0, cos_psi:  -29.0,  sin_eps:   -16.0, cos_eps:   14.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter: -4.0,    saturn: 10.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     9.0, cos_psi:  -27.0,  sin_eps:   -14.0, cos_eps:   -5.0},
    PlanetaryCoefficients{ l: -2.0,   f:  0.0,  d:  2.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter:  0.0,    saturn: -5.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    12.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -6.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   3.0, earth:  -7.0, mars:   4.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -7.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f: -1.0,  d:  1.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  1.0,    saturn: -1.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   24.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -2.0,   f:  0.0,  d:  2.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   284.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps: -151.0},
    PlanetaryCoefficients{ l: -1.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  18.0, earth: -16.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   226.0, cos_psi:  101.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -2.0,   f:  1.0,  d:  1.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter: -2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -8.0,  sin_eps:    -2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -1.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:  18.0, earth: -17.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -6.0,  sin_eps:    -3.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -1.0,   f:  0.0,  d:  1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:  -2.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     5.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -3.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -8.0, earth:  13.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   -41.0, cos_psi:  175.0,  sin_eps:    76.0, cos_eps:   17.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d: -2.0,  om:  2.0, mercury:  0.0,    venus:  -8.0, earth:  11.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   15.0,  sin_eps:     6.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -8.0, earth:  13.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:   425.0, cos_psi:  212.0,  sin_eps:  -133.0, cos_eps:  269.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:  -8.0, earth:  12.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:  1200.0, cos_psi:  598.0,  sin_eps:   319.0, cos_eps: -641.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   8.0, earth: -13.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   235.0, cos_psi:  334.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   8.0, earth: -14.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    11.0, cos_psi:  -12.0,  sin_eps:    -7.0, cos_eps:   -6.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   8.0, earth: -13.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     5.0, cos_psi:   -6.0,  sin_eps:     3.0, cos_eps:    3.0},
    PlanetaryCoefficients{ l: -2.0,   f:  0.0,  d:  2.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -4.0,    saturn:  5.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -5.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    3.0},
    PlanetaryCoefficients{ l: -2.0,   f:  0.0,  d:  2.0,  om:  2.0, mercury:  0.0,    venus:   3.0, earth:  -3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     6.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -3.0},
    PlanetaryCoefficients{ l: -2.0,   f:  0.0,  d:  2.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -3.0,    saturn:  1.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    15.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   3.0, earth:  -5.0, mars:   0.0,  jupiter:  2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    13.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -7.0},
    PlanetaryCoefficients{ l: -2.0,   f:  0.0,  d:  2.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -4.0,    saturn:  3.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -6.0, cos_psi:   -9.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f: -1.0,  d:  1.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   2.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   266.0, cos_psi:  -78.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   2.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:  -460.0, cos_psi: -435.0,  sin_eps:  -232.0, cos_eps:  246.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:  -2.0, mars:   2.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   15.0,  sin_eps:     7.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -1.0,   f:  1.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   3.0, earth:  -5.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l: -1.0,   f:  0.0,  d:  1.0,  om:  0.0, mercury:  0.0,    venus:   3.0, earth:  -4.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:  131.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -2.0,   f:  0.0,  d:  2.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -2.0,    saturn: -2.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     4.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -2.0,   f:  2.0,  d:  0.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:  -5.0, mars:   9.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus: -1.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    4.0,  sin_eps:     2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  1.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  2.0,    pa:  0.0, sin_psi:   -17.0, cos_psi:  -19.0,  sin_eps:   -10.0, cos_eps:    9.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  2.0,    pa:  1.0, sin_psi:    -9.0, cos_psi:  -11.0,  sin_eps:     6.0, cos_eps:   -5.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  2.0,    pa:  2.0, sin_psi:    -6.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    3.0},
    PlanetaryCoefficients{ l: -1.0,   f:  0.0,  d:  1.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   3.0, mars:  -4.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -16.0, cos_psi:    8.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f: -1.0,  d:  1.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn:  2.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  0.0,    saturn:  2.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    11.0, cos_psi:   24.0,  sin_eps:    11.0, cos_eps:   -5.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -9.0, mars:  17.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:   -4.0,  sin_eps:    -2.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  2.0, mercury:  0.0,    venus:  -3.0, earth:   5.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter: -1.0,    saturn:  2.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -8.0,  sin_eps:    -4.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  1.0,    saturn: -2.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  1.0,   f:  0.0,  d: -2.0,  om:  0.0, mercury:  0.0,    venus:  17.0, earth: -16.0, mars:   0.0,  jupiter: -2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    5.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  1.0,    saturn: -3.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -2.0,   f:  0.0,  d:  2.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   5.0, mars:  -6.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -6.0, cos_psi:    4.0,  sin_eps:     2.0, cos_eps:    3.0},
    PlanetaryCoefficients{ l:  0.0,   f: -2.0,  d:  2.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   9.0, mars: -13.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:   -5.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  0.0,    saturn:  1.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -5.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  0.0,    saturn:  1.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     4.0, cos_psi:   24.0,  sin_eps:    13.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f: -1.0,  d:  1.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn:  1.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -42.0, cos_psi:   20.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f: -2.0,  d:  2.0,  om:  0.0, mercury:  0.0,    venus:   5.0, earth:  -6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -10.0, cos_psi:  233.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f: -1.0,  d:  1.0,  om:  1.0, mercury:  0.0,    venus:   5.0, earth:  -7.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l: -2.0,   f:  0.0,  d:  2.0,  om:  0.0, mercury:  0.0,    venus:   6.0, earth:  -8.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    78.0, cos_psi:  -18.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  2.0,   f:  1.0,  d: -3.0,  om:  1.0, mercury:  0.0,    venus:  -6.0, earth:   7.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     1.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -3.0,  sin_eps:    -1.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f: -1.0,  d:  1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -4.0,  sin_eps:    -2.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  2.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -8.0,  sin_eps:    -4.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  2.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:   -5.0,  sin_eps:     3.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  2.0, neptune:  0.0,    pa:  2.0, sin_psi:    -7.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    3.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -8.0, mars:  15.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   -14.0, cos_psi:    8.0,  sin_eps:     3.0, cos_eps:    6.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -8.0, mars:  15.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:    8.0,  sin_eps:    -4.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -9.0, mars:  15.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   19.0,  sin_eps:    10.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   8.0, mars: -15.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    45.0, cos_psi:  -22.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  1.0,   f: -1.0,  d: -1.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   8.0, mars: -15.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  2.0,   f:  0.0,  d: -2.0,  om:  0.0, mercury:  0.0,    venus:   2.0, earth:  -5.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -3.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -2.0,   f:  0.0,  d:  2.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -5.0,    saturn:  5.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  2.0,   f:  0.0,  d: -2.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -6.0, mars:   8.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     3.0, cos_psi:    5.0,  sin_eps:     3.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  2.0,   f:  0.0,  d: -2.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -2.0, mars:   0.0,  jupiter:  3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    89.0, cos_psi:  -16.0,  sin_eps:    -9.0, cos_eps:  -48.0},
    PlanetaryCoefficients{ l: -2.0,   f:  1.0,  d:  1.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter: -3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -2.0,   f:  1.0,  d:  1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter: -3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:    7.0,  sin_eps:     4.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l: -2.0,   f:  0.0,  d:  2.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:  -349.0, cos_psi:  -62.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -2.0,   f:  0.0,  d:  2.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   6.0, mars:  -8.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -15.0, cos_psi:   22.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -2.0,   f:  0.0,  d:  2.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -1.0,    saturn: -5.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -1.0,   f:  0.0,  d:  1.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter: -1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -53.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -1.0,   f:  1.0,  d:  1.0,  om:  1.0, mercury:  0.0,    venus: -20.0, earth:  20.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     5.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -3.0},
    PlanetaryCoefficients{ l:  1.0,   f:  0.0,  d: -2.0,  om:  0.0, mercury:  0.0,    venus:  20.0, earth: -21.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -8.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   8.0, mars: -15.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    15.0, cos_psi:   -7.0,  sin_eps:    -4.0, cos_eps:   -8.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d: -2.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth: -10.0, mars:  15.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l:  0.0,   f: -1.0,  d:  1.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -21.0, cos_psi:  -78.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    20.0, cos_psi:  -70.0,  sin_eps:   -37.0, cos_eps:  -11.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    6.0,  sin_eps:     3.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter: -2.0,    saturn:  4.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     5.0, cos_psi:    3.0,  sin_eps:     2.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  2.0,   f:  0.0,  d: -2.0,  om:  1.0, mercury:  0.0,    venus:  -6.0, earth:   8.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -17.0, cos_psi:   -4.0,  sin_eps:    -2.0, cos_eps:    9.0},
    PlanetaryCoefficients{ l:  0.0,   f: -2.0,  d:  2.0,  om:  1.0, mercury:  0.0,    venus:   5.0, earth:  -6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    6.0,  sin_eps:     3.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  0.0,    saturn: -1.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    32.0, cos_psi:   15.0,  sin_eps:    -8.0, cos_eps:   17.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  0.0,    saturn: -1.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   174.0, cos_psi:   84.0,  sin_eps:    45.0, cos_eps:  -93.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  0.0,    saturn:  1.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    11.0, cos_psi:   56.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  0.0,    saturn:  1.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -66.0, cos_psi:  -12.0,  sin_eps:    -6.0, cos_eps:   35.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  0.0,    saturn:  1.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    47.0, cos_psi:    8.0,  sin_eps:     4.0, cos_eps:  -25.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  0.0,    saturn:  1.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:    8.0,  sin_eps:     4.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d: -2.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -9.0, mars:  13.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    10.0, cos_psi:  -22.0,  sin_eps:   -12.0, cos_eps:   -5.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   7.0, mars: -13.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l: -2.0,   f:  0.0,  d:  2.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   5.0, mars:  -6.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -24.0, cos_psi:   12.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   9.0, mars: -17.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     5.0, cos_psi:   -6.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -9.0, mars:  17.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  1.0,   f:  0.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -3.0, mars:   4.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     4.0, cos_psi:    3.0,  sin_eps:     1.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  1.0,   f:  0.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:  -3.0, earth:   4.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   29.0,  sin_eps:    15.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   2.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -5.0, cos_psi:   -4.0,  sin_eps:    -2.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f: -1.0,  d:  1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   2.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     8.0, cos_psi:   -3.0,  sin_eps:    -1.0, cos_eps:   -5.0},
    PlanetaryCoefficients{ l:  0.0,   f: -2.0,  d:  2.0,  om:  0.0, mercury:  1.0,    venus:   0.0, earth:  -2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -3.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   3.0, earth:  -5.0, mars:   0.0,  jupiter:  2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    10.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -2.0,   f:  0.0,  d:  2.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -3.0,    saturn:  1.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l: -2.0,   f:  0.0,  d:  2.0,  om:  1.0, mercury:  0.0,    venus:   3.0, earth:  -3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -5.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    3.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   8.0, earth: -13.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    46.0, cos_psi:   66.0,  sin_eps:    35.0, cos_eps:  -25.0},
    PlanetaryCoefficients{ l:  0.0,   f: -1.0,  d:  1.0,  om:  0.0, mercury:  0.0,    venus:   8.0, earth: -12.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -14.0, cos_psi:    7.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d: -2.0,  om:  1.0, mercury:  0.0,    venus:  -8.0, earth:  11.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -1.0,   f:  0.0,  d:  1.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:  -2.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -5.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -1.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:  18.0, earth: -16.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -68.0, cos_psi:  -34.0,  sin_eps:   -18.0, cos_eps:   36.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter: -1.0,    saturn:  1.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   14.0,  sin_eps:     7.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   3.0, earth:  -7.0, mars:   4.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    10.0, cos_psi:   -6.0,  sin_eps:    -3.0, cos_eps:   -5.0},
    PlanetaryCoefficients{ l: -2.0,   f:  1.0,  d:  1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -3.0, mars:   7.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -5.0, cos_psi:   -4.0,  sin_eps:    -2.0, cos_eps:    3.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter: -2.0,    saturn:  5.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:    5.0,  sin_eps:     2.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter: -2.0,    saturn:  5.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    76.0, cos_psi:   17.0,  sin_eps:     9.0, cos_eps:  -41.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -4.0, mars:   8.0,  jupiter: -3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    84.0, cos_psi:  298.0,  sin_eps:   159.0, cos_eps:  -45.0},
    PlanetaryCoefficients{ l:  1.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus: -10.0, earth:   3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d: -2.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l: -1.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:  10.0, earth:  -3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   4.0, mars:  -8.0,  jupiter:  3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -82.0, cos_psi:  292.0,  sin_eps:   156.0, cos_eps:   44.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  2.0,    saturn: -5.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -73.0, cos_psi:   17.0,  sin_eps:     9.0, cos_eps:   39.0},
    PlanetaryCoefficients{ l:  0.0,   f: -1.0,  d:  1.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  2.0,    saturn: -5.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -9.0, cos_psi:  -16.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  2.0,   f: -1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   3.0, mars:  -7.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:    -1.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l: -2.0,   f:  0.0,  d:  2.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter:  0.0,    saturn: -5.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:  -3.0, earth:   7.0, mars:  -4.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -9.0, cos_psi:   -5.0,  sin_eps:    -3.0, cos_eps:    5.0},
    PlanetaryCoefficients{ l: -2.0,   f:  0.0,  d:  2.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:  -439.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  1.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus: -18.0, earth:  16.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    57.0, cos_psi:  -28.0,  sin_eps:   -15.0, cos_eps:  -30.0},
    PlanetaryCoefficients{ l: -2.0,   f:  1.0,  d:  1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter: -2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -6.0,  sin_eps:    -3.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  2.0, mercury:  0.0,    venus:  -8.0, earth:  12.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -4.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:  -8.0, earth:  13.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -40.0, cos_psi:   57.0,  sin_eps:    30.0, cos_eps:   21.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:  -2.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    23.0, cos_psi:    7.0,  sin_eps:     3.0, cos_eps:  -13.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:  -2.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   273.0, cos_psi:   80.0,  sin_eps:    43.0, cos_eps: -146.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:  -2.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:  -449.0, cos_psi:  430.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -2.0, mars:   2.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -8.0, cos_psi:  -47.0,  sin_eps:   -25.0, cos_eps:    4.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   2.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     6.0, cos_psi:   47.0,  sin_eps:    25.0, cos_eps:   -3.0},
    PlanetaryCoefficients{ l: -1.0,   f:  0.0,  d:  1.0,  om:  1.0, mercury:  0.0,    venus:   3.0, earth:  -4.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   23.0,  sin_eps:    13.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -1.0,   f:  0.0,  d:  1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   3.0, mars:  -4.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  0.0,    saturn: -2.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     3.0, cos_psi:   -4.0,  sin_eps:    -2.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  0.0,    saturn:  2.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -48.0, cos_psi: -110.0,  sin_eps:   -59.0, cos_eps:   26.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  0.0,    saturn:  2.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    51.0, cos_psi:  114.0,  sin_eps:    61.0, cos_eps:  -27.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  0.0,    saturn:  2.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:  -133.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   57.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  0.0, mercury:  0.0,    venus:   3.0, earth:  -6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    4.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:  -3.0, earth:   5.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -21.0, cos_psi:   -6.0,  sin_eps:    -3.0, cos_eps:   11.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  2.0, mercury:  0.0,    venus:  -3.0, earth:   4.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -3.0,  sin_eps:    -1.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -2.0, mars:   4.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -11.0, cos_psi:  -21.0,  sin_eps:   -11.0, cos_eps:    6.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d: -2.0,  om:  1.0, mercury:  0.0,    venus:  -5.0, earth:   6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -18.0, cos_psi: -436.0,  sin_eps:  -233.0, cos_eps:    9.0},
    PlanetaryCoefficients{ l:  0.0,   f: -1.0,  d:  1.0,  om:  0.0, mercury:  0.0,    venus:   5.0, earth:  -7.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    35.0, cos_psi:   -7.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   5.0, earth:  -8.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    5.0,  sin_eps:     3.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -2.0,   f:  0.0,  d:  2.0,  om:  1.0, mercury:  0.0,    venus:   6.0, earth:  -8.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    11.0, cos_psi:   -3.0,  sin_eps:    -1.0, cos_eps:   -6.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -8.0, mars:  15.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -5.0, cos_psi:   -3.0,  sin_eps:    -1.0, cos_eps:    3.0},
    PlanetaryCoefficients{ l: -2.0,   f:  0.0,  d:  2.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -53.0, cos_psi:   -9.0,  sin_eps:    -5.0, cos_eps:   28.0},
    PlanetaryCoefficients{ l: -2.0,   f:  0.0,  d:  2.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   6.0, mars:  -8.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     2.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l:  1.0,   f:  0.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     4.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  3.0,    saturn: -5.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -4.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter: -1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -50.0, cos_psi:  194.0,  sin_eps:   103.0, cos_eps:   27.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter: -1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:   -13.0, cos_psi:   52.0,  sin_eps:    28.0, cos_eps:    7.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -91.0, cos_psi:  248.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     6.0, cos_psi:   49.0,  sin_eps:    26.0, cos_eps:   -3.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -6.0, cos_psi:  -47.0,  sin_eps:   -25.0, cos_eps:    3.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:    5.0,  sin_eps:     3.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    52.0, cos_psi:   23.0,  sin_eps:    10.0, cos_eps:  -23.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  0.0,    saturn: -1.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  0.0,    saturn: -1.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    5.0,  sin_eps:     3.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f: -1.0,  d:  1.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn: -1.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -4.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -7.0, mars:  13.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -4.0, cos_psi:    8.0,  sin_eps:     3.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   7.0, mars: -13.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    10.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  2.0,   f:  0.0,  d: -2.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -5.0, mars:   6.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d: -2.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -8.0, mars:  11.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    8.0,  sin_eps:     4.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d: -2.0,  om:  1.0, mercury: -1.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    8.0,  sin_eps:     4.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l: -2.0,   f:  0.0,  d:  2.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   4.0, mars:  -4.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -4.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  2.0,    saturn: -2.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -4.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  0.0,    saturn:  3.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -8.0, cos_psi:    4.0,  sin_eps:     2.0, cos_eps:    4.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  0.0,    saturn:  3.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     8.0, cos_psi:   -4.0,  sin_eps:    -2.0, cos_eps:   -4.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  0.0,    saturn:  3.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:   15.0,  sin_eps:     7.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -2.0,   f:  0.0,  d:  2.0,  om:  0.0, mercury:  0.0,    venus:   3.0, earth:  -3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:  -138.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:  -4.0, mars:   8.0,  jupiter: -3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -7.0,  sin_eps:    -3.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:   4.0, mars:  -8.0,  jupiter:  3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -7.0,  sin_eps:    -3.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  2.0,   f:  0.0,  d: -2.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -2.0, mars:   0.0,  jupiter:  2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    54.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:  -29.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   10.0,  sin_eps:     4.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:  -2.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -7.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    3.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:  -2.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -37.0, cos_psi:   35.0,  sin_eps:    19.0, cos_eps:   20.0},
    PlanetaryCoefficients{ l:  0.0,   f: -1.0,  d:  1.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:  -2.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    4.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f: -1.0,  d:  1.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn: -2.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -4.0, cos_psi:    9.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d: -2.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -2.0, mars:   0.0,  jupiter:  0.0,    saturn:  2.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     8.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -4.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   3.0, earth:  -6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -9.0, cos_psi:  -14.0,  sin_eps:    -8.0, cos_eps:    5.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   3.0, earth:  -5.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    -3.0, cos_psi:   -9.0,  sin_eps:    -5.0, cos_eps:    3.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   3.0, earth:  -5.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:  -145.0, cos_psi:   47.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:  -3.0, earth:   4.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -10.0, cos_psi:   40.0,  sin_eps:    21.0, cos_eps:    5.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -3.0, earth:   5.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    11.0, cos_psi:  -49.0,  sin_eps:   -26.0, cos_eps:   -7.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -3.0, earth:   5.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi: -2150.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:  932.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d: -2.0,  om:  2.0, mercury:  0.0,    venus:  -3.0, earth:   3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -12.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    5.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -3.0, earth:   5.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    85.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:  -37.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:  -4.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     4.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:  -4.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:  -4.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -86.0, cos_psi:  153.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -2.0, mars:   4.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    -6.0, cos_psi:    9.0,  sin_eps:     5.0, cos_eps:    3.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -3.0, mars:   4.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     9.0, cos_psi:  -13.0,  sin_eps:    -7.0, cos_eps:   -5.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -2.0, mars:   4.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    -8.0, cos_psi:   12.0,  sin_eps:     6.0, cos_eps:    4.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -2.0, mars:   4.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   -51.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   22.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -5.0, earth:   8.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   -11.0, cos_psi: -268.0,  sin_eps:  -116.0, cos_eps:    5.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d: -2.0,  om:  2.0, mercury:  0.0,    venus:  -5.0, earth:   6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   12.0,  sin_eps:     5.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -5.0, earth:   8.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:    7.0,  sin_eps:     3.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -5.0, earth:   8.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    31.0, cos_psi:    6.0,  sin_eps:     3.0, cos_eps:  -17.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:  -5.0, earth:   7.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   140.0, cos_psi:   27.0,  sin_eps:    14.0, cos_eps:  -75.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -5.0, earth:   8.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    57.0, cos_psi:   11.0,  sin_eps:     6.0, cos_eps:  -30.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   5.0, earth:  -8.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -14.0, cos_psi:  -39.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter: -1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -6.0,  sin_eps:    -2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter: -1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     4.0, cos_psi:   15.0,  sin_eps:     8.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f: -1.0,  d:  1.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter: -1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    4.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d: -2.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -2.0, mars:   0.0,  jupiter:  1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -6.0, mars:  11.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:   11.0,  sin_eps:     5.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   6.0, mars: -11.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     9.0, cos_psi:    6.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury: -1.0,    venus:   0.0, earth:   4.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -4.0, cos_psi:   10.0,  sin_eps:     4.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  1.0,    venus:   0.0, earth:  -4.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     5.0, cos_psi:    3.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  2.0,   f:  0.0,  d: -2.0,  om:  1.0, mercury:  0.0,    venus:  -3.0, earth:   3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    16.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -9.0},
    PlanetaryCoefficients{ l: -2.0,   f:  0.0,  d:  2.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter:  0.0,    saturn: -2.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d: -2.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -7.0, mars:   9.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     2.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  4.0,    saturn: -5.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     7.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -3.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -25.0, cos_psi:   22.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    42.0, cos_psi:  223.0,  sin_eps:   119.0, cos_eps:  -22.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -27.0, cos_psi: -143.0,  sin_eps:   -77.0, cos_eps:   14.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     9.0, cos_psi:   49.0,  sin_eps:    26.0, cos_eps:   -5.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi: -1166.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:  505.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d: -2.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:  -2.0, mars:   0.0,  jupiter:  2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -5.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  0.0,    saturn:  5.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -6.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    3.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   3.0, earth:  -5.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -8.0, cos_psi:    0.0,  sin_eps:     1.0, cos_eps:    4.0},
    PlanetaryCoefficients{ l:  0.0,   f: -1.0,  d:  1.0,  om:  0.0, mercury:  0.0,    venus:   3.0, earth:  -4.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -4.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d: -2.0,  om:  1.0, mercury:  0.0,    venus:  -3.0, earth:   3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   117.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:  -63.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:  -4.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -4.0, cos_psi:    8.0,  sin_eps:     4.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d: -2.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -4.0, mars:   4.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  2.0, mercury:  0.0,    venus:  -5.0, earth:   7.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -5.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   3.0, mars:  -6.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   31.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -3.0, mars:   6.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    -5.0, cos_psi:    0.0,  sin_eps:     1.0, cos_eps:    3.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -4.0, mars:   6.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     4.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -3.0, mars:   6.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    -4.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -3.0, mars:   6.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   -24.0, cos_psi:  -13.0,  sin_eps:    -6.0, cos_eps:   10.0},
    PlanetaryCoefficients{ l:  0.0,   f: -1.0,  d:  1.0,  om:  0.0, mercury:  0.0,    venus:   2.0, earth:  -2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   2.0, earth:  -3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:  -32.0,  sin_eps:   -17.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -5.0, mars:   9.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     8.0, cos_psi:   12.0,  sin_eps:     5.0, cos_eps:   -3.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -5.0, mars:   9.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   5.0, mars:  -9.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     7.0, cos_psi:   13.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f: -1.0,  d:  1.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter: -2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:   16.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d: -2.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -2.0, mars:   0.0,  jupiter:  2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    50.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:  -27.0},
    PlanetaryCoefficients{ l: -2.0,   f:  1.0,  d:  1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -5.0,  sin_eps:    -3.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f: -2.0,  d:  2.0,  om:  0.0, mercury:  0.0,    venus:   3.0, earth:  -3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    13.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -6.0, earth:  10.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:    5.0,  sin_eps:     3.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -6.0, earth:  10.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    24.0, cos_psi:    5.0,  sin_eps:     2.0, cos_eps:  -11.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -2.0, earth:   3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     5.0, cos_psi:  -11.0,  sin_eps:    -5.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -2.0, earth:   3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    30.0, cos_psi:   -3.0,  sin_eps:    -2.0, cos_eps:  -16.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:  -2.0, earth:   2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    18.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -9.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   2.0, earth:  -3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     8.0, cos_psi:  614.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   2.0, earth:  -3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     3.0, cos_psi:   -3.0,  sin_eps:    -1.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     6.0, cos_psi:   17.0,  sin_eps:     9.0, cos_eps:   -3.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:   -9.0,  sin_eps:    -5.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:    6.0,  sin_eps:     3.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:  -127.0, cos_psi:   21.0,  sin_eps:     9.0, cos_eps:   55.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   4.0, mars:  -8.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     3.0, cos_psi:    5.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -4.0, mars:   8.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -6.0, cos_psi:  -10.0,  sin_eps:    -4.0, cos_eps:    3.0},
    PlanetaryCoefficients{ l:  0.0,   f: -2.0,  d:  2.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     5.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -4.0, mars:   7.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    16.0, cos_psi:    9.0,  sin_eps:     4.0, cos_eps:   -7.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -4.0, mars:   7.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   4.0, mars:  -7.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   22.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:  -2.0, earth:   3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   19.0,  sin_eps:    10.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d: -2.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -2.0, mars:   0.0,  jupiter:  3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     7.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -4.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -5.0, mars:  10.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:   -5.0,  sin_eps:    -2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:  -1.0, earth:   2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     1.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  4.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -9.0, cos_psi:    3.0,  sin_eps:     1.0, cos_eps:    4.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -3.0, mars:   5.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    17.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -7.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -3.0, mars:   5.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:   -3.0,  sin_eps:    -2.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   3.0, mars:  -5.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -20.0, cos_psi:   34.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   1.0, earth:  -2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:   -10.0, cos_psi:    0.0,  sin_eps:     1.0, cos_eps:    5.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   1.0, earth:  -3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -4.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   1.0, earth:  -2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    22.0, cos_psi:  -87.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -1.0, earth:   2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    -4.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -1.0, earth:   2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -3.0, cos_psi:   -6.0,  sin_eps:    -2.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -7.0, earth:  11.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   -16.0, cos_psi:   -3.0,  sin_eps:    -1.0, cos_eps:    7.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -7.0, earth:  11.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:   -3.0,  sin_eps:    -2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f: -2.0,  d:  2.0,  om:  0.0, mercury:  0.0,    venus:   4.0, earth:  -4.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     4.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:  -3.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -68.0, cos_psi:   39.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d: -2.0,  om:  1.0, mercury:  0.0,    venus:  -4.0, earth:   4.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    27.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:  -14.0},
    PlanetaryCoefficients{ l:  0.0,   f: -1.0,  d:  1.0,  om:  0.0, mercury:  0.0,    venus:   4.0, earth:  -5.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -4.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:  -1.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -25.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -4.0, earth:   7.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:   -12.0, cos_psi:   -3.0,  sin_eps:    -2.0, cos_eps:    6.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:  -4.0, earth:   6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -4.0, earth:   7.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     3.0, cos_psi:   66.0,  sin_eps:    29.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -4.0, earth:   6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   490.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps: -213.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -4.0, earth:   6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:   -22.0, cos_psi:   93.0,  sin_eps:    49.0, cos_eps:   12.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:  -4.0, earth:   5.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -7.0, cos_psi:   28.0,  sin_eps:    15.0, cos_eps:    4.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -4.0, earth:   6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    -3.0, cos_psi:   13.0,  sin_eps:     7.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   4.0, earth:  -6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -46.0, cos_psi:   14.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -2.0,   f:  0.0,  d:  2.0,  om:  0.0, mercury:  0.0,    venus:   2.0, earth:  -2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -5.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   1.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     2.0, cos_psi:    1.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f: -1.0,  d:  1.0,  om:  0.0, mercury:  0.0,    venus:   1.0, earth:   0.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -3.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   1.0, earth:  -1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -28.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   15.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  5.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     5.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:  -3.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   3.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   -11.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    5.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -7.0, mars:  12.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     1.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -1.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -1.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    25.0, cos_psi:  106.0,  sin_eps:    57.0, cos_eps:  -13.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:  -1.0, earth:   0.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     5.0, cos_psi:   21.0,  sin_eps:    11.0, cos_eps:   -3.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   1.0, earth:  -1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:  1485.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   1.0, earth:  -1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    -7.0, cos_psi:  -32.0,  sin_eps:   -17.0, cos_eps:    4.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   1.0, earth:  -2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    5.0,  sin_eps:     3.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -2.0, mars:   5.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -6.0, cos_psi:   -3.0,  sin_eps:    -2.0, cos_eps:    3.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  4.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    30.0, cos_psi:   -6.0,  sin_eps:    -2.0, cos_eps:  -13.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter: -4.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -4.0, cos_psi:    4.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:  -1.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -19.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   10.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -6.0, mars:  10.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:    4.0,  sin_eps:     2.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -6.0, mars:  10.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d: -2.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -3.0, mars:   0.0,  jupiter:  3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     4.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -3.0, mars:   7.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:   -3.0,  sin_eps:    -1.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -2.0,   f:  0.0,  d:  2.0,  om:  0.0, mercury:  0.0,    venus:   4.0, earth:  -4.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -5.0, mars:   8.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     5.0, cos_psi:    3.0,  sin_eps:     1.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   5.0, mars:  -8.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   11.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   118.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:  -52.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:   -5.0,  sin_eps:    -3.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter: -3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -28.0, cos_psi:   36.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   2.0, earth:  -4.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     5.0, cos_psi:   -5.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -2.0, earth:   4.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    14.0, cos_psi:  -59.0,  sin_eps:   -31.0, cos_eps:   -8.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:  -2.0, earth:   3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    9.0,  sin_eps:     5.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -2.0, earth:   4.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:  -458.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:  198.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -6.0, earth:   9.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:  -45.0,  sin_eps:   -20.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -6.0, earth:   9.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     9.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -5.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   6.0, earth:  -9.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -3.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter: -2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -4.0,  sin_eps:    -2.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d: -2.0,  om:  1.0, mercury:  0.0,    venus:  -2.0, earth:   2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    11.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -6.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -4.0, mars:   6.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     6.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   4.0, mars:  -6.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -16.0, cos_psi:   23.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   3.0, earth:  -4.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -4.0,  sin_eps:    -2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -5.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter: -2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:  -166.0, cos_psi:  269.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter: -1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    15.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -8.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -5.0, earth:   9.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    10.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -4.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   3.0, mars:  -4.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -78.0, cos_psi:   45.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -3.0, earth:   4.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:   -5.0,  sin_eps:    -2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -3.0, earth:   4.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     7.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -4.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   3.0, earth:  -4.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -5.0, cos_psi:  328.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   3.0, earth:  -4.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:  -2.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     5.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     1.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn: -3.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  1.0,    saturn: -5.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:   -4.0,  sin_eps:    -2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter: -1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi: -1223.0, cos_psi:  -26.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter: -1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:    7.0,  sin_eps:     3.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter: -3.0,    saturn:  5.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:  -3.0, earth:   4.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn: -2.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -6.0, cos_psi:   20.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:  -2.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:  -368.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn: -1.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -75.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    11.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -6.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -2.0, mars:   2.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -8.0, earth:  14.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  2.0,    saturn: -5.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -13.0, cos_psi:  -30.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   5.0, mars:  -8.0,  jupiter:  3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    21.0, cos_psi:    3.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   5.0, mars:  -8.0,  jupiter:  3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    -4.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     8.0, cos_psi:  -27.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   3.0, mars:  -8.0,  jupiter:  3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -19.0, cos_psi:  -11.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -3.0, mars:   8.0,  jupiter: -3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -4.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter: -2.0,    saturn:  5.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:    5.0,  sin_eps:     2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -8.0, earth:  12.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -6.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -8.0, earth:  12.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -8.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  1.0,    saturn: -2.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -1.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn:  1.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   -14.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    6.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   2.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     6.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   2.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   -74.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   32.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn:  2.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:   -3.0,  sin_eps:    -1.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d: -2.0,  om:  1.0, mercury:  0.0,    venus:  -5.0, earth:   5.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     4.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     8.0, cos_psi:   11.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:  -262.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:  114.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   3.0, earth:  -6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -4.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -3.0, earth:   6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    -7.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    4.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -3.0, earth:   6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:  -27.0,  sin_eps:   -12.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   4.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   -19.0, cos_psi:   -8.0,  sin_eps:    -4.0, cos_eps:    8.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -5.0, earth:   7.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   202.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:  -87.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -5.0, earth:   7.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    -8.0, cos_psi:   35.0,  sin_eps:    19.0, cos_eps:    5.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:  -5.0, earth:   6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    4.0,  sin_eps:     2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   5.0, earth:  -7.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    16.0, cos_psi:   -5.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d: -2.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     5.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -3.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -3.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury: -1.0,    venus:   0.0, earth:   3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     1.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   -35.0, cos_psi:  -48.0,  sin_eps:   -21.0, cos_eps:   15.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -2.0, mars:   6.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -3.0, cos_psi:   -5.0,  sin_eps:    -2.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   2.0, earth:  -2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     6.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -3.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -6.0, mars:   9.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   6.0, mars:  -9.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -5.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -2.0, earth:   2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    12.0, cos_psi:   55.0,  sin_eps:    29.0, cos_eps:   -6.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:  -2.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    5.0,  sin_eps:     3.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   2.0, earth:  -2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:  -598.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   2.0, earth:  -2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    -3.0, cos_psi:  -13.0,  sin_eps:    -7.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -5.0, cos_psi:   -7.0,  sin_eps:    -3.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -5.0, mars:   7.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   5.0, mars:  -7.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     5.0, cos_psi:   -7.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:  -2.0, earth:   2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     4.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   4.0, mars:  -5.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    16.0, cos_psi:   -6.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   1.0, earth:  -3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     8.0, cos_psi:   -3.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -1.0, earth:   3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     8.0, cos_psi:  -31.0,  sin_eps:   -16.0, cos_eps:   -4.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:  -1.0, earth:   2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     1.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -1.0, earth:   3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   113.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:  -49.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -7.0, earth:  10.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:  -24.0,  sin_eps:   -10.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -7.0, earth:  10.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     4.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   3.0, mars:  -3.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    27.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -4.0, earth:   8.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -4.0, earth:   5.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:   -4.0,  sin_eps:    -2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -4.0, earth:   5.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     5.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   4.0, earth:  -5.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -3.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   1.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   -13.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    6.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -2.0, mars:   0.0,  jupiter:  5.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     5.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   3.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   -18.0, cos_psi:  -10.0,  sin_eps:    -4.0, cos_eps:    8.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   1.0, earth:   0.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -4.0, cos_psi:  -28.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   1.0, earth:   0.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -5.0, cos_psi:    6.0,  sin_eps:     3.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -9.0, earth:  13.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   5.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -5.0, cos_psi:   -9.0,  sin_eps:    -4.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -2.0, mars:   0.0,  jupiter:  4.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    17.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -7.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -4.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    11.0, cos_psi:    4.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -2.0, mars:   7.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:   -6.0,  sin_eps:    -2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    83.0, cos_psi:   15.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -2.0, earth:   5.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    -4.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -2.0, earth:   5.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi: -114.0,  sin_eps:   -49.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -6.0, earth:   8.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   117.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:  -51.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -6.0, earth:   8.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    -5.0, cos_psi:   19.0,  sin_eps:    10.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   6.0, earth:  -8.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -3.0, mars:   9.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:   -3.0,  sin_eps:    -1.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   5.0, mars:  -6.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   5.0, mars:  -6.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:   -6.0,  sin_eps:    -2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   393.0, cos_psi:    3.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    -4.0, cos_psi:   21.0,  sin_eps:    11.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -6.0, cos_psi:    0.0,  sin_eps:    -1.0, cos_eps:    3.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -5.0, earth:  10.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -3.0, cos_psi:    8.0,  sin_eps:     4.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   4.0, mars:  -4.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     8.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   4.0, mars:  -4.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    18.0, cos_psi:  -29.0,  sin_eps:   -13.0, cos_eps:   -8.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -3.0, earth:   3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     8.0, cos_psi:   34.0,  sin_eps:    18.0, cos_eps:   -4.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   3.0, earth:  -3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    89.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   3.0, earth:  -3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     3.0, cos_psi:   12.0,  sin_eps:     6.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   3.0, earth:  -3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    54.0, cos_psi:  -15.0,  sin_eps:    -7.0, cos_eps:  -24.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter:  0.0,    saturn: -3.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -5.0, mars:  13.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   35.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:  -154.0, cos_psi:  -30.0,  sin_eps:   -13.0, cos_eps:   67.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter:  0.0,    saturn: -2.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    15.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter:  0.0,    saturn: -2.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:    4.0,  sin_eps:     2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   3.0, mars:  -2.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    9.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   3.0, mars:  -2.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    80.0, cos_psi:  -71.0,  sin_eps:   -31.0, cos_eps:  -35.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter:  0.0,    saturn: -1.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:  -20.0,  sin_eps:    -9.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -6.0, mars:  15.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    11.0, cos_psi:    5.0,  sin_eps:     2.0, cos_eps:   -5.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -8.0, earth:  15.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    61.0, cos_psi:  -96.0,  sin_eps:   -42.0, cos_eps:  -27.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -3.0, earth:   9.0, mars:  -4.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    14.0, cos_psi:    9.0,  sin_eps:     4.0, cos_eps:   -6.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter:  2.0,    saturn: -5.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   -11.0, cos_psi:   -6.0,  sin_eps:    -3.0, cos_eps:    5.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -2.0, mars:   8.0,  jupiter: -1.0,    saturn: -5.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:   -3.0,  sin_eps:    -1.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   6.0, mars:  -8.0,  jupiter:  3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   123.0, cos_psi: -415.0,  sin_eps:  -180.0, cos_eps:  -53.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:  -35.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -5.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     7.0, cos_psi:  -32.0,  sin_eps:   -17.0, cos_eps:   -4.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -9.0,  sin_eps:    -5.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:   -4.0,  sin_eps:     2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   -89.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   38.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -6.0, mars:  16.0,  jupiter: -4.0,    saturn: -5.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:  -86.0,  sin_eps:   -19.0, cos_eps:   -6.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -2.0, mars:   8.0,  jupiter: -3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:    0.0,  sin_eps:   -19.0, cos_eps:    6.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -2.0, mars:   8.0,  jupiter: -3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:  -123.0, cos_psi: -416.0,  sin_eps:  -180.0, cos_eps:   53.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   6.0, mars:  -8.0,  jupiter:  1.0,    saturn:  5.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:   -3.0,  sin_eps:    -1.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -2.0,    saturn:  5.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    12.0, cos_psi:   -6.0,  sin_eps:    -3.0, cos_eps:   -5.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   3.0, earth:  -5.0, mars:   4.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   -13.0, cos_psi:    9.0,  sin_eps:     4.0, cos_eps:    6.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -8.0, earth:  11.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:  -15.0,  sin_eps:    -7.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -8.0, earth:  11.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -8.0, earth:  11.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   -62.0, cos_psi:  -97.0,  sin_eps:   -42.0, cos_eps:   27.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  11.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   -11.0, cos_psi:    5.0,  sin_eps:     2.0, cos_eps:    5.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter:  0.0,    saturn:  1.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:  -19.0,  sin_eps:    -8.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   3.0, earth:  -3.0, mars:   0.0,  jupiter:  2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d: -2.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   4.0, mars:  -8.0,  jupiter:  3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    4.0,  sin_eps:     2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d: -1.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d: -2.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -4.0, mars:   8.0,  jupiter: -3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    4.0,  sin_eps:     2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   2.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   -85.0, cos_psi:  -70.0,  sin_eps:   -31.0, cos_eps:   37.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter:  1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   163.0, cos_psi:  -12.0,  sin_eps:    -5.0, cos_eps:  -72.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -3.0, earth:   7.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   -63.0, cos_psi:  -16.0,  sin_eps:    -7.0, cos_eps:   28.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   4.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   -21.0, cos_psi:  -32.0,  sin_eps:   -14.0, cos_eps:    9.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -5.0, earth:   6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:   -3.0,  sin_eps:    -1.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -5.0, earth:   6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   5.0, earth:  -6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    8.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   5.0, earth:  -6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     3.0, cos_psi:   10.0,  sin_eps:     4.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter:  2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   6.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:   -7.0,  sin_eps:    -3.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   7.0, mars:  -9.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:   -4.0,  sin_eps:    -2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   2.0, earth:  -1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     6.0, cos_psi:   19.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   2.0, earth:  -1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     5.0, cos_psi: -173.0,  sin_eps:   -75.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   6.0, mars:  -7.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:   -7.0,  sin_eps:    -3.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   5.0, mars:  -5.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     7.0, cos_psi:  -12.0,  sin_eps:    -5.0, cos_eps:   -3.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -1.0, earth:   4.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -1.0, earth:   4.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     3.0, cos_psi:   -4.0,  sin_eps:    -2.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -7.0, earth:   9.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    74.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:  -32.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -7.0, earth:   9.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:    -3.0, cos_psi:   12.0,  sin_eps:     6.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   4.0, mars:  -3.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    26.0, cos_psi:  -14.0,  sin_eps:    -6.0, cos_eps:  -11.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   3.0, mars:  -1.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    19.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -8.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -4.0, earth:   4.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     6.0, cos_psi:   24.0,  sin_eps:    13.0, cos_eps:   -3.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   4.0, earth:  -4.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    83.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   4.0, earth:  -4.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:  -10.0,  sin_eps:    -5.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   4.0, earth:  -4.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    11.0, cos_psi:   -3.0,  sin_eps:    -1.0, cos_eps:   -5.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   1.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     1.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -3.0, mars:   0.0,  jupiter:  5.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   1.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -4.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   1.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     5.0, cos_psi:  -23.0,  sin_eps:   -12.0, cos_eps:   -3.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   1.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:  -339.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:  147.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -9.0, earth:  12.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:  -10.0,  sin_eps:    -5.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   3.0, mars:   0.0,  jupiter: -4.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     5.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d: -2.0,  om:  1.0, mercury:  0.0,    venus:   1.0, earth:  -1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   7.0, mars:  -8.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:   -4.0,  sin_eps:    -2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   3.0, mars:   0.0,  jupiter: -3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    18.0, cos_psi:   -3.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   3.0, mars:   0.0,  jupiter: -3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     9.0, cos_psi:  -11.0,  sin_eps:    -5.0, cos_eps:   -4.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -2.0, earth:   6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -8.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    4.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -6.0, earth:   7.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   6.0, earth:  -7.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    9.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   6.0, mars:  -6.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     6.0, cos_psi:   -9.0,  sin_eps:    -4.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   3.0, mars:   0.0,  jupiter: -2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -4.0, cos_psi:  -12.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   3.0, mars:   0.0,  jupiter: -2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    67.0, cos_psi:  -91.0,  sin_eps:   -39.0, cos_eps:  -29.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   5.0, mars:  -4.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    30.0, cos_psi:  -18.0,  sin_eps:    -8.0, cos_eps:  -13.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   3.0, earth:  -2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   3.0, earth:  -2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi: -114.0,  sin_eps:   -50.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   3.0, mars:   0.0,  jupiter: -1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   23.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   3.0, mars:   0.0,  jupiter: -1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   517.0, cos_psi:   16.0,  sin_eps:     7.0, cos_eps: -224.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   3.0, mars:   0.0,  jupiter:  0.0,    saturn: -2.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:   -7.0,  sin_eps:    -3.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   4.0, mars:  -2.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   143.0, cos_psi:   -3.0,  sin_eps:    -1.0, cos_eps:  -62.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   3.0, mars:   0.0,  jupiter:  0.0,    saturn: -1.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    29.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:  -13.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d: -2.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter: -1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -4.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -8.0, earth:  16.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -6.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    3.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   3.0, mars:   0.0,  jupiter:  2.0,    saturn: -5.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     5.0, cos_psi:   12.0,  sin_eps:     5.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   7.0, mars:  -8.0,  jupiter:  3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   -25.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   11.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -5.0, mars:  16.0,  jupiter: -4.0,    saturn: -5.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:    4.0,  sin_eps:     2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   8.0,  jupiter: -3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   -22.0, cos_psi:   12.0,  sin_eps:     5.0, cos_eps:   10.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -8.0, earth:  10.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    50.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:  -22.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -8.0, earth:  10.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:    7.0,  sin_eps:     4.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -8.0, earth:  10.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     1.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   2.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -4.0, cos_psi:    4.0,  sin_eps:     2.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   3.0, mars:   0.0,  jupiter:  1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -5.0, cos_psi:  -11.0,  sin_eps:    -5.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -3.0, earth:   8.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:    4.0,  sin_eps:     2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -5.0, earth:   5.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     4.0, cos_psi:   17.0,  sin_eps:     9.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   5.0, earth:  -5.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    59.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   5.0, earth:  -5.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:   -4.0,  sin_eps:    -2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   5.0, earth:  -5.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -8.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    4.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   2.0, earth:   0.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   2.0, earth:   0.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     4.0, cos_psi:  -15.0,  sin_eps:    -8.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   2.0, earth:   0.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   370.0, cos_psi:   -8.0,  sin_eps:     0.0, cos_eps: -160.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   7.0, mars:  -7.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:    0.0,  sin_eps:    -3.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   7.0, mars:  -7.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     1.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   6.0, mars:  -5.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -6.0, cos_psi:    3.0,  sin_eps:     1.0, cos_eps:    3.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   7.0, earth:  -8.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    6.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   5.0, mars:  -3.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   -10.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    4.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   4.0, earth:  -3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:    9.0,  sin_eps:     4.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   1.0, earth:   2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     4.0, cos_psi:   17.0,  sin_eps:     7.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -9.0, earth:  11.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    34.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:  -15.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -9.0, earth:  11.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:    5.0,  sin_eps:     3.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   4.0, mars:   0.0,  jupiter: -4.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -5.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   4.0, mars:   0.0,  jupiter: -3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:   -37.0, cos_psi:   -7.0,  sin_eps:    -3.0, cos_eps:   16.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -6.0, earth:   6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     3.0, cos_psi:   13.0,  sin_eps:     7.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   6.0, earth:  -6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    40.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   6.0, earth:  -6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:   -3.0,  sin_eps:    -2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   4.0, mars:   0.0,  jupiter: -2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:  -184.0, cos_psi:   -3.0,  sin_eps:    -1.0, cos_eps:   80.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   6.0, mars:  -4.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   3.0, earth:  -1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   3.0, earth:  -1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:  -10.0,  sin_eps:    -6.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   3.0, earth:  -1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    31.0, cos_psi:   -6.0,  sin_eps:     0.0, cos_eps:  -13.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   4.0, mars:   0.0,  jupiter: -1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -3.0, cos_psi:  -32.0,  sin_eps:   -14.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   4.0, mars:   0.0,  jupiter:  0.0,    saturn: -2.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -7.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    3.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   5.0, mars:  -2.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:   -8.0,  sin_eps:    -4.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   4.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     3.0, cos_psi:   -4.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   8.0, earth:  -9.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    4.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   5.0, earth:  -4.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     1.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   2.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    19.0, cos_psi:  -23.0,  sin_eps:   -10.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   2.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:  -10.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   2.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -7.0, earth:   7.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:    9.0,  sin_eps:     5.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   7.0, earth:  -7.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    28.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   4.0, earth:  -2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:   -7.0,  sin_eps:    -4.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   4.0, earth:  -2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     8.0, cos_psi:   -4.0,  sin_eps:     0.0, cos_eps:   -4.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   4.0, earth:  -2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    0.0,  sin_eps:    -2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   4.0, earth:  -2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   5.0, mars:   0.0,  jupiter: -4.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   5.0, mars:   0.0,  jupiter: -3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    -9.0, cos_psi:    0.0,  sin_eps:     1.0, cos_eps:    4.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   5.0, mars:   0.0,  jupiter: -2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     3.0, cos_psi:   12.0,  sin_eps:     5.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   3.0, earth:   0.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    17.0, cos_psi:   -3.0,  sin_eps:    -1.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -8.0, earth:   8.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:    7.0,  sin_eps:     4.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   8.0, earth:  -8.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    19.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   5.0, earth:  -3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:   -5.0,  sin_eps:    -3.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   5.0, earth:  -3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:    14.0, cos_psi:   -3.0,  sin_eps:     0.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -9.0, earth:   9.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:    0.0,  sin_eps:    -1.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -9.0, earth:   9.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -5.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:  -9.0, earth:   9.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:    5.0,  sin_eps:     3.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   9.0, earth:  -9.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    13.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   6.0, earth:  -4.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:   -3.0,  sin_eps:    -2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     2.0, cos_psi:    9.0,  sin_eps:     4.0, cos_eps:    3.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -4.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     8.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:    4.0,  sin_eps:     2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     6.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -3.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     6.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  1.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     1.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   6.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     5.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   0.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  2.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  1.0,   f:  0.0,  d: -2.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  1.0,   f:  0.0,  d: -2.0,  om:  0.0, mercury:  0.0,    venus:   2.0, earth:  -2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     6.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  1.0,   f:  0.0,  d: -2.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter: -1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     7.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  1.0,   f:  0.0,  d: -2.0,  om:  0.0, mercury:  0.0,    venus:   1.0, earth:  -1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -4.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -1.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   3.0, earth:  -3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     4.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -1.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     6.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -1.0,   f:  0.0,  d:  2.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   4.0, mars:  -8.0,  jupiter:  3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -4.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  1.0,   f:  0.0,  d: -2.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   4.0, mars:  -8.0,  jupiter:  3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -4.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -2.0,   f:  0.0,  d:  2.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   4.0, mars:  -8.0,  jupiter:  3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     5.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -1.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -1.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter: -1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     4.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -1.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   1.0, earth:  -1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -5.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -1.0,   f:  0.0,  d:  2.0,  om:  0.0, mercury:  0.0,    venus:   2.0, earth:  -2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     4.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  1.0,   f: -1.0,  d:  1.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -1.0,   f:  0.0,  d:  2.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    13.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -2.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    21.0, cos_psi:   11.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  1.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   4.0, mars:  -8.0,  jupiter:  3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -5.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -1.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -5.0,  sin_eps:    -2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  1.0,   f:  1.0,  d: -1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    5.0,  sin_eps:     3.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -1.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   4.0, mars:  -8.0,  jupiter:  3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -5.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -1.0,   f:  0.0,  d:  2.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    20.0, cos_psi:   10.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -1.0,   f:  0.0,  d:  2.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -34.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -1.0,   f:  0.0,  d:  2.0,  om:  0.0, mercury:  0.0,    venus:   3.0, earth:  -3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -19.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  1.0,   f:  0.0,  d: -2.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -2.0, mars:   0.0,  jupiter:  2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  1.0,   f:  2.0,  d: -2.0,  om:  2.0, mercury:  0.0,    venus:  -3.0, earth:   3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l:  1.0,   f:  2.0,  d: -2.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:  -2.0, mars:   0.0,  jupiter:  2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -6.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    3.0},
    PlanetaryCoefficients{ l:  1.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   1.0, earth:  -1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -4.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  1.0,   f:  0.0,  d:  0.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter: -1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d: -2.0,  om:  0.0, mercury:  0.0,    venus:   2.0, earth:  -2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d: -2.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter: -1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     4.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d:  0.0,  om:  2.0, mercury:  0.0,    venus:  -2.0, earth:   2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d:  0.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     6.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -3.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d:  0.0,  om:  2.0, mercury:  0.0,    venus:  -1.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -8.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    3.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d:  0.0,  om:  2.0, mercury:  0.0,    venus:  -2.0, earth:   3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     1.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  0.0,  d:  2.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d:  1.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -3.0,  sin_eps:    -2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  1.0,   f:  2.0,  d:  0.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   126.0, cos_psi:  -63.0,  sin_eps:   -27.0, cos_eps:  -55.0},
    PlanetaryCoefficients{ l: -1.0,   f:  2.0,  d:  0.0,  om:  2.0, mercury:  0.0,    venus:  10.0, earth:  -3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -5.0, cos_psi:    0.0,  sin_eps:     1.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d:  1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:   28.0,  sin_eps:    15.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  1.0,   f:  2.0,  d:  0.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     5.0, cos_psi:    0.0,  sin_eps:     1.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d:  0.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:   4.0, mars:  -8.0,  jupiter:  3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    9.0,  sin_eps:     4.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d:  0.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:  -4.0, mars:   8.0,  jupiter: -3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    9.0,  sin_eps:     4.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l: -1.0,   f:  2.0,  d:  0.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:  -4.0, mars:   8.0,  jupiter: -3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:  -126.0, cos_psi:  -63.0,  sin_eps:   -27.0, cos_eps:   55.0},
    PlanetaryCoefficients{ l:  2.0,   f:  2.0,  d: -2.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:  -2.0, mars:   0.0,  jupiter:  3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  1.0,   f:  2.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:  -2.0, mars:   0.0,  jupiter:  3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    21.0, cos_psi:  -11.0,  sin_eps:    -6.0, cos_eps:  -11.0},
    PlanetaryCoefficients{ l:  0.0,   f:  1.0,  d:  1.0,  om:  0.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:   -4.0,  sin_eps:     0.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l: -1.0,   f:  2.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -21.0, cos_psi:  -11.0,  sin_eps:    -6.0, cos_eps:   11.0},
    PlanetaryCoefficients{ l: -2.0,   f:  2.0,  d:  2.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d:  0.0,  om:  2.0, mercury:  0.0,    venus:   2.0, earth:  -3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     1.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d:  0.0,  om:  2.0, mercury:  0.0,    venus:   1.0, earth:  -1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     8.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -4.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d:  0.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter: -1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -6.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    3.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d:  0.0,  om:  2.0, mercury:  0.0,    venus:   2.0, earth:  -2.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l: -1.0,   f:  2.0,  d:  2.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:  -1.0, mars:   0.0,  jupiter:  1.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  1.0,   f:  2.0,  d:  0.0,  om:  2.0, mercury:  0.0,    venus:  -1.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    1.0},
    PlanetaryCoefficients{ l: -1.0,   f:  2.0,  d:  2.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    -5.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:    2.0},
    PlanetaryCoefficients{ l:  2.0,   f:  2.0,  d:  0.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    24.0, cos_psi:  -12.0,  sin_eps:    -5.0, cos_eps:  -11.0},
    PlanetaryCoefficients{ l:  1.0,   f:  2.0,  d:  0.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:  -4.0, mars:   8.0,  jupiter: -3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     1.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  1.0,   f:  2.0,  d:  0.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:   4.0, mars:  -8.0,  jupiter:  3.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     1.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  1.0,   f:  1.0,  d:  1.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     0.0, cos_psi:    3.0,  sin_eps:     2.0, cos_eps:    0.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d:  0.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:   -24.0, cos_psi:  -12.0,  sin_eps:    -5.0, cos_eps:   10.0},
    PlanetaryCoefficients{ l:  2.0,   f:  2.0,  d:  0.0,  om:  1.0, mercury:  0.0,    venus:   0.0, earth:   1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     4.0, cos_psi:    0.0,  sin_eps:    -1.0, cos_eps:   -2.0},
    PlanetaryCoefficients{ l: -1.0,   f:  2.0,  d:  2.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:    13.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -6.0},
    PlanetaryCoefficients{ l: -1.0,   f:  2.0,  d:  2.0,  om:  2.0, mercury:  0.0,    venus:   3.0, earth:  -3.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     7.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -3.0},
    PlanetaryCoefficients{ l:  1.0,   f:  2.0,  d:  0.0,  om:  2.0, mercury:  0.0,    venus:   1.0, earth:  -1.0, mars:   0.0,  jupiter:  0.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -1.0},
    PlanetaryCoefficients{ l:  0.0,   f:  2.0,  d:  2.0,  om:  2.0, mercury:  0.0,    venus:   0.0, earth:   2.0, mars:   0.0,  jupiter: -2.0,    saturn:  0.0, uranus:  0.0, neptune:  0.0,    pa:  0.0, sin_psi:     3.0, cos_psi:    0.0,  sin_eps:     0.0, cos_eps:   -1.0}
];
// @formatter:off
