/*
 * Copyright (c) 2024. Helge Eichhorn and the LOX contributors
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, you can obtain one at https://mozilla.org/MPL/2.0/.
 */

use crate::tides::{LuniSolarTidalTerm, OceanicTidalTerm};

pub const OCEANIC_TIDAL_TERMS: [OceanicTidalTerm; 71] = [
    OceanicTidalTerm {
        coefficients: [1, -1, 0, -2, -2, -2],
        x_sin: -0.05,
        x_cos: 0.94,
        y_sin: -0.94,
        y_cos: -0.05,
        t_sin: 0.396,
        t_cos: -0.078,
    },
    OceanicTidalTerm {
        coefficients: [1, -2, 0, -2, 0, -1],
        x_sin: 0.06,
        x_cos: 0.64,
        y_sin: -0.64,
        y_cos: 0.06,
        t_sin: 0.195,
        t_cos: -0.059,
    },
    OceanicTidalTerm {
        coefficients: [1, -2, 0, -2, 0, -2],
        x_sin: 0.30,
        x_cos: 3.42,
        y_sin: -3.42,
        y_cos: 0.30,
        t_sin: 1.034,
        t_cos: -0.314,
    },
    OceanicTidalTerm {
        coefficients: [1, 0, 0, -2, -2, -1],
        x_sin: 0.08,
        x_cos: 0.78,
        y_sin: -0.78,
        y_cos: 0.08,
        t_sin: 0.224,
        t_cos: -0.073,
    },
    OceanicTidalTerm {
        coefficients: [1, 0, 0, -2, -2, -2],
        x_sin: 0.46,
        x_cos: 4.15,
        y_sin: -4.15,
        y_cos: 0.45,
        t_sin: 1.187,
        t_cos: -0.387,
    },
    OceanicTidalTerm {
        coefficients: [1, -1, 0, -2, 0, -1],
        x_sin: 1.19,
        x_cos: 4.96,
        y_sin: -4.96,
        y_cos: 1.19,
        t_sin: 0.966,
        t_cos: -0.474,
    },
    OceanicTidalTerm {
        coefficients: [1, -1, 0, -2, 0, -2],
        x_sin: 6.24,
        x_cos: 26.31,
        y_sin: -26.31,
        y_cos: 6.23,
        t_sin: 5.118,
        t_cos: -2.499,
    },
    OceanicTidalTerm {
        coefficients: [1, 1, 0, -2, -2, -1],
        x_sin: 0.24,
        x_cos: 0.94,
        y_sin: -0.94,
        y_cos: 0.24,
        t_sin: 0.172,
        t_cos: -0.090,
    },
    OceanicTidalTerm {
        coefficients: [1, 1, 0, -2, -2, -2],
        x_sin: 1.28,
        x_cos: 4.99,
        y_sin: -4.99,
        y_cos: 1.28,
        t_sin: 0.911,
        t_cos: -0.475,
    },
    OceanicTidalTerm {
        coefficients: [1, 0, 0, -2, 0, 0],
        x_sin: -0.28,
        x_cos: -0.77,
        y_sin: 0.77,
        y_cos: -0.28,
        t_sin: -0.093,
        t_cos: 0.070,
    },
    OceanicTidalTerm {
        coefficients: [1, 0, 0, -2, 0, -1],
        x_sin: 9.22,
        x_cos: 25.06,
        y_sin: -25.06,
        y_cos: 9.22,
        t_sin: 3.025,
        t_cos: -2.280,
    },
    OceanicTidalTerm {
        coefficients: [1, 0, 0, -2, 0, -2],
        x_sin: 48.82,
        x_cos: 132.91,
        y_sin: -132.90,
        y_cos: 48.82,
        t_sin: 16.020,
        t_cos: -12.069,
    },
    OceanicTidalTerm {
        coefficients: [1, -2, 0, 0, 0, 0],
        x_sin: -0.32,
        x_cos: -0.86,
        y_sin: 0.86,
        y_cos: -0.32,
        t_sin: -0.103,
        t_cos: 0.078,
    },
    OceanicTidalTerm {
        coefficients: [1, 0, 0, 0, -2, 0],
        x_sin: -0.66,
        x_cos: -1.72,
        y_sin: 1.72,
        y_cos: -0.66,
        t_sin: -0.194,
        t_cos: 0.154,
    },
    OceanicTidalTerm {
        coefficients: [1, -1, 0, -2, 2, -2],
        x_sin: -0.42,
        x_cos: -0.92,
        y_sin: 0.92,
        y_cos: -0.42,
        t_sin: -0.083,
        t_cos: 0.074,
    },
    OceanicTidalTerm {
        coefficients: [1, 1, 0, -2, 0, -1],
        x_sin: -0.30,
        x_cos: -0.64,
        y_sin: 0.64,
        y_cos: -0.30,
        t_sin: -0.057,
        t_cos: 0.050,
    },
    OceanicTidalTerm {
        coefficients: [1, 1, 0, -2, 0, -2],
        x_sin: -1.61,
        x_cos: -3.46,
        y_sin: 3.46,
        y_cos: -1.61,
        t_sin: -0.308,
        t_cos: 0.271,
    },
    OceanicTidalTerm {
        coefficients: [1, -1, 0, 0, 0, 0],
        x_sin: -4.48,
        x_cos: -9.61,
        y_sin: 9.61,
        y_cos: -4.48,
        t_sin: -0.856,
        t_cos: 0.751,
    },
    OceanicTidalTerm {
        coefficients: [1, -1, 0, 0, 0, -1],
        x_sin: -0.90,
        x_cos: -1.93,
        y_sin: 1.93,
        y_cos: -0.90,
        t_sin: -0.172,
        t_cos: 0.151,
    },
    OceanicTidalTerm {
        coefficients: [1, 1, 0, 0, -2, 0],
        x_sin: -0.86,
        x_cos: -1.81,
        y_sin: 1.81,
        y_cos: -0.86,
        t_sin: -0.161,
        t_cos: 0.137,
    },
    OceanicTidalTerm {
        coefficients: [1, 0, -1, -2, 2, -2],
        x_sin: 1.54,
        x_cos: 3.03,
        y_sin: -3.03,
        y_cos: 1.54,
        t_sin: 0.315,
        t_cos: -0.189,
    },
    OceanicTidalTerm {
        coefficients: [1, 0, 0, -2, 2, -1],
        x_sin: -0.29,
        x_cos: -0.58,
        y_sin: 0.58,
        y_cos: -0.29,
        t_sin: -0.062,
        t_cos: 0.035,
    },
    OceanicTidalTerm {
        coefficients: [1, 0, 0, -2, 2, -2],
        x_sin: 26.13,
        x_cos: 51.25,
        y_sin: -51.25,
        y_cos: 26.13,
        t_sin: 5.512,
        t_cos: -3.095,
    },
    OceanicTidalTerm {
        coefficients: [1, 0, 1, -2, 2, -2],
        x_sin: -0.22,
        x_cos: -0.42,
        y_sin: 0.42,
        y_cos: -0.22,
        t_sin: -0.047,
        t_cos: 0.025,
    },
    OceanicTidalTerm {
        coefficients: [1, 0, -1, 0, 0, 0],
        x_sin: -0.61,
        x_cos: -1.20,
        y_sin: 1.20,
        y_cos: -0.61,
        t_sin: -0.134,
        t_cos: 0.070,
    },
    OceanicTidalTerm {
        coefficients: [1, 0, 0, 0, 0, 1],
        x_sin: 1.54,
        x_cos: 3.00,
        y_sin: -3.00,
        y_cos: 1.54,
        t_sin: 0.348,
        t_cos: -0.171,
    },
    OceanicTidalTerm {
        coefficients: [1, 0, 0, 0, 0, 0],
        x_sin: -77.48,
        x_cos: -151.74,
        y_sin: 151.74,
        y_cos: -77.48,
        t_sin: -17.620,
        t_cos: 8.548,
    },
    OceanicTidalTerm {
        coefficients: [1, 0, 0, 0, 0, -1],
        x_sin: -10.52,
        x_cos: -20.56,
        y_sin: 20.56,
        y_cos: -10.52,
        t_sin: -2.392,
        t_cos: 1.159,
    },
    OceanicTidalTerm {
        coefficients: [1, 0, 0, 0, 0, -2],
        x_sin: 0.23,
        x_cos: 0.44,
        y_sin: -0.44,
        y_cos: 0.23,
        t_sin: 0.052,
        t_cos: -0.025,
    },
    OceanicTidalTerm {
        coefficients: [1, 0, 1, 0, 0, 0],
        x_sin: -0.61,
        x_cos: -1.19,
        y_sin: 1.19,
        y_cos: -0.61,
        t_sin: -0.144,
        t_cos: 0.065,
    },
    OceanicTidalTerm {
        coefficients: [1, 0, 0, 2, -2, 2],
        x_sin: -1.09,
        x_cos: -2.11,
        y_sin: 2.11,
        y_cos: -1.09,
        t_sin: -0.267,
        t_cos: 0.111,
    },
    OceanicTidalTerm {
        coefficients: [1, -1, 0, 0, 2, 0],
        x_sin: -0.69,
        x_cos: -1.43,
        y_sin: 1.43,
        y_cos: -0.69,
        t_sin: -0.288,
        t_cos: 0.043,
    },
    OceanicTidalTerm {
        coefficients: [1, 1, 0, 0, 0, 0],
        x_sin: -3.46,
        x_cos: -7.28,
        y_sin: 7.28,
        y_cos: -3.46,
        t_sin: -1.610,
        t_cos: 0.187,
    },
    OceanicTidalTerm {
        coefficients: [1, 1, 0, 0, 0, -1],
        x_sin: -0.69,
        x_cos: -1.44,
        y_sin: 1.44,
        y_cos: -0.69,
        t_sin: -0.320,
        t_cos: 0.037,
    },
    OceanicTidalTerm {
        coefficients: [1, 0, 0, 0, 2, 0],
        x_sin: -0.37,
        x_cos: -1.06,
        y_sin: 1.06,
        y_cos: -0.37,
        t_sin: -0.407,
        t_cos: -0.005,
    },
    OceanicTidalTerm {
        coefficients: [1, 2, 0, 0, 0, 0],
        x_sin: -0.17,
        x_cos: -0.51,
        y_sin: 0.51,
        y_cos: -0.17,
        t_sin: -0.213,
        t_cos: -0.005,
    },
    OceanicTidalTerm {
        coefficients: [1, 0, 0, 2, 0, 2],
        x_sin: -1.10,
        x_cos: -3.42,
        y_sin: 3.42,
        y_cos: -1.09,
        t_sin: -1.436,
        t_cos: -0.037,
    },
    OceanicTidalTerm {
        coefficients: [1, 0, 0, 2, 0, 1],
        x_sin: -0.70,
        x_cos: -2.19,
        y_sin: 2.19,
        y_cos: -0.70,
        t_sin: -0.921,
        t_cos: -0.023,
    },
    OceanicTidalTerm {
        coefficients: [1, 0, 0, 2, 0, 0],
        x_sin: -0.15,
        x_cos: -0.46,
        y_sin: 0.46,
        y_cos: -0.15,
        t_sin: -0.193,
        t_cos: -0.005,
    },
    OceanicTidalTerm {
        coefficients: [1, 1, 0, 2, 0, 2],
        x_sin: -0.03,
        x_cos: -0.59,
        y_sin: 0.59,
        y_cos: -0.03,
        t_sin: -0.396,
        t_cos: -0.024,
    },
    OceanicTidalTerm {
        coefficients: [1, 1, 0, 2, 0, 1],
        x_sin: -0.02,
        x_cos: -0.38,
        y_sin: 0.38,
        y_cos: -0.02,
        t_sin: -0.253,
        t_cos: -0.015,
    },
    OceanicTidalTerm {
        coefficients: [2, -3, 0, -2, 0, -2],
        x_sin: -0.49,
        x_cos: -0.04,
        y_sin: 0.63,
        y_cos: 0.24,
        t_sin: -0.089,
        t_cos: -0.011,
    },
    OceanicTidalTerm {
        coefficients: [2, -1, 0, -2, -2, -2],
        x_sin: -1.33,
        x_cos: -0.17,
        y_sin: 1.53,
        y_cos: 0.68,
        t_sin: -0.224,
        t_cos: -0.032,
    },
    OceanicTidalTerm {
        coefficients: [2, -2, 0, -2, 0, -2],
        x_sin: -6.08,
        x_cos: -1.61,
        y_sin: 3.13,
        y_cos: 3.35,
        t_sin: -0.637,
        t_cos: -0.177,
    },
    OceanicTidalTerm {
        coefficients: [2, 0, 0, -2, -2, -2],
        x_sin: -7.59,
        x_cos: -2.05,
        y_sin: 3.44,
        y_cos: 4.23,
        t_sin: -0.745,
        t_cos: -0.222,
    },
    OceanicTidalTerm {
        coefficients: [2, 0, 1, -2, -2, -2],
        x_sin: -0.52,
        x_cos: -0.14,
        y_sin: 0.22,
        y_cos: 0.29,
        t_sin: -0.049,
        t_cos: -0.015,
    },
    OceanicTidalTerm {
        coefficients: [2, -1, -1, -2, 0, -2],
        x_sin: 0.47,
        x_cos: 0.11,
        y_sin: -0.10,
        y_cos: -0.27,
        t_sin: 0.033,
        t_cos: 0.013,
    },
    OceanicTidalTerm {
        coefficients: [2, -1, 0, -2, 0, -1],
        x_sin: 2.12,
        x_cos: 0.49,
        y_sin: -0.41,
        y_cos: -1.23,
        t_sin: 0.141,
        t_cos: 0.058,
    },
    OceanicTidalTerm {
        coefficients: [2, -1, 0, -2, 0, -2],
        x_sin: -56.87,
        x_cos: -12.93,
        y_sin: 11.15,
        y_cos: 32.88,
        t_sin: -3.795,
        t_cos: -1.556,
    },
    OceanicTidalTerm {
        coefficients: [2, -1, 1, -2, 0, -2],
        x_sin: -0.54,
        x_cos: -0.12,
        y_sin: 0.10,
        y_cos: 0.31,
        t_sin: -0.035,
        t_cos: -0.015,
    },
    OceanicTidalTerm {
        coefficients: [2, 1, 0, -2, -2, -2],
        x_sin: -11.01,
        x_cos: -2.40,
        y_sin: 1.89,
        y_cos: 6.41,
        t_sin: -0.698,
        t_cos: -0.298,
    },
    OceanicTidalTerm {
        coefficients: [2, 1, 1, -2, -2, -2],
        x_sin: -0.51,
        x_cos: -0.11,
        y_sin: 0.08,
        y_cos: 0.30,
        t_sin: -0.032,
        t_cos: -0.014,
    },
    OceanicTidalTerm {
        coefficients: [2, -2, 0, -2, 2, -2],
        x_sin: 0.98,
        x_cos: 0.11,
        y_sin: -0.11,
        y_cos: -0.58,
        t_sin: 0.050,
        t_cos: 0.022,
    },
    OceanicTidalTerm {
        coefficients: [2, 0, -1, -2, 0, -2],
        x_sin: 1.13,
        x_cos: 0.11,
        y_sin: -0.13,
        y_cos: -0.67,
        t_sin: 0.056,
        t_cos: 0.025,
    },
    OceanicTidalTerm {
        coefficients: [2, 0, 0, -2, 0, -1],
        x_sin: 12.32,
        x_cos: 1.00,
        y_sin: -1.41,
        y_cos: -7.31,
        t_sin: 0.605,
        t_cos: 0.266,
    },
    OceanicTidalTerm {
        coefficients: [2, 0, 0, -2, 0, -2],
        x_sin: -330.15,
        x_cos: -26.96,
        y_sin: 37.58,
        y_cos: 195.92,
        t_sin: -16.195,
        t_cos: -7.140,
    },
    OceanicTidalTerm {
        coefficients: [2, 0, 1, -2, 0, -2],
        x_sin: -1.01,
        x_cos: -0.07,
        y_sin: 0.11,
        y_cos: 0.60,
        t_sin: -0.049,
        t_cos: -0.021,
    },
    OceanicTidalTerm {
        coefficients: [2, -1, 0, -2, 2, -2],
        x_sin: 2.47,
        x_cos: -0.28,
        y_sin: -0.44,
        y_cos: -1.48,
        t_sin: 0.111,
        t_cos: 0.034,
    },
    OceanicTidalTerm {
        coefficients: [2, 1, 0, -2, 0, -2],
        x_sin: 9.40,
        x_cos: -1.44,
        y_sin: -1.88,
        y_cos: -5.65,
        t_sin: 0.425,
        t_cos: 0.117,
    },
    OceanicTidalTerm {
        coefficients: [2, -1, 0, 0, 0, 0],
        x_sin: -2.35,
        x_cos: 0.37,
        y_sin: 0.47,
        y_cos: 1.41,
        t_sin: -0.106,
        t_cos: -0.029,
    },
    OceanicTidalTerm {
        coefficients: [2, -1, 0, 0, 0, -1],
        x_sin: -1.04,
        x_cos: 0.17,
        y_sin: 0.21,
        y_cos: 0.62,
        t_sin: -0.047,
        t_cos: -0.013,
    },
    OceanicTidalTerm {
        coefficients: [2, 0, -1, -2, 2, -2],
        x_sin: -8.51,
        x_cos: 3.50,
        y_sin: 3.29,
        y_cos: 5.11,
        t_sin: -0.437,
        t_cos: -0.019,
    },
    OceanicTidalTerm {
        coefficients: [2, 0, 0, -2, 2, -2],
        x_sin: -144.13,
        x_cos: 63.56,
        y_sin: 59.23,
        y_cos: 86.56,
        t_sin: -7.547,
        t_cos: -0.159,
    },
    OceanicTidalTerm {
        coefficients: [2, 0, 1, -2, 2, -2],
        x_sin: 1.19,
        x_cos: -0.56,
        y_sin: -0.52,
        y_cos: -0.72,
        t_sin: 0.064,
        t_cos: 0.000,
    },
    OceanicTidalTerm {
        coefficients: [2, 0, 0, 0, 0, 1],
        x_sin: 0.49,
        x_cos: -0.25,
        y_sin: -0.23,
        y_cos: -0.29,
        t_sin: 0.027,
        t_cos: -0.001,
    },
    OceanicTidalTerm {
        coefficients: [2, 0, 0, 0, 0, 0],
        x_sin: -38.48,
        x_cos: 19.14,
        y_sin: 17.72,
        y_cos: 23.11,
        t_sin: -2.104,
        t_cos: 0.041,
    },
    OceanicTidalTerm {
        coefficients: [2, 0, 0, 0, 0, -1],
        x_sin: -11.44,
        x_cos: 5.75,
        y_sin: 5.32,
        y_cos: 6.87,
        t_sin: -0.627,
        t_cos: 0.015,
    },
    OceanicTidalTerm {
        coefficients: [2, 0, 0, 0, 0, -2],
        x_sin: -1.24,
        x_cos: 0.63,
        y_sin: 0.58,
        y_cos: 0.75,
        t_sin: -0.068,
        t_cos: 0.002,
    },
    OceanicTidalTerm {
        coefficients: [2, 1, 0, 0, 0, 0],
        x_sin: -1.77,
        x_cos: 1.79,
        y_sin: 1.71,
        y_cos: 1.04,
        t_sin: -0.146,
        t_cos: 0.037,
    },
    OceanicTidalTerm {
        coefficients: [2, 1, 0, 0, 0, -1],
        x_sin: -0.77,
        x_cos: 0.78,
        y_sin: 0.75,
        y_cos: 0.45,
        t_sin: -0.064,
        t_cos: 0.017,
    },
    OceanicTidalTerm {
        coefficients: [2, 0, 0, 2, 0, 2],
        x_sin: -0.33,
        x_cos: 0.62,
        y_sin: 0.65,
        y_cos: 0.19,
        t_sin: -0.049,
        t_cos: 0.018,
    },
];

pub const LUNI_SOLAR_TIDAL_TERMS: [LuniSolarTidalTerm; 10] = [
    LuniSolarTidalTerm {
        coefficients: [1, -1, 0, -2, 0, -1],
        x_sin: -0.44,
        x_cos: 0.25,
        y_sin: -0.25,
        y_cos: -0.44,
    },
    LuniSolarTidalTerm {
        coefficients: [1, -1, 0, -2, 0, -2],
        x_sin: -2.31,
        x_cos: 1.32,
        y_sin: -1.32,
        y_cos: -2.31,
    },
    LuniSolarTidalTerm {
        coefficients: [1, 1, 0, -2, -2, -2],
        x_sin: -0.44,
        x_cos: 0.25,
        y_sin: -0.25,
        y_cos: -0.44,
    },
    LuniSolarTidalTerm {
        coefficients: [1, 0, 0, -2, 0, -1],
        x_sin: -2.14,
        x_cos: 1.23,
        y_sin: -1.23,
        y_cos: -2.14,
    },
    LuniSolarTidalTerm {
        coefficients: [1, 0, 0, -2, 0, -2],
        x_sin: -11.36,
        x_cos: 6.52,
        y_sin: -6.52,
        y_cos: -11.36,
    },
    LuniSolarTidalTerm {
        coefficients: [1, -1, 0, 0, 0, 0],
        x_sin: 0.84,
        x_cos: -0.48,
        y_sin: 0.48,
        y_cos: 0.84,
    },
    LuniSolarTidalTerm {
        coefficients: [1, 0, 0, -2, 2, -2],
        x_sin: -4.76,
        x_cos: 2.73,
        y_sin: -2.73,
        y_cos: -4.76,
    },
    LuniSolarTidalTerm {
        coefficients: [1, 0, 0, 0, 0, 0],
        x_sin: 14.27,
        x_cos: -8.19,
        y_sin: 8.19,
        y_cos: 14.27,
    },
    LuniSolarTidalTerm {
        coefficients: [1, 0, 0, 0, 0, -1],
        x_sin: 1.93,
        x_cos: -1.11,
        y_sin: 1.11,
        y_cos: 1.93,
    },
    LuniSolarTidalTerm {
        coefficients: [1, 1, 0, 0, 0, 0],
        x_sin: 0.76,
        x_cos: -0.43,
        y_sin: 0.43,
        y_cos: 0.76,
    },
];
