# -*- coding: utf-8 -*-
# Generated by the protocol buffer compiler. DO NOT EDIT!
# See https://github.com/eolymp/contracts/tree/main/cmd/protoc-gen-python-esdk for more details.
"""Generated protocol buffer code."""

import urllib.parse
from google.protobuf import symbol_database as _symbol_database

_sym_db = _symbol_database.Default()


class ProductServiceClient:
    def __init__(self, transport, url="https://api.eolymp.com"):
        self.transport = transport
        self.url = url

    def CreateProduct(self, request, **kwargs):
        path = "/store/products"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.commerce.CreateProductOutput"),
            **kwargs,
        )

    def UpdateProduct(self, request, **kwargs):
        path = "/store/products/"+urllib.parse.quote(request.product_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.product_id = ""

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.commerce.UpdateProductOutput"),
            **kwargs,
        )

    def DeleteProduct(self, request, **kwargs):
        path = "/store/products/"+urllib.parse.quote(request.product_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.product_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.commerce.DeleteProductOutput"),
            **kwargs,
        )

    def DescribeProduct(self, request, **kwargs):
        path = "/store/products/"+urllib.parse.quote(request.product_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.product_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.commerce.DescribeProductOutput"),
            **kwargs,
        )

    def ListProducts(self, request, **kwargs):
        path = "/store/products"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.commerce.ListProductsOutput"),
            **kwargs,
        )

