# -*- coding: utf-8 -*-
# Generated by the protocol buffer compiler. DO NOT EDIT!
# See https://github.com/eolymp/contracts/tree/main/cmd/protoc-gen-python-esdk for more details.
"""Generated protocol buffer code."""

import urllib.parse
from google.protobuf import symbol_database as _symbol_database

_sym_db = _symbol_database.Default()


class ShoppingServiceClient:
    def __init__(self, transport, url="https://api.eolymp.com"):
        self.transport = transport
        self.url = url

    def DescribeShoppingCart(self, request, **kwargs):
        path = "/store/cart"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.commerce.DescribeShoppingCartOutput"),
            **kwargs,
        )

    def CreateShoppingCartItem(self, request, **kwargs):
        path = "/store/cart/items"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.commerce.CreateShoppingCartItemOutput"),
            **kwargs,
        )

    def UpdateShoppingCartItem(self, request, **kwargs):
        path = "/store/cart/items/"+urllib.parse.quote(request.item_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.item_id = ""

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.commerce.UpdateShoppingCartItemOutput"),
            **kwargs,
        )

    def DeleteShoppingCartItem(self, request, **kwargs):
        path = "/store/cart/items/"+urllib.parse.quote(request.item_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.item_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.commerce.DeleteShoppingCartItemOutput"),
            **kwargs,
        )

    def UpdateShippingAddress(self, request, **kwargs):
        path = "/store/cart/shipping-address"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.commerce.UpdateShippingAddressOutput"),
            **kwargs,
        )

    def UpdateBillingAddress(self, request, **kwargs):
        path = "/store/cart/billing-address"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.commerce.UpdateBillingAddressOutput"),
            **kwargs,
        )

    def PlaceOrder(self, request, **kwargs):
        path = "/store/cart:order"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.commerce.PlaceOrderOutput"),
            **kwargs,
        )

