# -*- coding: utf-8 -*-
# Generated by the protocol buffer compiler. DO NOT EDIT!
# See https://github.com/eolymp/contracts/tree/main/cmd/protoc-gen-python-esdk for more details.
"""Generated protocol buffer code."""

import urllib.parse
from google.protobuf import symbol_database as _symbol_database

_sym_db = _symbol_database.Default()


class CreditServiceClient:
    def __init__(self, transport, url="https://api.eolymp.com"):
        self.transport = transport
        self.url = url

    def DescribeBalance(self, request, **kwargs):
        path = "/credit/balance"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.community.DescribeBalanceOutput"),
            **kwargs,
        )

    def GrantCredit(self, request, **kwargs):
        path = "/credit/grants"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.community.GrantCreditOutput"),
            **kwargs,
        )

    def CancelCredit(self, request, **kwargs):
        path = "/credit/grants/"+urllib.parse.quote(request.grant_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.grant_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.community.CancelCreditOutput"),
            **kwargs,
        )

    def ListCreditGrants(self, request, **kwargs):
        path = "/credit/grants"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.community.ListCreditGrantsOutput"),
            **kwargs,
        )

    def RedeemCredit(self, request, **kwargs):
        path = "/credit/redeem"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.community.RedeemCreditOutput"),
            **kwargs,
        )

    def ListCreditTransactions(self, request, **kwargs):
        path = "/credit/grants"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.community.ListCreditTransactionsOutput"),
            **kwargs,
        )

    def RefundCredit(self, request, **kwargs):
        path = "/credit/transactions/"+urllib.parse.quote(request.transaction_id)+"/refund"

        # Cleanup URL parameters to avoid any ambiguity
        request.transaction_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.community.RefundCreditOutput"),
            **kwargs,
        )

