# -*- coding: utf-8 -*-
# Generated by the protocol buffer compiler. DO NOT EDIT!
# See https://github.com/eolymp/contracts/tree/main/cmd/protoc-gen-python-esdk for more details.
"""Generated protocol buffer code."""

import urllib.parse
from google.protobuf import symbol_database as _symbol_database

_sym_db = _symbol_database.Default()


class SessionServiceClient:
    def __init__(self, transport, url="https://api.eolymp.com"):
        self.transport = transport
        self.url = url

    def DescribeSession(self, request, **kwargs):
        path = "/sessions/"+urllib.parse.quote(request.session_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.session_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.community.DescribeSessionOutput"),
            **kwargs,
        )

    def ListSessions(self, request, **kwargs):
        path = "/sessions"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.community.ListSessionsOutput"),
            **kwargs,
        )

    def TerminateSession(self, request, **kwargs):
        path = "/sessions/"+urllib.parse.quote(request.session_id)+"/terminate"

        # Cleanup URL parameters to avoid any ambiguity
        request.session_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.community.TerminateSessionOutput"),
            **kwargs,
        )

    def TerminateAllSessions(self, request, **kwargs):
        path = "/sessions:terminate-all"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.community.TerminateAllSessionsOutput"),
            **kwargs,
        )

