# -*- coding: utf-8 -*-
# Generated by the protocol buffer compiler. DO NOT EDIT!
# See https://github.com/eolymp/contracts/tree/main/cmd/protoc-gen-python-esdk for more details.
"""Generated protocol buffer code."""

import urllib.parse
from google.protobuf import symbol_database as _symbol_database

_sym_db = _symbol_database.Default()


class CourseServiceClient:
    def __init__(self, transport, url="https://api.eolymp.com"):
        self.transport = transport
        self.url = url

    def CreateCourse(self, request, **kwargs):
        path = "/courses"

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.CreateCourseOutput"),
            **kwargs,
        )

    def UpdateCourse(self, request, **kwargs):
        path = "/courses/"+urllib.parse.quote(request.course_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.course_id = ""

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.UpdateCourseOutput"),
            **kwargs,
        )

    def DeleteCourse(self, request, **kwargs):
        path = "/courses/"+urllib.parse.quote(request.course_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.course_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.DeleteCourseOutput"),
            **kwargs,
        )

    def DescribeCourse(self, request, **kwargs):
        path = "/courses/"+urllib.parse.quote(request.course_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.course_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.DescribeCourseOutput"),
            **kwargs,
        )

    def ListCourses(self, request, **kwargs):
        path = "/courses"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.ListCoursesOutput"),
            **kwargs,
        )

    def CopyCourse(self, request, **kwargs):
        path = "/courses/"+urllib.parse.quote(request.course_id)+"/copy"

        # Cleanup URL parameters to avoid any ambiguity
        request.course_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.CopyCourseOutput"),
            **kwargs,
        )

