# -*- coding: utf-8 -*-
# Generated by the protocol buffer compiler. DO NOT EDIT!
# See https://github.com/eolymp/contracts/tree/main/cmd/protoc-gen-python-esdk for more details.
"""Generated protocol buffer code."""

import urllib.parse
from google.protobuf import symbol_database as _symbol_database

_sym_db = _symbol_database.Default()


class MaterialServiceClient:
    def __init__(self, transport, url="https://api.eolymp.com"):
        self.transport = transport
        self.url = url

    def CreateMaterial(self, request, **kwargs):
        path = "/materials"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.CreateMaterialOutput"),
            **kwargs,
        )

    def UpdateMaterial(self, request, **kwargs):
        path = "/materials/"+urllib.parse.quote(request.material_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.material_id = ""

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.UpdateMaterialOutput"),
            **kwargs,
        )

    def MoveMaterial(self, request, **kwargs):
        path = "/materials/"+urllib.parse.quote(request.material_id)+"/move"

        # Cleanup URL parameters to avoid any ambiguity
        request.material_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.MoveMaterialOutput"),
            **kwargs,
        )

    def DeleteMaterial(self, request, **kwargs):
        path = "/materials/"+urllib.parse.quote(request.material_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.material_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.DeleteMaterialOutput"),
            **kwargs,
        )

    def DescribeMaterial(self, request, **kwargs):
        path = "/materials/"+urllib.parse.quote(request.material_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.material_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.DescribeMaterialOutput"),
            **kwargs,
        )

    def ListMaterials(self, request, **kwargs):
        path = "/materials"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.ListMaterialsOutput"),
            **kwargs,
        )

    def ReportProgress(self, request, **kwargs):
        path = "/materials/"+urllib.parse.quote(request.material_id)+"/progress"

        # Cleanup URL parameters to avoid any ambiguity
        request.material_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.ReportProgressOutput"),
            **kwargs,
        )

    def GradeMaterial(self, request, **kwargs):
        path = "/materials/"+urllib.parse.quote(request.material_id)+"/grade"

        # Cleanup URL parameters to avoid any ambiguity
        request.material_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.GradeMaterialOutput"),
            **kwargs,
        )

