# -*- coding: utf-8 -*-
# Generated by the protocol buffer compiler. DO NOT EDIT!
# See https://github.com/eolymp/contracts/tree/main/cmd/protoc-gen-python-esdk for more details.
"""Generated protocol buffer code."""

import urllib.parse
from google.protobuf import symbol_database as _symbol_database

_sym_db = _symbol_database.Default()


class ProblemServiceClient:
    def __init__(self, transport, url="https://api.eolymp.com"):
        self.transport = transport
        self.url = url

    def ListStatements(self, request, **kwargs):
        path = "/statements"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.ListStatementsOutput"),
            **kwargs,
        )

    def LookupStatement(self, request, **kwargs):
        path = "/statements:lookup"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.LookupStatementOutput"),
            **kwargs,
        )

    def ListExamples(self, request, **kwargs):
        path = "/examples"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.ListExamplesOutput"),
            **kwargs,
        )

    def CreateSubmission(self, request, **kwargs):
        path = "/submissions"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.CreateSubmissionOutput"),
            **kwargs,
        )

    def ListSubmissions(self, request, **kwargs):
        path = "/submissions"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.ListSubmissionsOutput"),
            **kwargs,
        )

    def DescribeSubmission(self, request, **kwargs):
        path = "/submissions/"+urllib.parse.quote(request.submission_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.submission_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.DescribeSubmissionOutput"),
            **kwargs,
        )

    def LookupCodeTemplate(self, request, **kwargs):
        path = "/template"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.LookupCodeTemplateOutput"),
            **kwargs,
        )

    def CreateRun(self, request, **kwargs):
        path = "/runs"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.CreateRunOutput"),
            **kwargs,
        )

    def DescribeRun(self, request, **kwargs):
        path = "/runs/"+urllib.parse.quote(request.run_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.run_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.DescribeRunOutput"),
            **kwargs,
        )

    def WatchRun(self, request, **kwargs):
        path = "/runs/"+urllib.parse.quote(request.run_id)+"/watch"

        # Cleanup URL parameters to avoid any ambiguity
        request.run_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.WatchRunOutput"),
            **kwargs,
        )

    def ListRuntimes(self, request, **kwargs):
        path = "/runtime"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.course.ListRuntimesOutput"),
            **kwargs,
        )

