# -*- coding: utf-8 -*-
# Generated by the protocol buffer compiler. DO NOT EDIT!
# See https://github.com/eolymp/contracts/tree/main/cmd/protoc-gen-python-esdk for more details.
"""Generated protocol buffer code."""

import urllib.parse
from google.protobuf import symbol_database as _symbol_database

_sym_db = _symbol_database.Default()


class MessageServiceClient:
    def __init__(self, transport, url="https://api.eolymp.com"):
        self.transport = transport
        self.url = url

    def DescribeMessage(self, request, **kwargs):
        path = "/messages/"+urllib.parse.quote(request.message_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.message_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.discussion.DescribeMessageOutput"),
            **kwargs,
        )

    def ListMessages(self, request, **kwargs):
        path = "/messages"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.discussion.ListMessagesOutput"),
            **kwargs,
        )

    def PostMessage(self, request, **kwargs):
        path = "/messages"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.discussion.PostMessageOutput"),
            **kwargs,
        )

    def UpdateMessage(self, request, **kwargs):
        path = "/messages/"+urllib.parse.quote(request.message_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.message_id = ""

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.discussion.UpdateMessageOutput"),
            **kwargs,
        )

    def DeleteMessage(self, request, **kwargs):
        path = "/messages/"+urllib.parse.quote(request.message_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.message_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.discussion.DeleteMessageOutput"),
            **kwargs,
        )

    def VoteMessage(self, request, **kwargs):
        path = "/messages/"+urllib.parse.quote(request.message_id)+"/vote"

        # Cleanup URL parameters to avoid any ambiguity
        request.message_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.discussion.VoteMessageOutput"),
            **kwargs,
        )

    def ListMessageChanges(self, request, **kwargs):
        path = "/messages/"+urllib.parse.quote(request.message_id)+"/changes"

        # Cleanup URL parameters to avoid any ambiguity
        request.message_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.discussion.ListMessageChangesOutput"),
            **kwargs,
        )

