# -*- coding: utf-8 -*-
# Generated by the protocol buffer compiler. DO NOT EDIT!
# See https://github.com/eolymp/contracts/tree/main/cmd/protoc-gen-python-esdk for more details.
"""Generated protocol buffer code."""

import urllib.parse
from google.protobuf import symbol_database as _symbol_database

_sym_db = _symbol_database.Default()


class LocalizationServiceClient:
    def __init__(self, transport, url="https://api.eolymp.com"):
        self.transport = transport
        self.url = url

    def CreateTerm(self, request, **kwargs):
        path = "/terms"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.l10n.CreateTermOutput"),
            **kwargs,
        )

    def ListTerms(self, request, **kwargs):
        path = "/terms"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.l10n.ListTermsOutput"),
            **kwargs,
        )

    def UpdateTerm(self, request, **kwargs):
        path = "/terms/"+urllib.parse.quote(request.term_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.term_id = ""

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.l10n.UpdateTermOutput"),
            **kwargs,
        )

    def RestoreTerm(self, request, **kwargs):
        path = "/terms/"+urllib.parse.quote(request.term_id)+"/restore"

        # Cleanup URL parameters to avoid any ambiguity
        request.term_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.l10n.RestoreTermOutput"),
            **kwargs,
        )

    def DeprecateTerm(self, request, **kwargs):
        path = "/terms/"+urllib.parse.quote(request.term_id)+"/deprecate"

        # Cleanup URL parameters to avoid any ambiguity
        request.term_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.l10n.DeprecateTermOutput"),
            **kwargs,
        )

    def DeleteTerm(self, request, **kwargs):
        path = "/terms/"+urllib.parse.quote(request.term_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.term_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.l10n.DeleteTermOutput"),
            **kwargs,
        )

    def DescribeTerm(self, request, **kwargs):
        path = "/terms/"+urllib.parse.quote(request.term_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.term_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.l10n.DescribeTermOutput"),
            **kwargs,
        )

    def ImportTerms(self, request, **kwargs):
        path = "/terms"

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.l10n.ImportTermsOutput"),
            **kwargs,
        )

    def AddLocale(self, request, **kwargs):
        path = "/locales/"+urllib.parse.quote(request.locale_code)

        # Cleanup URL parameters to avoid any ambiguity
        request.locale_code = ""

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.l10n.AddLocaleOutput"),
            **kwargs,
        )

    def RemoveLocale(self, request, **kwargs):
        path = "/locales/"+urllib.parse.quote(request.locale_code)

        # Cleanup URL parameters to avoid any ambiguity
        request.locale_code = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.l10n.RemoveLocaleOutput"),
            **kwargs,
        )

    def ListLocales(self, request, **kwargs):
        path = "/locales"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.l10n.ListLocalesOutput"),
            **kwargs,
        )

    def TranslateTerm(self, request, **kwargs):
        path = "/terms/"+urllib.parse.quote(request.term_id)+"/translations"

        # Cleanup URL parameters to avoid any ambiguity
        request.term_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.l10n.TranslateTermOutput"),
            **kwargs,
        )

    def ListTranslations(self, request, **kwargs):
        path = "/terms/"+urllib.parse.quote(request.term_id)+"/translations"

        # Cleanup URL parameters to avoid any ambiguity
        request.term_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.l10n.ListTranslationsOutput"),
            **kwargs,
        )

    def DeleteTranslation(self, request, **kwargs):
        path = "/terms/"+urllib.parse.quote(request.term_id)+"/translations/"+urllib.parse.quote(request.translation_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.term_id = ""
        request.translation_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.l10n.DeleteTranslationOutput"),
            **kwargs,
        )

    def SuggestTranslation(self, request, **kwargs):
        path = "/terms/"+urllib.parse.quote(request.term_id)+"/suggestions/"+urllib.parse.quote(request.locale)

        # Cleanup URL parameters to avoid any ambiguity
        request.term_id = ""
        request.locale = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.l10n.SuggestTranslationOutput"),
            **kwargs,
        )

    def UpdateTranslation(self, request, **kwargs):
        path = "/terms/"+urllib.parse.quote(request.term_id)+"/translations/"+urllib.parse.quote(request.translation_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.term_id = ""
        request.translation_id = ""

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.l10n.UpdateTranslationOutput"),
            **kwargs,
        )

    def ApproveTranslation(self, request, **kwargs):
        path = "/terms/"+urllib.parse.quote(request.term_id)+"/translations/"+urllib.parse.quote(request.translation_id)+"/approve"

        # Cleanup URL parameters to avoid any ambiguity
        request.term_id = ""
        request.translation_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.l10n.ApproveTranslationOutput"),
            **kwargs,
        )

    def RejectTranslation(self, request, **kwargs):
        path = "/terms/"+urllib.parse.quote(request.term_id)+"/translations/"+urllib.parse.quote(request.translation_id)+"/reject"

        # Cleanup URL parameters to avoid any ambiguity
        request.term_id = ""
        request.translation_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.l10n.RejectTranslationOutput"),
            **kwargs,
        )

    def ImportTranslations(self, request, **kwargs):
        path = "/translations/"+urllib.parse.quote(request.locale)

        # Cleanup URL parameters to avoid any ambiguity
        request.locale = ""

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.l10n.ImportTranslationsOutput"),
            **kwargs,
        )

    def ExportTranslations(self, request, **kwargs):
        path = "/translations/"+urllib.parse.quote(request.locale)

        # Cleanup URL parameters to avoid any ambiguity
        request.locale = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.l10n.ExportTranslationsOutput"),
            **kwargs,
        )

    def ListTranslationPairs(self, request, **kwargs):
        path = "/translate/"+urllib.parse.quote(request.locale)

        # Cleanup URL parameters to avoid any ambiguity
        request.locale = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.l10n.ListTranslationPairsOutput"),
            **kwargs,
        )

