# -*- coding: utf-8 -*-
# Generated by the protocol buffer compiler. DO NOT EDIT!
# See https://github.com/eolymp/contracts/tree/main/cmd/protoc-gen-python-esdk for more details.
"""Generated protocol buffer code."""

import urllib.parse
from google.protobuf import symbol_database as _symbol_database

_sym_db = _symbol_database.Default()


class CampaignServiceClient:
    def __init__(self, transport, url="https://api.eolymp.com"):
        self.transport = transport
        self.url = url

    def CreateCampaign(self, request, **kwargs):
        path = "/campaigns"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.newsletter.CreateCampaignOutput"),
            **kwargs,
        )

    def UpdateCampaign(self, request, **kwargs):
        path = "/campaigns/"+urllib.parse.quote(request.campaign_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.campaign_id = ""

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.newsletter.UpdateCampaignOutput"),
            **kwargs,
        )

    def DeleteCampaign(self, request, **kwargs):
        path = "/campaigns/"+urllib.parse.quote(request.campaign_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.campaign_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.newsletter.DeleteCampaignOutput"),
            **kwargs,
        )

    def DescribeCampaign(self, request, **kwargs):
        path = "/campaigns/"+urllib.parse.quote(request.campaign_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.campaign_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.newsletter.DescribeCampaignOutput"),
            **kwargs,
        )

    def ListCampaigns(self, request, **kwargs):
        path = "/campaigns"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.newsletter.ListCampaignsOutput"),
            **kwargs,
        )

    def TestCampaign(self, request, **kwargs):
        path = "/campaigns/"+urllib.parse.quote(request.campaign_id)+"/test"

        # Cleanup URL parameters to avoid any ambiguity
        request.campaign_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.newsletter.TestCampaignOutput"),
            **kwargs,
        )

    def SendCampaign(self, request, **kwargs):
        path = "/campaigns/"+urllib.parse.quote(request.campaign_id)+"/send"

        # Cleanup URL parameters to avoid any ambiguity
        request.campaign_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.newsletter.SendCampaignOutput"),
            **kwargs,
        )

    def TranslateCampaign(self, request, **kwargs):
        path = "/campaigns/"+urllib.parse.quote(request.campaign_id)+"/translate"

        # Cleanup URL parameters to avoid any ambiguity
        request.campaign_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.newsletter.TranslateCampaignOutput"),
            **kwargs,
        )

    def CreateTranslation(self, request, **kwargs):
        path = "/campaigns/"+urllib.parse.quote(request.campaign_id)+"/translations"

        # Cleanup URL parameters to avoid any ambiguity
        request.campaign_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.newsletter.CreateTranslationOutput"),
            **kwargs,
        )

    def UpdateTranslation(self, request, **kwargs):
        path = "/campaigns/"+urllib.parse.quote(request.campaign_id)+"/translations/"+urllib.parse.quote(request.translation_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.campaign_id = ""
        request.translation_id = ""

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.newsletter.UpdateTranslationOutput"),
            **kwargs,
        )

    def DeleteTranslation(self, request, **kwargs):
        path = "/campaigns/"+urllib.parse.quote(request.campaign_id)+"/translations/"+urllib.parse.quote(request.translation_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.campaign_id = ""
        request.translation_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.newsletter.DeleteTranslationOutput"),
            **kwargs,
        )

    def DescribeTranslation(self, request, **kwargs):
        path = "/campaigns/"+urllib.parse.quote(request.campaign_id)+"/translations/"+urllib.parse.quote(request.translation_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.campaign_id = ""
        request.translation_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.newsletter.DescribeTranslationOutput"),
            **kwargs,
        )

    def ListTranslations(self, request, **kwargs):
        path = "/campaigns/"+urllib.parse.quote(request.campaign_id)+"/translations"

        # Cleanup URL parameters to avoid any ambiguity
        request.campaign_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.newsletter.ListTranslationsOutput"),
            **kwargs,
        )

    def CreateRecipient(self, request, **kwargs):
        path = "/campaigns/"+urllib.parse.quote(request.campaign_id)+"/recipients"

        # Cleanup URL parameters to avoid any ambiguity
        request.campaign_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.newsletter.CreateRecipientOutput"),
            **kwargs,
        )

    def ImportRecipient(self, request, **kwargs):
        path = "/campaigns/"+urllib.parse.quote(request.campaign_id)+"/recipients:import"

        # Cleanup URL parameters to avoid any ambiguity
        request.campaign_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.newsletter.ImportRecipientOutput"),
            **kwargs,
        )

    def DeleteRecipient(self, request, **kwargs):
        path = "/campaigns/"+urllib.parse.quote(request.campaign_id)+"/recipients/"+urllib.parse.quote(request.recipient_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.campaign_id = ""
        request.recipient_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.newsletter.DeleteRecipientOutput"),
            **kwargs,
        )

    def ListRecipients(self, request, **kwargs):
        path = "/campaigns/"+urllib.parse.quote(request.campaign_id)+"/recipients"

        # Cleanup URL parameters to avoid any ambiguity
        request.campaign_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.newsletter.ListRecipientsOutput"),
            **kwargs,
        )

    def DescribeRecipient(self, request, **kwargs):
        path = "/campaigns/"+urllib.parse.quote(request.campaign_id)+"/recipients/"+urllib.parse.quote(request.recipient_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.campaign_id = ""
        request.recipient_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.newsletter.DescribeRecipientOutput"),
            **kwargs,
        )

