# -*- coding: utf-8 -*-
# Generated by the protocol buffer compiler. DO NOT EDIT!
# See https://github.com/eolymp/contracts/tree/main/cmd/protoc-gen-python-esdk for more details.
"""Generated protocol buffer code."""

import urllib.parse
from google.protobuf import symbol_database as _symbol_database

_sym_db = _symbol_database.Default()


class PrinterServiceClient:
    def __init__(self, transport, url="https://api.eolymp.com"):
        self.transport = transport
        self.url = url

    def CreatePrinter(self, request, **kwargs):
        path = "/printers"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.printer.CreatePrinterOutput"),
            **kwargs,
        )

    def UpdatePrinter(self, request, **kwargs):
        path = "/printers/"+urllib.parse.quote(request.printer_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.printer_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.printer.UpdatePrinterOutput"),
            **kwargs,
        )

    def DeletePrinter(self, request, **kwargs):
        path = "/printers/"+urllib.parse.quote(request.printer_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.printer_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.printer.DeletePrinterOutput"),
            **kwargs,
        )

    def DescribePrinter(self, request, **kwargs):
        path = "/printers/"+urllib.parse.quote(request.printer_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.printer_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.printer.DescribePrinterOutput"),
            **kwargs,
        )

    def ListPrinters(self, request, **kwargs):
        path = "/printers"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.printer.ListPrintersOutput"),
            **kwargs,
        )

    def CreatePrinterJob(self, request, **kwargs):
        path = "/printers/"+urllib.parse.quote(request.printer_id)+"/jobs"

        # Cleanup URL parameters to avoid any ambiguity
        request.printer_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.printer.CreatePrinterJobOutput"),
            **kwargs,
        )

    def DescribePrinterJob(self, request, **kwargs):
        path = "/printers/"+urllib.parse.quote(request.printer_id)+"/jobs/"+urllib.parse.quote(request.job_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.printer_id = ""
        request.job_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.printer.DescribePrinterJobOutput"),
            **kwargs,
        )

    def ListPrinterJobs(self, request, **kwargs):
        path = "/printers/"+urllib.parse.quote(request.printer_id)+"/jobs"

        # Cleanup URL parameters to avoid any ambiguity
        request.printer_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.printer.ListPrinterJobsOutput"),
            **kwargs,
        )

    def UpdatePrinterJob(self, request, **kwargs):
        path = "/printers/"+urllib.parse.quote(request.printer_id)+"/jobs/"+urllib.parse.quote(request.job_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.printer_id = ""
        request.job_id = ""

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.printer.UpdatePrinterJobOutput"),
            **kwargs,
        )

    def DeletePrinterJob(self, request, **kwargs):
        path = "/printers/"+urllib.parse.quote(request.printer_id)+"/jobs/"+urllib.parse.quote(request.job_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.printer_id = ""
        request.job_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.printer.DeletePrinterJobOutput"),
            **kwargs,
        )

