# -*- coding: utf-8 -*-
# Generated by the protocol buffer compiler. DO NOT EDIT!
# See https://github.com/eolymp/contracts/tree/main/cmd/protoc-gen-python-esdk for more details.
"""Generated protocol buffer code."""

import urllib.parse
from google.protobuf import symbol_database as _symbol_database

_sym_db = _symbol_database.Default()


class RankerClient:
    def __init__(self, transport, url="https://api.eolymp.com"):
        self.transport = transport
        self.url = url

    def CreateScoreboard(self, request, **kwargs):
        path = "/scoreboards"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.ranker.CreateScoreboardOutput"),
            **kwargs,
        )

    def UpdateScoreboard(self, request, **kwargs):
        path = "/scoreboards/"+urllib.parse.quote(request.scoreboard_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.scoreboard_id = ""

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.ranker.UpdateScoreboardOutput"),
            **kwargs,
        )

    def RebuildScoreboard(self, request, **kwargs):
        path = "/scoreboards/"+urllib.parse.quote(request.scoreboard_id)+"/rebuild"

        # Cleanup URL parameters to avoid any ambiguity
        request.scoreboard_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.ranker.RebuildScoreboardOutput"),
            **kwargs,
        )

    def DeleteScoreboard(self, request, **kwargs):
        path = "/scoreboards/"+urllib.parse.quote(request.scoreboard_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.scoreboard_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.ranker.DeleteScoreboardOutput"),
            **kwargs,
        )

    def DescribeScoreboard(self, request, **kwargs):
        path = "/scoreboards/"+urllib.parse.quote(request.scoreboard_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.scoreboard_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.ranker.DescribeScoreboardOutput"),
            **kwargs,
        )

    def ListScoreboards(self, request, **kwargs):
        path = "/scoreboards"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.ranker.ListScoreboardsOutput"),
            **kwargs,
        )

    def DescribeScoreboardRow(self, request, **kwargs):
        path = "/scoreboards/"+urllib.parse.quote(request.scoreboard_id)+"/rows/"+urllib.parse.quote(request.member_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.scoreboard_id = ""
        request.member_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.ranker.DescribeScoreboardRowOutput"),
            **kwargs,
        )

    def ListScoreboardRows(self, request, **kwargs):
        path = "/scoreboards/"+urllib.parse.quote(request.scoreboard_id)+"/rows"

        # Cleanup URL parameters to avoid any ambiguity
        request.scoreboard_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.ranker.ListScoreboardRowsOutput"),
            **kwargs,
        )

    def AddScoreboardColumn(self, request, **kwargs):
        path = "/scoreboards/"+urllib.parse.quote(request.scoreboard_id)+"/columns"

        # Cleanup URL parameters to avoid any ambiguity
        request.scoreboard_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.ranker.AddScoreboardColumnOutput"),
            **kwargs,
        )

    def UpdateScoreboardColumn(self, request, **kwargs):
        path = "/scoreboards/"+urllib.parse.quote(request.scoreboard_id)+"/columns/"+urllib.parse.quote(request.column_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.scoreboard_id = ""
        request.column_id = ""

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.ranker.UpdateScoreboardColumnOutput"),
            **kwargs,
        )

    def DeleteScoreboardColumn(self, request, **kwargs):
        path = "/scoreboards/"+urllib.parse.quote(request.scoreboard_id)+"/columns/"+urllib.parse.quote(request.column_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.scoreboard_id = ""
        request.column_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.ranker.DeleteScoreboardColumnOutput"),
            **kwargs,
        )

    def DescribeScoreboardColumn(self, request, **kwargs):
        path = "/scoreboards/"+urllib.parse.quote(request.scoreboard_id)+"/columns/"+urllib.parse.quote(request.column_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.scoreboard_id = ""
        request.column_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.ranker.DescribeScoreboardColumnOutput"),
            **kwargs,
        )

    def ListScoreboardColumns(self, request, **kwargs):
        path = "/scoreboards/"+urllib.parse.quote(request.scoreboard_id)+"/columns"

        # Cleanup URL parameters to avoid any ambiguity
        request.scoreboard_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.ranker.ListScoreboardColumnsOutput"),
            **kwargs,
        )

    def ListActivities(self, request, **kwargs):
        path = "/scoreboards/"+urllib.parse.quote(request.scoreboard_id)+"/activities"

        # Cleanup URL parameters to avoid any ambiguity
        request.scoreboard_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.ranker.ListActivitiesOutput"),
            **kwargs,
        )

    def ScheduleAction(self, request, **kwargs):
        path = "/scoreboards/"+urllib.parse.quote(request.scoreboard_id)+"/schedule"

        # Cleanup URL parameters to avoid any ambiguity
        request.scoreboard_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.ranker.ScheduleActionOutput"),
            **kwargs,
        )

    def UnscheduleAction(self, request, **kwargs):
        path = "/scoreboards/"+urllib.parse.quote(request.scoreboard_id)+"/schedule/"+urllib.parse.quote(request.action_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.scoreboard_id = ""
        request.action_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.ranker.UnscheduleActionOutput"),
            **kwargs,
        )

    def ListScheduledActions(self, request, **kwargs):
        path = "/scoreboards/"+urllib.parse.quote(request.scoreboard_id)+"/schedule"

        # Cleanup URL parameters to avoid any ambiguity
        request.scoreboard_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.ranker.ListScheduledActionsOutput"),
            **kwargs,
        )

