# -*- coding: utf-8 -*-
# Generated by the protocol buffer compiler. DO NOT EDIT!
# See https://github.com/eolymp/contracts/tree/main/cmd/protoc-gen-python-esdk for more details.
"""Generated protocol buffer code."""

import urllib.parse
from google.protobuf import symbol_database as _symbol_database

_sym_db = _symbol_database.Default()


class RatingServiceClient:
    def __init__(self, transport, url="https://api.eolymp.com"):
        self.transport = transport
        self.url = url

    def SetRating(self, request, **kwargs):
        path = "/rating"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.rating.SetRatingOutput"),
            **kwargs,
        )

    def UpdateRating(self, request, **kwargs):
        path = "/rating/"+urllib.parse.quote(request.rating_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.rating_id = ""

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.rating.UpdateRatingOutput"),
            **kwargs,
        )

    def DeleteRating(self, request, **kwargs):
        path = "/rating/"+urllib.parse.quote(request.rating_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.rating_id = ""

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.rating.DeleteRatingOutput"),
            **kwargs,
        )

    def DescribeRating(self, request, **kwargs):
        path = "/rating/"+urllib.parse.quote(request.rating_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.rating_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.rating.DescribeRatingOutput"),
            **kwargs,
        )

    def ListRating(self, request, **kwargs):
        path = "/members/"+urllib.parse.quote(request.member_id)+"/rating"

        # Cleanup URL parameters to avoid any ambiguity
        request.member_id = ""

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.rating.ListRatingOutput"),
            **kwargs,
        )

    def DescribeRatingBoundaries(self, request, **kwargs):
        path = "/rating-boundaries"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.rating.DescribeRatingBoundariesOutput"),
            **kwargs,
        )

    def DescribeRatingDistribution(self, request, **kwargs):
        path = "/rating-distribution"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.rating.DescribeRatingDistributionOutput"),
            **kwargs,
        )

