# -*- coding: utf-8 -*-
# Generated by the protocol buffer compiler. DO NOT EDIT!
# See https://github.com/eolymp/contracts/tree/main/cmd/protoc-gen-python-esdk for more details.
"""Generated protocol buffer code."""

import urllib.parse
from google.protobuf import symbol_database as _symbol_database

_sym_db = _symbol_database.Default()


class BillingServiceClient:
    def __init__(self, transport, url="https://api.eolymp.com"):
        self.transport = transport
        self.url = url

    def DescribeBillingInformation(self, request, **kwargs):
        path = "/billing/info"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.universe.DescribeBillingInformationOutput"),
            **kwargs,
        )

    def UpdateBillingInformation(self, request, **kwargs):
        path = "/billing/info"

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.universe.UpdateBillingInformationOutput"),
            **kwargs,
        )

    def DescribeSubscription(self, request, **kwargs):
        path = "/billing/subscription"

        return self.transport.request(
            method="GET",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.universe.DescribeSubscriptionOutput"),
            **kwargs,
        )

    def CreateSubscription(self, request, **kwargs):
        path = "/billing/subscription"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.universe.CreateSubscriptionOutput"),
            **kwargs,
        )

    def UpdateSubscription(self, request, **kwargs):
        path = "/billing/subscription"

        return self.transport.request(
            method="PUT",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.universe.UpdateSubscriptionOutput"),
            **kwargs,
        )

    def CancelSubscription(self, request, **kwargs):
        path = "/billing/subscription"

        return self.transport.request(
            method="DELETE",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.universe.CancelSubscriptionOutput"),
            **kwargs,
        )

    def StartSubscriptionTrial(self, request, **kwargs):
        path = "/billing/trial/start"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.universe.StartSubscriptionTrialOutput"),
            **kwargs,
        )

    def EndSubscriptionTrial(self, request, **kwargs):
        path = "/billing/trial/end"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.universe.EndSubscriptionTrialOutput"),
            **kwargs,
        )

    def SimulateSubscription(self, request, **kwargs):
        path = "/billing/subscription/simulate"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.universe.SimulateSubscriptionOutput"),
            **kwargs,
        )

    def CreatePortalLink(self, request, **kwargs):
        path = "/billing/portal-link"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.universe.CreatePortalLinkOutput"),
            **kwargs,
        )

    def UpcomingInvoice(self, request, **kwargs):
        path = "/billing/upcoming"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.universe.UpcomingInvoiceOutput"),
            **kwargs,
        )

    def DescribeInvoice(self, request, **kwargs):
        path = "/billing/invoice/"+urllib.parse.quote(request.invoice_id)

        # Cleanup URL parameters to avoid any ambiguity
        request.invoice_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.universe.DescribeInvoiceOutput"),
            **kwargs,
        )

    def PayInvoice(self, request, **kwargs):
        path = "/billing/invoice/"+urllib.parse.quote(request.invoice_id)+"/pay"

        # Cleanup URL parameters to avoid any ambiguity
        request.invoice_id = ""

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.universe.PayInvoiceOutput"),
            **kwargs,
        )

    def ListInvoices(self, request, **kwargs):
        path = "/billing/invoices"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.universe.ListInvoicesOutput"),
            **kwargs,
        )

    def ListAvailablePlans(self, request, **kwargs):
        path = "/billing/plans"

        return self.transport.request(
            method="POST",
            url=self.url+path,
            request_data=request,
            response_symbol=_sym_db.GetSymbol("eolymp.universe.ListAvailablePlansOutput"),
            **kwargs,
        )

