PARSE_TEXT_CASE = [
    {
        "kwargs": {
            "text": "METAR ZBAA 311400Z 01002MPS CAVOK 14/12 Q1009 NOSIG=",
            "year": 2021,
            "month": 5,
        },
        "result": {
            "kind": "METAR",
            "icao": "ZBAA",
            "auto": False,
            "datetime": "2021-05-31T14:00:00+00:00",
            "wind_direction": 10,
            "wind_direction_units": "degree",
            "wind_speed": 2,
            "wind_speed_units": "m/s",
            "gust": None,
            "wind_direction_range": None,
            "visibility": 99999,
            "visibility_units": "m",
            "cavok": True,
            "temperature": 14,
            "dew_temperature": 12,
            "temperature_units": "degree C",
            "qnh": 1009,
            "qnh_units": "hPa",
            "cloud": None,
            "weather": ["Clear Sky"],
        },
    },
    {
        "kwargs": {
            "text": "METAR ZBAA 310630Z 09002MPS 050V140 8000 -SHRA NSC 19/14 Q1007 NOSIG=",
            "year": 2021,
            "month": 5,
        },
        "result": {
            "kind": "METAR",
            "icao": "ZBAA",
            "auto": False,
            "datetime": "2021-05-31T06:30:00+00:00",
            "wind_direction": 90,
            "wind_direction_units": "degree",
            "wind_speed": 2,
            "wind_speed_units": "m/s",
            "gust": None,
            "wind_direction_range": (50, 140),
            "visibility": 8000,
            "visibility_units": "m",
            "cavok": False,
            "temperature": 19,
            "dew_temperature": 14,
            "temperature_units": "degree C",
            "qnh": 1007,
            "qnh_units": "hPa",
            "cloud": [
                {
                    "cloud_height": None,
                    "cloud_height_units": "m",
                    "cloud_mask": 0,
                    "cloud_type": None,
                }
            ],
            "weather": ["Light Showers of Rain"],
        },
    },
    {
        "kwargs": {
            "text": "METAR ZBAA 310530Z VRB02MPS 8000 NSC 19/13 Q1007 NOSIG=",
            "year": 2021,
            "month": 5,
        },
        "result": {
            "kind": "METAR",
            "icao": "ZBAA",
            "auto": False,
            "datetime": "2021-05-31T05:30:00+00:00",
            "wind_direction": None,
            "wind_direction_units": "degree",
            "wind_speed": 2,
            "wind_speed_units": "m/s",
            "gust": None,
            "wind_direction_range": None,
            "visibility": 8000,
            "visibility_units": "m",
            "cavok": False,
            "temperature": 19,
            "dew_temperature": 13,
            "temperature_units": "degree C",
            "qnh": 1007,
            "qnh_units": "hPa",
            "cloud": [
                {
                    "cloud_height": None,
                    "cloud_height_units": "m",
                    "cloud_mask": 0,
                    "cloud_type": None,
                }
            ],
            "weather": ["Clear Sky"],
        },
    },
    {
        "kwargs": {
            "text": "METAR ZBAA 310230Z 03002MPS 330V080 6000 -SHRA NSC 16/14 Q1008 NOSIG=",
            "year": 2021,
            "month": 5,
        },
        "result": {
            "kind": "METAR",
            "icao": "ZBAA",
            "auto": False,
            "datetime": "2021-05-31T02:30:00+00:00",
            "wind_direction": 30,
            "wind_direction_units": "degree",
            "wind_speed": 2,
            "wind_speed_units": "m/s",
            "gust": None,
            "wind_direction_range": (330, 80),
            "visibility": 6000,
            "visibility_units": "m",
            "cavok": False,
            "temperature": 16,
            "dew_temperature": 14,
            "temperature_units": "degree C",
            "qnh": 1008,
            "qnh_units": "hPa",
            "cloud": [
                {
                    "cloud_height": None,
                    "cloud_height_units": "m",
                    "cloud_mask": 0,
                    "cloud_type": None,
                }
            ],
            "weather": ["Light Showers of Rain"],
        },
    },
    {
        "kwargs": {
            "text": "METAR ZBHD 311500Z VRB03MPS 3000 TS BR FEW040CB 22/19 Q1006 NOSIG=",
            "year": 2021,
            "month": 5,
        },
        "result": {
            "kind": "METAR",
            "icao": "ZBHD",
            "auto": False,
            "datetime": "2021-05-31T15:00:00+00:00",
            "wind_direction": None,
            "wind_direction_units": "degree",
            "wind_speed": 3,
            "wind_speed_units": "m/s",
            "gust": None,
            "wind_direction_range": None,
            "visibility": 3000,
            "visibility_units": "m",
            "cavok": False,
            "temperature": 22,
            "dew_temperature": 19,
            "temperature_units": "degree C",
            "qnh": 1006,
            "qnh_units": "hPa",
            "cloud": [
                {
                    "cloud_height": 800,
                    "cloud_height_units": "m",
                    "cloud_mask": 0.25,
                    "cloud_type": "cumulonimbus",
                }
            ],
            "weather": ["Thunderstorm", "Mist"],
        },
    },
    {
        "kwargs": {
            "text": "SPECI ZBHD 311029Z 30009MPS 7000 -TSRA SCT030CB BKN046 25/17 Q1007 NOSIG=",
            "year": 2021,
            "month": 5,
        },
        "result": {
            "kind": "SPECI",
            "icao": "ZBHD",
            "auto": False,
            "datetime": "2021-05-31T10:29:00+00:00",
            "wind_direction": 300,
            "wind_direction_units": "degree",
            "wind_speed": 9,
            "wind_speed_units": "m/s",
            "gust": None,
            "wind_direction_range": None,
            "visibility": 7000,
            "visibility_units": "m",
            "cavok": False,
            "temperature": 25,
            "dew_temperature": 17,
            "temperature_units": "degree C",
            "qnh": 1007,
            "qnh_units": "hPa",
            "cloud": [
                {
                    "cloud_height": 920,
                    "cloud_height_units": "m",
                    "cloud_mask": 0.75,
                    "cloud_type": None,
                },
                {
                    "cloud_height": 600,
                    "cloud_height_units": "m",
                    "cloud_mask": 0.5,
                    "cloud_type": "cumulonimbus",
                },
            ],
            "weather": ["Light Thunderstorm Rain"],
        },
    },
    {
        "kwargs": {
            "text": "SPECI ZBHD 311029Z 30009MPS 7000 -TSRA SCT030CB BKN046 25/17 Q1007 NOSIG",
            "year": 2021,
            "month": 5,
        },
        "result": {
            "kind": "SPECI",
            "icao": "ZBHD",
            "auto": False,
            "datetime": "2021-05-31T10:29:00+00:00",
            "wind_direction": 300,
            "wind_direction_units": "degree",
            "wind_speed": 9,
            "wind_speed_units": "m/s",
            "gust": None,
            "wind_direction_range": None,
            "visibility": 7000,
            "visibility_units": "m",
            "cavok": False,
            "temperature": 25,
            "dew_temperature": 17,
            "temperature_units": "degree C",
            "qnh": 1007,
            "qnh_units": "hPa",
            "cloud": [
                {
                    "cloud_height": 920,
                    "cloud_height_units": "m",
                    "cloud_mask": 0.75,
                    "cloud_type": None,
                },
                {
                    "cloud_height": 600,
                    "cloud_height_units": "m",
                    "cloud_mask": 0.5,
                    "cloud_type": "cumulonimbus",
                },
            ],
            "weather": ["Light Thunderstorm Rain"],
        },
    },
    {
        "kwargs": {
            "text": "METAR ZBCZ 161200Z AUTO 22004MPS 8000 // ////// 21/19 Q1008=",
            "year": 2021,
            "month": 5,
        },
        "result": {
            "kind": "METAR",
            "icao": "ZBCZ",
            "auto": True,
            "datetime": "2021-05-16T12:00:00+00:00",
            "wind_direction": 220,
            "wind_direction_units": "degree",
            "wind_speed": 4,
            "wind_speed_units": "m/s",
            "gust": None,
            "wind_direction_range": None,
            "visibility": 8000,
            "visibility_units": "m",
            "cavok": False,
            "temperature": 21,
            "dew_temperature": 19,
            "temperature_units": "degree C",
            "qnh": 1008,
            "qnh_units": "hPa",
            "cloud": None,
            "weather": ["Clear Sky"],
        },
    },
    {
        "kwargs": {
            "text": "METAR ZBCZ 161200Z AUTO 22004MPS 8000 // ////// 21/19 Q1008",
            "year": 2021,
            "month": 5,
        },
        "result": {
            "kind": "METAR",
            "icao": "ZBCZ",
            "auto": True,
            "datetime": "2021-05-16T12:00:00+00:00",
            "wind_direction": 220,
            "wind_direction_units": "degree",
            "wind_speed": 4,
            "wind_speed_units": "m/s",
            "gust": None,
            "wind_direction_range": None,
            "visibility": 8000,
            "visibility_units": "m",
            "cavok": False,
            "temperature": 21,
            "dew_temperature": 19,
            "temperature_units": "degree C",
            "qnh": 1008,
            "qnh_units": "hPa",
            "cloud": None,
            "weather": ["Clear Sky"],
        },
    },
    {
        "kwargs": {
            "text": "SPECI ZUUU 160837Z 02004MPS 340V040 3500 SHRA BR FEW006 FEW026CB SCT026 25/25 Q1001 BECMG TL0930 -SHRA=",
            "year": 2021,
            "month": 5,
        },
        "result": {
            "kind": "SPECI",
            "icao": "ZUUU",
            "auto": False,
            "datetime": "2021-05-16T08:37:00+00:00",
            "wind_direction": 20,
            "wind_direction_units": "degree",
            "wind_speed": 4,
            "wind_speed_units": "m/s",
            "gust": None,
            "wind_direction_range": (340, 40),
            "visibility": 3500,
            "visibility_units": "m",
            "cavok": False,
            "temperature": 25,
            "dew_temperature": 25,
            "temperature_units": "degree C",
            "qnh": 1001,
            "qnh_units": "hPa",
            "cloud": [
                {
                    "cloud_height": 120,
                    "cloud_height_units": "m",
                    "cloud_mask": 0.25,
                    "cloud_type": None,
                },
                {
                    "cloud_height": 520,
                    "cloud_height_units": "m",
                    "cloud_mask": 0.25,
                    "cloud_type": "cumulonimbus",
                },
                {
                    "cloud_height": 520,
                    "cloud_height_units": "m",
                    "cloud_mask": 0.5,
                    "cloud_type": None,
                },
            ],
            "weather": ["Showers of Rain", "Mist"],
        },
    },
    {
        "kwargs": {
            "text": "METAR ZUUU 161030Z 02005MPS 330V050 8000 FEW006 FEW026TCU SCT026 24/22 Q1002 NOSIG=",
            "year": 2021,
            "month": 5,
        },
        "result": {
            "kind": "METAR",
            "icao": "ZUUU",
            "auto": False,
            "datetime": "2021-05-16T10:30:00+00:00",
            "wind_direction": 20,
            "wind_direction_units": "degree",
            "wind_speed": 5,
            "wind_speed_units": "m/s",
            "gust": None,
            "wind_direction_range": (330, 50),
            "visibility": 8000,
            "visibility_units": "m",
            "cavok": False,
            "temperature": 24,
            "dew_temperature": 22,
            "temperature_units": "degree C",
            "qnh": 1002,
            "qnh_units": "hPa",
            "cloud": [
                {
                    "cloud_height": 120,
                    "cloud_height_units": "m",
                    "cloud_mask": 0.25,
                    "cloud_type": None,
                },
                {
                    "cloud_height": 520,
                    "cloud_height_units": "m",
                    "cloud_mask": 0.25,
                    "cloud_type": "altocumulus",
                },
                {
                    "cloud_height": 520,
                    "cloud_height_units": "m",
                    "cloud_mask": 0.5,
                    "cloud_type": None,
                },
            ],
            "weather": ["Cloudy"],
        },
    },
    {
        "kwargs": {
            "text": "METAR RCKH 160600Z VRB03KT 2500 SHRA BR SCT003 BKN006 OVC020 26/26 Q1008 TEMPO 5000 -SHRA RMK A2977 RA AMT 5.4MM=",
            "year": 2021,
            "month": 5,
        },
        "result": {
            "kind": "METAR",
            "icao": "RCKH",
            "auto": False,
            "datetime": "2021-05-16T06:00:00+00:00",
            "wind_direction": None,
            "wind_direction_units": "degree",
            "wind_speed": 1,
            "wind_speed_units": "m/s",
            "gust": None,
            "wind_direction_range": None,
            "visibility": 2500,
            "visibility_units": "m",
            "cavok": False,
            "temperature": 26,
            "dew_temperature": 26,
            "temperature_units": "degree C",
            "qnh": 1008,
            "qnh_units": "hPa",
            "cloud": [
                {
                    "cloud_height": 120,
                    "cloud_height_units": "m",
                    "cloud_mask": 0.75,
                    "cloud_type": None,
                },
                {
                    "cloud_height": 400,
                    "cloud_height_units": "m",
                    "cloud_mask": 1,
                    "cloud_type": None,
                },
                {
                    "cloud_height": 60,
                    "cloud_height_units": "m",
                    "cloud_mask": 0.5,
                    "cloud_type": None,
                },
            ],
            "weather": ["Showers of Rain", "Mist"],
        },
    },
    {
        "kwargs": {
            "text": "METAR ZYAS 250500Z 21009G14MPS 6000 NSC 18/08 Q1018 NOSIG",
            "year": 2021,
            "month": 10,
        },
        "result": {
            "kind": "METAR",
            "icao": "ZYAS",
            "auto": False,
            "datetime": "2021-10-25T05:00:00+00:00",
            "wind_direction": 210,
            "wind_direction_units": "degree",
            "wind_speed": 9,
            "wind_speed_units": "m/s",
            "gust": 14,
            "wind_direction_range": None,
            "visibility": 6000,
            "visibility_units": "m",
            "cavok": False,
            "temperature": 18,
            "dew_temperature": 8,
            "temperature_units": "degree C",
            "qnh": 1018,
            "qnh_units": "hPa",
            "cloud": [
                {
                    "cloud_height": None,
                    "cloud_height_units": "m",
                    "cloud_mask": 0,
                    "cloud_type": None,
                }
            ],
            "weather": ["Clear Sky"],
        },
    },
    {
        "kwargs": {"text": "METAR RCMQ 080500Z NIL", "year": 2021, "month": 10},
        "result": None,
    },
    {
        "kwargs": {
            "text": "METAR ZYQQ 081700Z AUTO /////MPS //// // ////// M05/M07 Q1006",
            "year": 2021,
            "month": 11,
        },
        "result": {
            "kind": "METAR",
            "icao": "ZYQQ",
            "auto": True,
            "datetime": "2021-11-08T17:00:00+00:00",
            "wind_direction": None,
            "wind_direction_units": "degree",
            "wind_speed": None,
            "wind_speed_units": "m/s",
            "gust": None,
            "wind_direction_range": None,
            "visibility": None,
            "visibility_units": "m",
            "cavok": False,
            "temperature": -5,
            "dew_temperature": -7,
            "temperature_units": "degree C",
            "qnh": 1006,
            "qnh_units": "hPa",
            "cloud": None,
            "weather": ["Clear Sky"],
        },
    },
    {
        "kwargs": {
            "text": "KSUA 300715Z AUTO 10SM CLR 12/08 A3013 RMK AO2 T01170076",
            "year": 2024,
            "month": 1,
        },
        "result": {
            "kind": None,
            "icao": "KSUA",
            "datetime": "2024-01-30T07:15:00+00:00",
            "wind_direction": None,
            "wind_direction_units": "degree",
            "wind_speed": None,
            "wind_speed_units": "m/s",
            "gust": None,
            "wind_direction_range": None,
            "cavok": False,
            "visibility": 16093,
            "visibility_units": "m",
            "temperature": 12,
            "dew_temperature": 8,
            "temperature_units": "degree C",
            "qnh": 102031,
            "qnh_units": "hPa",
            "cloud": None,
            "weather": ["Clear Sky"],
            "auto": True,
        },
    },
    {
        "kwargs": {
            "text": "RJCW 010642Z 33025KT 0500 R08/0225V1100D BLSN SHSN VV005 M07/M09 Q1011 RMK A2987",
            "year": 2024,
            "month": 2,
        },
        "result": {
            "kind": None,
            "icao": "RJCW",
            "datetime": "2024-02-01T06:42:00+00:00",
            "wind_direction": 330,
            "wind_direction_units": "degree",
            "wind_speed": 12,
            "wind_speed_units": "m/s",
            "gust": None,
            "wind_direction_range": None,
            "cavok": False,
            "visibility": 500,
            "visibility_units": "m",
            "temperature": -7,
            "dew_temperature": -9,
            "temperature_units": "degree C",
            "qnh": 1011,
            "qnh_units": "hPa",
            "cloud": None,
            "weather": ["Blowing Snow", "Showers of Snow"],
            "auto": False,
        },
    },
    {
        "kwargs": {
            "text": "RCFN 010700Z 16006KT 120V200 9999 VCSH SCT018 BKN030 BKN060 25/19 Q1018 NOSIG RMK A3007",
            "year": 2024,
            "month": 2,
        },
        "result": {
            "kind": None,
            "icao": "RCFN",
            "datetime": "2024-02-01T07:00:00+00:00",
            "wind_direction": 160,
            "wind_direction_units": "degree",
            "wind_speed": 3,
            "wind_speed_units": "m/s",
            "gust": None,
            "wind_direction_range": (120, 200),
            "cavok": False,
            "visibility": 99999,
            "visibility_units": "m",
            "temperature": 25,
            "dew_temperature": 19,
            "temperature_units": "degree C",
            "qnh": 1018,
            "qnh_units": "hPa",
            "cloud": [
                {
                    "cloud_mask": 0.75,
                    "cloud_height": 600,
                    "cloud_height_units": "m",
                    "cloud_type": None,
                },
                {
                    "cloud_mask": 0.75,
                    "cloud_height": 1200,
                    "cloud_height_units": "m",
                    "cloud_type": None,
                },
                {
                    "cloud_mask": 0.5,
                    "cloud_height": 360,
                    "cloud_height_units": "m",
                    "cloud_type": None,
                },
            ],
            "weather": ["Showers in the Vicinity"],
            "auto": False,
        },
    },
    {
        "kwargs": {
            "text": "METAR ZBAA 301630Z 00000MPS CAVOK 16/16 Q1009 NOSIG=",
            "year": 2025,
            "month": 10,
        },
        "result": {
            "kind": "METAR",
            "icao": "ZBAA",
            "auto": False,
            "datetime": "2025-10-30T16:30:00+00:00",
            "wind_direction": None,
            "wind_direction_units": "degree",
            "wind_speed": 0,
            "wind_speed_units": "m/s",
            "gust": None,
            "wind_direction_range": None,
            "cavok": True,
            "visibility": 99999,
            "visibility_units": "m",
            "temperature": 16,
            "dew_temperature": 16,
            "temperature_units": "degree C",
            "qnh": 1009,
            "qnh_units": "hPa",
            "cloud": None,
            "weather": ["Clear Sky"],
        },
    },
    {
        "kwargs": {
            "text": "METAR RCNN 091100Z 20003KT 9999 VCSH FEW010 BKN040 29/25 Q1010 RMK A2984 VCSH W=",
            "year": 2024,
            "month": 10,
        },
        "result": {
            "kind": "METAR",
            "icao": "RCNN",
            "auto": False,
            "datetime": "2024-10-09T11:00:00+00:00",
            "wind_direction": 200,
            "wind_direction_units": "degree",
            "wind_speed": 1,
            "wind_speed_units": "m/s",
            "gust": None,
            "wind_direction_range": None,
            "visibility": 99999,
            "visibility_units": "m",
            "cavok": False,
            "temperature": 29,
            "dew_temperature": 25,
            "temperature_units": "degree C",
            "qnh": 1010,
            "qnh_units": "hPa",
            "cloud": [
                {
                    "cloud_mask": 0.75,
                    "cloud_height": 800,
                    "cloud_height_units": "m",
                    "cloud_type": None,
                },
                {
                    "cloud_mask": 0.25,
                    "cloud_height": 200,
                    "cloud_height_units": "m",
                    "cloud_type": None,
                },
            ],
            "weather": ["Showers in the Vicinity"],  # Only one, RMK content is ignored
        },
    },
    {
        "kwargs": {
            "text": "METAR RCNN 092130Z 30003KT 6000 -RA VCTS FEW008 FEW012CB BKN016 BKN040 27/26 Q1009 BECMG FM2200 TL2300 TSRA RMK A2980 TS SW MOV N=",
            "year": 2024,
            "month": 10,
        },
        "result": {
            "kind": "METAR",
            "icao": "RCNN",
            "auto": False,
            "datetime": "2024-10-09T21:30:00+00:00",
            "wind_direction": 300,
            "wind_direction_units": "degree",
            "wind_speed": 1,
            "wind_speed_units": "m/s",
            "gust": None,
            "wind_direction_range": None,
            "visibility": 6000,
            "visibility_units": "m",
            "cavok": False,
            "temperature": 27,
            "dew_temperature": 26,
            "temperature_units": "degree C",
            "qnh": 1009,
            "qnh_units": "hPa",
            "cloud": [
                {
                    "cloud_mask": 0.75,
                    "cloud_height": 320,
                    "cloud_height_units": "m",
                    "cloud_type": None,
                },
                {
                    "cloud_mask": 0.75,
                    "cloud_height": 800,
                    "cloud_height_units": "m",
                    "cloud_type": None,
                },
                {
                    "cloud_mask": 0.25,
                    "cloud_height": 160,
                    "cloud_height_units": "m",
                    "cloud_type": None,
                },
                {
                    "cloud_mask": 0.25,
                    "cloud_height": 240,
                    "cloud_height_units": "m",
                    "cloud_type": "cumulonimbus",
                },
            ],
            "weather": [
                "Light Rain",
                "Thunderstorm in the Vicinity",
            ],  # VCTS with new word order, RMK ignored
        },
    },
]
