"""
AFNI

AFNI (Analysis of Functional NeuroImages) is a leading software suite of C,
Python, R programs and shell scripts primarily developed for the analysis and
display of multiple MRI modalities: anatomical, functional MRI (FMRI) and
diffusion weighted (DW) data. It is freely available (both as open source code
and as precompiled binaries) for research purposes. The software is made to run
on virtually any Unix system with X11 and Motif displays. Binary packages are
provided for MacOS and Linux systems such as Fedora, CentOS/Red Hat and Ubuntu
(which includes the Windows Subsystem for Linux).

Author: AFNI Developers

URL: https://afni.nimh.nih.gov/
"""
# This file was auto generated by Styx.
# Do not edit this file directly.

from .abids_json_info_py import *
from .abids_json_tool_py import *
from .abids_tool_py import *
from .adjunct_apqc_tsnr_general import *
from .adjunct_aw_tableize_roi_info_py import *
from .adjunct_calc_mont_dims_py import *
from .adjunct_combine_str_py import *
from .adjunct_is_label_py import *
from .adjunct_make_script_and_rst_py import *
from .adjunct_select_str_py import *
from .adjunct_simplify_cost_py import *
from .adjunct_suma_fs_mask_and_qc import *
from .adjunct_suma_fs_roi_info import *
from .adjunct_tort_plot_dp_align import *
from .adwarp import *
from .afni import *
from .afni_batch_r import *
from .afni_check_omp import *
from .afni_history import *
from .afni_open import *
from .afni_proc_py import *
from .afni_run_r import *
from .afni_system_check_py import *
from .aiv import *
from .align_epi_anat_py import *
from .analyze_trace import *
from .ap_run_simple_rest_tcsh import *
from .apqc_make_html_py import *
from .apqc_make_tcsh_py import *
from .apsearch import *
from .auto_warp_py import *
from .balloon import *
from .bayes_view import *
from .bayesian_group_ana_py import *
from .brain_skin import *
from .build_afni_py import *
from .cat_matvec import *
from .ccalc import *
from .cifti_tool import *
from .cjpeg import *
from .clust_exp_hist_table_py import *
from .clust_exp_stat_parse_py import *
from .column_cat import *
from .compare_surfaces import *
from .convert_cdiflist_to_grads_py import *
from .convert_dset import *
from .convert_surface import *
from .convex_hull import *
from .count import *
from .create_icosahedron import *
from .dcm2niix_afni import *
from .dicom_hdr import *
from .dicom_hinfo import *
from .dicom_to_raw import *
from .dimon import *
from .djpeg import *
from .drive_suma import *
from .dsetstat2p import *
from .dtistudio_fiberto_segments import *
from .epi_b0_correct_py import *
from .examine_xmat import *
from .fat_mat2d_plot_py import *
from .fat_mat_sel_py import *
from .fat_mat_tableize_py import *
from .fat_mvm_gridconv_py import *
from .fat_mvm_prep_py import *
from .fat_mvm_scripter_py import *
from .fat_proc_align_anat_pair import *
from .fat_proc_axialize_anat import *
from .fat_proc_connec_vis import *
from .fat_proc_convert_dcm_anat import *
from .fat_proc_convert_dcm_dwis import *
from .fat_proc_decmap import *
from .fat_proc_dwi_to_dt import *
from .fat_proc_filter_dwis import *
from .fat_proc_imit2w_from_t1w import *
from .fat_proc_map_to_dti import *
from .fat_proc_select_vols import *
from .fat_roi_row_py import *
from .fatcat_matplot import *
from .fdrval import *
from .fftest import *
from .file_tool import *
from .fim2 import *
from .find_variance_lines_tcsh import *
from .firdesign import *
from .float_scan import *
from .from3d import *
from .fsread_annot import *
from .gen_epi_review_py import *
from .gen_group_command_py import *
from .gen_ss_review_scripts_py import *
from .gen_ss_review_table_py import *
from .get_afni_model_prf import *
from .get_afni_model_prf_6 import *
from .get_afni_model_prf_6_bad import *
from .gifti_tool import *
from .gltsymtest import *
from .help_format import *
from .im2niml import *
from .images_equal import *
from .imand import *
from .imaver import *
from .imcalc import *
from .imcat import *
from .imcutup import *
from .imdump import *
from .immask import *
from .imreg import *
from .imrotate import *
from .imstack import *
from .imstat import *
from .imupsam import *
from .init_user_dotfiles_py import *
from .inspec import *
from .iso_surface import *
from .make_color_map import *
from .make_pq_script_py import *
from .make_random_timing_py import *
from .make_stim_times_py import *
from .map_icosahedron import *
from .map_track_id import *
from .mba import *
from .meica_py import *
from .myget import *
from .neuro_deconvolve_py import *
from .nicat import *
from .niccc import *
from .nifti_tool import *
from .niml_feedme import *
from .nsize import *
from .p2dsetstat import *
from .parse_fs_lt_log_py import *
from .plugout_drive import *
from .plugout_ijk import *
from .plugout_tt import *
from .plugout_tta import *
from .prompt_popup import *
from .prompt_user import *
from .pta import *
from .qdelaunay import *
from .qhull import *
from .quick_alpha_vals_py import *
from .quickspec import *
from .quickspec_sl import *
from .quotize import *
from .r_pkgs_install import *
from .rba import *
from .rbox import *
from .read_matlab_files_py import *
from .realtime_receiver_py import *
from .retro_ts_py import *
from .rmz import *
from .roi2dataset import *
from .roigrow import *
from .rotcom import *
from .rsfgen import *
from .rtfeedme import *
from .samp_bias import *
from .scale_to_map import *
from .serial_helper import *
from .sfim import *
from .slow_surf_clustsim_py import *
from .spharm_deco import *
from .spharm_reco import *
from .stimband import *
from .strblast import *
from .suma_change_spec import *
from .suma_glxdino import *
from .surf2_vol_coord import *
from .surf_clust import *
from .surf_dist import *
from .surf_dset_info import *
from .surf_extrema import *
from .surf_fwhm import *
from .surf_info import *
from .surf_layers import *
from .surf_localstat import *
from .surf_measures import *
from .surf_mesh import *
from .surf_patch import *
from .surf_qual import *
from .surf_retino_map import *
from .surf_smooth import *
from .surf_to_surf import *
from .surface_metrics import *
from .tedana_wrapper_py import *
from .tfim import *
from .timing_tool_py import *
from .to3d import *
from .tokens import *
from .trr import *
from .uber_align_test_py import *
from .uber_proc_py import *
from .uber_skel_py import *
from .uber_subject_py import *
from .un_warp_epi_py import *
from .uniq_images import *
from .v_1d_apar2mat import *
from .v_1d_astrip import *
from .v_1d_bandpass import *
from .v_1d_bport import *
from .v_1d_correlate import *
from .v_1d_dw_grad_o_mat__ import *
from .v_1d_flag_motion import *
from .v_1d_marry import *
from .v_1d_nlfit import *
from .v_1d_rplot import *
from .v_1d_sem import *
from .v_1d_tool_py import *
from .v_1d_tsort import *
from .v_1d_upsample import *
from .v_1dcat import *
from .v_1ddot import *
from .v_1deval import *
from .v_1dfft import *
from .v_1dgen_arma11 import *
from .v_1dgrayplot import *
from .v_1dmatcalc import *
from .v_1dnorm import *
from .v_1dplot import *
from .v_1dplot_py import *
from .v_1dsound import *
from .v_1dsum import *
from .v_1dsvd import *
from .v_1dtranspose import *
from .v_24swap import *
from .v_2d_im_reg import *
from .v_2dcat import *
from .v_2perm import *
from .v_2swap import *
from .v_3d_aboverlap import *
from .v_3d_acost import *
from .v_3d_afnito3_d import *
from .v_3d_afnito_analyze import *
from .v_3d_afnito_nifti import *
from .v_3d_afnito_niml import *
from .v_3d_afnito_raw import *
from .v_3d_allineate import *
from .v_3d_amp_to_rsfc import *
from .v_3d_anhist import *
from .v_3d_anova import *
from .v_3d_anova2 import *
from .v_3d_anova3 import *
from .v_3d_attribute import *
from .v_3d_auto_tcorrelate import *
from .v_3d_autobox import *
from .v_3d_automask import *
from .v_3d_ball_match import *
from .v_3d_bandpass import *
from .v_3d_blur_in_mask import *
from .v_3d_blur_to_fwhm import *
from .v_3d_brain_sync import *
from .v_3d_brain_voyagerto_afni import *
from .v_3d_brick_stat import *
from .v_3d_clip_level import *
from .v_3d_clust_count import *
from .v_3d_clust_sim import *
from .v_3d_clusterize import *
from .v_3d_cm import *
from .v_3d_compare_affine import *
from .v_3d_conformist import *
from .v_3d_convolve import *
from .v_3d_cruiseto_afni import *
from .v_3d_deconvolve import *
from .v_3d_degree_centrality import *
from .v_3d_depth_map import *
from .v_3d_despike import *
from .v_3d_detrend import *
from .v_3d_dft import *
from .v_3d_diff import *
from .v_3d_dteig import *
from .v_3d_dtto_dwi import *
from .v_3d_dtto_noisy_dwi import *
from .v_3d_dwito_dt import *
from .v_3d_dwuncert import *
from .v_3d_ecm import *
from .v_3d_edu_01_scale import *
from .v_3d_eigs_to_dt import *
from .v_3d_empty import *
from .v_3d_entropy import *
from .v_3d_errts_cormat import *
from .v_3d_exchange import *
from .v_3d_extract_group_in_corr import *
from .v_3d_extrema import *
from .v_3d_fdr import *
from .v_3d_fft import *
from .v_3d_friedman import *
from .v_3d_fwhmx import *
from .v_3d_gen_feature_dist import *
from .v_3d_gen_priors import *
from .v_3d_getrow import *
from .v_3d_grayplot import *
from .v_3d_group_in_corr import *
from .v_3d_hist import *
from .v_3d_icc import *
from .v_3d_intracranial import *
from .v_3d_inv_fmri import *
from .v_3d_isc import *
from .v_3d_kruskal_wallis import *
from .v_3d_lfcd import *
from .v_3d_lme import *
from .v_3d_lmer import *
from .v_3d_local_acf import *
from .v_3d_local_bistat import *
from .v_3d_local_histog import *
from .v_3d_local_pv import *
from .v_3d_local_svd import *
from .v_3d_local_unifize import *
from .v_3d_localstat import *
from .v_3d_lomb_scargle import *
from .v_3d_lrflip import *
from .v_3d_lss import *
from .v_3d_mann_whitney import *
from .v_3d_mask_to_ascii import *
from .v_3d_match import *
from .v_3d_mean import *
from .v_3d_median_filter import *
from .v_3d_mema import *
from .v_3d_mepfm import *
from .v_3d_mse import *
from .v_3d_mss import *
from .v_3d_multi_thresh import *
from .v_3d_mvm import *
from .v_3d_mvm_validator import *
from .v_3d_net_corr import *
from .v_3d_nlfim import *
from .v_3d_normality_test import *
from .v_3d_notes import *
from .v_3d_nwarp_adjust import *
from .v_3d_nwarp_apply import *
from .v_3d_nwarp_cat import *
from .v_3d_nwarp_funcs import *
from .v_3d_nwarp_xyz import *
from .v_3d_overlap import *
from .v_3d_par2_afni_pl import *
from .v_3d_periodogram import *
from .v_3d_pfm import *
from .v_3d_polyfit import *
from .v_3d_pval import *
from .v_3d_pvmap import *
from .v_3d_qwarp import *
from .v_3d_rank import *
from .v_3d_rankizer import *
from .v_3d_re_ho import *
from .v_3d_reg_ana import *
from .v_3d_remlfit import *
from .v_3d_retino_phase import *
from .v_3d_roimaker import *
from .v_3d_roistats import *
from .v_3d_row_fillin import *
from .v_3d_rprog_demo import *
from .v_3d_rsfc import *
from .v_3d_seg import *
from .v_3d_setup_group_in_corr import *
from .v_3d_sharpen import *
from .v_3d_signatures import *
from .v_3d_skull_strip import *
from .v_3d_slice_ndice import *
from .v_3d_space_time_corr import *
from .v_3d_spat_norm import *
from .v_3d_stat_clust import *
from .v_3d_surf2_vol import *
from .v_3d_surf_mask import *
from .v_3d_synthesize import *
from .v_3d_tagalign import *
from .v_3d_tcat import *
from .v_3d_tcorr1_d import *
from .v_3d_tcorr_map import *
from .v_3d_tcorrelate import *
from .v_3d_tfilter import *
from .v_3d_tfitter import *
from .v_3d_threeto_rgb import *
from .v_3d_tnorm import *
from .v_3d_tortoiseto_here import *
from .v_3d_toutcount import *
from .v_3d_toy_prog import *
from .v_3d_tproject import *
from .v_3d_tqual import *
from .v_3d_track_id import *
from .v_3d_trfix import *
from .v_3d_tsgen import *
from .v_3d_tshift import *
from .v_3d_tsmooth import *
from .v_3d_tsort import *
from .v_3d_tsplit4_d import *
from .v_3d_tstat import *
from .v_3d_tto1_d import *
from .v_3d_twoto_complex import *
from .v_3d_undump import *
from .v_3d_unifize import *
from .v_3d_upsample import *
from .v_3d_vec_rgb_to_hsl import *
from .v_3d_vol2_surf import *
from .v_3d_warp import *
from .v_3d_warp_drive import *
from .v_3d_wilcoxon import *
from .v_3d_winsor import *
from .v_3d_xclust_sim import *
from .v_3d_xyzcat import *
from .v_3d_zcat import *
from .v_3d_zcutup import *
from .v_3d_zeropad import *
from .v_3d_zipper_zapper import *
from .v_3d_zregrid import *
from .v_3danisosmooth import *
from .v_3daxialize import *
from .v_3dbucket import *
from .v_3dcalc import *
from .v_3dclust import *
from .v_3dcopy import *
from .v_3ddelay import *
from .v_3ddot import *
from .v_3ddot_beta import *
from .v_3dedge3 import *
from .v_3dedgedog import *
from .v_3dfim_ import *
from .v_3dfractionize import *
from .v_3dhistog import *
from .v_3dinfill import *
from .v_3dinfo import *
from .v_3dkmeans import *
from .v_3dmask_svd import *
from .v_3dmask_tool import *
from .v_3dmaskave import *
from .v_3dmaskdump import *
from .v_3dmatcalc import *
from .v_3dmatmult import *
from .v_3dmaxdisp import *
from .v_3dmaxima import *
from .v_3dmerge import *
from .v_3dnewid import *
from .v_3dnvals import *
from .v_3dpc import *
from .v_3drefit import *
from .v_3drename import *
from .v_3dresample import *
from .v_3dretroicor import *
from .v_3drotate import *
from .v_3dsvm import *
from .v_3dsvm_linpredict import *
from .v_3dto_xdataset import *
from .v_3dttest__ import *
from .v_3dvolreg import *
from .v_4swap import *
from .v__1d_diff_mag import *
from .v__2dwarper import *
from .v__2dwarper_allin import *
from .v__4_daverage import *
from .v__add_edge import *
from .v__afni_env import *
from .v__afni_orient2_raimap import *
from .v__afni_orient_sign import *
from .v__afni_r_package_install import *
from .v__afni_refacer_make_master import *
from .v__afni_refacer_make_onebig_a12 import *
from .v__afni_refacer_run import *
from .v__afni_run_me import *
from .v__align_centers import *
from .v__align_partial_oblique import *
from .v__anaticor import *
from .v__animal_warper import *
from .v__atlasize import *
from .v__auto_tlrc import *
from .v__build_afni_xlib import *
from .v__center_distance import *
from .v__chauffeur_afni import *
from .v__check_for_afni_dset import *
from .v__clip_volume import *
from .v__clust_exp_cat_lab import *
from .v__clust_exp_run_shiny import *
from .v__command_globb import *
from .v__compute_gcor import *
from .v__compute_oc_weights import *
from .v__deblank_file_names import *
from .v__demo_prompt import *
from .v__dice_metric import *
from .v__diff_files import *
from .v__diff_tree import *
from .v__djunct_4d_imager import *
from .v__djunct_4d_slices_to_3d_vol import *
from .v__djunct_anonymize import *
from .v__djunct_dwi_selector_tcsh import *
from .v__djunct_edgy_align_check import *
from .v__djunct_modal_smoothing_with_rep import *
from .v__djunct_montage_coordinator import *
from .v__djunct_overlap_check import *
from .v__djunct_ssw_intermed_edge_imgs import *
from .v__do_examples import *
from .v__electro_grid import *
from .v__examine_gen_feat_dists import *
from .v__extract_meica_ortvec import *
from .v__fast_roi import *
from .v__fat_tract_colorize import *
from .v__find_afni_dset_path import *
from .v__fix_fssphere import *
from .v__float_fix import *
from .v__from_rai import *
from .v__fs_roi_label import *
from .v__fslabel2dset import *
from .v__get_afni_dims import *
from .v__get_afni_id import *
from .v__get_afni_orient import *
from .v__get_afni_prefix import *
from .v__get_afni_res import *
from .v__get_afni_version import *
from .v__get_afni_view import *
from .v__grad_flip_test import *
from .v__grayplot import *
from .v__help_afni import *
from .v__is_oblique import *
from .v__iso_masks import *
from .v__make_label_table import *
from .v__make_plug_diff import *
from .v__measure_bb_thick import *
from .v__measure_erosion_thick import *
from .v__measure_in2out import *
from .v__move_to_series_dirs import *
from .v__no_ext import *
from .v__no_pound import *
from .v__noisy_skull_strip import *
from .v__np import *
from .v__parse_afni_name import *
from .v__purify_1_d import *
from .v__quiet_talkers import *
from .v__radial_correlate import *
from .v__rename_panga import *
from .v__reorder import *
from .v__retino_proc import *
from .v__roi_corr_mat import *
from .v__roi_decluster import *
from .v__roi_modal_grow import *
from .v__scale_volume import *
from .v__script_check import *
from .v__shift_volume import *
from .v__show_dynamic_range import *
from .v__simulate_motion import *
from .v__skull_strip_touch_up import *
from .v__snapshot_volreg import *
from .v__spharm_examples import *
from .v__sswarper import *
from .v__statauxcode import *
from .v__suma_acknowledge import *
from .v__suma_align_to_experiment import *
from .v__suma_fsvol_to_brik import *
from .v__suma_make_spec_caret import *
from .v__suma_make_spec_fs import *
from .v__suma_make_spec_sf import *
from .v__suma_renumber_fs import *
from .v__suma_reprefixize_spec import *
from .v__surf_smooth_heat_07_examples import *
from .v__surf_to_vol_spackle import *
from .v__t1scale import *
from .v__thickness_master import *
from .v__time_diff import *
from .v__to_mni_awarp import *
from .v__to_mni_qwarpar import *
from .v__to_rai import *
from .v__update_afni_binaries import *
from .v__vol_center import *
from .v__xyz_to_ijk import *
from .vecwarp import *
from .waver import *
from .whirlgif import *
from .xmat_tool_py import *
from styxdefs import Runner as _Runner


def execute(
    params: dict,
    runner: _Runner | None = None,
) -> None:
    """
    Run a command in this package dynamically from a params object.
    
    Args:
        params: The parameters.
        runner: Command runner.
    """
    return {
        "afni/1dApar2mat": v_1d_apar2mat_execute,
        "afni/1dAstrip": v_1d_astrip_execute,
        "afni/1dBandpass": v_1d_bandpass_execute,
        "afni/1dBport": v_1d_bport_execute,
        "afni/1dCorrelate": v_1d_correlate_execute,
        "afni/1dDW_Grad_o_Mat++": v_1d_dw_grad_o_mat___execute,
        "afni/1dFlagMotion": v_1d_flag_motion_execute,
        "afni/1dMarry": v_1d_marry_execute,
        "afni/1dNLfit": v_1d_nlfit_execute,
        "afni/1dRplot": v_1d_rplot_execute,
        "afni/1dSEM": v_1d_sem_execute,
        "afni/1dTsort": v_1d_tsort_execute,
        "afni/1dUpsample": v_1d_upsample_execute,
        "afni/1d_tool.py": v_1d_tool_py_execute,
        "afni/1dcat": v_1dcat_execute,
        "afni/1ddot": v_1ddot_execute,
        "afni/1deval": v_1deval_execute,
        "afni/1dfft": v_1dfft_execute,
        "afni/1dgenARMA11": v_1dgen_arma11_execute,
        "afni/1dgrayplot": v_1dgrayplot_execute,
        "afni/1dmatcalc": v_1dmatcalc_execute,
        "afni/1dnorm": v_1dnorm_execute,
        "afni/1dplot": v_1dplot_execute,
        "afni/1dplot.py": v_1dplot_py_execute,
        "afni/1dsound": v_1dsound_execute,
        "afni/1dsum": v_1dsum_execute,
        "afni/1dsvd": v_1dsvd_execute,
        "afni/1dtranspose": v_1dtranspose_execute,
        "afni/24swap": v_24swap_execute,
        "afni/2dImReg": v_2d_im_reg_execute,
        "afni/2dcat": v_2dcat_execute,
        "afni/2perm": v_2perm_execute,
        "afni/2swap": v_2swap_execute,
        "afni/3dABoverlap": v_3d_aboverlap_execute,
        "afni/3dAFNIto3D": v_3d_afnito3_d_execute,
        "afni/3dAFNItoANALYZE": v_3d_afnito_analyze_execute,
        "afni/3dAFNItoNIFTI": v_3d_afnito_nifti_execute,
        "afni/3dAFNItoNIML": v_3d_afnito_niml_execute,
        "afni/3dAFNItoRaw": v_3d_afnito_raw_execute,
        "afni/3dANOVA": v_3d_anova_execute,
        "afni/3dANOVA2": v_3d_anova2_execute,
        "afni/3dANOVA3": v_3d_anova3_execute,
        "afni/3dAcost": v_3d_acost_execute,
        "afni/3dAllineate": v_3d_allineate_execute,
        "afni/3dAmpToRSFC": v_3d_amp_to_rsfc_execute,
        "afni/3dAnhist": v_3d_anhist_execute,
        "afni/3dAttribute": v_3d_attribute_execute,
        "afni/3dAutoTcorrelate": v_3d_auto_tcorrelate_execute,
        "afni/3dAutobox": v_3d_autobox_execute,
        "afni/3dAutomask": v_3d_automask_execute,
        "afni/3dBRAIN_VOYAGERtoAFNI": v_3d_brain_voyagerto_afni_execute,
        "afni/3dBallMatch": v_3d_ball_match_execute,
        "afni/3dBandpass": v_3d_bandpass_execute,
        "afni/3dBlurInMask": v_3d_blur_in_mask_execute,
        "afni/3dBlurToFWHM": v_3d_blur_to_fwhm_execute,
        "afni/3dBrainSync": v_3d_brain_sync_execute,
        "afni/3dBrickStat": v_3d_brick_stat_execute,
        "afni/3dCM": v_3d_cm_execute,
        "afni/3dCRUISEtoAFNI": v_3d_cruiseto_afni_execute,
        "afni/3dClipLevel": v_3d_clip_level_execute,
        "afni/3dClustCount": v_3d_clust_count_execute,
        "afni/3dClustSim": v_3d_clust_sim_execute,
        "afni/3dClusterize": v_3d_clusterize_execute,
        "afni/3dCompareAffine": v_3d_compare_affine_execute,
        "afni/3dConformist": v_3d_conformist_execute,
        "afni/3dConvolve": v_3d_convolve_execute,
        "afni/3dDFT": v_3d_dft_execute,
        "afni/3dDTeig": v_3d_dteig_execute,
        "afni/3dDTtoDWI": v_3d_dtto_dwi_execute,
        "afni/3dDTtoNoisyDWI": v_3d_dtto_noisy_dwi_execute,
        "afni/3dDWItoDT": v_3d_dwito_dt_execute,
        "afni/3dDWUncert": v_3d_dwuncert_execute,
        "afni/3dDeconvolve": v_3d_deconvolve_execute,
        "afni/3dDegreeCentrality": v_3d_degree_centrality_execute,
        "afni/3dDepthMap": v_3d_depth_map_execute,
        "afni/3dDespike": v_3d_despike_execute,
        "afni/3dDetrend": v_3d_detrend_execute,
        "afni/3dDiff": v_3d_diff_execute,
        "afni/3dECM": v_3d_ecm_execute,
        "afni/3dEdu_01_scale": v_3d_edu_01_scale_execute,
        "afni/3dEigsToDT": v_3d_eigs_to_dt_execute,
        "afni/3dEmpty": v_3d_empty_execute,
        "afni/3dEntropy": v_3d_entropy_execute,
        "afni/3dErrtsCormat": v_3d_errts_cormat_execute,
        "afni/3dExchange": v_3d_exchange_execute,
        "afni/3dExtractGroupInCorr": v_3d_extract_group_in_corr_execute,
        "afni/3dExtrema": v_3d_extrema_execute,
        "afni/3dFDR": v_3d_fdr_execute,
        "afni/3dFFT": v_3d_fft_execute,
        "afni/3dFWHMx": v_3d_fwhmx_execute,
        "afni/3dFriedman": v_3d_friedman_execute,
        "afni/3dGenFeatureDist": v_3d_gen_feature_dist_execute,
        "afni/3dGenPriors": v_3d_gen_priors_execute,
        "afni/3dGetrow": v_3d_getrow_execute,
        "afni/3dGrayplot": v_3d_grayplot_execute,
        "afni/3dGroupInCorr": v_3d_group_in_corr_execute,
        "afni/3dHist": v_3d_hist_execute,
        "afni/3dICC": v_3d_icc_execute,
        "afni/3dISC": v_3d_isc_execute,
        "afni/3dIntracranial": v_3d_intracranial_execute,
        "afni/3dInvFMRI": v_3d_inv_fmri_execute,
        "afni/3dKruskalWallis": v_3d_kruskal_wallis_execute,
        "afni/3dLFCD": v_3d_lfcd_execute,
        "afni/3dLME": v_3d_lme_execute,
        "afni/3dLMEr": v_3d_lmer_execute,
        "afni/3dLRflip": v_3d_lrflip_execute,
        "afni/3dLSS": v_3d_lss_execute,
        "afni/3dLocalACF": v_3d_local_acf_execute,
        "afni/3dLocalBistat": v_3d_local_bistat_execute,
        "afni/3dLocalHistog": v_3d_local_histog_execute,
        "afni/3dLocalPV": v_3d_local_pv_execute,
        "afni/3dLocalSVD": v_3d_local_svd_execute,
        "afni/3dLocalUnifize": v_3d_local_unifize_execute,
        "afni/3dLocalstat": v_3d_localstat_execute,
        "afni/3dLombScargle": v_3d_lomb_scargle_execute,
        "afni/3dMEMA": v_3d_mema_execute,
        "afni/3dMEPFM": v_3d_mepfm_execute,
        "afni/3dMSE": v_3d_mse_execute,
        "afni/3dMSS": v_3d_mss_execute,
        "afni/3dMVM": v_3d_mvm_execute,
        "afni/3dMVM_validator": v_3d_mvm_validator_execute,
        "afni/3dMannWhitney": v_3d_mann_whitney_execute,
        "afni/3dMaskToASCII": v_3d_mask_to_ascii_execute,
        "afni/3dMatch": v_3d_match_execute,
        "afni/3dMean": v_3d_mean_execute,
        "afni/3dMedianFilter": v_3d_median_filter_execute,
        "afni/3dMultiThresh": v_3d_multi_thresh_execute,
        "afni/3dNLfim": v_3d_nlfim_execute,
        "afni/3dNetCorr": v_3d_net_corr_execute,
        "afni/3dNormalityTest": v_3d_normality_test_execute,
        "afni/3dNotes": v_3d_notes_execute,
        "afni/3dNwarpAdjust": v_3d_nwarp_adjust_execute,
        "afni/3dNwarpApply": v_3d_nwarp_apply_execute,
        "afni/3dNwarpCat": v_3d_nwarp_cat_execute,
        "afni/3dNwarpFuncs": v_3d_nwarp_funcs_execute,
        "afni/3dNwarpXYZ": v_3d_nwarp_xyz_execute,
        "afni/3dOverlap": v_3d_overlap_execute,
        "afni/3dPAR2AFNI.pl": v_3d_par2_afni_pl_execute,
        "afni/3dPFM": v_3d_pfm_execute,
        "afni/3dPVmap": v_3d_pvmap_execute,
        "afni/3dPeriodogram": v_3d_periodogram_execute,
        "afni/3dPolyfit": v_3d_polyfit_execute,
        "afni/3dPval": v_3d_pval_execute,
        "afni/3dQwarp": v_3d_qwarp_execute,
        "afni/3dREMLfit": v_3d_remlfit_execute,
        "afni/3dROIMaker": v_3d_roimaker_execute,
        "afni/3dROIstats": v_3d_roistats_execute,
        "afni/3dRSFC": v_3d_rsfc_execute,
        "afni/3dRank": v_3d_rank_execute,
        "afni/3dRankizer": v_3d_rankizer_execute,
        "afni/3dReHo": v_3d_re_ho_execute,
        "afni/3dRegAna": v_3d_reg_ana_execute,
        "afni/3dRetinoPhase": v_3d_retino_phase_execute,
        "afni/3dRowFillin": v_3d_row_fillin_execute,
        "afni/3dRprogDemo": v_3d_rprog_demo_execute,
        "afni/3dSeg": v_3d_seg_execute,
        "afni/3dSetupGroupInCorr": v_3d_setup_group_in_corr_execute,
        "afni/3dSharpen": v_3d_sharpen_execute,
        "afni/3dSignatures": v_3d_signatures_execute,
        "afni/3dSkullStrip": v_3d_skull_strip_execute,
        "afni/3dSliceNDice": v_3d_slice_ndice_execute,
        "afni/3dSpaceTimeCorr": v_3d_space_time_corr_execute,
        "afni/3dSpatNorm": v_3d_spat_norm_execute,
        "afni/3dStatClust": v_3d_stat_clust_execute,
        "afni/3dSurf2Vol": v_3d_surf2_vol_execute,
        "afni/3dSurfMask": v_3d_surf_mask_execute,
        "afni/3dSynthesize": v_3d_synthesize_execute,
        "afni/3dTORTOISEtoHere": v_3d_tortoiseto_here_execute,
        "afni/3dTRfix": v_3d_trfix_execute,
        "afni/3dTSgen": v_3d_tsgen_execute,
        "afni/3dTagalign": v_3d_tagalign_execute,
        "afni/3dTcat": v_3d_tcat_execute,
        "afni/3dTcorr1D": v_3d_tcorr1_d_execute,
        "afni/3dTcorrMap": v_3d_tcorr_map_execute,
        "afni/3dTcorrelate": v_3d_tcorrelate_execute,
        "afni/3dTfilter": v_3d_tfilter_execute,
        "afni/3dTfitter": v_3d_tfitter_execute,
        "afni/3dThreetoRGB": v_3d_threeto_rgb_execute,
        "afni/3dTnorm": v_3d_tnorm_execute,
        "afni/3dToutcount": v_3d_toutcount_execute,
        "afni/3dToyProg": v_3d_toy_prog_execute,
        "afni/3dTproject": v_3d_tproject_execute,
        "afni/3dTqual": v_3d_tqual_execute,
        "afni/3dTrackID": v_3d_track_id_execute,
        "afni/3dTshift": v_3d_tshift_execute,
        "afni/3dTsmooth": v_3d_tsmooth_execute,
        "afni/3dTsort": v_3d_tsort_execute,
        "afni/3dTsplit4D": v_3d_tsplit4_d_execute,
        "afni/3dTstat": v_3d_tstat_execute,
        "afni/3dTto1D": v_3d_tto1_d_execute,
        "afni/3dTwotoComplex": v_3d_twoto_complex_execute,
        "afni/3dUndump": v_3d_undump_execute,
        "afni/3dUnifize": v_3d_unifize_execute,
        "afni/3dUpsample": v_3d_upsample_execute,
        "afni/3dVecRGB_to_HSL": v_3d_vec_rgb_to_hsl_execute,
        "afni/3dVol2Surf": v_3d_vol2_surf_execute,
        "afni/3dWarp": v_3d_warp_execute,
        "afni/3dWarpDrive": v_3d_warp_drive_execute,
        "afni/3dWilcoxon": v_3d_wilcoxon_execute,
        "afni/3dWinsor": v_3d_winsor_execute,
        "afni/3dXClustSim": v_3d_xclust_sim_execute,
        "afni/3dXYZcat": v_3d_xyzcat_execute,
        "afni/3dZcat": v_3d_zcat_execute,
        "afni/3dZcutup": v_3d_zcutup_execute,
        "afni/3dZeropad": v_3d_zeropad_execute,
        "afni/3dZipperZapper": v_3d_zipper_zapper_execute,
        "afni/3dZregrid": v_3d_zregrid_execute,
        "afni/3danisosmooth": v_3danisosmooth_execute,
        "afni/3daxialize": v_3daxialize_execute,
        "afni/3dbucket": v_3dbucket_execute,
        "afni/3dcalc": v_3dcalc_execute,
        "afni/3dclust": v_3dclust_execute,
        "afni/3dcopy": v_3dcopy_execute,
        "afni/3ddelay": v_3ddelay_execute,
        "afni/3ddot": v_3ddot_execute,
        "afni/3ddot_beta": v_3ddot_beta_execute,
        "afni/3dedge3": v_3dedge3_execute,
        "afni/3dedgedog": v_3dedgedog_execute,
        "afni/3dfim+": v_3dfim__execute,
        "afni/3dfractionize": v_3dfractionize_execute,
        "afni/3dhistog": v_3dhistog_execute,
        "afni/3dinfill": v_3dinfill_execute,
        "afni/3dinfo": v_3dinfo_execute,
        "afni/3dkmeans": v_3dkmeans_execute,
        "afni/3dmaskSVD": v_3dmask_svd_execute,
        "afni/3dmask_tool": v_3dmask_tool_execute,
        "afni/3dmaskave": v_3dmaskave_execute,
        "afni/3dmaskdump": v_3dmaskdump_execute,
        "afni/3dmatcalc": v_3dmatcalc_execute,
        "afni/3dmatmult": v_3dmatmult_execute,
        "afni/3dmaxdisp": v_3dmaxdisp_execute,
        "afni/3dmaxima": v_3dmaxima_execute,
        "afni/3dmerge": v_3dmerge_execute,
        "afni/3dnewid": v_3dnewid_execute,
        "afni/3dnvals": v_3dnvals_execute,
        "afni/3dpc": v_3dpc_execute,
        "afni/3drefit": v_3drefit_execute,
        "afni/3drename": v_3drename_execute,
        "afni/3dresample": v_3dresample_execute,
        "afni/3dretroicor": v_3dretroicor_execute,
        "afni/3drotate": v_3drotate_execute,
        "afni/3dsvm": v_3dsvm_execute,
        "afni/3dsvm_linpredict": v_3dsvm_linpredict_execute,
        "afni/3dtoXdataset": v_3dto_xdataset_execute,
        "afni/3dttest++": v_3dttest___execute,
        "afni/3dvolreg": v_3dvolreg_execute,
        "afni/4swap": v_4swap_execute,
        "afni/@1dDiffMag": v__1d_diff_mag_execute,
        "afni/@2dwarper.Allin": v__2dwarper_allin_execute,
        "afni/@2dwarper": v__2dwarper_execute,
        "afni/@4Daverage": v__4_daverage_execute,
        "afni/@ANATICOR": v__anaticor_execute,
        "afni/@AddEdge": v__add_edge_execute,
        "afni/@AfniEnv": v__afni_env_execute,
        "afni/@AfniOrient2RAImap": v__afni_orient2_raimap_execute,
        "afni/@AfniOrientSign": v__afni_orient_sign_execute,
        "afni/@Align_Centers": v__align_centers_execute,
        "afni/@Atlasize": v__atlasize_execute,
        "afni/@Center_Distance": v__center_distance_execute,
        "afni/@CheckForAfniDset": v__check_for_afni_dset_execute,
        "afni/@ClustExp_CatLab": v__clust_exp_cat_lab_execute,
        "afni/@ClustExp_run_shiny": v__clust_exp_run_shiny_execute,
        "afni/@CommandGlobb": v__command_globb_execute,
        "afni/@DO.examples": v__do_examples_execute,
        "afni/@DeblankFileNames": v__deblank_file_names_execute,
        "afni/@DiceMetric": v__dice_metric_execute,
        "afni/@ElectroGrid": v__electro_grid_execute,
        "afni/@ExamineGenFeatDists": v__examine_gen_feat_dists_execute,
        "afni/@FS_roi_label": v__fs_roi_label_execute,
        "afni/@FSlabel2dset": v__fslabel2dset_execute,
        "afni/@FindAfniDsetPath": v__find_afni_dset_path_execute,
        "afni/@FromRAI": v__from_rai_execute,
        "afni/@GetAfniDims": v__get_afni_dims_execute,
        "afni/@GetAfniID": v__get_afni_id_execute,
        "afni/@GetAfniOrient": v__get_afni_orient_execute,
        "afni/@GetAfniPrefix": v__get_afni_prefix_execute,
        "afni/@GetAfniRes": v__get_afni_res_execute,
        "afni/@GetAfniView": v__get_afni_view_execute,
        "afni/@GradFlipTest": v__grad_flip_test_execute,
        "afni/@IsoMasks": v__iso_masks_execute,
        "afni/@MakeLabelTable": v__make_label_table_execute,
        "afni/@NoExt": v__no_ext_execute,
        "afni/@NoPound": v__no_pound_execute,
        "afni/@NoisySkullStrip": v__noisy_skull_strip_execute,
        "afni/@Purify_1D": v__purify_1_d_execute,
        "afni/@Quiet_Talkers": v__quiet_talkers_execute,
        "afni/@ROI_Corr_Mat": v__roi_corr_mat_execute,
        "afni/@ROI_decluster": v__roi_decluster_execute,
        "afni/@ROI_modal_grow": v__roi_modal_grow_execute,
        "afni/@RenamePanga": v__rename_panga_execute,
        "afni/@Reorder": v__reorder_execute,
        "afni/@RetinoProc": v__retino_proc_execute,
        "afni/@SSwarper": v__sswarper_execute,
        "afni/@SUMA_AlignToExperiment": v__suma_align_to_experiment_execute,
        "afni/@SUMA_FSvolToBRIK": v__suma_fsvol_to_brik_execute,
        "afni/@SUMA_Make_Spec_Caret": v__suma_make_spec_caret_execute,
        "afni/@SUMA_Make_Spec_FS": v__suma_make_spec_fs_execute,
        "afni/@SUMA_Make_Spec_SF": v__suma_make_spec_sf_execute,
        "afni/@SUMA_renumber_FS": v__suma_renumber_fs_execute,
        "afni/@ScaleVolume": v__scale_volume_execute,
        "afni/@ScriptCheck": v__script_check_execute,
        "afni/@Shift_Volume": v__shift_volume_execute,
        "afni/@ShowDynamicRange": v__show_dynamic_range_execute,
        "afni/@SkullStrip_TouchUp": v__skull_strip_touch_up_execute,
        "afni/@Spharm.examples": v__spharm_examples_execute,
        "afni/@SurfSmooth.HEAT_07.examples": v__surf_smooth_heat_07_examples_execute,
        "afni/@T1scale": v__t1scale_execute,
        "afni/@TimeDiff": v__time_diff_execute,
        "afni/@ToRAI": v__to_rai_execute,
        "afni/@VolCenter": v__vol_center_execute,
        "afni/@afni.run.me": v__afni_run_me_execute,
        "afni/@afni_R_package_install": v__afni_r_package_install_execute,
        "afni/@afni_refacer_make_master": v__afni_refacer_make_master_execute,
        "afni/@afni_refacer_make_onebigA12": v__afni_refacer_make_onebig_a12_execute,
        "afni/@afni_refacer_run": v__afni_refacer_run_execute,
        "afni/@align_partial_oblique": v__align_partial_oblique_execute,
        "afni/@animal_warper": v__animal_warper_execute,
        "afni/@auto_tlrc": v__auto_tlrc_execute,
        "afni/@build_afni_Xlib": v__build_afni_xlib_execute,
        "afni/@chauffeur_afni": v__chauffeur_afni_execute,
        "afni/@clip_volume": v__clip_volume_execute,
        "afni/@compute_OC_weights": v__compute_oc_weights_execute,
        "afni/@compute_gcor": v__compute_gcor_execute,
        "afni/@demo_prompt": v__demo_prompt_execute,
        "afni/@diff.files": v__diff_files_execute,
        "afni/@diff.tree": v__diff_tree_execute,
        "afni/@djunct_4d_imager": v__djunct_4d_imager_execute,
        "afni/@djunct_4d_slices_to_3d_vol": v__djunct_4d_slices_to_3d_vol_execute,
        "afni/@djunct_anonymize": v__djunct_anonymize_execute,
        "afni/@djunct_dwi_selector.tcsh": v__djunct_dwi_selector_tcsh_execute,
        "afni/@djunct_edgy_align_check": v__djunct_edgy_align_check_execute,
        "afni/@djunct_modal_smoothing_with_rep": v__djunct_modal_smoothing_with_rep_execute,
        "afni/@djunct_montage_coordinator": v__djunct_montage_coordinator_execute,
        "afni/@djunct_overlap_check": v__djunct_overlap_check_execute,
        "afni/@djunct_ssw_intermed_edge_imgs": v__djunct_ssw_intermed_edge_imgs_execute,
        "afni/@extract_meica_ortvec": v__extract_meica_ortvec_execute,
        "afni/@fast_roi": v__fast_roi_execute,
        "afni/@fat_tract_colorize": v__fat_tract_colorize_execute,
        "afni/@fix_FSsphere": v__fix_fssphere_execute,
        "afni/@float_fix": v__float_fix_execute,
        "afni/@get.afni.version": v__get_afni_version_execute,
        "afni/@grayplot": v__grayplot_execute,
        "afni/@help.AFNI": v__help_afni_execute,
        "afni/@isOblique": v__is_oblique_execute,
        "afni/@make_plug_diff": v__make_plug_diff_execute,
        "afni/@measure_bb_thick": v__measure_bb_thick_execute,
        "afni/@measure_erosion_thick": v__measure_erosion_thick_execute,
        "afni/@measure_in2out": v__measure_in2out_execute,
        "afni/@move.to.series.dirs": v__move_to_series_dirs_execute,
        "afni/@np": v__np_execute,
        "afni/@parse_afni_name": v__parse_afni_name_execute,
        "afni/@radial_correlate": v__radial_correlate_execute,
        "afni/@simulate_motion": v__simulate_motion_execute,
        "afni/@snapshot_volreg": v__snapshot_volreg_execute,
        "afni/@statauxcode": v__statauxcode_execute,
        "afni/@suma_acknowledge": v__suma_acknowledge_execute,
        "afni/@suma_reprefixize_spec": v__suma_reprefixize_spec_execute,
        "afni/@surf_to_vol_spackle": v__surf_to_vol_spackle_execute,
        "afni/@thickness_master": v__thickness_master_execute,
        "afni/@toMNI_Awarp": v__to_mni_awarp_execute,
        "afni/@toMNI_Qwarpar": v__to_mni_qwarpar_execute,
        "afni/@update.afni.binaries": v__update_afni_binaries_execute,
        "afni/@xyz_to_ijk": v__xyz_to_ijk_execute,
        "afni/AFNI_Batch_R": afni_batch_r_execute,
        "afni/AnalyzeTrace": analyze_trace_execute,
        "afni/BayesianGroupAna.py": bayesian_group_ana_py_execute,
        "afni/BrainSkin": brain_skin_execute,
        "afni/ClustExp_HistTable.py": clust_exp_hist_table_py_execute,
        "afni/ClustExp_StatParse.py": clust_exp_stat_parse_py_execute,
        "afni/CompareSurfaces": compare_surfaces_execute,
        "afni/ConvertDset": convert_dset_execute,
        "afni/ConvertSurface": convert_surface_execute,
        "afni/ConvexHull": convex_hull_execute,
        "afni/CreateIcosahedron": create_icosahedron_execute,
        "afni/DTIStudioFibertoSegments": dtistudio_fiberto_segments_execute,
        "afni/Dimon": dimon_execute,
        "afni/DriveSuma": drive_suma_execute,
        "afni/ExamineXmat": examine_xmat_execute,
        "afni/FATCAT_matplot": fatcat_matplot_execute,
        "afni/FIRdesign": firdesign_execute,
        "afni/FSread_annot": fsread_annot_execute,
        "afni/GLTsymtest": gltsymtest_execute,
        "afni/IsoSurface": iso_surface_execute,
        "afni/MBA": mba_execute,
        "afni/MakeColorMap": make_color_map_execute,
        "afni/MapIcosahedron": map_icosahedron_execute,
        "afni/PTA": pta_execute,
        "afni/RBA": rba_execute,
        "afni/ROI2dataset": roi2dataset_execute,
        "afni/ROIgrow": roigrow_execute,
        "afni/RSFgen": rsfgen_execute,
        "afni/RetroTS.py": retro_ts_py_execute,
        "afni/SUMA_glxdino": suma_glxdino_execute,
        "afni/SampBias": samp_bias_execute,
        "afni/ScaleToMap": scale_to_map_execute,
        "afni/SpharmDeco": spharm_deco_execute,
        "afni/SpharmReco": spharm_reco_execute,
        "afni/Surf2VolCoord": surf2_vol_coord_execute,
        "afni/SurfClust": surf_clust_execute,
        "afni/SurfDist": surf_dist_execute,
        "afni/SurfDsetInfo": surf_dset_info_execute,
        "afni/SurfExtrema": surf_extrema_execute,
        "afni/SurfFWHM": surf_fwhm_execute,
        "afni/SurfInfo": surf_info_execute,
        "afni/SurfLayers": surf_layers_execute,
        "afni/SurfLocalstat": surf_localstat_execute,
        "afni/SurfMeasures": surf_measures_execute,
        "afni/SurfMesh": surf_mesh_execute,
        "afni/SurfPatch": surf_patch_execute,
        "afni/SurfQual": surf_qual_execute,
        "afni/SurfRetinoMap": surf_retino_map_execute,
        "afni/SurfSmooth": surf_smooth_execute,
        "afni/SurfToSurf": surf_to_surf_execute,
        "afni/SurfaceMetrics": surface_metrics_execute,
        "afni/TRR": trr_execute,
        "afni/Vecwarp": vecwarp_execute,
        "afni/abids_json_info.py": abids_json_info_py_execute,
        "afni/abids_json_tool.py": abids_json_tool_py_execute,
        "afni/abids_tool.py": abids_tool_py_execute,
        "afni/adjunct_apqc_tsnr_general": adjunct_apqc_tsnr_general_execute,
        "afni/adjunct_aw_tableize_roi_info.py": adjunct_aw_tableize_roi_info_py_execute,
        "afni/adjunct_calc_mont_dims.py": adjunct_calc_mont_dims_py_execute,
        "afni/adjunct_combine_str.py": adjunct_combine_str_py_execute,
        "afni/adjunct_is_label.py": adjunct_is_label_py_execute,
        "afni/adjunct_make_script_and_rst.py": adjunct_make_script_and_rst_py_execute,
        "afni/adjunct_select_str.py": adjunct_select_str_py_execute,
        "afni/adjunct_simplify_cost.py": adjunct_simplify_cost_py_execute,
        "afni/adjunct_suma_fs_mask_and_qc": adjunct_suma_fs_mask_and_qc_execute,
        "afni/adjunct_suma_fs_roi_info": adjunct_suma_fs_roi_info_execute,
        "afni/adjunct_tort_plot_dp_align": adjunct_tort_plot_dp_align_execute,
        "afni/adwarp": adwarp_execute,
        "afni/afni": afni_execute,
        "afni/afni_check_omp": afni_check_omp_execute,
        "afni/afni_history": afni_history_execute,
        "afni/afni_open": afni_open_execute,
        "afni/afni_proc.py": afni_proc_py_execute,
        "afni/afni_run_R": afni_run_r_execute,
        "afni/afni_system_check.py": afni_system_check_py_execute,
        "afni/aiv": aiv_execute,
        "afni/align_epi_anat.py": align_epi_anat_py_execute,
        "afni/ap_run_simple_rest.tcsh": ap_run_simple_rest_tcsh_execute,
        "afni/apqc_make_html.py": apqc_make_html_py_execute,
        "afni/apqc_make_tcsh.py": apqc_make_tcsh_py_execute,
        "afni/apsearch": apsearch_execute,
        "afni/auto_warp.py": auto_warp_py_execute,
        "afni/balloon": balloon_execute,
        "afni/bayes_view": bayes_view_execute,
        "afni/build_afni.py": build_afni_py_execute,
        "afni/cat_matvec": cat_matvec_execute,
        "afni/ccalc": ccalc_execute,
        "afni/cifti_tool": cifti_tool_execute,
        "afni/cjpeg": cjpeg_execute,
        "afni/column_cat": column_cat_execute,
        "afni/convert_cdiflist_to_grads.py": convert_cdiflist_to_grads_py_execute,
        "afni/count": count_execute,
        "afni/dcm2niix_afni": dcm2niix_afni_execute,
        "afni/dicom_hdr": dicom_hdr_execute,
        "afni/dicom_hinfo": dicom_hinfo_execute,
        "afni/dicom_to_raw": dicom_to_raw_execute,
        "afni/djpeg": djpeg_execute,
        "afni/dsetstat2p": dsetstat2p_execute,
        "afni/epi_b0_correct.py": epi_b0_correct_py_execute,
        "afni/fat_mat2d_plot.py": fat_mat2d_plot_py_execute,
        "afni/fat_mat_sel.py": fat_mat_sel_py_execute,
        "afni/fat_mat_tableize.py": fat_mat_tableize_py_execute,
        "afni/fat_mvm_gridconv.py": fat_mvm_gridconv_py_execute,
        "afni/fat_mvm_prep.py": fat_mvm_prep_py_execute,
        "afni/fat_mvm_scripter.py": fat_mvm_scripter_py_execute,
        "afni/fat_proc_align_anat_pair": fat_proc_align_anat_pair_execute,
        "afni/fat_proc_axialize_anat": fat_proc_axialize_anat_execute,
        "afni/fat_proc_connec_vis": fat_proc_connec_vis_execute,
        "afni/fat_proc_convert_dcm_anat": fat_proc_convert_dcm_anat_execute,
        "afni/fat_proc_convert_dcm_dwis": fat_proc_convert_dcm_dwis_execute,
        "afni/fat_proc_decmap": fat_proc_decmap_execute,
        "afni/fat_proc_dwi_to_dt": fat_proc_dwi_to_dt_execute,
        "afni/fat_proc_filter_dwis": fat_proc_filter_dwis_execute,
        "afni/fat_proc_imit2w_from_t1w": fat_proc_imit2w_from_t1w_execute,
        "afni/fat_proc_map_to_dti": fat_proc_map_to_dti_execute,
        "afni/fat_proc_select_vols": fat_proc_select_vols_execute,
        "afni/fat_roi_row.py": fat_roi_row_py_execute,
        "afni/fdrval": fdrval_execute,
        "afni/fftest": fftest_execute,
        "afni/file_tool": file_tool_execute,
        "afni/fim2": fim2_execute,
        "afni/find_variance_lines.tcsh": find_variance_lines_tcsh_execute,
        "afni/float_scan": float_scan_execute,
        "afni/from3d": from3d_execute,
        "afni/gen_epi_review.py": gen_epi_review_py_execute,
        "afni/gen_group_command.py": gen_group_command_py_execute,
        "afni/gen_ss_review_scripts.py": gen_ss_review_scripts_py_execute,
        "afni/gen_ss_review_table.py": gen_ss_review_table_py_execute,
        "afni/get_afni_model_PRF": get_afni_model_prf_execute,
        "afni/get_afni_model_PRF_6": get_afni_model_prf_6_execute,
        "afni/get_afni_model_PRF_6_BAD": get_afni_model_prf_6_bad_execute,
        "afni/gifti_tool": gifti_tool_execute,
        "afni/help_format": help_format_execute,
        "afni/im2niml": im2niml_execute,
        "afni/images_equal": images_equal_execute,
        "afni/imand": imand_execute,
        "afni/imaver": imaver_execute,
        "afni/imcalc": imcalc_execute,
        "afni/imcat": imcat_execute,
        "afni/imcutup": imcutup_execute,
        "afni/imdump": imdump_execute,
        "afni/immask": immask_execute,
        "afni/imreg": imreg_execute,
        "afni/imrotate": imrotate_execute,
        "afni/imstack": imstack_execute,
        "afni/imstat": imstat_execute,
        "afni/imupsam": imupsam_execute,
        "afni/init_user_dotfiles.py": init_user_dotfiles_py_execute,
        "afni/inspec": inspec_execute,
        "afni/make_pq_script.py": make_pq_script_py_execute,
        "afni/make_random_timing.py": make_random_timing_py_execute,
        "afni/make_stim_times.py": make_stim_times_py_execute,
        "afni/map_TrackID": map_track_id_execute,
        "afni/meica.py": meica_py_execute,
        "afni/myget": myget_execute,
        "afni/neuro_deconvolve.py": neuro_deconvolve_py_execute,
        "afni/nicat": nicat_execute,
        "afni/niccc": niccc_execute,
        "afni/nifti_tool": nifti_tool_execute,
        "afni/niml_feedme": niml_feedme_execute,
        "afni/nsize": nsize_execute,
        "afni/p2dsetstat": p2dsetstat_execute,
        "afni/parse_fs_lt_log.py": parse_fs_lt_log_py_execute,
        "afni/plugout_drive": plugout_drive_execute,
        "afni/plugout_ijk": plugout_ijk_execute,
        "afni/plugout_tt": plugout_tt_execute,
        "afni/plugout_tta": plugout_tta_execute,
        "afni/prompt_popup": prompt_popup_execute,
        "afni/prompt_user": prompt_user_execute,
        "afni/qdelaunay": qdelaunay_execute,
        "afni/qhull": qhull_execute,
        "afni/quick.alpha.vals.py": quick_alpha_vals_py_execute,
        "afni/quickspec": quickspec_execute,
        "afni/quickspecSL": quickspec_sl_execute,
        "afni/quotize": quotize_execute,
        "afni/rPkgsInstall": r_pkgs_install_execute,
        "afni/rbox": rbox_execute,
        "afni/read_matlab_files.py": read_matlab_files_py_execute,
        "afni/realtime_receiver.py": realtime_receiver_py_execute,
        "afni/rmz": rmz_execute,
        "afni/rotcom": rotcom_execute,
        "afni/rtfeedme": rtfeedme_execute,
        "afni/serial_helper": serial_helper_execute,
        "afni/sfim": sfim_execute,
        "afni/slow_surf_clustsim.py": slow_surf_clustsim_py_execute,
        "afni/stimband": stimband_execute,
        "afni/strblast": strblast_execute,
        "afni/suma_change_spec": suma_change_spec_execute,
        "afni/tedana_wrapper.py": tedana_wrapper_py_execute,
        "afni/tfim": tfim_execute,
        "afni/timing_tool.py": timing_tool_py_execute,
        "afni/to3d": to3d_execute,
        "afni/tokens": tokens_execute,
        "afni/uber_align_test.py": uber_align_test_py_execute,
        "afni/uber_proc.py": uber_proc_py_execute,
        "afni/uber_skel.py": uber_skel_py_execute,
        "afni/uber_subject.py": uber_subject_py_execute,
        "afni/unWarpEPI.py": un_warp_epi_py_execute,
        "afni/uniq_images": uniq_images_execute,
        "afni/waver": waver_execute,
        "afni/whirlgif": whirlgif_execute,
        "afni/xmat_tool.py": xmat_tool_py_execute,
    }[params["@type"]](params, runner)
