# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

ABIDS_JSON_INFO_PY_METADATA = Metadata(
    id="cdac5506c8cbb0e985bd9b452999658837f91d6a.boutiques",
    name="abids_json_info.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


AbidsJsonInfoPyParameters = typing.TypedDict('AbidsJsonInfoPyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/abids_json_info.py"]],
    "json_files": list[InputPathType],
    "tr_flag": bool,
    "te_flag": bool,
    "te_sec_flag": bool,
    "match_nii_flag": bool,
    "field_list": typing.NotRequired[list[str] | None],
    "list_fields_flag": bool,
    "help_flag": bool,
})
AbidsJsonInfoPyParametersTagged = typing.TypedDict('AbidsJsonInfoPyParametersTagged', {
    "@type": typing.Literal["afni/abids_json_info.py"],
    "json_files": list[InputPathType],
    "tr_flag": bool,
    "te_flag": bool,
    "te_sec_flag": bool,
    "match_nii_flag": bool,
    "field_list": typing.NotRequired[list[str] | None],
    "list_fields_flag": bool,
    "help_flag": bool,
})


class AbidsJsonInfoPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `AbidsJsonInfoPyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def abids_json_info_py_params(
    json_files: list[InputPathType],
    tr_flag: bool = False,
    te_flag: bool = False,
    te_sec_flag: bool = False,
    match_nii_flag: bool = False,
    field_list: list[str] | None = None,
    list_fields_flag: bool = False,
    help_flag: bool = False,
) -> AbidsJsonInfoPyParametersTagged:
    """
    Build parameters.
    
    Args:
        json_files: Specify .json file(s).
        tr_flag: Print the TR from the json file in seconds, from the\
            'RepetitionTime' field.
        te_flag: Print out the 'EchoTime' field in milliseconds (the json file\
            stores it in seconds).
        te_sec_flag: Print the 'EchoTime' field in seconds.
        match_nii_flag: Check if there is a .nii or .nii.gz file that matches\
            the .json file (1 if the dataset is loadable).
        field_list: Print any field or list of fields from the json file.
        list_fields_flag: Print a list of the available fields from the .json\
            file. This must be the only argument specified.
        help_flag: Show this help message and exit.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/abids_json_info.py",
        "json_files": json_files,
        "tr_flag": tr_flag,
        "te_flag": te_flag,
        "te_sec_flag": te_sec_flag,
        "match_nii_flag": match_nii_flag,
        "list_fields_flag": list_fields_flag,
        "help_flag": help_flag,
    }
    if field_list is not None:
        params["field_list"] = field_list
    return params


def abids_json_info_py_cargs(
    params: AbidsJsonInfoPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("abids_json_info.py")
    cargs.extend([execution.input_file(f) for f in params.get("json_files", None)])
    if params.get("tr_flag", False):
        cargs.append("-TR")
    if params.get("te_flag", False):
        cargs.append("-TE")
    if params.get("te_sec_flag", False):
        cargs.append("-TE_sec")
    if params.get("match_nii_flag", False):
        cargs.append("-match_nii")
    if params.get("field_list", None) is not None:
        cargs.extend([
            "-field",
            *params.get("field_list", None)
        ])
    if params.get("list_fields_flag", False):
        cargs.append("-list_fields")
    if params.get("help_flag", False):
        cargs.append("-help")
    return cargs


def abids_json_info_py_outputs(
    params: AbidsJsonInfoPyParameters,
    execution: Execution,
) -> AbidsJsonInfoPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = AbidsJsonInfoPyOutputs(
        root=execution.output_file("."),
    )
    return ret


def abids_json_info_py_execute(
    params: AbidsJsonInfoPyParameters,
    runner: Runner | None = None,
) -> AbidsJsonInfoPyOutputs:
    """
    abids_json_info.py
    
    A tool to extract information from BIDS formatted json files.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `AbidsJsonInfoPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(ABIDS_JSON_INFO_PY_METADATA)
    params = execution.params(params)
    cargs = abids_json_info_py_cargs(params, execution)
    ret = abids_json_info_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def abids_json_info_py(
    json_files: list[InputPathType],
    tr_flag: bool = False,
    te_flag: bool = False,
    te_sec_flag: bool = False,
    match_nii_flag: bool = False,
    field_list: list[str] | None = None,
    list_fields_flag: bool = False,
    help_flag: bool = False,
    runner: Runner | None = None,
) -> AbidsJsonInfoPyOutputs:
    """
    abids_json_info.py
    
    A tool to extract information from BIDS formatted json files.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        json_files: Specify .json file(s).
        tr_flag: Print the TR from the json file in seconds, from the\
            'RepetitionTime' field.
        te_flag: Print out the 'EchoTime' field in milliseconds (the json file\
            stores it in seconds).
        te_sec_flag: Print the 'EchoTime' field in seconds.
        match_nii_flag: Check if there is a .nii or .nii.gz file that matches\
            the .json file (1 if the dataset is loadable).
        field_list: Print any field or list of fields from the json file.
        list_fields_flag: Print a list of the available fields from the .json\
            file. This must be the only argument specified.
        help_flag: Show this help message and exit.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `AbidsJsonInfoPyOutputs`).
    """
    params = abids_json_info_py_params(
        json_files=json_files,
        tr_flag=tr_flag,
        te_flag=te_flag,
        te_sec_flag=te_sec_flag,
        match_nii_flag=match_nii_flag,
        field_list=field_list,
        list_fields_flag=list_fields_flag,
        help_flag=help_flag,
    )
    return abids_json_info_py_execute(params, runner)


__all__ = [
    "ABIDS_JSON_INFO_PY_METADATA",
    "AbidsJsonInfoPyOutputs",
    "abids_json_info_py",
    "abids_json_info_py_execute",
    "abids_json_info_py_params",
]
