# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

ABIDS_TOOL_PY_METADATA = Metadata(
    id="0cec3da978793786b74a6ef0ab3a3f167672d68f.boutiques",
    name="abids_tool.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


AbidsToolPyParameters = typing.TypedDict('AbidsToolPyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/abids_tool.py"]],
    "input_files": list[InputPathType],
    "tr_match": bool,
    "add_tr": bool,
    "add_slice_times": bool,
    "copy_prefix": typing.NotRequired[list[str] | None],
    "help_flag": bool,
})
AbidsToolPyParametersTagged = typing.TypedDict('AbidsToolPyParametersTagged', {
    "@type": typing.Literal["afni/abids_tool.py"],
    "input_files": list[InputPathType],
    "tr_match": bool,
    "add_tr": bool,
    "add_slice_times": bool,
    "copy_prefix": typing.NotRequired[list[str] | None],
    "help_flag": bool,
})


class AbidsToolPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `AbidsToolPyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def abids_tool_py_params(
    input_files: list[InputPathType],
    tr_match: bool = False,
    add_tr: bool = False,
    add_slice_times: bool = False,
    copy_prefix: list[str] | None = None,
    help_flag: bool = False,
) -> AbidsToolPyParametersTagged:
    """
    Build parameters.
    
    Args:
        input_files: At least one 3d+time dataset in NIFTI format.
        tr_match: Check if the TR in the json file matches the TR from input\
            dataset header. (Returns 1 if match).
        add_tr: Add the TR from the BIDS json file to the input dataset using\
            3drefit.
        add_slice_times: Add the slice times from the BIDS json file to the\
            input dataset using 3drefit.
        copy_prefix: Copy both the NIFTI dataset(s) and matching .json file(s)\
            to PREFIX. Must have the same number of prefixes as datasets.
        help_flag: Show help information and exit.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/abids_tool.py",
        "input_files": input_files,
        "tr_match": tr_match,
        "add_tr": add_tr,
        "add_slice_times": add_slice_times,
        "help_flag": help_flag,
    }
    if copy_prefix is not None:
        params["copy_prefix"] = copy_prefix
    return params


def abids_tool_py_cargs(
    params: AbidsToolPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("abids_tool.py")
    cargs.extend([execution.input_file(f) for f in params.get("input_files", None)])
    if params.get("tr_match", False):
        cargs.append("-TR_match")
    if params.get("add_tr", False):
        cargs.append("-add_TR")
    if params.get("add_slice_times", False):
        cargs.append("-add_slice_times")
    if params.get("copy_prefix", None) is not None:
        cargs.extend([
            "-copy",
            *params.get("copy_prefix", None)
        ])
    if params.get("help_flag", False):
        cargs.append("-help")
    return cargs


def abids_tool_py_outputs(
    params: AbidsToolPyParameters,
    execution: Execution,
) -> AbidsToolPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = AbidsToolPyOutputs(
        root=execution.output_file("."),
    )
    return ret


def abids_tool_py_execute(
    params: AbidsToolPyParameters,
    runner: Runner | None = None,
) -> AbidsToolPyOutputs:
    """
    abids_tool.py
    
    A tool to work with BIDS formatted datasets created with dcm2niix_afni or
    dcm2niix, mainly to pull information from the matching JSON file and refit
    the input dataset using 3drefit.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `AbidsToolPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(ABIDS_TOOL_PY_METADATA)
    params = execution.params(params)
    cargs = abids_tool_py_cargs(params, execution)
    ret = abids_tool_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def abids_tool_py(
    input_files: list[InputPathType],
    tr_match: bool = False,
    add_tr: bool = False,
    add_slice_times: bool = False,
    copy_prefix: list[str] | None = None,
    help_flag: bool = False,
    runner: Runner | None = None,
) -> AbidsToolPyOutputs:
    """
    abids_tool.py
    
    A tool to work with BIDS formatted datasets created with dcm2niix_afni or
    dcm2niix, mainly to pull information from the matching JSON file and refit
    the input dataset using 3drefit.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_files: At least one 3d+time dataset in NIFTI format.
        tr_match: Check if the TR in the json file matches the TR from input\
            dataset header. (Returns 1 if match).
        add_tr: Add the TR from the BIDS json file to the input dataset using\
            3drefit.
        add_slice_times: Add the slice times from the BIDS json file to the\
            input dataset using 3drefit.
        copy_prefix: Copy both the NIFTI dataset(s) and matching .json file(s)\
            to PREFIX. Must have the same number of prefixes as datasets.
        help_flag: Show help information and exit.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `AbidsToolPyOutputs`).
    """
    params = abids_tool_py_params(
        input_files=input_files,
        tr_match=tr_match,
        add_tr=add_tr,
        add_slice_times=add_slice_times,
        copy_prefix=copy_prefix,
        help_flag=help_flag,
    )
    return abids_tool_py_execute(params, runner)


__all__ = [
    "ABIDS_TOOL_PY_METADATA",
    "AbidsToolPyOutputs",
    "abids_tool_py",
    "abids_tool_py_execute",
    "abids_tool_py_params",
]
