# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

ADJUNCT_APQC_TSNR_GENERAL_METADATA = Metadata(
    id="d0e88b706d5959e353f1480626f5f268697b57dd.boutiques",
    name="adjunct_apqc_tsnr_general",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


AdjunctApqcTsnrGeneralParameters = typing.TypedDict('AdjunctApqcTsnrGeneralParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/adjunct_apqc_tsnr_general"]],
    "montgap": typing.NotRequired[str | None],
    "montcolor": typing.NotRequired[str | None],
    "montx": typing.NotRequired[str | None],
    "monty": typing.NotRequired[str | None],
    "opacity": typing.NotRequired[str | None],
    "blowup": typing.NotRequired[str | None],
    "save_ftype": typing.NotRequired[str | None],
    "set_dicom_xyz": typing.NotRequired[list[str] | None],
    "set_ijk": typing.NotRequired[list[str] | None],
    "set_subbricks": typing.NotRequired[list[str] | None],
    "olay_alpha": typing.NotRequired[str | None],
    "olay_boxed": typing.NotRequired[str | None],
    "thr_olay": typing.NotRequired[str | None],
    "ulay_range_nz": typing.NotRequired[list[str] | None],
    "ulay_range": typing.NotRequired[list[str] | None],
    "delta_slices": typing.NotRequired[list[str] | None],
    "olay_disc_hot_range": typing.NotRequired[list[str] | None],
    "olay_cont_max": typing.NotRequired[str | None],
    "cbar_cont": typing.NotRequired[str | None],
    "no_cor": bool,
    "no_sag": bool,
    "no_axi": bool,
    "echo": bool,
})
AdjunctApqcTsnrGeneralParametersTagged = typing.TypedDict('AdjunctApqcTsnrGeneralParametersTagged', {
    "@type": typing.Literal["afni/adjunct_apqc_tsnr_general"],
    "montgap": typing.NotRequired[str | None],
    "montcolor": typing.NotRequired[str | None],
    "montx": typing.NotRequired[str | None],
    "monty": typing.NotRequired[str | None],
    "opacity": typing.NotRequired[str | None],
    "blowup": typing.NotRequired[str | None],
    "save_ftype": typing.NotRequired[str | None],
    "set_dicom_xyz": typing.NotRequired[list[str] | None],
    "set_ijk": typing.NotRequired[list[str] | None],
    "set_subbricks": typing.NotRequired[list[str] | None],
    "olay_alpha": typing.NotRequired[str | None],
    "olay_boxed": typing.NotRequired[str | None],
    "thr_olay": typing.NotRequired[str | None],
    "ulay_range_nz": typing.NotRequired[list[str] | None],
    "ulay_range": typing.NotRequired[list[str] | None],
    "delta_slices": typing.NotRequired[list[str] | None],
    "olay_disc_hot_range": typing.NotRequired[list[str] | None],
    "olay_cont_max": typing.NotRequired[str | None],
    "cbar_cont": typing.NotRequired[str | None],
    "no_cor": bool,
    "no_sag": bool,
    "no_axi": bool,
    "echo": bool,
})


class AdjunctApqcTsnrGeneralOutputs(typing.NamedTuple):
    """
    Output object returned when calling `AdjunctApqcTsnrGeneralParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def adjunct_apqc_tsnr_general_params(
    montgap: str | None = None,
    montcolor: str | None = None,
    montx: str | None = None,
    monty: str | None = None,
    opacity: str | None = None,
    blowup: str | None = None,
    save_ftype: str | None = None,
    set_dicom_xyz: list[str] | None = None,
    set_ijk: list[str] | None = None,
    set_subbricks: list[str] | None = None,
    olay_alpha: str | None = None,
    olay_boxed: str | None = None,
    thr_olay: str | None = None,
    ulay_range_nz: list[str] | None = None,
    ulay_range: list[str] | None = None,
    delta_slices: list[str] | None = None,
    olay_disc_hot_range: list[str] | None = None,
    olay_cont_max: str | None = None,
    cbar_cont: str | None = None,
    no_cor: bool = False,
    no_sag: bool = False,
    no_axi: bool = False,
    echo: bool = False,
) -> AdjunctApqcTsnrGeneralParametersTagged:
    """
    Build parameters.
    
    Args:
        montgap: Specify montage gap.
        montcolor: Specify montage color.
        montx: Specify montage x coordinate.
        monty: Specify montage y coordinate.
        opacity: Specify overlay opacity.
        blowup: Specify blowup factor.
        save_ftype: Specify save file type.
        set_dicom_xyz: Set DICOM x, y, z coordinates.
        set_ijk: Set IJK coordinates.
        set_subbricks: Set sub-bricks.
        olay_alpha: Specify overlay alpha.
        olay_boxed: Specify boxed overlay.
        thr_olay: Specify threshold for overlay.
        ulay_range_nz: Specify non-zero range for underlay.
        ulay_range: Specify range for underlay.
        delta_slices: Specify delta slices.
        olay_disc_hot_range: Specify discrete hot range for overlay.
        olay_cont_max: Specify continuous max for overlay.
        cbar_cont: Specify continuous color bar.
        no_cor: No coronal view.
        no_sag: No sagittal view.
        no_axi: No axial view.
        echo: Echo the command line arguments.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/adjunct_apqc_tsnr_general",
        "no_cor": no_cor,
        "no_sag": no_sag,
        "no_axi": no_axi,
        "echo": echo,
    }
    if montgap is not None:
        params["montgap"] = montgap
    if montcolor is not None:
        params["montcolor"] = montcolor
    if montx is not None:
        params["montx"] = montx
    if monty is not None:
        params["monty"] = monty
    if opacity is not None:
        params["opacity"] = opacity
    if blowup is not None:
        params["blowup"] = blowup
    if save_ftype is not None:
        params["save_ftype"] = save_ftype
    if set_dicom_xyz is not None:
        params["set_dicom_xyz"] = set_dicom_xyz
    if set_ijk is not None:
        params["set_ijk"] = set_ijk
    if set_subbricks is not None:
        params["set_subbricks"] = set_subbricks
    if olay_alpha is not None:
        params["olay_alpha"] = olay_alpha
    if olay_boxed is not None:
        params["olay_boxed"] = olay_boxed
    if thr_olay is not None:
        params["thr_olay"] = thr_olay
    if ulay_range_nz is not None:
        params["ulay_range_nz"] = ulay_range_nz
    if ulay_range is not None:
        params["ulay_range"] = ulay_range
    if delta_slices is not None:
        params["delta_slices"] = delta_slices
    if olay_disc_hot_range is not None:
        params["olay_disc_hot_range"] = olay_disc_hot_range
    if olay_cont_max is not None:
        params["olay_cont_max"] = olay_cont_max
    if cbar_cont is not None:
        params["cbar_cont"] = cbar_cont
    return params


def adjunct_apqc_tsnr_general_cargs(
    params: AdjunctApqcTsnrGeneralParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("adjunct_apqc_tsnr_general")
    if params.get("montgap", None) is not None:
        cargs.extend([
            "-montgap",
            params.get("montgap", None)
        ])
    if params.get("montcolor", None) is not None:
        cargs.extend([
            "-montcolor",
            params.get("montcolor", None)
        ])
    if params.get("montx", None) is not None:
        cargs.extend([
            "-montx",
            params.get("montx", None)
        ])
    if params.get("monty", None) is not None:
        cargs.extend([
            "-monty",
            params.get("monty", None)
        ])
    if params.get("opacity", None) is not None:
        cargs.extend([
            "-opacity",
            params.get("opacity", None)
        ])
    if params.get("blowup", None) is not None:
        cargs.extend([
            "-blowup",
            params.get("blowup", None)
        ])
    if params.get("save_ftype", None) is not None:
        cargs.extend([
            "-save_ftype",
            params.get("save_ftype", None)
        ])
    if params.get("set_dicom_xyz", None) is not None:
        cargs.extend([
            "-set_dicom_xyz",
            *params.get("set_dicom_xyz", None)
        ])
    if params.get("set_ijk", None) is not None:
        cargs.extend([
            "-set_ijk",
            *params.get("set_ijk", None)
        ])
    if params.get("set_subbricks", None) is not None:
        cargs.extend([
            "-set_subbricks",
            *params.get("set_subbricks", None)
        ])
    if params.get("olay_alpha", None) is not None:
        cargs.extend([
            "-olay_alpha",
            params.get("olay_alpha", None)
        ])
    if params.get("olay_boxed", None) is not None:
        cargs.extend([
            "-olay_boxed",
            params.get("olay_boxed", None)
        ])
    if params.get("thr_olay", None) is not None:
        cargs.extend([
            "-thr_olay",
            params.get("thr_olay", None)
        ])
    if params.get("ulay_range_nz", None) is not None:
        cargs.extend([
            "-ulay_range_nz",
            *params.get("ulay_range_nz", None)
        ])
    if params.get("ulay_range", None) is not None:
        cargs.extend([
            "-ulay_range",
            *params.get("ulay_range", None)
        ])
    if params.get("delta_slices", None) is not None:
        cargs.extend([
            "-delta_slices",
            *params.get("delta_slices", None)
        ])
    if params.get("olay_disc_hot_range", None) is not None:
        cargs.extend([
            "-olay_disc_hot_range",
            *params.get("olay_disc_hot_range", None)
        ])
    if params.get("olay_cont_max", None) is not None:
        cargs.extend([
            "-olay_cont_max",
            params.get("olay_cont_max", None)
        ])
    if params.get("cbar_cont", None) is not None:
        cargs.extend([
            "-cbar_cont",
            params.get("cbar_cont", None)
        ])
    if params.get("no_cor", False):
        cargs.append("-no_cor")
    if params.get("no_sag", False):
        cargs.append("-no_sag")
    if params.get("no_axi", False):
        cargs.append("-no_axi")
    if params.get("echo", False):
        cargs.append("-echo")
    return cargs


def adjunct_apqc_tsnr_general_outputs(
    params: AdjunctApqcTsnrGeneralParameters,
    execution: Execution,
) -> AdjunctApqcTsnrGeneralOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = AdjunctApqcTsnrGeneralOutputs(
        root=execution.output_file("."),
    )
    return ret


def adjunct_apqc_tsnr_general_execute(
    params: AdjunctApqcTsnrGeneralParameters,
    runner: Runner | None = None,
) -> AdjunctApqcTsnrGeneralOutputs:
    """
    adjunct_apqc_tsnr_general
    
    An adjunct program for making TSNR plots for APQC.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `AdjunctApqcTsnrGeneralOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(ADJUNCT_APQC_TSNR_GENERAL_METADATA)
    params = execution.params(params)
    cargs = adjunct_apqc_tsnr_general_cargs(params, execution)
    ret = adjunct_apqc_tsnr_general_outputs(params, execution)
    execution.run(cargs)
    return ret


def adjunct_apqc_tsnr_general(
    montgap: str | None = None,
    montcolor: str | None = None,
    montx: str | None = None,
    monty: str | None = None,
    opacity: str | None = None,
    blowup: str | None = None,
    save_ftype: str | None = None,
    set_dicom_xyz: list[str] | None = None,
    set_ijk: list[str] | None = None,
    set_subbricks: list[str] | None = None,
    olay_alpha: str | None = None,
    olay_boxed: str | None = None,
    thr_olay: str | None = None,
    ulay_range_nz: list[str] | None = None,
    ulay_range: list[str] | None = None,
    delta_slices: list[str] | None = None,
    olay_disc_hot_range: list[str] | None = None,
    olay_cont_max: str | None = None,
    cbar_cont: str | None = None,
    no_cor: bool = False,
    no_sag: bool = False,
    no_axi: bool = False,
    echo: bool = False,
    runner: Runner | None = None,
) -> AdjunctApqcTsnrGeneralOutputs:
    """
    adjunct_apqc_tsnr_general
    
    An adjunct program for making TSNR plots for APQC.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        montgap: Specify montage gap.
        montcolor: Specify montage color.
        montx: Specify montage x coordinate.
        monty: Specify montage y coordinate.
        opacity: Specify overlay opacity.
        blowup: Specify blowup factor.
        save_ftype: Specify save file type.
        set_dicom_xyz: Set DICOM x, y, z coordinates.
        set_ijk: Set IJK coordinates.
        set_subbricks: Set sub-bricks.
        olay_alpha: Specify overlay alpha.
        olay_boxed: Specify boxed overlay.
        thr_olay: Specify threshold for overlay.
        ulay_range_nz: Specify non-zero range for underlay.
        ulay_range: Specify range for underlay.
        delta_slices: Specify delta slices.
        olay_disc_hot_range: Specify discrete hot range for overlay.
        olay_cont_max: Specify continuous max for overlay.
        cbar_cont: Specify continuous color bar.
        no_cor: No coronal view.
        no_sag: No sagittal view.
        no_axi: No axial view.
        echo: Echo the command line arguments.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `AdjunctApqcTsnrGeneralOutputs`).
    """
    params = adjunct_apqc_tsnr_general_params(
        montgap=montgap,
        montcolor=montcolor,
        montx=montx,
        monty=monty,
        opacity=opacity,
        blowup=blowup,
        save_ftype=save_ftype,
        set_dicom_xyz=set_dicom_xyz,
        set_ijk=set_ijk,
        set_subbricks=set_subbricks,
        olay_alpha=olay_alpha,
        olay_boxed=olay_boxed,
        thr_olay=thr_olay,
        ulay_range_nz=ulay_range_nz,
        ulay_range=ulay_range,
        delta_slices=delta_slices,
        olay_disc_hot_range=olay_disc_hot_range,
        olay_cont_max=olay_cont_max,
        cbar_cont=cbar_cont,
        no_cor=no_cor,
        no_sag=no_sag,
        no_axi=no_axi,
        echo=echo,
    )
    return adjunct_apqc_tsnr_general_execute(params, runner)


__all__ = [
    "ADJUNCT_APQC_TSNR_GENERAL_METADATA",
    "AdjunctApqcTsnrGeneralOutputs",
    "adjunct_apqc_tsnr_general",
    "adjunct_apqc_tsnr_general_execute",
    "adjunct_apqc_tsnr_general_params",
]
