# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

ADJUNCT_IS_LABEL_PY_METADATA = Metadata(
    id="d2235f4fdb54ec6b5f9ee49cb86db0943973aad4.boutiques",
    name="adjunct_is_label.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


AdjunctIsLabelPyParameters = typing.TypedDict('AdjunctIsLabelPyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/adjunct_is_label.py"]],
    "infile": InputPathType,
    "label": str,
})
AdjunctIsLabelPyParametersTagged = typing.TypedDict('AdjunctIsLabelPyParametersTagged', {
    "@type": typing.Literal["afni/adjunct_is_label.py"],
    "infile": InputPathType,
    "label": str,
})


class AdjunctIsLabelPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `AdjunctIsLabelPyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def adjunct_is_label_py_params(
    infile: InputPathType,
    label: str,
) -> AdjunctIsLabelPyParametersTagged:
    """
    Build parameters.
    
    Args:
        infile: Input file for the adjunct_is_label script.
        label: Output label generated by the script.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/adjunct_is_label.py",
        "infile": infile,
        "label": label,
    }
    return params


def adjunct_is_label_py_cargs(
    params: AdjunctIsLabelPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("adjunct_is_label.py")
    cargs.append(execution.input_file(params.get("infile", None)))
    cargs.append(params.get("label", None))
    return cargs


def adjunct_is_label_py_outputs(
    params: AdjunctIsLabelPyParameters,
    execution: Execution,
) -> AdjunctIsLabelPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = AdjunctIsLabelPyOutputs(
        root=execution.output_file("."),
    )
    return ret


def adjunct_is_label_py_execute(
    params: AdjunctIsLabelPyParameters,
    runner: Runner | None = None,
) -> AdjunctIsLabelPyOutputs:
    """
    adjunct_is_label.py
    
    A subsidiary script of the chauffeur_afni suite for label functionalities.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `AdjunctIsLabelPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(ADJUNCT_IS_LABEL_PY_METADATA)
    params = execution.params(params)
    cargs = adjunct_is_label_py_cargs(params, execution)
    ret = adjunct_is_label_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def adjunct_is_label_py(
    infile: InputPathType,
    label: str,
    runner: Runner | None = None,
) -> AdjunctIsLabelPyOutputs:
    """
    adjunct_is_label.py
    
    A subsidiary script of the chauffeur_afni suite for label functionalities.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        infile: Input file for the adjunct_is_label script.
        label: Output label generated by the script.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `AdjunctIsLabelPyOutputs`).
    """
    params = adjunct_is_label_py_params(
        infile=infile,
        label=label,
    )
    return adjunct_is_label_py_execute(params, runner)


__all__ = [
    "ADJUNCT_IS_LABEL_PY_METADATA",
    "AdjunctIsLabelPyOutputs",
    "adjunct_is_label_py",
    "adjunct_is_label_py_execute",
    "adjunct_is_label_py_params",
]
