# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

ADJUNCT_MAKE_SCRIPT_AND_RST_PY_METADATA = Metadata(
    id="5a086004f7800ee08b4596337d3a8c88235a01ac.boutiques",
    name="adjunct_make_script_and_rst.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


AdjunctMakeScriptAndRstPyParameters = typing.TypedDict('AdjunctMakeScriptAndRstPyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/adjunct_make_script_and_rst.py"]],
    "input_script": InputPathType,
    "prefix_rst": str,
    "prefix_script": str,
    "reflink": str,
    "execute_script": bool,
})
AdjunctMakeScriptAndRstPyParametersTagged = typing.TypedDict('AdjunctMakeScriptAndRstPyParametersTagged', {
    "@type": typing.Literal["afni/adjunct_make_script_and_rst.py"],
    "input_script": InputPathType,
    "prefix_rst": str,
    "prefix_script": str,
    "reflink": str,
    "execute_script": bool,
})


class AdjunctMakeScriptAndRstPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `AdjunctMakeScriptAndRstPyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    rst_file: OutputPathType
    """Generated RST documentation file."""
    script_file: OutputPathType
    """Generated script file."""
    output_directory: OutputPathType
    """Output directory in Sphinx tree."""


def adjunct_make_script_and_rst_py_params(
    input_script: InputPathType,
    prefix_rst: str,
    prefix_script: str,
    reflink: str,
    execute_script: bool = False,
) -> AdjunctMakeScriptAndRstPyParametersTagged:
    """
    Build parameters.
    
    Args:
        input_script: Input script file with special markup.
        prefix_rst: Output filename including any path of the RST/Sphinx file.\
            Must include file extension '.rst'.
        prefix_script: Output filename of the script file. Should include file\
            extension such as '.tcsh'.
        reflink: A string tag that will serve as the subdirectory name holding\
            images for the given demo, and the RST internal reference label.
        execute_script: Flag to create the RST and script files, and also\
            execute the script.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/adjunct_make_script_and_rst.py",
        "input_script": input_script,
        "prefix_rst": prefix_rst,
        "prefix_script": prefix_script,
        "reflink": reflink,
        "execute_script": execute_script,
    }
    return params


def adjunct_make_script_and_rst_py_cargs(
    params: AdjunctMakeScriptAndRstPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("adjunct_make_script_and_rst.py")
    cargs.extend([
        "-input",
        execution.input_file(params.get("input_script", None))
    ])
    cargs.extend([
        "--prefix_rst",
        params.get("prefix_rst", None)
    ])
    cargs.extend([
        "--prefix_script",
        params.get("prefix_script", None)
    ])
    cargs.extend([
        "--reflink",
        params.get("reflink", None)
    ])
    if params.get("execute_script", False):
        cargs.append("--execute_script")
    return cargs


def adjunct_make_script_and_rst_py_outputs(
    params: AdjunctMakeScriptAndRstPyParameters,
    execution: Execution,
) -> AdjunctMakeScriptAndRstPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = AdjunctMakeScriptAndRstPyOutputs(
        root=execution.output_file("."),
        rst_file=execution.output_file(params.get("prefix_rst", None)),
        script_file=execution.output_file(params.get("prefix_script", None)),
        output_directory=execution.output_file(params.get("prefix_rst", None) + "/media/" + params.get("reflink", None)),
    )
    return ret


def adjunct_make_script_and_rst_py_execute(
    params: AdjunctMakeScriptAndRstPyParameters,
    runner: Runner | None = None,
) -> AdjunctMakeScriptAndRstPyOutputs:
    """
    adjunct_make_script_and_rst.py
    
    Program to take a script with some special markup and turn it into both an
    RST page and a script for the online Sphinx documentation.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `AdjunctMakeScriptAndRstPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(ADJUNCT_MAKE_SCRIPT_AND_RST_PY_METADATA)
    params = execution.params(params)
    cargs = adjunct_make_script_and_rst_py_cargs(params, execution)
    ret = adjunct_make_script_and_rst_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def adjunct_make_script_and_rst_py(
    input_script: InputPathType,
    prefix_rst: str,
    prefix_script: str,
    reflink: str,
    execute_script: bool = False,
    runner: Runner | None = None,
) -> AdjunctMakeScriptAndRstPyOutputs:
    """
    adjunct_make_script_and_rst.py
    
    Program to take a script with some special markup and turn it into both an
    RST page and a script for the online Sphinx documentation.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_script: Input script file with special markup.
        prefix_rst: Output filename including any path of the RST/Sphinx file.\
            Must include file extension '.rst'.
        prefix_script: Output filename of the script file. Should include file\
            extension such as '.tcsh'.
        reflink: A string tag that will serve as the subdirectory name holding\
            images for the given demo, and the RST internal reference label.
        execute_script: Flag to create the RST and script files, and also\
            execute the script.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `AdjunctMakeScriptAndRstPyOutputs`).
    """
    params = adjunct_make_script_and_rst_py_params(
        input_script=input_script,
        prefix_rst=prefix_rst,
        prefix_script=prefix_script,
        reflink=reflink,
        execute_script=execute_script,
    )
    return adjunct_make_script_and_rst_py_execute(params, runner)


__all__ = [
    "ADJUNCT_MAKE_SCRIPT_AND_RST_PY_METADATA",
    "AdjunctMakeScriptAndRstPyOutputs",
    "adjunct_make_script_and_rst_py",
    "adjunct_make_script_and_rst_py_execute",
    "adjunct_make_script_and_rst_py_params",
]
