# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

ADJUNCT_SELECT_STR_PY_METADATA = Metadata(
    id="6cd5b7c3dc004b32564c974ad12a283bfedda12f.boutiques",
    name="adjunct_select_str.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


AdjunctSelectStrPyParameters = typing.TypedDict('AdjunctSelectStrPyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/adjunct_select_str.py"]],
    "input_file": InputPathType,
    "num_bricks": float,
    "output_file": str,
})
AdjunctSelectStrPyParametersTagged = typing.TypedDict('AdjunctSelectStrPyParametersTagged', {
    "@type": typing.Literal["afni/adjunct_select_str.py"],
    "input_file": InputPathType,
    "num_bricks": float,
    "output_file": str,
})


class AdjunctSelectStrPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `AdjunctSelectStrPyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def adjunct_select_str_py_params(
    input_file: InputPathType,
    num_bricks: float,
    output_file: str,
) -> AdjunctSelectStrPyParametersTagged:
    """
    Build parameters.
    
    Args:
        input_file: File containing a list of integers.
        num_bricks: The number N of bricks in the dataset (so max index is N-1).
        output_file: Output file name.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/adjunct_select_str.py",
        "input_file": input_file,
        "num_bricks": num_bricks,
        "output_file": output_file,
    }
    return params


def adjunct_select_str_py_cargs(
    params: AdjunctSelectStrPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("adjunct_select_str.py")
    cargs.append(execution.input_file(params.get("input_file", None)))
    cargs.append(str(params.get("num_bricks", None)))
    cargs.append(params.get("output_file", None))
    return cargs


def adjunct_select_str_py_outputs(
    params: AdjunctSelectStrPyParameters,
    execution: Execution,
) -> AdjunctSelectStrPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = AdjunctSelectStrPyOutputs(
        root=execution.output_file("."),
    )
    return ret


def adjunct_select_str_py_execute(
    params: AdjunctSelectStrPyParameters,
    runner: Runner | None = None,
) -> AdjunctSelectStrPyOutputs:
    """
    adjunct_select_str.py
    
    A simple helper function for the fat_proc* scripts.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `AdjunctSelectStrPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(ADJUNCT_SELECT_STR_PY_METADATA)
    params = execution.params(params)
    cargs = adjunct_select_str_py_cargs(params, execution)
    ret = adjunct_select_str_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def adjunct_select_str_py(
    input_file: InputPathType,
    num_bricks: float,
    output_file: str,
    runner: Runner | None = None,
) -> AdjunctSelectStrPyOutputs:
    """
    adjunct_select_str.py
    
    A simple helper function for the fat_proc* scripts.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_file: File containing a list of integers.
        num_bricks: The number N of bricks in the dataset (so max index is N-1).
        output_file: Output file name.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `AdjunctSelectStrPyOutputs`).
    """
    params = adjunct_select_str_py_params(
        input_file=input_file,
        num_bricks=num_bricks,
        output_file=output_file,
    )
    return adjunct_select_str_py_execute(params, runner)


__all__ = [
    "ADJUNCT_SELECT_STR_PY_METADATA",
    "AdjunctSelectStrPyOutputs",
    "adjunct_select_str_py",
    "adjunct_select_str_py_execute",
    "adjunct_select_str_py_params",
]
