# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

ADJUNCT_SIMPLIFY_COST_PY_METADATA = Metadata(
    id="829e8e6deae200b0466a903fca638f1647be7707.boutiques",
    name="adjunct_simplify_cost.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


AdjunctSimplifyCostPyParameters = typing.TypedDict('AdjunctSimplifyCostPyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/adjunct_simplify_cost.py"]],
    "cost_function": str,
})
AdjunctSimplifyCostPyParametersTagged = typing.TypedDict('AdjunctSimplifyCostPyParametersTagged', {
    "@type": typing.Literal["afni/adjunct_simplify_cost.py"],
    "cost_function": str,
})


class AdjunctSimplifyCostPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `AdjunctSimplifyCostPyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def adjunct_simplify_cost_py_params(
    cost_function: str,
) -> AdjunctSimplifyCostPyParametersTagged:
    """
    Build parameters.
    
    Args:
        cost_function: The cost function name to be simplified.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/adjunct_simplify_cost.py",
        "cost_function": cost_function,
    }
    return params


def adjunct_simplify_cost_py_cargs(
    params: AdjunctSimplifyCostPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("adjunct_simplify_cost.py")
    cargs.append(params.get("cost_function", None))
    return cargs


def adjunct_simplify_cost_py_outputs(
    params: AdjunctSimplifyCostPyParameters,
    execution: Execution,
) -> AdjunctSimplifyCostPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = AdjunctSimplifyCostPyOutputs(
        root=execution.output_file("."),
    )
    return ret


def adjunct_simplify_cost_py_execute(
    params: AdjunctSimplifyCostPyParameters,
    runner: Runner | None = None,
) -> AdjunctSimplifyCostPyOutputs:
    """
    adjunct_simplify_cost.py
    
    Simplifies a cost function name by removing the '+' and anything following
    it.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `AdjunctSimplifyCostPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(ADJUNCT_SIMPLIFY_COST_PY_METADATA)
    params = execution.params(params)
    cargs = adjunct_simplify_cost_py_cargs(params, execution)
    ret = adjunct_simplify_cost_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def adjunct_simplify_cost_py(
    cost_function: str,
    runner: Runner | None = None,
) -> AdjunctSimplifyCostPyOutputs:
    """
    adjunct_simplify_cost.py
    
    Simplifies a cost function name by removing the '+' and anything following
    it.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        cost_function: The cost function name to be simplified.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `AdjunctSimplifyCostPyOutputs`).
    """
    params = adjunct_simplify_cost_py_params(
        cost_function=cost_function,
    )
    return adjunct_simplify_cost_py_execute(params, runner)


__all__ = [
    "ADJUNCT_SIMPLIFY_COST_PY_METADATA",
    "AdjunctSimplifyCostPyOutputs",
    "adjunct_simplify_cost_py",
    "adjunct_simplify_cost_py_execute",
    "adjunct_simplify_cost_py_params",
]
