# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

AFNI_CHECK_OMP_METADATA = Metadata(
    id="902e7955e7e9298e8850ef2d18d6e0b1a5e24ec2.boutiques",
    name="afni_check_omp",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


AfniCheckOmpParameters = typing.TypedDict('AfniCheckOmpParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/afni_check_omp"]],
    "iterations": typing.NotRequired[float | None],
})
AfniCheckOmpParametersTagged = typing.TypedDict('AfniCheckOmpParametersTagged', {
    "@type": typing.Literal["afni/afni_check_omp"],
    "iterations": typing.NotRequired[float | None],
})


class AfniCheckOmpOutputs(typing.NamedTuple):
    """
    Output object returned when calling `AfniCheckOmpParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def afni_check_omp_params(
    iterations: float | None = None,
) -> AfniCheckOmpParametersTagged:
    """
    Build parameters.
    
    Args:
        iterations: Number of iterations to run.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/afni_check_omp",
    }
    if iterations is not None:
        params["iterations"] = iterations
    return params


def afni_check_omp_cargs(
    params: AfniCheckOmpParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("afni_check_omp")
    if params.get("iterations", None) is not None:
        cargs.append(str(params.get("iterations", None)))
    return cargs


def afni_check_omp_outputs(
    params: AfniCheckOmpParameters,
    execution: Execution,
) -> AfniCheckOmpOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = AfniCheckOmpOutputs(
        root=execution.output_file("."),
    )
    return ret


def afni_check_omp_execute(
    params: AfniCheckOmpParameters,
    runner: Runner | None = None,
) -> AfniCheckOmpOutputs:
    """
    afni_check_omp
    
    Tool to check the OpenMP multi-threading environment for AFNI.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `AfniCheckOmpOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(AFNI_CHECK_OMP_METADATA)
    params = execution.params(params)
    cargs = afni_check_omp_cargs(params, execution)
    ret = afni_check_omp_outputs(params, execution)
    execution.run(cargs)
    return ret


def afni_check_omp(
    iterations: float | None = None,
    runner: Runner | None = None,
) -> AfniCheckOmpOutputs:
    """
    afni_check_omp
    
    Tool to check the OpenMP multi-threading environment for AFNI.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        iterations: Number of iterations to run.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `AfniCheckOmpOutputs`).
    """
    params = afni_check_omp_params(
        iterations=iterations,
    )
    return afni_check_omp_execute(params, runner)


__all__ = [
    "AFNI_CHECK_OMP_METADATA",
    "AfniCheckOmpOutputs",
    "afni_check_omp",
    "afni_check_omp_execute",
    "afni_check_omp_params",
]
