# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

AFNI_SYSTEM_CHECK_PY_METADATA = Metadata(
    id="4adec5e6e037e559c429c7306f6d084906ba4604.boutiques",
    name="afni_system_check.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


AfniSystemCheckPyParameters = typing.TypedDict('AfniSystemCheckPyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/afni_system_check.py"]],
    "check_all": bool,
    "find_prog": typing.NotRequired[str | None],
    "exact": typing.NotRequired[str | None],
    "disp_num_cpu": bool,
    "disp_ver_matplotlib": bool,
    "dot_file_list": bool,
    "dot_file_show": bool,
    "dot_file_pack": typing.NotRequired[str | None],
    "casematch": typing.NotRequired[str | None],
    "data_root": typing.NotRequired[str | None],
})
AfniSystemCheckPyParametersTagged = typing.TypedDict('AfniSystemCheckPyParametersTagged', {
    "@type": typing.Literal["afni/afni_system_check.py"],
    "check_all": bool,
    "find_prog": typing.NotRequired[str | None],
    "exact": typing.NotRequired[str | None],
    "disp_num_cpu": bool,
    "disp_ver_matplotlib": bool,
    "dot_file_list": bool,
    "dot_file_show": bool,
    "dot_file_pack": typing.NotRequired[str | None],
    "casematch": typing.NotRequired[str | None],
    "data_root": typing.NotRequired[str | None],
})


class AfniSystemCheckPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `AfniSystemCheckPyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def afni_system_check_py_params(
    check_all: bool = False,
    find_prog: str | None = None,
    exact: str | None = None,
    disp_num_cpu: bool = False,
    disp_ver_matplotlib: bool = False,
    dot_file_list: bool = False,
    dot_file_show: bool = False,
    dot_file_pack: str | None = None,
    casematch: str | None = None,
    data_root: str | None = None,
) -> AfniSystemCheckPyParametersTagged:
    """
    Build parameters.
    
    Args:
        check_all: Perform all system checks.
        find_prog: Search PATH for PROG.
        exact: Search for PROG without wildcards in -find_prog.
        disp_num_cpu: Display number of CPUs available.
        disp_ver_matplotlib: Display matplotlib version (else 'None').
        dot_file_list: List all found dot files (startup files).
        dot_file_show: Display contents of all found dot files.
        dot_file_pack: Create a NAME.tgz package containing dot files.
        casematch: Match case in -find_prog.
        data_root: Search for class data under DDIR.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/afni_system_check.py",
        "check_all": check_all,
        "disp_num_cpu": disp_num_cpu,
        "disp_ver_matplotlib": disp_ver_matplotlib,
        "dot_file_list": dot_file_list,
        "dot_file_show": dot_file_show,
    }
    if find_prog is not None:
        params["find_prog"] = find_prog
    if exact is not None:
        params["exact"] = exact
    if dot_file_pack is not None:
        params["dot_file_pack"] = dot_file_pack
    if casematch is not None:
        params["casematch"] = casematch
    if data_root is not None:
        params["data_root"] = data_root
    return params


def afni_system_check_py_cargs(
    params: AfniSystemCheckPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("afni_system_check.py")
    if params.get("check_all", False):
        cargs.append("-check_all")
    if params.get("find_prog", None) is not None:
        cargs.extend([
            "-find_prog",
            params.get("find_prog", None)
        ])
    if params.get("exact", None) is not None:
        cargs.extend([
            "-exact",
            params.get("exact", None)
        ])
    if params.get("disp_num_cpu", False):
        cargs.append("-disp_num_cpu")
    if params.get("disp_ver_matplotlib", False):
        cargs.append("-disp_ver_matplotlib")
    if params.get("dot_file_list", False):
        cargs.append("-dot_file_list")
    if params.get("dot_file_show", False):
        cargs.append("-dot_file_show")
    if params.get("dot_file_pack", None) is not None:
        cargs.extend([
            "-dot_file_pack",
            params.get("dot_file_pack", None)
        ])
    if params.get("casematch", None) is not None:
        cargs.extend([
            "-casematch",
            params.get("casematch", None)
        ])
    if params.get("data_root", None) is not None:
        cargs.extend([
            "-data_root",
            params.get("data_root", None)
        ])
    return cargs


def afni_system_check_py_outputs(
    params: AfniSystemCheckPyParameters,
    execution: Execution,
) -> AfniSystemCheckPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = AfniSystemCheckPyOutputs(
        root=execution.output_file("."),
    )
    return ret


def afni_system_check_py_execute(
    params: AfniSystemCheckPyParameters,
    runner: Runner | None = None,
) -> AfniSystemCheckPyOutputs:
    """
    afni_system_check.py
    
    Perform various system checks for figuring out AFNI installation issues.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `AfniSystemCheckPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(AFNI_SYSTEM_CHECK_PY_METADATA)
    params = execution.params(params)
    cargs = afni_system_check_py_cargs(params, execution)
    ret = afni_system_check_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def afni_system_check_py(
    check_all: bool = False,
    find_prog: str | None = None,
    exact: str | None = None,
    disp_num_cpu: bool = False,
    disp_ver_matplotlib: bool = False,
    dot_file_list: bool = False,
    dot_file_show: bool = False,
    dot_file_pack: str | None = None,
    casematch: str | None = None,
    data_root: str | None = None,
    runner: Runner | None = None,
) -> AfniSystemCheckPyOutputs:
    """
    afni_system_check.py
    
    Perform various system checks for figuring out AFNI installation issues.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        check_all: Perform all system checks.
        find_prog: Search PATH for PROG.
        exact: Search for PROG without wildcards in -find_prog.
        disp_num_cpu: Display number of CPUs available.
        disp_ver_matplotlib: Display matplotlib version (else 'None').
        dot_file_list: List all found dot files (startup files).
        dot_file_show: Display contents of all found dot files.
        dot_file_pack: Create a NAME.tgz package containing dot files.
        casematch: Match case in -find_prog.
        data_root: Search for class data under DDIR.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `AfniSystemCheckPyOutputs`).
    """
    params = afni_system_check_py_params(
        check_all=check_all,
        find_prog=find_prog,
        exact=exact,
        disp_num_cpu=disp_num_cpu,
        disp_ver_matplotlib=disp_ver_matplotlib,
        dot_file_list=dot_file_list,
        dot_file_show=dot_file_show,
        dot_file_pack=dot_file_pack,
        casematch=casematch,
        data_root=data_root,
    )
    return afni_system_check_py_execute(params, runner)


__all__ = [
    "AFNI_SYSTEM_CHECK_PY_METADATA",
    "AfniSystemCheckPyOutputs",
    "afni_system_check_py",
    "afni_system_check_py_execute",
    "afni_system_check_py_params",
]
