# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

ALIGN_EPI_ANAT_PY_METADATA = Metadata(
    id="1196723b5074ff83caa433d170999d4f8b1ef074.boutiques",
    name="align_epi_anat.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


AlignEpiAnatPyParameters = typing.TypedDict('AlignEpiAnatPyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/align_epi_anat.py"]],
    "epi": InputPathType,
    "anat": InputPathType,
    "epi_base": str,
    "anat2epi": bool,
    "epi2anat": bool,
    "suffix": typing.NotRequired[str | None],
    "AddEdge": bool,
    "big_move": bool,
    "giant_move": bool,
    "ginormous_move": bool,
    "keep_rm_files": bool,
    "prep_only": bool,
    "ana_has_skull": typing.NotRequired[typing.Literal["yes", "no"] | None],
    "epi_strip": typing.NotRequired[typing.Literal["3dSkullStrip", "3dAutomask", "None"] | None],
    "volreg_method": typing.NotRequired[typing.Literal["3dvolreg", "3dWarpDrive", "3dAllineate"] | None],
    "ex_mode": typing.NotRequired[typing.Literal["quiet", "echo", "dry_run", "script"] | None],
    "overwrite": bool,
})
AlignEpiAnatPyParametersTagged = typing.TypedDict('AlignEpiAnatPyParametersTagged', {
    "@type": typing.Literal["afni/align_epi_anat.py"],
    "epi": InputPathType,
    "anat": InputPathType,
    "epi_base": str,
    "anat2epi": bool,
    "epi2anat": bool,
    "suffix": typing.NotRequired[str | None],
    "AddEdge": bool,
    "big_move": bool,
    "giant_move": bool,
    "ginormous_move": bool,
    "keep_rm_files": bool,
    "prep_only": bool,
    "ana_has_skull": typing.NotRequired[typing.Literal["yes", "no"] | None],
    "epi_strip": typing.NotRequired[typing.Literal["3dSkullStrip", "3dAutomask", "None"] | None],
    "volreg_method": typing.NotRequired[typing.Literal["3dvolreg", "3dWarpDrive", "3dAllineate"] | None],
    "ex_mode": typing.NotRequired[typing.Literal["quiet", "echo", "dry_run", "script"] | None],
    "overwrite": bool,
})


class AlignEpiAnatPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `AlignEpiAnatPyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    anat_aligned: OutputPathType
    """A version of the anatomy that is aligned to the EPI"""
    epi_aligned: OutputPathType
    """A version of the EPI dataset aligned to the Anatomy"""


def align_epi_anat_py_params(
    epi: InputPathType,
    anat: InputPathType,
    epi_base: str,
    anat2epi: bool = False,
    epi2anat: bool = False,
    suffix: str | None = None,
    add_edge: bool = False,
    big_move: bool = False,
    giant_move: bool = False,
    ginormous_move: bool = False,
    keep_rm_files: bool = False,
    prep_only: bool = False,
    ana_has_skull: typing.Literal["yes", "no"] | None = None,
    epi_strip: typing.Literal["3dSkullStrip", "3dAutomask", "None"] | None = None,
    volreg_method: typing.Literal["3dvolreg", "3dWarpDrive", "3dAllineate"] | None = None,
    ex_mode: typing.Literal["quiet", "echo", "dry_run", "script"] | None = None,
    overwrite: bool = False,
) -> AlignEpiAnatPyParametersTagged:
    """
    Build parameters.
    
    Args:
        epi: EPI dataset to align or to which to align.
        anat: Anatomical dataset to align or to which to align.
        epi_base: Base sub-brick to use for alignment\
            (0/mean/median/max/subbrick#).
        anat2epi: Align anatomical to EPI dataset (default).
        epi2anat: Align EPI to anatomical dataset.
        suffix: Append suffix to the original anat/epi dataset to use in the\
            resulting dataset names.
        add_edge: Run @AddEdge script to create composite edge images.
        big_move: Large displacement is needed to align the two volumes.
        giant_move: Even larger movement required, uses cmass, two passes and\
            very large angles and shifts.
        ginormous_move: Adds align_centers to giant_move.
        keep_rm_files: Don't delete any of the temporary files created.
        prep_only: Do preprocessing steps only without alignment.
        ana_has_skull: Do not skullstrip anat dataset.
        epi_strip: Method to remove skull for EPI data.
        volreg_method: Time series volume registration method.
        ex_mode: Command execution mode.
        overwrite: Overwrite existing files.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/align_epi_anat.py",
        "epi": epi,
        "anat": anat,
        "epi_base": epi_base,
        "anat2epi": anat2epi,
        "epi2anat": epi2anat,
        "AddEdge": add_edge,
        "big_move": big_move,
        "giant_move": giant_move,
        "ginormous_move": ginormous_move,
        "keep_rm_files": keep_rm_files,
        "prep_only": prep_only,
        "overwrite": overwrite,
    }
    if suffix is not None:
        params["suffix"] = suffix
    if ana_has_skull is not None:
        params["ana_has_skull"] = ana_has_skull
    if epi_strip is not None:
        params["epi_strip"] = epi_strip
    if volreg_method is not None:
        params["volreg_method"] = volreg_method
    if ex_mode is not None:
        params["ex_mode"] = ex_mode
    return params


def align_epi_anat_py_cargs(
    params: AlignEpiAnatPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("align_epi_anat.py")
    cargs.extend([
        "-epi",
        execution.input_file(params.get("epi", None))
    ])
    cargs.extend([
        "-anat",
        execution.input_file(params.get("anat", None))
    ])
    cargs.extend([
        "-epi_base",
        params.get("epi_base", None)
    ])
    if params.get("anat2epi", False):
        cargs.append("-anat2epi")
    if params.get("epi2anat", False):
        cargs.append("-epi2anat")
    if params.get("suffix", None) is not None:
        cargs.extend([
            "-suffix",
            params.get("suffix", None)
        ])
    if params.get("AddEdge", False):
        cargs.append("-AddEdge")
    if params.get("big_move", False):
        cargs.append("-big_move")
    if params.get("giant_move", False):
        cargs.append("-giant_move")
    if params.get("ginormous_move", False):
        cargs.append("-ginormous_move")
    if params.get("keep_rm_files", False):
        cargs.append("-keep_rm_files")
    if params.get("prep_only", False):
        cargs.append("-prep_only")
    if params.get("ana_has_skull", None) is not None:
        cargs.extend([
            "-anat_has_skull",
            params.get("ana_has_skull", None)
        ])
    if params.get("epi_strip", None) is not None:
        cargs.extend([
            "-epi_strip",
            params.get("epi_strip", None)
        ])
    if params.get("volreg_method", None) is not None:
        cargs.extend([
            "-volreg_method",
            params.get("volreg_method", None)
        ])
    if params.get("ex_mode", None) is not None:
        cargs.extend([
            "-ex_mode",
            params.get("ex_mode", None)
        ])
    if params.get("overwrite", False):
        cargs.append("-overwrite")
    return cargs


def align_epi_anat_py_outputs(
    params: AlignEpiAnatPyParameters,
    execution: Execution,
) -> AlignEpiAnatPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = AlignEpiAnatPyOutputs(
        root=execution.output_file("."),
        anat_aligned=execution.output_file(pathlib.Path(params.get("anat", None)).name + "+orig"),
        epi_aligned=execution.output_file(pathlib.Path(params.get("epi", None)).name + "+orig"),
    )
    return ret


def align_epi_anat_py_execute(
    params: AlignEpiAnatPyParameters,
    runner: Runner | None = None,
) -> AlignEpiAnatPyOutputs:
    """
    align_epi_anat.py
    
    Align EPI to anatomical datasets or vice versa.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `AlignEpiAnatPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(ALIGN_EPI_ANAT_PY_METADATA)
    params = execution.params(params)
    cargs = align_epi_anat_py_cargs(params, execution)
    ret = align_epi_anat_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def align_epi_anat_py(
    epi: InputPathType,
    anat: InputPathType,
    epi_base: str,
    anat2epi: bool = False,
    epi2anat: bool = False,
    suffix: str | None = None,
    add_edge: bool = False,
    big_move: bool = False,
    giant_move: bool = False,
    ginormous_move: bool = False,
    keep_rm_files: bool = False,
    prep_only: bool = False,
    ana_has_skull: typing.Literal["yes", "no"] | None = None,
    epi_strip: typing.Literal["3dSkullStrip", "3dAutomask", "None"] | None = None,
    volreg_method: typing.Literal["3dvolreg", "3dWarpDrive", "3dAllineate"] | None = None,
    ex_mode: typing.Literal["quiet", "echo", "dry_run", "script"] | None = None,
    overwrite: bool = False,
    runner: Runner | None = None,
) -> AlignEpiAnatPyOutputs:
    """
    align_epi_anat.py
    
    Align EPI to anatomical datasets or vice versa.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        epi: EPI dataset to align or to which to align.
        anat: Anatomical dataset to align or to which to align.
        epi_base: Base sub-brick to use for alignment\
            (0/mean/median/max/subbrick#).
        anat2epi: Align anatomical to EPI dataset (default).
        epi2anat: Align EPI to anatomical dataset.
        suffix: Append suffix to the original anat/epi dataset to use in the\
            resulting dataset names.
        add_edge: Run @AddEdge script to create composite edge images.
        big_move: Large displacement is needed to align the two volumes.
        giant_move: Even larger movement required, uses cmass, two passes and\
            very large angles and shifts.
        ginormous_move: Adds align_centers to giant_move.
        keep_rm_files: Don't delete any of the temporary files created.
        prep_only: Do preprocessing steps only without alignment.
        ana_has_skull: Do not skullstrip anat dataset.
        epi_strip: Method to remove skull for EPI data.
        volreg_method: Time series volume registration method.
        ex_mode: Command execution mode.
        overwrite: Overwrite existing files.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `AlignEpiAnatPyOutputs`).
    """
    params = align_epi_anat_py_params(
        epi=epi,
        anat=anat,
        epi_base=epi_base,
        anat2epi=anat2epi,
        epi2anat=epi2anat,
        suffix=suffix,
        add_edge=add_edge,
        big_move=big_move,
        giant_move=giant_move,
        ginormous_move=ginormous_move,
        keep_rm_files=keep_rm_files,
        prep_only=prep_only,
        ana_has_skull=ana_has_skull,
        epi_strip=epi_strip,
        volreg_method=volreg_method,
        ex_mode=ex_mode,
        overwrite=overwrite,
    )
    return align_epi_anat_py_execute(params, runner)


__all__ = [
    "ALIGN_EPI_ANAT_PY_METADATA",
    "AlignEpiAnatPyOutputs",
    "align_epi_anat_py",
    "align_epi_anat_py_execute",
    "align_epi_anat_py_params",
]
