# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

AP_RUN_SIMPLE_REST_TCSH_METADATA = Metadata(
    id="7e737e7c00ddc467814f6d863dc72a85ba7f5b1b.boutiques",
    name="ap_run_simple_rest.tcsh",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


ApRunSimpleRestTcshParameters = typing.TypedDict('ApRunSimpleRestTcshParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/ap_run_simple_rest.tcsh"]],
    "anat": typing.NotRequired[InputPathType | None],
    "epi": list[InputPathType],
    "nt_rm": typing.NotRequired[float | None],
    "run_ap": bool,
    "run_proc": bool,
    "subjid": typing.NotRequired[str | None],
    "template": typing.NotRequired[InputPathType | None],
    "compressor": typing.NotRequired[str | None],
    "verb": typing.NotRequired[float | None],
    "echo": bool,
})
ApRunSimpleRestTcshParametersTagged = typing.TypedDict('ApRunSimpleRestTcshParametersTagged', {
    "@type": typing.Literal["afni/ap_run_simple_rest.tcsh"],
    "anat": typing.NotRequired[InputPathType | None],
    "epi": list[InputPathType],
    "nt_rm": typing.NotRequired[float | None],
    "run_ap": bool,
    "run_proc": bool,
    "subjid": typing.NotRequired[str | None],
    "template": typing.NotRequired[InputPathType | None],
    "compressor": typing.NotRequired[str | None],
    "verb": typing.NotRequired[float | None],
    "echo": bool,
})


class ApRunSimpleRestTcshOutputs(typing.NamedTuple):
    """
    Output object returned when calling `ApRunSimpleRestTcshParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    run_ap_script: OutputPathType | None
    """afni_proc.py command script"""
    proc_script: OutputPathType | None
    """proc script (if AP is run)"""
    proc_results_dir: OutputPathType | None
    """proc results directory (if run)"""


def ap_run_simple_rest_tcsh_params(
    epi: list[InputPathType],
    anat: InputPathType | None = None,
    nt_rm: float | None = None,
    run_ap: bool = False,
    run_proc: bool = False,
    subjid: str | None = None,
    template: InputPathType | None = None,
    compressor: str | None = None,
    verb: float | None = None,
    echo: bool = False,
) -> ApRunSimpleRestTcshParametersTagged:
    """
    Build parameters.
    
    Args:
        epi: EPI datasets.
        anat: Single anatomical dataset.
        nt_rm: Number of time points to remove from starts of runs.
        run_ap: Run the afni_proc.py command.
        run_proc: Run the proc script from afni_proc.py command.
        subjid: Specify subject ID for file names.
        template: Specify template for standard space.
        compressor: Control automatic compression of *.BRIK files.
        verb: Specify verbosity level.
        echo: Same as verbosity level 3.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/ap_run_simple_rest.tcsh",
        "epi": epi,
        "run_ap": run_ap,
        "run_proc": run_proc,
        "echo": echo,
    }
    if anat is not None:
        params["anat"] = anat
    if nt_rm is not None:
        params["nt_rm"] = nt_rm
    if subjid is not None:
        params["subjid"] = subjid
    if template is not None:
        params["template"] = template
    if compressor is not None:
        params["compressor"] = compressor
    if verb is not None:
        params["verb"] = verb
    return params


def ap_run_simple_rest_tcsh_cargs(
    params: ApRunSimpleRestTcshParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("ap_run_simple_rest.tcsh")
    if params.get("anat", None) is not None:
        cargs.extend([
            "-anat",
            execution.input_file(params.get("anat", None))
        ])
    cargs.extend([
        "-epi",
        *[execution.input_file(f) for f in params.get("epi", None)]
    ])
    if params.get("nt_rm", None) is not None:
        cargs.extend([
            "-nt_rm",
            str(params.get("nt_rm", None))
        ])
    if params.get("run_ap", False):
        cargs.append("-run_ap")
    if params.get("run_proc", False):
        cargs.append("-run_proc")
    if params.get("subjid", None) is not None:
        cargs.extend([
            "-subjid",
            params.get("subjid", None)
        ])
    if params.get("template", None) is not None:
        cargs.extend([
            "-template",
            execution.input_file(params.get("template", None))
        ])
    if params.get("compressor", None) is not None:
        cargs.extend([
            "-compressor",
            params.get("compressor", None)
        ])
    if params.get("verb", None) is not None:
        cargs.extend([
            "-verb",
            str(params.get("verb", None))
        ])
    if params.get("echo", False):
        cargs.append("-echo")
    return cargs


def ap_run_simple_rest_tcsh_outputs(
    params: ApRunSimpleRestTcshParameters,
    execution: Execution,
) -> ApRunSimpleRestTcshOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = ApRunSimpleRestTcshOutputs(
        root=execution.output_file("."),
        run_ap_script=execution.output_file("run_ap_" + params.get("subjid", None)) if (params.get("subjid") is not None) else None,
        proc_script=execution.output_file("proc." + params.get("subjid", None)) if (params.get("subjid") is not None) else None,
        proc_results_dir=execution.output_file(params.get("subjid", None) + ".results") if (params.get("subjid") is not None) else None,
    )
    return ret


def ap_run_simple_rest_tcsh_execute(
    params: ApRunSimpleRestTcshParameters,
    runner: Runner | None = None,
) -> ApRunSimpleRestTcshOutputs:
    """
    ap_run_simple_rest.tcsh
    
    Run a quick afni_proc.py analysis for QC.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ApRunSimpleRestTcshOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(AP_RUN_SIMPLE_REST_TCSH_METADATA)
    params = execution.params(params)
    cargs = ap_run_simple_rest_tcsh_cargs(params, execution)
    ret = ap_run_simple_rest_tcsh_outputs(params, execution)
    execution.run(cargs)
    return ret


def ap_run_simple_rest_tcsh(
    epi: list[InputPathType],
    anat: InputPathType | None = None,
    nt_rm: float | None = None,
    run_ap: bool = False,
    run_proc: bool = False,
    subjid: str | None = None,
    template: InputPathType | None = None,
    compressor: str | None = None,
    verb: float | None = None,
    echo: bool = False,
    runner: Runner | None = None,
) -> ApRunSimpleRestTcshOutputs:
    """
    ap_run_simple_rest.tcsh
    
    Run a quick afni_proc.py analysis for QC.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        epi: EPI datasets.
        anat: Single anatomical dataset.
        nt_rm: Number of time points to remove from starts of runs.
        run_ap: Run the afni_proc.py command.
        run_proc: Run the proc script from afni_proc.py command.
        subjid: Specify subject ID for file names.
        template: Specify template for standard space.
        compressor: Control automatic compression of *.BRIK files.
        verb: Specify verbosity level.
        echo: Same as verbosity level 3.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ApRunSimpleRestTcshOutputs`).
    """
    params = ap_run_simple_rest_tcsh_params(
        anat=anat,
        epi=epi,
        nt_rm=nt_rm,
        run_ap=run_ap,
        run_proc=run_proc,
        subjid=subjid,
        template=template,
        compressor=compressor,
        verb=verb,
        echo=echo,
    )
    return ap_run_simple_rest_tcsh_execute(params, runner)


__all__ = [
    "AP_RUN_SIMPLE_REST_TCSH_METADATA",
    "ApRunSimpleRestTcshOutputs",
    "ap_run_simple_rest_tcsh",
    "ap_run_simple_rest_tcsh_execute",
    "ap_run_simple_rest_tcsh_params",
]
