# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

APQC_MAKE_HTML_PY_METADATA = Metadata(
    id="75d15c133646b9af46b8b07280f7d7208042b9a7.boutiques",
    name="apqc_make_html.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


ApqcMakeHtmlPyParameters = typing.TypedDict('ApqcMakeHtmlPyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/apqc_make_html.py"]],
    "qc_dir": str,
})
ApqcMakeHtmlPyParametersTagged = typing.TypedDict('ApqcMakeHtmlPyParametersTagged', {
    "@type": typing.Literal["afni/apqc_make_html.py"],
    "qc_dir": str,
})


class ApqcMakeHtmlPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `ApqcMakeHtmlPyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def apqc_make_html_py_params(
    qc_dir: str,
) -> ApqcMakeHtmlPyParametersTagged:
    """
    Build parameters.
    
    Args:
        qc_dir: Directory where QC files will be saved.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/apqc_make_html.py",
        "qc_dir": qc_dir,
    }
    return params


def apqc_make_html_py_cargs(
    params: ApqcMakeHtmlPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("apqc_make_html.py")
    cargs.extend([
        "-qc_dir",
        params.get("qc_dir", None)
    ])
    return cargs


def apqc_make_html_py_outputs(
    params: ApqcMakeHtmlPyParameters,
    execution: Execution,
) -> ApqcMakeHtmlPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = ApqcMakeHtmlPyOutputs(
        root=execution.output_file("."),
    )
    return ret


def apqc_make_html_py_execute(
    params: ApqcMakeHtmlPyParameters,
    runner: Runner | None = None,
) -> ApqcMakeHtmlPyOutputs:
    """
    apqc_make_html.py
    
    Tool to generate HTML reports.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ApqcMakeHtmlPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(APQC_MAKE_HTML_PY_METADATA)
    params = execution.params(params)
    cargs = apqc_make_html_py_cargs(params, execution)
    ret = apqc_make_html_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def apqc_make_html_py(
    qc_dir: str,
    runner: Runner | None = None,
) -> ApqcMakeHtmlPyOutputs:
    """
    apqc_make_html.py
    
    Tool to generate HTML reports.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        qc_dir: Directory where QC files will be saved.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ApqcMakeHtmlPyOutputs`).
    """
    params = apqc_make_html_py_params(
        qc_dir=qc_dir,
    )
    return apqc_make_html_py_execute(params, runner)


__all__ = [
    "APQC_MAKE_HTML_PY_METADATA",
    "ApqcMakeHtmlPyOutputs",
    "apqc_make_html_py",
    "apqc_make_html_py_execute",
    "apqc_make_html_py_params",
]
