# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

BAYES_VIEW_METADATA = Metadata(
    id="9505bae1fe22a390a7c949d3eee05a64bdd40fb6.boutiques",
    name="bayes_view",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


BayesViewParameters = typing.TypedDict('BayesViewParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/bayes_view"]],
    "input_folder": str,
    "help": bool,
    "shiny_folder": typing.NotRequired[str | None],
})
BayesViewParametersTagged = typing.TypedDict('BayesViewParametersTagged', {
    "@type": typing.Literal["afni/bayes_view"],
    "input_folder": str,
    "help": bool,
    "shiny_folder": typing.NotRequired[str | None],
})


class BayesViewOutputs(typing.NamedTuple):
    """
    Output object returned when calling `BayesViewParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def bayes_view_params(
    input_folder: str,
    help_: bool = False,
    shiny_folder: str | None = None,
) -> BayesViewParametersTagged:
    """
    Build parameters.
    
    Args:
        input_folder: Path to a folder containing .RData files.
        help_: Show help message.
        shiny_folder: Use a custom shiny folder (for testing purposes).
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/bayes_view",
        "input_folder": input_folder,
        "help": help_,
    }
    if shiny_folder is not None:
        params["shiny_folder"] = shiny_folder
    return params


def bayes_view_cargs(
    params: BayesViewParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("bayes_view")
    cargs.append(params.get("input_folder", None))
    if params.get("help", False):
        cargs.append("-help")
    if params.get("shiny_folder", None) is not None:
        cargs.extend([
            "-ShinyFolder",
            params.get("shiny_folder", None)
        ])
    return cargs


def bayes_view_outputs(
    params: BayesViewParameters,
    execution: Execution,
) -> BayesViewOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = BayesViewOutputs(
        root=execution.output_file("."),
    )
    return ret


def bayes_view_execute(
    params: BayesViewParameters,
    runner: Runner | None = None,
) -> BayesViewOutputs:
    """
    bayes_view
    
    Launch a shiny app to visualize RBA output files. The files must have the
    .RData extension.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `BayesViewOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(BAYES_VIEW_METADATA)
    params = execution.params(params)
    cargs = bayes_view_cargs(params, execution)
    ret = bayes_view_outputs(params, execution)
    execution.run(cargs)
    return ret


def bayes_view(
    input_folder: str,
    help_: bool = False,
    shiny_folder: str | None = None,
    runner: Runner | None = None,
) -> BayesViewOutputs:
    """
    bayes_view
    
    Launch a shiny app to visualize RBA output files. The files must have the
    .RData extension.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_folder: Path to a folder containing .RData files.
        help_: Show help message.
        shiny_folder: Use a custom shiny folder (for testing purposes).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `BayesViewOutputs`).
    """
    params = bayes_view_params(
        input_folder=input_folder,
        help_=help_,
        shiny_folder=shiny_folder,
    )
    return bayes_view_execute(params, runner)


__all__ = [
    "BAYES_VIEW_METADATA",
    "BayesViewOutputs",
    "bayes_view",
    "bayes_view_execute",
    "bayes_view_params",
]
