# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

CCALC_METADATA = Metadata(
    id="b145289273191dd83b1fd1959696713496ba9bee.boutiques",
    name="ccalc",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


CcalcParameters = typing.TypedDict('CcalcParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/ccalc"]],
    "format": typing.NotRequired[str | None],
    "expr": str,
})
CcalcParametersTagged = typing.TypedDict('CcalcParametersTagged', {
    "@type": typing.Literal["afni/ccalc"],
    "format": typing.NotRequired[str | None],
    "expr": str,
})


class CcalcOutputs(typing.NamedTuple):
    """
    Output object returned when calling `CcalcParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def ccalc_params(
    expr: str,
    format_: str | None = None,
) -> CcalcParametersTagged:
    """
    Build parameters.
    
    Args:
        expr: Evaluate an expression specified on command line, return answer\
            and quit.
        format_: Format output in a nice form. Choose from 'double', 'nice',\
            'int', 'rint', 'cint', 'fint', or custom format string (e.g., %n.mf).
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/ccalc",
        "expr": expr,
    }
    if format_ is not None:
        params["format"] = format_
    return params


def ccalc_cargs(
    params: CcalcParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("ccalc")
    if params.get("format", None) is not None:
        cargs.extend([
            "-form",
            params.get("format", None)
        ])
    cargs.extend([
        "-eval",
        params.get("expr", None)
    ])
    return cargs


def ccalc_outputs(
    params: CcalcParameters,
    execution: Execution,
) -> CcalcOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = CcalcOutputs(
        root=execution.output_file("."),
    )
    return ret


def ccalc_execute(
    params: CcalcParameters,
    runner: Runner | None = None,
) -> CcalcOutputs:
    """
    ccalc
    
    Command line calculator with formatted output options.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `CcalcOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(CCALC_METADATA)
    params = execution.params(params)
    cargs = ccalc_cargs(params, execution)
    ret = ccalc_outputs(params, execution)
    execution.run(cargs)
    return ret


def ccalc(
    expr: str,
    format_: str | None = None,
    runner: Runner | None = None,
) -> CcalcOutputs:
    """
    ccalc
    
    Command line calculator with formatted output options.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        expr: Evaluate an expression specified on command line, return answer\
            and quit.
        format_: Format output in a nice form. Choose from 'double', 'nice',\
            'int', 'rint', 'cint', 'fint', or custom format string (e.g., %n.mf).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `CcalcOutputs`).
    """
    params = ccalc_params(
        format_=format_,
        expr=expr,
    )
    return ccalc_execute(params, runner)


__all__ = [
    "CCALC_METADATA",
    "CcalcOutputs",
    "ccalc",
    "ccalc_execute",
    "ccalc_params",
]
