# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

CIFTI_TOOL_METADATA = Metadata(
    id="5dccf8e632c65fb5c70327668e713fb4c23945df.boutiques",
    name="cifti_tool",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


CiftiToolParameters = typing.TypedDict('CiftiToolParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/cifti_tool"]],
    "input_file": InputPathType,
    "as_cext": bool,
    "disp_cext": bool,
    "eval_cext": bool,
    "eval_type": typing.NotRequired[typing.Literal["has_data", "has_bdata", "num_tokens", "show", "show_names", "show_summary", "show_text_data"] | None],
    "output_file": typing.NotRequired[str | None],
    "verbose_level": typing.NotRequired[float | None],
    "verbose_read_level": typing.NotRequired[float | None],
    "both_verbose_levels": typing.NotRequired[float | None],
})
CiftiToolParametersTagged = typing.TypedDict('CiftiToolParametersTagged', {
    "@type": typing.Literal["afni/cifti_tool"],
    "input_file": InputPathType,
    "as_cext": bool,
    "disp_cext": bool,
    "eval_cext": bool,
    "eval_type": typing.NotRequired[typing.Literal["has_data", "has_bdata", "num_tokens", "show", "show_names", "show_summary", "show_text_data"] | None],
    "output_file": typing.NotRequired[str | None],
    "verbose_level": typing.NotRequired[float | None],
    "verbose_read_level": typing.NotRequired[float | None],
    "both_verbose_levels": typing.NotRequired[float | None],
})


class CiftiToolOutputs(typing.NamedTuple):
    """
    Output object returned when calling `CiftiToolParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType | None
    """Output file for results"""


def cifti_tool_params(
    input_file: InputPathType,
    as_cext: bool = False,
    disp_cext: bool = False,
    eval_cext: bool = False,
    eval_type: typing.Literal["has_data", "has_bdata", "num_tokens", "show", "show_names", "show_summary", "show_text_data"] | None = None,
    output_file: str | None = None,
    verbose_level: float | None = None,
    verbose_read_level: float | None = None,
    both_verbose_levels: float | None = None,
) -> CiftiToolParametersTagged:
    """
    Build parameters.
    
    Args:
        input_file: Specify input dataset.
        as_cext: Process the input as just an extension.
        disp_cext: Display the CIFTI extension.
        eval_cext: Evaluate the CIFTI extension.
        eval_type: Method for evaluation of axml elements.
        output_file: Where to write output.
        verbose_level: Set the verbose level.
        verbose_read_level: Set verbose level when reading.
        both_verbose_levels: Apply both -verb options.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/cifti_tool",
        "input_file": input_file,
        "as_cext": as_cext,
        "disp_cext": disp_cext,
        "eval_cext": eval_cext,
    }
    if eval_type is not None:
        params["eval_type"] = eval_type
    if output_file is not None:
        params["output_file"] = output_file
    if verbose_level is not None:
        params["verbose_level"] = verbose_level
    if verbose_read_level is not None:
        params["verbose_read_level"] = verbose_read_level
    if both_verbose_levels is not None:
        params["both_verbose_levels"] = both_verbose_levels
    return params


def cifti_tool_cargs(
    params: CiftiToolParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("cifti_tool")
    cargs.extend([
        "-input",
        execution.input_file(params.get("input_file", None))
    ])
    if params.get("as_cext", False):
        cargs.append("-as_cext")
    if params.get("disp_cext", False):
        cargs.append("-disp_cext")
    if params.get("eval_cext", False):
        cargs.append("-eval_cext")
    if params.get("eval_type", None) is not None:
        cargs.extend([
            "-eval_type",
            params.get("eval_type", None)
        ])
    if params.get("output_file", None) is not None:
        cargs.extend([
            "-output",
            params.get("output_file", None)
        ])
    if params.get("verbose_level", None) is not None:
        cargs.extend([
            "-verb",
            str(params.get("verbose_level", None))
        ])
    if params.get("verbose_read_level", None) is not None:
        cargs.extend([
            "-verb_read",
            str(params.get("verbose_read_level", None))
        ])
    if params.get("both_verbose_levels", None) is not None:
        cargs.extend([
            "-vboth",
            str(params.get("both_verbose_levels", None))
        ])
    return cargs


def cifti_tool_outputs(
    params: CiftiToolParameters,
    execution: Execution,
) -> CiftiToolOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = CiftiToolOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file(params.get("output_file", None)) if (params.get("output_file") is not None) else None,
    )
    return ret


def cifti_tool_execute(
    params: CiftiToolParameters,
    runner: Runner | None = None,
) -> CiftiToolOutputs:
    """
    cifti_tool
    
    Example tool for reading/writing CIFTI-2 datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `CiftiToolOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(CIFTI_TOOL_METADATA)
    params = execution.params(params)
    cargs = cifti_tool_cargs(params, execution)
    ret = cifti_tool_outputs(params, execution)
    execution.run(cargs)
    return ret


def cifti_tool(
    input_file: InputPathType,
    as_cext: bool = False,
    disp_cext: bool = False,
    eval_cext: bool = False,
    eval_type: typing.Literal["has_data", "has_bdata", "num_tokens", "show", "show_names", "show_summary", "show_text_data"] | None = None,
    output_file: str | None = None,
    verbose_level: float | None = None,
    verbose_read_level: float | None = None,
    both_verbose_levels: float | None = None,
    runner: Runner | None = None,
) -> CiftiToolOutputs:
    """
    cifti_tool
    
    Example tool for reading/writing CIFTI-2 datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_file: Specify input dataset.
        as_cext: Process the input as just an extension.
        disp_cext: Display the CIFTI extension.
        eval_cext: Evaluate the CIFTI extension.
        eval_type: Method for evaluation of axml elements.
        output_file: Where to write output.
        verbose_level: Set the verbose level.
        verbose_read_level: Set verbose level when reading.
        both_verbose_levels: Apply both -verb options.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `CiftiToolOutputs`).
    """
    params = cifti_tool_params(
        input_file=input_file,
        as_cext=as_cext,
        disp_cext=disp_cext,
        eval_cext=eval_cext,
        eval_type=eval_type,
        output_file=output_file,
        verbose_level=verbose_level,
        verbose_read_level=verbose_read_level,
        both_verbose_levels=both_verbose_levels,
    )
    return cifti_tool_execute(params, runner)


__all__ = [
    "CIFTI_TOOL_METADATA",
    "CiftiToolOutputs",
    "cifti_tool",
    "cifti_tool_execute",
    "cifti_tool_params",
]
