# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

CLUST_EXP_HIST_TABLE_PY_METADATA = Metadata(
    id="1463a61d8d642f1da2ae42321f37e18bffcb4d50.boutiques",
    name="ClustExp_HistTable.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


ClustExpHistTablePyParameters = typing.TypedDict('ClustExpHistTablePyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/ClustExp_HistTable.py"]],
    "stat_dset": InputPathType,
    "prefix": typing.NotRequired[str | None],
    "session": typing.NotRequired[str | None],
    "overwrite": bool,
})
ClustExpHistTablePyParametersTagged = typing.TypedDict('ClustExpHistTablePyParametersTagged', {
    "@type": typing.Literal["afni/ClustExp_HistTable.py"],
    "stat_dset": InputPathType,
    "prefix": typing.NotRequired[str | None],
    "session": typing.NotRequired[str | None],
    "overwrite": bool,
})


class ClustExpHistTablePyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `ClustExpHistTablePyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    group_table: OutputPathType | None
    """Table with information parsed from the statistics dataset history."""


def clust_exp_hist_table_py_params(
    stat_dset: InputPathType,
    prefix: str | None = None,
    session: str | None = None,
    overwrite: bool = False,
) -> ClustExpHistTablePyParametersTagged:
    """
    Build parameters.
    
    Args:
        stat_dset: Statistics dataset.
        prefix: Name for output (no path). Default is GroupOut.
        session: Output parent folder if you don't want the current working\
            directory. Default is ./.
        overwrite: Remove previous folder with same PREFIX.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/ClustExp_HistTable.py",
        "stat_dset": stat_dset,
        "overwrite": overwrite,
    }
    if prefix is not None:
        params["prefix"] = prefix
    if session is not None:
        params["session"] = session
    return params


def clust_exp_hist_table_py_cargs(
    params: ClustExpHistTablePyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("ClustExp_HistTable.py")
    cargs.extend([
        "-StatDSET",
        execution.input_file(params.get("stat_dset", None))
    ])
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("session", None) is not None:
        cargs.extend([
            "-session",
            params.get("session", None)
        ])
    if params.get("overwrite", False):
        cargs.append("-overwrite")
    return cargs


def clust_exp_hist_table_py_outputs(
    params: ClustExpHistTablePyParameters,
    execution: Execution,
) -> ClustExpHistTablePyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = ClustExpHistTablePyOutputs(
        root=execution.output_file("."),
        group_table=execution.output_file(params.get("prefix", None) + "_GroupTable.csv") if (params.get("prefix") is not None) else None,
    )
    return ret


def clust_exp_hist_table_py_execute(
    params: ClustExpHistTablePyParameters,
    runner: Runner | None = None,
) -> ClustExpHistTablePyOutputs:
    """
    ClustExp_HistTable.py
    
    Script to extract the data table from history of datasets from 3dttest++,
    3dMVM, or 3dLME.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ClustExpHistTablePyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(CLUST_EXP_HIST_TABLE_PY_METADATA)
    params = execution.params(params)
    cargs = clust_exp_hist_table_py_cargs(params, execution)
    ret = clust_exp_hist_table_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def clust_exp_hist_table_py(
    stat_dset: InputPathType,
    prefix: str | None = None,
    session: str | None = None,
    overwrite: bool = False,
    runner: Runner | None = None,
) -> ClustExpHistTablePyOutputs:
    """
    ClustExp_HistTable.py
    
    Script to extract the data table from history of datasets from 3dttest++,
    3dMVM, or 3dLME.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        stat_dset: Statistics dataset.
        prefix: Name for output (no path). Default is GroupOut.
        session: Output parent folder if you don't want the current working\
            directory. Default is ./.
        overwrite: Remove previous folder with same PREFIX.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ClustExpHistTablePyOutputs`).
    """
    params = clust_exp_hist_table_py_params(
        stat_dset=stat_dset,
        prefix=prefix,
        session=session,
        overwrite=overwrite,
    )
    return clust_exp_hist_table_py_execute(params, runner)


__all__ = [
    "CLUST_EXP_HIST_TABLE_PY_METADATA",
    "ClustExpHistTablePyOutputs",
    "clust_exp_hist_table_py",
    "clust_exp_hist_table_py_execute",
    "clust_exp_hist_table_py_params",
]
