# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

CONVERT_CDIFLIST_TO_GRADS_PY_METADATA = Metadata(
    id="64ab963d60d406f9d0685d461ee3fcdb60c15e0c.boutiques",
    name="convert_cdiflist_to_grads.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


ConvertCdiflistToGradsPyParameters = typing.TypedDict('ConvertCdiflistToGradsPyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/convert_cdiflist_to_grads.py"]],
    "cdiflist": InputPathType,
    "bval_max": float,
    "prefix": str,
    "ver": bool,
    "date": bool,
    "help": bool,
    "hview": bool,
})
ConvertCdiflistToGradsPyParametersTagged = typing.TypedDict('ConvertCdiflistToGradsPyParametersTagged', {
    "@type": typing.Literal["afni/convert_cdiflist_to_grads.py"],
    "cdiflist": InputPathType,
    "bval_max": float,
    "prefix": str,
    "ver": bool,
    "date": bool,
    "help": bool,
    "hview": bool,
})


class ConvertCdiflistToGradsPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `ConvertCdiflistToGradsPyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_rvec: OutputPathType
    """Row-format of gradients (unit magnitude)."""
    output_bval: OutputPathType
    """Row-format of bvals."""
    output_cvec: OutputPathType
    """Col-format of gradients (scaled by b-values)."""


def convert_cdiflist_to_grads_py_params(
    cdiflist: InputPathType,
    bval_max: float,
    prefix: str,
    ver: bool = False,
    date: bool = False,
    help_: bool = False,
    hview: bool = False,
) -> ConvertCdiflistToGradsPyParametersTagged:
    """
    Build parameters.
    
    Args:
        cdiflist: Name(s) of cdiflist text file output by GE scanners when\
            acquiring DWIs.
        bval_max: Max bvalue used, which provides a reference value for scaling\
            everything else.
        prefix: Output basename for the subsequent grad and bvalue files\
            (suffix and extensions will be added).
        ver: Display current version.
        date: Display release/editing date of current version.
        help_: Display help in terminal.
        hview: Display help in terminal.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/convert_cdiflist_to_grads.py",
        "cdiflist": cdiflist,
        "bval_max": bval_max,
        "prefix": prefix,
        "ver": ver,
        "date": date,
        "help": help_,
        "hview": hview,
    }
    return params


def convert_cdiflist_to_grads_py_cargs(
    params: ConvertCdiflistToGradsPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("convert_cdiflist_to_grads.py")
    cargs.extend([
        "-cdiflist",
        execution.input_file(params.get("cdiflist", None))
    ])
    cargs.extend([
        "-bval_max",
        str(params.get("bval_max", None))
    ])
    cargs.extend([
        "-prefix",
        params.get("prefix", None)
    ])
    if params.get("ver", False):
        cargs.append("-ver")
    if params.get("date", False):
        cargs.append("-date")
    if params.get("help", False):
        cargs.append("-help")
    if params.get("hview", False):
        cargs.append("-h")
    return cargs


def convert_cdiflist_to_grads_py_outputs(
    params: ConvertCdiflistToGradsPyParameters,
    execution: Execution,
) -> ConvertCdiflistToGradsPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = ConvertCdiflistToGradsPyOutputs(
        root=execution.output_file("."),
        output_rvec=execution.output_file(params.get("prefix", None) + "_rvec.dat"),
        output_bval=execution.output_file(params.get("prefix", None) + "_bval.dat"),
        output_cvec=execution.output_file(params.get("prefix", None) + "_cvec.dat"),
    )
    return ret


def convert_cdiflist_to_grads_py_execute(
    params: ConvertCdiflistToGradsPyParameters,
    runner: Runner | None = None,
) -> ConvertCdiflistToGradsPyOutputs:
    """
    convert_cdiflist_to_grads.py
    
    This program reads in a GE cdiflist and outputs gradient file and file of
    bvalues for subsequent processing.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ConvertCdiflistToGradsPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(CONVERT_CDIFLIST_TO_GRADS_PY_METADATA)
    params = execution.params(params)
    cargs = convert_cdiflist_to_grads_py_cargs(params, execution)
    ret = convert_cdiflist_to_grads_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def convert_cdiflist_to_grads_py(
    cdiflist: InputPathType,
    bval_max: float,
    prefix: str,
    ver: bool = False,
    date: bool = False,
    help_: bool = False,
    hview: bool = False,
    runner: Runner | None = None,
) -> ConvertCdiflistToGradsPyOutputs:
    """
    convert_cdiflist_to_grads.py
    
    This program reads in a GE cdiflist and outputs gradient file and file of
    bvalues for subsequent processing.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        cdiflist: Name(s) of cdiflist text file output by GE scanners when\
            acquiring DWIs.
        bval_max: Max bvalue used, which provides a reference value for scaling\
            everything else.
        prefix: Output basename for the subsequent grad and bvalue files\
            (suffix and extensions will be added).
        ver: Display current version.
        date: Display release/editing date of current version.
        help_: Display help in terminal.
        hview: Display help in terminal.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ConvertCdiflistToGradsPyOutputs`).
    """
    params = convert_cdiflist_to_grads_py_params(
        cdiflist=cdiflist,
        bval_max=bval_max,
        prefix=prefix,
        ver=ver,
        date=date,
        help_=help_,
        hview=hview,
    )
    return convert_cdiflist_to_grads_py_execute(params, runner)


__all__ = [
    "CONVERT_CDIFLIST_TO_GRADS_PY_METADATA",
    "ConvertCdiflistToGradsPyOutputs",
    "convert_cdiflist_to_grads_py",
    "convert_cdiflist_to_grads_py_execute",
    "convert_cdiflist_to_grads_py_params",
]
