# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

CONVERT_SURFACE_METADATA = Metadata(
    id="57576de1b82aad67fcaed9b36da45f9b5b81e8fe.boutiques",
    name="ConvertSurface",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


ConvertSurfaceParameters = typing.TypedDict('ConvertSurfaceParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/ConvertSurface"]],
    "input_surface": str,
    "output_surface": str,
    "surface_volume": typing.NotRequired[str | None],
    "transform_tlrc": bool,
    "mni_rai": bool,
    "mni_lpi": bool,
    "xmat_1D": typing.NotRequired[str | None],
    "ixmat_1D": typing.NotRequired[str | None],
    "seed": typing.NotRequired[str | None],
    "native": bool,
})
ConvertSurfaceParametersTagged = typing.TypedDict('ConvertSurfaceParametersTagged', {
    "@type": typing.Literal["afni/ConvertSurface"],
    "input_surface": str,
    "output_surface": str,
    "surface_volume": typing.NotRequired[str | None],
    "transform_tlrc": bool,
    "mni_rai": bool,
    "mni_lpi": bool,
    "xmat_1D": typing.NotRequired[str | None],
    "ixmat_1D": typing.NotRequired[str | None],
    "seed": typing.NotRequired[str | None],
    "native": bool,
})


class ConvertSurfaceOutputs(typing.NamedTuple):
    """
    Output object returned when calling `ConvertSurfaceParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_surface_file: OutputPathType
    """The converted output surface file."""


def convert_surface_params(
    input_surface: str,
    output_surface: str,
    surface_volume: str | None = None,
    transform_tlrc: bool = False,
    mni_rai: bool = False,
    mni_lpi: bool = False,
    xmat_1_d: str | None = None,
    ixmat_1_d: str | None = None,
    seed: str | None = None,
    native: bool = False,
) -> ConvertSurfaceParametersTagged:
    """
    Build parameters.
    
    Args:
        input_surface: Specifies the input surface.
        output_surface: Specifies the output surface.
        surface_volume: Specifies a surface volume.
        transform_tlrc: Apply Talairach transform.
        mni_rai: Turn AFNI tlrc coordinates (RAI) into MNI coord space in RAI.
        mni_lpi: Turn AFNI tlrc coordinates (RAI) into MNI coord space in LPI.
        xmat_1_d: Apply transformation specified in 1D file.
        ixmat_1_d: Apply inverse transformation specified in 1D file.
        seed: Specify SEED to seed the random number generator for random\
            matrix generation.
        native: Write the output surface in the coordinate system native to its\
            format.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/ConvertSurface",
        "input_surface": input_surface,
        "output_surface": output_surface,
        "transform_tlrc": transform_tlrc,
        "mni_rai": mni_rai,
        "mni_lpi": mni_lpi,
        "native": native,
    }
    if surface_volume is not None:
        params["surface_volume"] = surface_volume
    if xmat_1_d is not None:
        params["xmat_1D"] = xmat_1_d
    if ixmat_1_d is not None:
        params["ixmat_1D"] = ixmat_1_d
    if seed is not None:
        params["seed"] = seed
    return params


def convert_surface_cargs(
    params: ConvertSurfaceParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("ConvertSurface")
    cargs.extend([
        "-i",
        params.get("input_surface", None)
    ])
    cargs.extend([
        "-o",
        params.get("output_surface", None)
    ])
    if params.get("surface_volume", None) is not None:
        cargs.extend([
            "-sv",
            params.get("surface_volume", None)
        ])
    if params.get("transform_tlrc", False):
        cargs.append("-tlrc")
    if params.get("mni_rai", False):
        cargs.append("-MNI_rai")
    if params.get("mni_lpi", False):
        cargs.append("-MNI_lpi")
    if params.get("xmat_1D", None) is not None:
        cargs.extend([
            "-xmat_1D",
            params.get("xmat_1D", None)
        ])
    if params.get("ixmat_1D", None) is not None:
        cargs.extend([
            "-ixmat_1D",
            params.get("ixmat_1D", None)
        ])
    if params.get("seed", None) is not None:
        cargs.extend([
            "-seed",
            params.get("seed", None)
        ])
    if params.get("native", False):
        cargs.append("-native")
    return cargs


def convert_surface_outputs(
    params: ConvertSurfaceParameters,
    execution: Execution,
) -> ConvertSurfaceOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = ConvertSurfaceOutputs(
        root=execution.output_file("."),
        output_surface_file=execution.output_file(params.get("output_surface", None)),
    )
    return ret


def convert_surface_execute(
    params: ConvertSurfaceParameters,
    runner: Runner | None = None,
) -> ConvertSurfaceOutputs:
    """
    ConvertSurface
    
    Reads in a surface and writes it out in another format. Only fields
    pertinent to SUMA are preserved.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ConvertSurfaceOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(CONVERT_SURFACE_METADATA)
    params = execution.params(params)
    cargs = convert_surface_cargs(params, execution)
    ret = convert_surface_outputs(params, execution)
    execution.run(cargs)
    return ret


def convert_surface(
    input_surface: str,
    output_surface: str,
    surface_volume: str | None = None,
    transform_tlrc: bool = False,
    mni_rai: bool = False,
    mni_lpi: bool = False,
    xmat_1_d: str | None = None,
    ixmat_1_d: str | None = None,
    seed: str | None = None,
    native: bool = False,
    runner: Runner | None = None,
) -> ConvertSurfaceOutputs:
    """
    ConvertSurface
    
    Reads in a surface and writes it out in another format. Only fields
    pertinent to SUMA are preserved.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_surface: Specifies the input surface.
        output_surface: Specifies the output surface.
        surface_volume: Specifies a surface volume.
        transform_tlrc: Apply Talairach transform.
        mni_rai: Turn AFNI tlrc coordinates (RAI) into MNI coord space in RAI.
        mni_lpi: Turn AFNI tlrc coordinates (RAI) into MNI coord space in LPI.
        xmat_1_d: Apply transformation specified in 1D file.
        ixmat_1_d: Apply inverse transformation specified in 1D file.
        seed: Specify SEED to seed the random number generator for random\
            matrix generation.
        native: Write the output surface in the coordinate system native to its\
            format.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ConvertSurfaceOutputs`).
    """
    params = convert_surface_params(
        input_surface=input_surface,
        output_surface=output_surface,
        surface_volume=surface_volume,
        transform_tlrc=transform_tlrc,
        mni_rai=mni_rai,
        mni_lpi=mni_lpi,
        xmat_1_d=xmat_1_d,
        ixmat_1_d=ixmat_1_d,
        seed=seed,
        native=native,
    )
    return convert_surface_execute(params, runner)


__all__ = [
    "CONVERT_SURFACE_METADATA",
    "ConvertSurfaceOutputs",
    "convert_surface",
    "convert_surface_execute",
    "convert_surface_params",
]
