# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

CONVEX_HULL_METADATA = Metadata(
    id="79e3bac48907406f7ee6520d509c9b76000ff72f.boutiques",
    name="ConvexHull",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


ConvexHullParameters = typing.TypedDict('ConvexHullParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/ConvexHull"]],
    "vol": typing.NotRequired[InputPathType | None],
    "isoval": typing.NotRequired[float | None],
    "isorange": typing.NotRequired[list[float] | None],
    "isocmask": typing.NotRequired[str | None],
    "xform": typing.NotRequired[str | None],
    "surface_input": typing.NotRequired[InputPathType | None],
    "surf_vol": typing.NotRequired[InputPathType | None],
    "input_1d": typing.NotRequired[InputPathType | None],
    "q_opt": typing.NotRequired[str | None],
    "proj_xy": bool,
    "orig_coord": bool,
    "these_coords": typing.NotRequired[InputPathType | None],
    "output_prefix": typing.NotRequired[str | None],
    "debug": typing.NotRequired[str | None],
    "novolreg": bool,
    "setenv": typing.NotRequired[str | None],
})
ConvexHullParametersTagged = typing.TypedDict('ConvexHullParametersTagged', {
    "@type": typing.Literal["afni/ConvexHull"],
    "vol": typing.NotRequired[InputPathType | None],
    "isoval": typing.NotRequired[float | None],
    "isorange": typing.NotRequired[list[float] | None],
    "isocmask": typing.NotRequired[str | None],
    "xform": typing.NotRequired[str | None],
    "surface_input": typing.NotRequired[InputPathType | None],
    "surf_vol": typing.NotRequired[InputPathType | None],
    "input_1d": typing.NotRequired[InputPathType | None],
    "q_opt": typing.NotRequired[str | None],
    "proj_xy": bool,
    "orig_coord": bool,
    "these_coords": typing.NotRequired[InputPathType | None],
    "output_prefix": typing.NotRequired[str | None],
    "debug": typing.NotRequired[str | None],
    "novolreg": bool,
    "setenv": typing.NotRequired[str | None],
})


class ConvexHullOutputs(typing.NamedTuple):
    """
    Output object returned when calling `ConvexHullParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    out_surf: OutputPathType | None
    """Output surface file"""


def convex_hull_params(
    vol: InputPathType | None = None,
    isoval: float | None = None,
    isorange: list[float] | None = None,
    isocmask: str | None = None,
    xform: str | None = None,
    surface_input: InputPathType | None = None,
    surf_vol: InputPathType | None = None,
    input_1d: InputPathType | None = None,
    q_opt: str | None = None,
    proj_xy: bool = False,
    orig_coord: bool = False,
    these_coords: InputPathType | None = None,
    output_prefix: str | None = None,
    debug: str | None = None,
    novolreg: bool = False,
    setenv: str | None = None,
) -> ConvexHullParametersTagged:
    """
    Build parameters.
    
    Args:
        vol: Input AFNI (or AFNI readable) volume.
        isoval: Create isosurface where volume = V.
        isorange: Create isosurface where V0 <= volume < V1.
        isocmask: Create isosurface where MASK_COM != 0. Example: -isocmask '-a\
            VOL+orig -expr (1-bool(a-V))' is equivalent to using -isoval V. NOTE:\
            Allowed only with -xform mask.
        xform: Transform to apply to volume values before searching for sign\
            change boundary. Options: mask, shift, none.
        surface_input: Input surface type.
        surf_vol: Specify a surface volume which contains a transform to apply\
            to the surface node coordinates.
        input_1d: Construct the triangulation of the points contained in 1D\
            file XYZ. Use AFNI's [] selectors to specify the XYZ columns.
        q_opt: Meshing option OPT. Options: convex_hull, triangulate_xy.
        proj_xy: Project points onto plane whose normal is the third principal\
            component. Then rotate projection so that plane is parallel to Z =\
            constant.
        orig_coord: Use original coordinates when writing surface, not\
            transformed ones.
        these_coords: Use coordinates in COORDS.1D when writing surface.
        output_prefix: Prefix of output surface. Specifies the format and\
            prefix of the surface.
        debug: Debugging level.
        novolreg: Ignore any Rotate, Volreg, Tagalign, or WarpDrive\
            transformations present in the Surface Volume.
        setenv: Set environment variable ENVname to be ENVvalue.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/ConvexHull",
        "proj_xy": proj_xy,
        "orig_coord": orig_coord,
        "novolreg": novolreg,
    }
    if vol is not None:
        params["vol"] = vol
    if isoval is not None:
        params["isoval"] = isoval
    if isorange is not None:
        params["isorange"] = isorange
    if isocmask is not None:
        params["isocmask"] = isocmask
    if xform is not None:
        params["xform"] = xform
    if surface_input is not None:
        params["surface_input"] = surface_input
    if surf_vol is not None:
        params["surf_vol"] = surf_vol
    if input_1d is not None:
        params["input_1d"] = input_1d
    if q_opt is not None:
        params["q_opt"] = q_opt
    if these_coords is not None:
        params["these_coords"] = these_coords
    if output_prefix is not None:
        params["output_prefix"] = output_prefix
    if debug is not None:
        params["debug"] = debug
    if setenv is not None:
        params["setenv"] = setenv
    return params


def convex_hull_cargs(
    params: ConvexHullParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("ConvexHull")
    if params.get("vol", None) is not None:
        cargs.extend([
            "-input",
            execution.input_file(params.get("vol", None))
        ])
    if params.get("isoval", None) is not None:
        cargs.extend([
            "-isoval",
            str(params.get("isoval", None))
        ])
    if params.get("isorange", None) is not None:
        cargs.extend([
            "-isorange",
            *map(str, params.get("isorange", None))
        ])
    if params.get("isocmask", None) is not None:
        cargs.extend([
            "-isocmask",
            params.get("isocmask", None)
        ])
    if params.get("xform", None) is not None:
        cargs.extend([
            "-xform",
            params.get("xform", None)
        ])
    if params.get("surface_input", None) is not None:
        cargs.extend([
            "-i_TYPE",
            execution.input_file(params.get("surface_input", None))
        ])
    if params.get("surf_vol", None) is not None:
        cargs.extend([
            "-sv",
            execution.input_file(params.get("surf_vol", None))
        ])
    if params.get("input_1d", None) is not None:
        cargs.extend([
            "-input_1D",
            execution.input_file(params.get("input_1d", None))
        ])
    if params.get("q_opt", None) is not None:
        cargs.extend([
            "-q_opt",
            params.get("q_opt", None)
        ])
    if params.get("proj_xy", False):
        cargs.append("-proj_xy")
    if params.get("orig_coord", False):
        cargs.append("-orig_coord")
    if params.get("these_coords", None) is not None:
        cargs.extend([
            "-these_coords",
            execution.input_file(params.get("these_coords", None))
        ])
    if params.get("output_prefix", None) is not None:
        cargs.extend([
            "-o_TYPE",
            params.get("output_prefix", None)
        ])
    if params.get("debug", None) is not None:
        cargs.extend([
            "-debug",
            params.get("debug", None)
        ])
    if params.get("novolreg", False):
        cargs.append("-novolreg")
    if params.get("setenv", None) is not None:
        cargs.extend([
            "-setenv",
            params.get("setenv", None)
        ])
    return cargs


def convex_hull_outputs(
    params: ConvexHullParameters,
    execution: Execution,
) -> ConvexHullOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = ConvexHullOutputs(
        root=execution.output_file("."),
        out_surf=execution.output_file(params.get("output_prefix", None)) if (params.get("output_prefix") is not None) else None,
    )
    return ret


def convex_hull_execute(
    params: ConvexHullParameters,
    runner: Runner | None = None,
) -> ConvexHullOutputs:
    """
    ConvexHull
    
    A program to find the convex hull, or perform a Delaunay triangulation of a
    set of points.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ConvexHullOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(CONVEX_HULL_METADATA)
    params = execution.params(params)
    cargs = convex_hull_cargs(params, execution)
    ret = convex_hull_outputs(params, execution)
    execution.run(cargs)
    return ret


def convex_hull(
    vol: InputPathType | None = None,
    isoval: float | None = None,
    isorange: list[float] | None = None,
    isocmask: str | None = None,
    xform: str | None = None,
    surface_input: InputPathType | None = None,
    surf_vol: InputPathType | None = None,
    input_1d: InputPathType | None = None,
    q_opt: str | None = None,
    proj_xy: bool = False,
    orig_coord: bool = False,
    these_coords: InputPathType | None = None,
    output_prefix: str | None = None,
    debug: str | None = None,
    novolreg: bool = False,
    setenv: str | None = None,
    runner: Runner | None = None,
) -> ConvexHullOutputs:
    """
    ConvexHull
    
    A program to find the convex hull, or perform a Delaunay triangulation of a
    set of points.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        vol: Input AFNI (or AFNI readable) volume.
        isoval: Create isosurface where volume = V.
        isorange: Create isosurface where V0 <= volume < V1.
        isocmask: Create isosurface where MASK_COM != 0. Example: -isocmask '-a\
            VOL+orig -expr (1-bool(a-V))' is equivalent to using -isoval V. NOTE:\
            Allowed only with -xform mask.
        xform: Transform to apply to volume values before searching for sign\
            change boundary. Options: mask, shift, none.
        surface_input: Input surface type.
        surf_vol: Specify a surface volume which contains a transform to apply\
            to the surface node coordinates.
        input_1d: Construct the triangulation of the points contained in 1D\
            file XYZ. Use AFNI's [] selectors to specify the XYZ columns.
        q_opt: Meshing option OPT. Options: convex_hull, triangulate_xy.
        proj_xy: Project points onto plane whose normal is the third principal\
            component. Then rotate projection so that plane is parallel to Z =\
            constant.
        orig_coord: Use original coordinates when writing surface, not\
            transformed ones.
        these_coords: Use coordinates in COORDS.1D when writing surface.
        output_prefix: Prefix of output surface. Specifies the format and\
            prefix of the surface.
        debug: Debugging level.
        novolreg: Ignore any Rotate, Volreg, Tagalign, or WarpDrive\
            transformations present in the Surface Volume.
        setenv: Set environment variable ENVname to be ENVvalue.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ConvexHullOutputs`).
    """
    params = convex_hull_params(
        vol=vol,
        isoval=isoval,
        isorange=isorange,
        isocmask=isocmask,
        xform=xform,
        surface_input=surface_input,
        surf_vol=surf_vol,
        input_1d=input_1d,
        q_opt=q_opt,
        proj_xy=proj_xy,
        orig_coord=orig_coord,
        these_coords=these_coords,
        output_prefix=output_prefix,
        debug=debug,
        novolreg=novolreg,
        setenv=setenv,
    )
    return convex_hull_execute(params, runner)


__all__ = [
    "CONVEX_HULL_METADATA",
    "ConvexHullOutputs",
    "convex_hull",
    "convex_hull_execute",
    "convex_hull_params",
]
