# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

COUNT_METADATA = Metadata(
    id="12da58ce0df53dbf18689eebeddd8ea53ea970cf.boutiques",
    name="count",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


CountParameters = typing.TypedDict('CountParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/count"]],
    "bot": str,
    "top": str,
    "step": typing.NotRequired[str | None],
    "seed": typing.NotRequired[float | None],
    "sseed": typing.NotRequired[str | None],
    "column": bool,
    "digits": typing.NotRequired[float | None],
    "form": typing.NotRequired[str | None],
    "root": typing.NotRequired[str | None],
    "sep": typing.NotRequired[str | None],
    "suffix": typing.NotRequired[str | None],
    "scale": typing.NotRequired[float | None],
    "comma": bool,
    "skipnmodm": typing.NotRequired[str | None],
})
CountParametersTagged = typing.TypedDict('CountParametersTagged', {
    "@type": typing.Literal["afni/count"],
    "bot": str,
    "top": str,
    "step": typing.NotRequired[str | None],
    "seed": typing.NotRequired[float | None],
    "sseed": typing.NotRequired[str | None],
    "column": bool,
    "digits": typing.NotRequired[float | None],
    "form": typing.NotRequired[str | None],
    "root": typing.NotRequired[str | None],
    "sep": typing.NotRequired[str | None],
    "suffix": typing.NotRequired[str | None],
    "scale": typing.NotRequired[float | None],
    "comma": bool,
    "skipnmodm": typing.NotRequired[str | None],
})


class CountOutputs(typing.NamedTuple):
    """
    Output object returned when calling `CountParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def count_params(
    bot: str,
    top: str,
    step: str | None = None,
    seed: float | None = None,
    sseed: str | None = None,
    column: bool = False,
    digits: float | None = None,
    form: str | None = None,
    root: str | None = None,
    sep: str | None = None,
    suffix: str | None = None,
    scale: float | None = None,
    comma: bool = False,
    skipnmodm: str | None = None,
) -> CountParametersTagged:
    """
    Build parameters.
    
    Args:
        bot: Starting number or character.
        top: Ending number or character.
        step: Stride step or mode (integer step size, R#, S# or S).
        seed: Seed number for random number generator.
        sseed: Seed string for random number generator.
        column: Write output, one number per line.
        digits: Number of digits to print.
        form: Custom format string for printing the numbers.
        root: String to print before the number.
        sep: Separator character between the numbers.
        suffix: String to print after the number.
        scale: Scale factor to multiply each number.
        comma: Put commas between the outputs.
        skipnmodm: Skip numbers with modulus.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/count",
        "bot": bot,
        "top": top,
        "column": column,
        "comma": comma,
    }
    if step is not None:
        params["step"] = step
    if seed is not None:
        params["seed"] = seed
    if sseed is not None:
        params["sseed"] = sseed
    if digits is not None:
        params["digits"] = digits
    if form is not None:
        params["form"] = form
    if root is not None:
        params["root"] = root
    if sep is not None:
        params["sep"] = sep
    if suffix is not None:
        params["suffix"] = suffix
    if scale is not None:
        params["scale"] = scale
    if skipnmodm is not None:
        params["skipnmodm"] = skipnmodm
    return params


def count_cargs(
    params: CountParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("count")
    cargs.append(params.get("bot", None))
    cargs.append(params.get("top", None))
    if params.get("step", None) is not None:
        cargs.append(params.get("step", None))
    if params.get("seed", None) is not None:
        cargs.extend([
            "-seed",
            str(params.get("seed", None))
        ])
    if params.get("sseed", None) is not None:
        cargs.extend([
            "-sseed",
            params.get("sseed", None)
        ])
    if params.get("column", False):
        cargs.append("-column")
    if params.get("digits", None) is not None:
        cargs.extend([
            "-digits",
            str(params.get("digits", None))
        ])
    if params.get("form", None) is not None:
        cargs.extend([
            "-form",
            params.get("form", None)
        ])
    if params.get("root", None) is not None:
        cargs.extend([
            "-root",
            params.get("root", None)
        ])
    if params.get("sep", None) is not None:
        cargs.extend([
            "-sep",
            params.get("sep", None)
        ])
    if params.get("suffix", None) is not None:
        cargs.extend([
            "-suffix",
            params.get("suffix", None)
        ])
    if params.get("scale", None) is not None:
        cargs.extend([
            "-scale",
            str(params.get("scale", None))
        ])
    if params.get("comma", False):
        cargs.append("-comma")
    if params.get("skipnmodm", None) is not None:
        cargs.extend([
            "-skipnmodm",
            params.get("skipnmodm", None)
        ])
    return cargs


def count_outputs(
    params: CountParameters,
    execution: Execution,
) -> CountOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = CountOutputs(
        root=execution.output_file("."),
    )
    return ret


def count_execute(
    params: CountParameters,
    runner: Runner | None = None,
) -> CountOutputs:
    """
    count
    
    Numbered copies generator with custom format support and random sequence
    options.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `CountOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(COUNT_METADATA)
    params = execution.params(params)
    cargs = count_cargs(params, execution)
    ret = count_outputs(params, execution)
    execution.run(cargs)
    return ret


def count(
    bot: str,
    top: str,
    step: str | None = None,
    seed: float | None = None,
    sseed: str | None = None,
    column: bool = False,
    digits: float | None = None,
    form: str | None = None,
    root: str | None = None,
    sep: str | None = None,
    suffix: str | None = None,
    scale: float | None = None,
    comma: bool = False,
    skipnmodm: str | None = None,
    runner: Runner | None = None,
) -> CountOutputs:
    """
    count
    
    Numbered copies generator with custom format support and random sequence
    options.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        bot: Starting number or character.
        top: Ending number or character.
        step: Stride step or mode (integer step size, R#, S# or S).
        seed: Seed number for random number generator.
        sseed: Seed string for random number generator.
        column: Write output, one number per line.
        digits: Number of digits to print.
        form: Custom format string for printing the numbers.
        root: String to print before the number.
        sep: Separator character between the numbers.
        suffix: String to print after the number.
        scale: Scale factor to multiply each number.
        comma: Put commas between the outputs.
        skipnmodm: Skip numbers with modulus.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `CountOutputs`).
    """
    params = count_params(
        bot=bot,
        top=top,
        step=step,
        seed=seed,
        sseed=sseed,
        column=column,
        digits=digits,
        form=form,
        root=root,
        sep=sep,
        suffix=suffix,
        scale=scale,
        comma=comma,
        skipnmodm=skipnmodm,
    )
    return count_execute(params, runner)


__all__ = [
    "COUNT_METADATA",
    "CountOutputs",
    "count",
    "count_execute",
    "count_params",
]
