# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

CREATE_ICOSAHEDRON_METADATA = Metadata(
    id="96e2d49d3eefc8b7ccf8343e61f4a58a876cac50.boutiques",
    name="CreateIcosahedron",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


CreateIcosahedronParameters = typing.TypedDict('CreateIcosahedronParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/CreateIcosahedron"]],
    "rad": typing.NotRequired[float | None],
    "rec_depth": typing.NotRequired[float | None],
    "lin_depth": typing.NotRequired[float | None],
    "min_nodes": typing.NotRequired[float | None],
    "nums": bool,
    "nums_quiet": bool,
    "center_coordinates": typing.NotRequired[list[float] | None],
    "to_sphere": bool,
    "output_prefix": typing.NotRequired[str | None],
    "help": bool,
})
CreateIcosahedronParametersTagged = typing.TypedDict('CreateIcosahedronParametersTagged', {
    "@type": typing.Literal["afni/CreateIcosahedron"],
    "rad": typing.NotRequired[float | None],
    "rec_depth": typing.NotRequired[float | None],
    "lin_depth": typing.NotRequired[float | None],
    "min_nodes": typing.NotRequired[float | None],
    "nums": bool,
    "nums_quiet": bool,
    "center_coordinates": typing.NotRequired[list[float] | None],
    "to_sphere": bool,
    "output_prefix": typing.NotRequired[str | None],
    "help": bool,
})


class CreateIcosahedronOutputs(typing.NamedTuple):
    """
    Output object returned when calling `CreateIcosahedronParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def create_icosahedron_params(
    rad: float | None = None,
    rec_depth: float | None = None,
    lin_depth: float | None = None,
    min_nodes: float | None = None,
    nums: bool = False,
    nums_quiet: bool = False,
    center_coordinates: list[float] | None = None,
    to_sphere: bool = False,
    output_prefix: str | None = None,
    help_: bool = False,
) -> CreateIcosahedronParametersTagged:
    """
    Build parameters.
    
    Args:
        rad: Size of icosahedron.
        rec_depth: Recursive tessellation depth for icosahedron.
        lin_depth: Number of edge divides for linear icosahedron tessellation.
        min_nodes: Automatically select the -ld value which produces an\
            icosahedron of at least MIN_NODES nodes.
        nums: Output the number of nodes (vertices), triangles, edges, total\
            volume, and total area then quit.
        nums_quiet: Output numbers in a less verbose manner.
        center_coordinates: Coordinates of the center of the icosahedron.
        to_sphere: Project nodes to sphere.
        output_prefix: Prefix for output files.
        help_: Display help message.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/CreateIcosahedron",
        "nums": nums,
        "nums_quiet": nums_quiet,
        "to_sphere": to_sphere,
        "help": help_,
    }
    if rad is not None:
        params["rad"] = rad
    if rec_depth is not None:
        params["rec_depth"] = rec_depth
    if lin_depth is not None:
        params["lin_depth"] = lin_depth
    if min_nodes is not None:
        params["min_nodes"] = min_nodes
    if center_coordinates is not None:
        params["center_coordinates"] = center_coordinates
    if output_prefix is not None:
        params["output_prefix"] = output_prefix
    return params


def create_icosahedron_cargs(
    params: CreateIcosahedronParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("CreateIcosahedron")
    if params.get("rad", None) is not None:
        cargs.extend([
            "-rad",
            str(params.get("rad", None))
        ])
    if params.get("rec_depth", None) is not None:
        cargs.extend([
            "-rd",
            str(params.get("rec_depth", None))
        ])
    if params.get("lin_depth", None) is not None:
        cargs.extend([
            "-ld",
            str(params.get("lin_depth", None))
        ])
    if params.get("min_nodes", None) is not None:
        cargs.extend([
            "-min_nodes",
            str(params.get("min_nodes", None))
        ])
    if params.get("nums", False):
        cargs.append("-nums")
    if params.get("nums_quiet", False):
        cargs.append("-nums_quiet")
    if params.get("center_coordinates", None) is not None:
        cargs.extend([
            "-ctr",
            *map(str, params.get("center_coordinates", None))
        ])
    if params.get("to_sphere", False):
        cargs.append("-tosphere")
    if params.get("output_prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("output_prefix", None)
        ])
    if params.get("help", False):
        cargs.append("-help")
    return cargs


def create_icosahedron_outputs(
    params: CreateIcosahedronParameters,
    execution: Execution,
) -> CreateIcosahedronOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = CreateIcosahedronOutputs(
        root=execution.output_file("."),
    )
    return ret


def create_icosahedron_execute(
    params: CreateIcosahedronParameters,
    runner: Runner | None = None,
) -> CreateIcosahedronOutputs:
    """
    CreateIcosahedron
    
    Tool to create an icosahedron with optional tessellation.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `CreateIcosahedronOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(CREATE_ICOSAHEDRON_METADATA)
    params = execution.params(params)
    cargs = create_icosahedron_cargs(params, execution)
    ret = create_icosahedron_outputs(params, execution)
    execution.run(cargs)
    return ret


def create_icosahedron(
    rad: float | None = None,
    rec_depth: float | None = None,
    lin_depth: float | None = None,
    min_nodes: float | None = None,
    nums: bool = False,
    nums_quiet: bool = False,
    center_coordinates: list[float] | None = None,
    to_sphere: bool = False,
    output_prefix: str | None = None,
    help_: bool = False,
    runner: Runner | None = None,
) -> CreateIcosahedronOutputs:
    """
    CreateIcosahedron
    
    Tool to create an icosahedron with optional tessellation.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        rad: Size of icosahedron.
        rec_depth: Recursive tessellation depth for icosahedron.
        lin_depth: Number of edge divides for linear icosahedron tessellation.
        min_nodes: Automatically select the -ld value which produces an\
            icosahedron of at least MIN_NODES nodes.
        nums: Output the number of nodes (vertices), triangles, edges, total\
            volume, and total area then quit.
        nums_quiet: Output numbers in a less verbose manner.
        center_coordinates: Coordinates of the center of the icosahedron.
        to_sphere: Project nodes to sphere.
        output_prefix: Prefix for output files.
        help_: Display help message.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `CreateIcosahedronOutputs`).
    """
    params = create_icosahedron_params(
        rad=rad,
        rec_depth=rec_depth,
        lin_depth=lin_depth,
        min_nodes=min_nodes,
        nums=nums,
        nums_quiet=nums_quiet,
        center_coordinates=center_coordinates,
        to_sphere=to_sphere,
        output_prefix=output_prefix,
        help_=help_,
    )
    return create_icosahedron_execute(params, runner)


__all__ = [
    "CREATE_ICOSAHEDRON_METADATA",
    "CreateIcosahedronOutputs",
    "create_icosahedron",
    "create_icosahedron_execute",
    "create_icosahedron_params",
]
