# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

DICOM_HDR_METADATA = Metadata(
    id="f0edec277c064e3934045c9faf56bc0c162e5eeb.boutiques",
    name="dicom_hdr",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


DicomHdrParameters = typing.TypedDict('DicomHdrParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/dicom_hdr"]],
    "files": list[InputPathType],
    "hex": bool,
    "noname": bool,
    "sexinfo": bool,
    "mulfram": bool,
    "v_dump": typing.NotRequired[float | None],
    "no_length": bool,
    "slice_times": bool,
    "slice_times_verb": bool,
    "siemens_csa_data": bool,
})
DicomHdrParametersTagged = typing.TypedDict('DicomHdrParametersTagged', {
    "@type": typing.Literal["afni/dicom_hdr"],
    "files": list[InputPathType],
    "hex": bool,
    "noname": bool,
    "sexinfo": bool,
    "mulfram": bool,
    "v_dump": typing.NotRequired[float | None],
    "no_length": bool,
    "slice_times": bool,
    "slice_times_verb": bool,
    "siemens_csa_data": bool,
})


class DicomHdrOutputs(typing.NamedTuple):
    """
    Output object returned when calling `DicomHdrParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def dicom_hdr_params(
    files: list[InputPathType],
    hex_: bool = False,
    noname: bool = False,
    sexinfo: bool = False,
    mulfram: bool = False,
    v_dump: float | None = None,
    no_length: bool = False,
    slice_times: bool = False,
    slice_times_verb: bool = False,
    siemens_csa_data: bool = False,
) -> DicomHdrParametersTagged:
    """
    Build parameters.
    
    Args:
        files: DICOM file(s) to read.
        hex_: Include hexadecimal printout for integer values.
        noname: Don't include element names in the printout.
        sexinfo: Dump Siemens EXtra INFO text (0029 1020), if present (can be\
            VERY lengthy).
        mulfram: Dump multi-frame information, if present (1 line per frame,\
            plus an XML-style header/footer). This option also implies -noname.
        v_dump: Dump n words of binary data also.
        no_length: Skip lengths and offsets (helps diffs).
        slice_times: Show slice times from Siemens mosaic images.
        slice_times_verb: Show slice times from Siemens mosaic images\
            verbosely. (multiple uses increase verbosity, can dump CSA data).
        siemens_csa_data: Same as 3 -slice_times_verb opts.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/dicom_hdr",
        "files": files,
        "hex": hex_,
        "noname": noname,
        "sexinfo": sexinfo,
        "mulfram": mulfram,
        "no_length": no_length,
        "slice_times": slice_times,
        "slice_times_verb": slice_times_verb,
        "siemens_csa_data": siemens_csa_data,
    }
    if v_dump is not None:
        params["v_dump"] = v_dump
    return params


def dicom_hdr_cargs(
    params: DicomHdrParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("dicom_hdr")
    cargs.extend([execution.input_file(f) for f in params.get("files", None)])
    if params.get("hex", False):
        cargs.append("-hex")
    if params.get("noname", False):
        cargs.append("-noname")
    if params.get("sexinfo", False):
        cargs.append("-sexinfo")
    if params.get("mulfram", False):
        cargs.append("-mulfram")
    if params.get("v_dump", None) is not None:
        cargs.extend([
            "-v",
            str(params.get("v_dump", None))
        ])
    if params.get("no_length", False):
        cargs.append("-no_length")
    if params.get("slice_times", False):
        cargs.append("-slice_times")
    if params.get("slice_times_verb", False):
        cargs.append("-slice_times_verb")
    if params.get("siemens_csa_data", False):
        cargs.append("-siemens_csa_data")
    return cargs


def dicom_hdr_outputs(
    params: DicomHdrParameters,
    execution: Execution,
) -> DicomHdrOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = DicomHdrOutputs(
        root=execution.output_file("."),
    )
    return ret


def dicom_hdr_execute(
    params: DicomHdrParameters,
    runner: Runner | None = None,
) -> DicomHdrOutputs:
    """
    dicom_hdr
    
    A tool to print DICOM file information to stdout.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `DicomHdrOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(DICOM_HDR_METADATA)
    params = execution.params(params)
    cargs = dicom_hdr_cargs(params, execution)
    ret = dicom_hdr_outputs(params, execution)
    execution.run(cargs)
    return ret


def dicom_hdr(
    files: list[InputPathType],
    hex_: bool = False,
    noname: bool = False,
    sexinfo: bool = False,
    mulfram: bool = False,
    v_dump: float | None = None,
    no_length: bool = False,
    slice_times: bool = False,
    slice_times_verb: bool = False,
    siemens_csa_data: bool = False,
    runner: Runner | None = None,
) -> DicomHdrOutputs:
    """
    dicom_hdr
    
    A tool to print DICOM file information to stdout.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        files: DICOM file(s) to read.
        hex_: Include hexadecimal printout for integer values.
        noname: Don't include element names in the printout.
        sexinfo: Dump Siemens EXtra INFO text (0029 1020), if present (can be\
            VERY lengthy).
        mulfram: Dump multi-frame information, if present (1 line per frame,\
            plus an XML-style header/footer). This option also implies -noname.
        v_dump: Dump n words of binary data also.
        no_length: Skip lengths and offsets (helps diffs).
        slice_times: Show slice times from Siemens mosaic images.
        slice_times_verb: Show slice times from Siemens mosaic images\
            verbosely. (multiple uses increase verbosity, can dump CSA data).
        siemens_csa_data: Same as 3 -slice_times_verb opts.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `DicomHdrOutputs`).
    """
    params = dicom_hdr_params(
        files=files,
        hex_=hex_,
        noname=noname,
        sexinfo=sexinfo,
        mulfram=mulfram,
        v_dump=v_dump,
        no_length=no_length,
        slice_times=slice_times,
        slice_times_verb=slice_times_verb,
        siemens_csa_data=siemens_csa_data,
    )
    return dicom_hdr_execute(params, runner)


__all__ = [
    "DICOM_HDR_METADATA",
    "DicomHdrOutputs",
    "dicom_hdr",
    "dicom_hdr_execute",
    "dicom_hdr_params",
]
