# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

DICOM_HINFO_METADATA = Metadata(
    id="2da4137ffb7a00f1751a6350ead114c9f0d440cc.boutiques",
    name="dicom_hinfo",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


DicomHinfoParameters = typing.TypedDict('DicomHinfoParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/dicom_hinfo"]],
    "tag": list[str],
    "sepstr": typing.NotRequired[str | None],
    "full_entry": bool,
    "no_name": bool,
    "namelast": bool,
    "files": list[InputPathType],
})
DicomHinfoParametersTagged = typing.TypedDict('DicomHinfoParametersTagged', {
    "@type": typing.Literal["afni/dicom_hinfo"],
    "tag": list[str],
    "sepstr": typing.NotRequired[str | None],
    "full_entry": bool,
    "no_name": bool,
    "namelast": bool,
    "files": list[InputPathType],
})


class DicomHinfoOutputs(typing.NamedTuple):
    """
    Output object returned when calling `DicomHinfoParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def dicom_hinfo_params(
    tag: list[str],
    files: list[InputPathType],
    sepstr: str | None = None,
    full_entry: bool = False,
    no_name: bool = False,
    namelast: bool = False,
) -> DicomHinfoParametersTagged:
    """
    Build parameters.
    
    Args:
        tag: Specify one or more DICOM tags to print, in the format aaaa,bbbb\
            where aaaa and bbbb are hexadecimal digits.
        files: DICOM file(s) to process.
        sepstr: Use the specified string to separate fields instead of space.
        full_entry: Output the full entry if it is more than one word or\
            contains white space.
        no_name: Omit the filename from the output.
        namelast: Place the filename last in the output instead of first.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/dicom_hinfo",
        "tag": tag,
        "full_entry": full_entry,
        "no_name": no_name,
        "namelast": namelast,
        "files": files,
    }
    if sepstr is not None:
        params["sepstr"] = sepstr
    return params


def dicom_hinfo_cargs(
    params: DicomHinfoParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("dicom_hinfo")
    cargs.extend([
        "-tag",
        *params.get("tag", None)
    ])
    if params.get("sepstr", None) is not None:
        cargs.extend([
            "-sepstr",
            params.get("sepstr", None)
        ])
    if params.get("full_entry", False):
        cargs.append("-full_entry")
    if params.get("no_name", False):
        cargs.append("-no_name")
    if params.get("namelast", False):
        cargs.append("-namelast")
    cargs.extend([execution.input_file(f) for f in params.get("files", None)])
    return cargs


def dicom_hinfo_outputs(
    params: DicomHinfoParameters,
    execution: Execution,
) -> DicomHinfoOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = DicomHinfoOutputs(
        root=execution.output_file("."),
    )
    return ret


def dicom_hinfo_execute(
    params: DicomHinfoParameters,
    runner: Runner | None = None,
) -> DicomHinfoOutputs:
    """
    dicom_hinfo
    
    Prints selected information from one or more DICOM files to stdout.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `DicomHinfoOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(DICOM_HINFO_METADATA)
    params = execution.params(params)
    cargs = dicom_hinfo_cargs(params, execution)
    ret = dicom_hinfo_outputs(params, execution)
    execution.run(cargs)
    return ret


def dicom_hinfo(
    tag: list[str],
    files: list[InputPathType],
    sepstr: str | None = None,
    full_entry: bool = False,
    no_name: bool = False,
    namelast: bool = False,
    runner: Runner | None = None,
) -> DicomHinfoOutputs:
    """
    dicom_hinfo
    
    Prints selected information from one or more DICOM files to stdout.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        tag: Specify one or more DICOM tags to print, in the format aaaa,bbbb\
            where aaaa and bbbb are hexadecimal digits.
        files: DICOM file(s) to process.
        sepstr: Use the specified string to separate fields instead of space.
        full_entry: Output the full entry if it is more than one word or\
            contains white space.
        no_name: Omit the filename from the output.
        namelast: Place the filename last in the output instead of first.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `DicomHinfoOutputs`).
    """
    params = dicom_hinfo_params(
        tag=tag,
        sepstr=sepstr,
        full_entry=full_entry,
        no_name=no_name,
        namelast=namelast,
        files=files,
    )
    return dicom_hinfo_execute(params, runner)


__all__ = [
    "DICOM_HINFO_METADATA",
    "DicomHinfoOutputs",
    "dicom_hinfo",
    "dicom_hinfo_execute",
    "dicom_hinfo_params",
]
