# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

DTISTUDIO_FIBERTO_SEGMENTS_METADATA = Metadata(
    id="153d8358c9e73a90c71c3f69eea088cdcd8f1746.boutiques",
    name="DTIStudioFibertoSegments",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


DtistudioFibertoSegmentsParameters = typing.TypedDict('DtistudioFibertoSegmentsParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/DTIStudioFibertoSegments"]],
    "dataset": InputPathType,
    "output_file": typing.NotRequired[str | None],
    "swap_flag": bool,
})
DtistudioFibertoSegmentsParametersTagged = typing.TypedDict('DtistudioFibertoSegmentsParametersTagged', {
    "@type": typing.Literal["afni/DTIStudioFibertoSegments"],
    "dataset": InputPathType,
    "output_file": typing.NotRequired[str | None],
    "swap_flag": bool,
})


class DtistudioFibertoSegmentsOutputs(typing.NamedTuple):
    """
    Output object returned when calling `DtistudioFibertoSegmentsParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_segment_file: OutputPathType | None
    """Output SUMA segment file"""


def dtistudio_fiberto_segments_params(
    dataset: InputPathType,
    output_file: str | None = None,
    swap_flag: bool = False,
) -> DtistudioFibertoSegmentsParametersTagged:
    """
    Build parameters.
    
    Args:
        dataset: Input dataset file.
        output_file: Name of the output file (default is rawxyzseg.dat).
        swap_flag: Swap bytes in data.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/DTIStudioFibertoSegments",
        "dataset": dataset,
        "swap_flag": swap_flag,
    }
    if output_file is not None:
        params["output_file"] = output_file
    return params


def dtistudio_fiberto_segments_cargs(
    params: DtistudioFibertoSegmentsParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("DTIStudioFibertoSegments")
    cargs.append(execution.input_file(params.get("dataset", None)))
    if params.get("output_file", None) is not None:
        cargs.extend([
            "-output",
            params.get("output_file", None)
        ])
    if params.get("swap_flag", False):
        cargs.append("-swap")
    return cargs


def dtistudio_fiberto_segments_outputs(
    params: DtistudioFibertoSegmentsParameters,
    execution: Execution,
) -> DtistudioFibertoSegmentsOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = DtistudioFibertoSegmentsOutputs(
        root=execution.output_file("."),
        output_segment_file=execution.output_file(params.get("output_file", None)) if (params.get("output_file") is not None) else None,
    )
    return ret


def dtistudio_fiberto_segments_execute(
    params: DtistudioFibertoSegmentsParameters,
    runner: Runner | None = None,
) -> DtistudioFibertoSegmentsOutputs:
    """
    DTIStudioFibertoSegments
    
    Convert a DTIStudio Fiber file to a SUMA segment file.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `DtistudioFibertoSegmentsOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(DTISTUDIO_FIBERTO_SEGMENTS_METADATA)
    params = execution.params(params)
    cargs = dtistudio_fiberto_segments_cargs(params, execution)
    ret = dtistudio_fiberto_segments_outputs(params, execution)
    execution.run(cargs)
    return ret


def dtistudio_fiberto_segments(
    dataset: InputPathType,
    output_file: str | None = None,
    swap_flag: bool = False,
    runner: Runner | None = None,
) -> DtistudioFibertoSegmentsOutputs:
    """
    DTIStudioFibertoSegments
    
    Convert a DTIStudio Fiber file to a SUMA segment file.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dataset: Input dataset file.
        output_file: Name of the output file (default is rawxyzseg.dat).
        swap_flag: Swap bytes in data.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `DtistudioFibertoSegmentsOutputs`).
    """
    params = dtistudio_fiberto_segments_params(
        dataset=dataset,
        output_file=output_file,
        swap_flag=swap_flag,
    )
    return dtistudio_fiberto_segments_execute(params, runner)


__all__ = [
    "DTISTUDIO_FIBERTO_SEGMENTS_METADATA",
    "DtistudioFibertoSegmentsOutputs",
    "dtistudio_fiberto_segments",
    "dtistudio_fiberto_segments_execute",
    "dtistudio_fiberto_segments_params",
]
