# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

EPI_B0_CORRECT_PY_METADATA = Metadata(
    id="3754a6613428decb4ca608a0210df3417d707879.boutiques",
    name="epi_b0_correct.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


EpiB0CorrectPyParameters = typing.TypedDict('EpiB0CorrectPyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/epi_b0_correct.py"]],
    "prefix": str,
    "input_freq": InputPathType,
    "input_epi": InputPathType,
    "input_mask": typing.NotRequired[InputPathType | None],
    "input_magn": typing.NotRequired[InputPathType | None],
    "input_anat": typing.NotRequired[InputPathType | None],
    "input_json": typing.NotRequired[InputPathType | None],
    "epi_pe_dir": str,
    "epi_pe_bwpp": typing.NotRequired[float | None],
    "epi_pe_echo_sp": typing.NotRequired[float | None],
    "epi_pe_vox_dim": typing.NotRequired[float | None],
    "scale_freq": typing.NotRequired[float | None],
    "out_cmds": typing.NotRequired[str | None],
    "out_pars": typing.NotRequired[str | None],
    "wdir_name": typing.NotRequired[str | None],
    "blur_sigma": typing.NotRequired[float | None],
    "do_recenter_freq": typing.NotRequired[str | None],
    "mask_dilate": typing.NotRequired[list[float] | None],
    "no_clean": bool,
    "qc_box_focus_ulay": bool,
    "no_qc_image": bool,
    "help": bool,
    "ver": bool,
    "date": bool,
})
EpiB0CorrectPyParametersTagged = typing.TypedDict('EpiB0CorrectPyParametersTagged', {
    "@type": typing.Literal["afni/epi_b0_correct.py"],
    "prefix": str,
    "input_freq": InputPathType,
    "input_epi": InputPathType,
    "input_mask": typing.NotRequired[InputPathType | None],
    "input_magn": typing.NotRequired[InputPathType | None],
    "input_anat": typing.NotRequired[InputPathType | None],
    "input_json": typing.NotRequired[InputPathType | None],
    "epi_pe_dir": str,
    "epi_pe_bwpp": typing.NotRequired[float | None],
    "epi_pe_echo_sp": typing.NotRequired[float | None],
    "epi_pe_vox_dim": typing.NotRequired[float | None],
    "scale_freq": typing.NotRequired[float | None],
    "out_cmds": typing.NotRequired[str | None],
    "out_pars": typing.NotRequired[str | None],
    "wdir_name": typing.NotRequired[str | None],
    "blur_sigma": typing.NotRequired[float | None],
    "do_recenter_freq": typing.NotRequired[str | None],
    "mask_dilate": typing.NotRequired[list[float] | None],
    "no_clean": bool,
    "qc_box_focus_ulay": bool,
    "no_qc_image": bool,
    "help": bool,
    "ver": bool,
    "date": bool,
})


class EpiB0CorrectPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `EpiB0CorrectPyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    warp_dset: OutputPathType
    """Warp dataset containing the warp along the phase encode axis."""
    cmds_script: OutputPathType
    """Script of the commands used to generate the warp and process the EPI."""
    params_txt: OutputPathType
    """Text file of parameters input or derived from datasets."""
    unwarped_epi: OutputPathType
    """EPI dataset with estimated distortion correction applied."""
    qc_image_dir: OutputPathType
    """Directory containing QC images."""


def epi_b0_correct_py_params(
    prefix: str,
    input_freq: InputPathType,
    input_epi: InputPathType,
    epi_pe_dir: str,
    input_mask: InputPathType | None = None,
    input_magn: InputPathType | None = None,
    input_anat: InputPathType | None = None,
    input_json: InputPathType | None = None,
    epi_pe_bwpp: float | None = None,
    epi_pe_echo_sp: float | None = None,
    epi_pe_vox_dim: float | None = None,
    scale_freq: float | None = None,
    out_cmds: str | None = None,
    out_pars: str | None = None,
    wdir_name: str | None = None,
    blur_sigma: float | None = None,
    do_recenter_freq: str | None = None,
    mask_dilate: list[float] | None = None,
    no_clean: bool = False,
    qc_box_focus_ulay: bool = False,
    no_qc_image: bool = False,
    help_: bool = False,
    ver: bool = False,
    date: bool = False,
) -> EpiB0CorrectPyParametersTagged:
    """
    Build parameters.
    
    Args:
        prefix: Prefix of output files; can include path.
        input_freq: Phase dataset (frequency volume); should be at similar\
            resolution and FOV as the EPI dataset; must be scaled appropriately.
        input_epi: EPI dataset to which B0 distortion correction will be\
            applied.
        epi_pe_dir: Direction (axis) of phase encoding, e.g., AP, PA, RL, ...
        input_mask: Mask of brain volume.
        input_magn: Magnitude dataset from which to estimate brain mask; can be\
            used for QC imaging.
        input_anat: Anatomical dataset to be used as underlay for QC images\
            (optional).
        input_json: JSON file containing parameters about the EPI dataset.
        epi_pe_bwpp: Bandwidth per pixel (in Hz) in the EPI dataset along the\
            phase encode direction.
        epi_pe_echo_sp: Effective TE spacing of the phase encoded volume, in\
            seconds.
        epi_pe_vox_dim: Voxel size along the EPI dataset's phase encode axis,\
            in mm.
        scale_freq: Scale to apply to frequency volume to match units (def:\
            SF=1.0).
        out_cmds: Name for output script recording commands (def:\
            PREFIX_cmds.tcsh).
        out_pars: Name for output text file recording relevant parameters (def:\
            PREFIX_pars.txt).
        wdir_name: Working directory name (def: automatic name).
        blur_sigma: Amount of blurring to apply to masked phase encode dataset\
            (def: BS=9).
        do_recenter_freq: Method to recenter the phase volume within the brain\
            mask (def: MC=mode).
        mask_dilate: Erosion and dilation parameters for automask (when using\
            magnitude image).
        no_clean: Don't remove the temporary directory of intermediate files.
        qc_box_focus_ulay: Focus the QC images on an automask region of the\
            underlay dataset.
        no_qc_image: Don't generate QC images.
        help_: Display program help in terminal.
        ver: Display program version number in terminal.
        date: Display date of program's last update in terminal.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/epi_b0_correct.py",
        "prefix": prefix,
        "input_freq": input_freq,
        "input_epi": input_epi,
        "epi_pe_dir": epi_pe_dir,
        "no_clean": no_clean,
        "qc_box_focus_ulay": qc_box_focus_ulay,
        "no_qc_image": no_qc_image,
        "help": help_,
        "ver": ver,
        "date": date,
    }
    if input_mask is not None:
        params["input_mask"] = input_mask
    if input_magn is not None:
        params["input_magn"] = input_magn
    if input_anat is not None:
        params["input_anat"] = input_anat
    if input_json is not None:
        params["input_json"] = input_json
    if epi_pe_bwpp is not None:
        params["epi_pe_bwpp"] = epi_pe_bwpp
    if epi_pe_echo_sp is not None:
        params["epi_pe_echo_sp"] = epi_pe_echo_sp
    if epi_pe_vox_dim is not None:
        params["epi_pe_vox_dim"] = epi_pe_vox_dim
    if scale_freq is not None:
        params["scale_freq"] = scale_freq
    if out_cmds is not None:
        params["out_cmds"] = out_cmds
    if out_pars is not None:
        params["out_pars"] = out_pars
    if wdir_name is not None:
        params["wdir_name"] = wdir_name
    if blur_sigma is not None:
        params["blur_sigma"] = blur_sigma
    if do_recenter_freq is not None:
        params["do_recenter_freq"] = do_recenter_freq
    if mask_dilate is not None:
        params["mask_dilate"] = mask_dilate
    return params


def epi_b0_correct_py_cargs(
    params: EpiB0CorrectPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("epi_b0_correct.py")
    cargs.append(params.get("prefix", None))
    cargs.extend([
        "-in_freq",
        execution.input_file(params.get("input_freq", None))
    ])
    cargs.extend([
        "-in_epi",
        execution.input_file(params.get("input_epi", None))
    ])
    if params.get("input_mask", None) is not None:
        cargs.extend([
            "-in_mask",
            execution.input_file(params.get("input_mask", None))
        ])
    if params.get("input_magn", None) is not None:
        cargs.extend([
            "-in_magn",
            execution.input_file(params.get("input_magn", None))
        ])
    if params.get("input_anat", None) is not None:
        cargs.extend([
            "-in_anat",
            execution.input_file(params.get("input_anat", None))
        ])
    if params.get("input_json", None) is not None:
        cargs.extend([
            "-in_epi_json",
            execution.input_file(params.get("input_json", None))
        ])
    cargs.extend([
        "-epi_pe_dir",
        params.get("epi_pe_dir", None)
    ])
    if params.get("epi_pe_bwpp", None) is not None:
        cargs.extend([
            "-epi_pe_bwpp",
            str(params.get("epi_pe_bwpp", None))
        ])
    if params.get("epi_pe_echo_sp", None) is not None:
        cargs.extend([
            "-epi_pe_echo_sp",
            str(params.get("epi_pe_echo_sp", None))
        ])
    if params.get("epi_pe_vox_dim", None) is not None:
        cargs.extend([
            "-epi_pe_voxdim",
            str(params.get("epi_pe_vox_dim", None))
        ])
    if params.get("scale_freq", None) is not None:
        cargs.extend([
            "-scale_freq",
            str(params.get("scale_freq", None))
        ])
    if params.get("out_cmds", None) is not None:
        cargs.extend([
            "-out_cmds",
            params.get("out_cmds", None)
        ])
    if params.get("out_pars", None) is not None:
        cargs.extend([
            "-out_pars",
            params.get("out_pars", None)
        ])
    if params.get("wdir_name", None) is not None:
        cargs.extend([
            "-wdir_name",
            params.get("wdir_name", None)
        ])
    if params.get("blur_sigma", None) is not None:
        cargs.extend([
            "-blur_sigma",
            str(params.get("blur_sigma", None))
        ])
    if params.get("do_recenter_freq", None) is not None:
        cargs.extend([
            "-do_recenter_freq",
            params.get("do_recenter_freq", None)
        ])
    if params.get("mask_dilate", None) is not None:
        cargs.extend([
            "-mask_dilate",
            *map(str, params.get("mask_dilate", None))
        ])
    if params.get("no_clean", False):
        cargs.append("-no_clean")
    if params.get("qc_box_focus_ulay", False):
        cargs.append("-qc_box_focus_ulay")
    if params.get("no_qc_image", False):
        cargs.append("-no_qc_image")
    if params.get("help", False):
        cargs.append("-help")
    if params.get("ver", False):
        cargs.append("-ver")
    if params.get("date", False):
        cargs.append("-date")
    return cargs


def epi_b0_correct_py_outputs(
    params: EpiB0CorrectPyParameters,
    execution: Execution,
) -> EpiB0CorrectPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = EpiB0CorrectPyOutputs(
        root=execution.output_file("."),
        warp_dset=execution.output_file(params.get("prefix", None) + "_WARP.nii.gz"),
        cmds_script=execution.output_file(params.get("prefix", None) + "_cmds.tcsh"),
        params_txt=execution.output_file(params.get("prefix", None) + "_pars.txt"),
        unwarped_epi=execution.output_file(params.get("prefix", None) + "_unwarped.nii.gz"),
        qc_image_dir=execution.output_file(params.get("prefix", None) + "_QC/"),
    )
    return ret


def epi_b0_correct_py_execute(
    params: EpiB0CorrectPyParameters,
    runner: Runner | None = None,
) -> EpiB0CorrectPyOutputs:
    """
    epi_b0_correct.py
    
    B0 distortion correction tool using an acquired frequency (phase) image.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `EpiB0CorrectPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(EPI_B0_CORRECT_PY_METADATA)
    params = execution.params(params)
    cargs = epi_b0_correct_py_cargs(params, execution)
    ret = epi_b0_correct_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def epi_b0_correct_py(
    prefix: str,
    input_freq: InputPathType,
    input_epi: InputPathType,
    epi_pe_dir: str,
    input_mask: InputPathType | None = None,
    input_magn: InputPathType | None = None,
    input_anat: InputPathType | None = None,
    input_json: InputPathType | None = None,
    epi_pe_bwpp: float | None = None,
    epi_pe_echo_sp: float | None = None,
    epi_pe_vox_dim: float | None = None,
    scale_freq: float | None = None,
    out_cmds: str | None = None,
    out_pars: str | None = None,
    wdir_name: str | None = None,
    blur_sigma: float | None = None,
    do_recenter_freq: str | None = None,
    mask_dilate: list[float] | None = None,
    no_clean: bool = False,
    qc_box_focus_ulay: bool = False,
    no_qc_image: bool = False,
    help_: bool = False,
    ver: bool = False,
    date: bool = False,
    runner: Runner | None = None,
) -> EpiB0CorrectPyOutputs:
    """
    epi_b0_correct.py
    
    B0 distortion correction tool using an acquired frequency (phase) image.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        prefix: Prefix of output files; can include path.
        input_freq: Phase dataset (frequency volume); should be at similar\
            resolution and FOV as the EPI dataset; must be scaled appropriately.
        input_epi: EPI dataset to which B0 distortion correction will be\
            applied.
        epi_pe_dir: Direction (axis) of phase encoding, e.g., AP, PA, RL, ...
        input_mask: Mask of brain volume.
        input_magn: Magnitude dataset from which to estimate brain mask; can be\
            used for QC imaging.
        input_anat: Anatomical dataset to be used as underlay for QC images\
            (optional).
        input_json: JSON file containing parameters about the EPI dataset.
        epi_pe_bwpp: Bandwidth per pixel (in Hz) in the EPI dataset along the\
            phase encode direction.
        epi_pe_echo_sp: Effective TE spacing of the phase encoded volume, in\
            seconds.
        epi_pe_vox_dim: Voxel size along the EPI dataset's phase encode axis,\
            in mm.
        scale_freq: Scale to apply to frequency volume to match units (def:\
            SF=1.0).
        out_cmds: Name for output script recording commands (def:\
            PREFIX_cmds.tcsh).
        out_pars: Name for output text file recording relevant parameters (def:\
            PREFIX_pars.txt).
        wdir_name: Working directory name (def: automatic name).
        blur_sigma: Amount of blurring to apply to masked phase encode dataset\
            (def: BS=9).
        do_recenter_freq: Method to recenter the phase volume within the brain\
            mask (def: MC=mode).
        mask_dilate: Erosion and dilation parameters for automask (when using\
            magnitude image).
        no_clean: Don't remove the temporary directory of intermediate files.
        qc_box_focus_ulay: Focus the QC images on an automask region of the\
            underlay dataset.
        no_qc_image: Don't generate QC images.
        help_: Display program help in terminal.
        ver: Display program version number in terminal.
        date: Display date of program's last update in terminal.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `EpiB0CorrectPyOutputs`).
    """
    params = epi_b0_correct_py_params(
        prefix=prefix,
        input_freq=input_freq,
        input_epi=input_epi,
        input_mask=input_mask,
        input_magn=input_magn,
        input_anat=input_anat,
        input_json=input_json,
        epi_pe_dir=epi_pe_dir,
        epi_pe_bwpp=epi_pe_bwpp,
        epi_pe_echo_sp=epi_pe_echo_sp,
        epi_pe_vox_dim=epi_pe_vox_dim,
        scale_freq=scale_freq,
        out_cmds=out_cmds,
        out_pars=out_pars,
        wdir_name=wdir_name,
        blur_sigma=blur_sigma,
        do_recenter_freq=do_recenter_freq,
        mask_dilate=mask_dilate,
        no_clean=no_clean,
        qc_box_focus_ulay=qc_box_focus_ulay,
        no_qc_image=no_qc_image,
        help_=help_,
        ver=ver,
        date=date,
    )
    return epi_b0_correct_py_execute(params, runner)


__all__ = [
    "EPI_B0_CORRECT_PY_METADATA",
    "EpiB0CorrectPyOutputs",
    "epi_b0_correct_py",
    "epi_b0_correct_py_execute",
    "epi_b0_correct_py_params",
]
