# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

FAT_MVM_GRIDCONV_PY_METADATA = Metadata(
    id="b082285800362f5644c0f2275c7fb8980bd9cc47.boutiques",
    name="fat_mvm_gridconv.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


FatMvmGridconvPyParameters = typing.TypedDict('FatMvmGridconvPyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/fat_mvm_gridconv.py"]],
    "matrix_files": typing.NotRequired[str | None],
    "list_file": typing.NotRequired[InputPathType | None],
})
FatMvmGridconvPyParametersTagged = typing.TypedDict('FatMvmGridconvPyParametersTagged', {
    "@type": typing.Literal["afni/fat_mvm_gridconv.py"],
    "matrix_files": typing.NotRequired[str | None],
    "list_file": typing.NotRequired[InputPathType | None],
})


class FatMvmGridconvPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `FatMvmGridconvPyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def fat_mvm_gridconv_py_params(
    matrix_files: str | None = None,
    list_file: InputPathType | None = None,
) -> FatMvmGridconvPyParametersTagged:
    """
    Build parameters.
    
    Args:
        matrix_files: Provide the set of matrix (*.grid) files as a searchable\
            path. This can be a globbable entry in quotes containing wildcard\
            characters.
        list_file: Provide the matrix (*.grid) files by explicit path in a text\
            file. The LIST text file must contain at least one column (path to\
            subject matrix file) with an optional second column (output file\
            names). If no second column is given, the default '_MOD.grid' postfix\
            is applied.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/fat_mvm_gridconv.py",
    }
    if matrix_files is not None:
        params["matrix_files"] = matrix_files
    if list_file is not None:
        params["list_file"] = list_file
    return params


def fat_mvm_gridconv_py_cargs(
    params: FatMvmGridconvPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("fat_mvm_gridconv.py")
    if params.get("matrix_files", None) is not None:
        cargs.extend([
            "-m",
            params.get("matrix_files", None)
        ])
    if params.get("list_file", None) is not None:
        cargs.extend([
            "-l",
            execution.input_file(params.get("list_file", None))
        ])
    return cargs


def fat_mvm_gridconv_py_outputs(
    params: FatMvmGridconvPyParameters,
    execution: Execution,
) -> FatMvmGridconvPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = FatMvmGridconvPyOutputs(
        root=execution.output_file("."),
    )
    return ret


def fat_mvm_gridconv_py_execute(
    params: FatMvmGridconvPyParameters,
    runner: Runner | None = None,
) -> FatMvmGridconvPyOutputs:
    """
    fat_mvm_gridconv.py
    
    Preprocess 'old school' *.grid files for statistical modeling using 3dMVM.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `FatMvmGridconvPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(FAT_MVM_GRIDCONV_PY_METADATA)
    params = execution.params(params)
    cargs = fat_mvm_gridconv_py_cargs(params, execution)
    ret = fat_mvm_gridconv_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def fat_mvm_gridconv_py(
    matrix_files: str | None = None,
    list_file: InputPathType | None = None,
    runner: Runner | None = None,
) -> FatMvmGridconvPyOutputs:
    """
    fat_mvm_gridconv.py
    
    Preprocess 'old school' *.grid files for statistical modeling using 3dMVM.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        matrix_files: Provide the set of matrix (*.grid) files as a searchable\
            path. This can be a globbable entry in quotes containing wildcard\
            characters.
        list_file: Provide the matrix (*.grid) files by explicit path in a text\
            file. The LIST text file must contain at least one column (path to\
            subject matrix file) with an optional second column (output file\
            names). If no second column is given, the default '_MOD.grid' postfix\
            is applied.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `FatMvmGridconvPyOutputs`).
    """
    params = fat_mvm_gridconv_py_params(
        matrix_files=matrix_files,
        list_file=list_file,
    )
    return fat_mvm_gridconv_py_execute(params, runner)


__all__ = [
    "FAT_MVM_GRIDCONV_PY_METADATA",
    "FatMvmGridconvPyOutputs",
    "fat_mvm_gridconv_py",
    "fat_mvm_gridconv_py_execute",
    "fat_mvm_gridconv_py_params",
]
