# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

FAT_MVM_PREP_PY_METADATA = Metadata(
    id="54af44a0131490c3e76aabb802ff1e00c7d8f153.boutiques",
    name="fat_mvm_prep.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


FatMvmPrepPyParameters = typing.TypedDict('FatMvmPrepPyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/fat_mvm_prep.py"]],
    "prefix": str,
    "csv_file": InputPathType,
    "matrix_files": typing.NotRequired[str | None],
    "list_match": typing.NotRequired[InputPathType | None],
    "unionize_rois": bool,
    "na_warn_off": bool,
    "extern_labels_no": bool,
})
FatMvmPrepPyParametersTagged = typing.TypedDict('FatMvmPrepPyParametersTagged', {
    "@type": typing.Literal["afni/fat_mvm_prep.py"],
    "prefix": str,
    "csv_file": InputPathType,
    "matrix_files": typing.NotRequired[str | None],
    "list_match": typing.NotRequired[InputPathType | None],
    "unionize_rois": bool,
    "na_warn_off": bool,
    "extern_labels_no": bool,
})


class FatMvmPrepPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `FatMvmPrepPyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    mvmtbl: OutputPathType
    """Output tabular text file for 3dMVM."""
    mvmprep_log: OutputPathType
    """Log file detailing subject matching and ROI list."""


def fat_mvm_prep_py_params(
    prefix: str,
    csv_file: InputPathType,
    matrix_files: str | None = None,
    list_match: InputPathType | None = None,
    unionize_rois: bool = False,
    na_warn_off: bool = False,
    extern_labels_no: bool = False,
) -> FatMvmPrepPyParametersTagged:
    """
    Build parameters.
    
    Args:
        prefix: Prefix for output files.
        csv_file: Comma-separated variable (CSV) file for input.
        matrix_files: Set of matrix (*.grid or *.netcc) files by searchable\
            path.
        list_match: Text file containing two columns: path to subject matrix\
            file and CSV IDs.
        unionize_rois: Make the ROI list as the union of elements across the\
            group.
        na_warn_off: Turn off the automatic warnings as the data table is\
            created.
        extern_labels_no: Turn off the writing/usage of user-defined labels in\
            the *.grid/*.netcc files.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/fat_mvm_prep.py",
        "prefix": prefix,
        "csv_file": csv_file,
        "unionize_rois": unionize_rois,
        "na_warn_off": na_warn_off,
        "extern_labels_no": extern_labels_no,
    }
    if matrix_files is not None:
        params["matrix_files"] = matrix_files
    if list_match is not None:
        params["list_match"] = list_match
    return params


def fat_mvm_prep_py_cargs(
    params: FatMvmPrepPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("fat_mvm_prep.py")
    cargs.extend([
        "-p",
        params.get("prefix", None)
    ])
    cargs.extend([
        "-c",
        execution.input_file(params.get("csv_file", None))
    ])
    if params.get("matrix_files", None) is not None:
        cargs.extend([
            "-m",
            params.get("matrix_files", None)
        ])
    if params.get("list_match", None) is not None:
        cargs.extend([
            "-l",
            execution.input_file(params.get("list_match", None))
        ])
    if params.get("unionize_rois", False):
        cargs.append("-u")
    if params.get("na_warn_off", False):
        cargs.append("-N")
    if params.get("extern_labels_no", False):
        cargs.append("-E")
    return cargs


def fat_mvm_prep_py_outputs(
    params: FatMvmPrepPyParameters,
    execution: Execution,
) -> FatMvmPrepPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = FatMvmPrepPyOutputs(
        root=execution.output_file("."),
        mvmtbl=execution.output_file(params.get("prefix", None) + "_MVMtbl.txt"),
        mvmprep_log=execution.output_file(params.get("prefix", None) + "_MVMprep.log"),
    )
    return ret


def fat_mvm_prep_py_execute(
    params: FatMvmPrepPyParameters,
    runner: Runner | None = None,
) -> FatMvmPrepPyOutputs:
    """
    fat_mvm_prep.py
    
    Combine FATCAT output with CSV data for statistical modeling.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `FatMvmPrepPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(FAT_MVM_PREP_PY_METADATA)
    params = execution.params(params)
    cargs = fat_mvm_prep_py_cargs(params, execution)
    ret = fat_mvm_prep_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def fat_mvm_prep_py(
    prefix: str,
    csv_file: InputPathType,
    matrix_files: str | None = None,
    list_match: InputPathType | None = None,
    unionize_rois: bool = False,
    na_warn_off: bool = False,
    extern_labels_no: bool = False,
    runner: Runner | None = None,
) -> FatMvmPrepPyOutputs:
    """
    fat_mvm_prep.py
    
    Combine FATCAT output with CSV data for statistical modeling.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        prefix: Prefix for output files.
        csv_file: Comma-separated variable (CSV) file for input.
        matrix_files: Set of matrix (*.grid or *.netcc) files by searchable\
            path.
        list_match: Text file containing two columns: path to subject matrix\
            file and CSV IDs.
        unionize_rois: Make the ROI list as the union of elements across the\
            group.
        na_warn_off: Turn off the automatic warnings as the data table is\
            created.
        extern_labels_no: Turn off the writing/usage of user-defined labels in\
            the *.grid/*.netcc files.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `FatMvmPrepPyOutputs`).
    """
    params = fat_mvm_prep_py_params(
        prefix=prefix,
        csv_file=csv_file,
        matrix_files=matrix_files,
        list_match=list_match,
        unionize_rois=unionize_rois,
        na_warn_off=na_warn_off,
        extern_labels_no=extern_labels_no,
    )
    return fat_mvm_prep_py_execute(params, runner)


__all__ = [
    "FAT_MVM_PREP_PY_METADATA",
    "FatMvmPrepPyOutputs",
    "fat_mvm_prep_py",
    "fat_mvm_prep_py_execute",
    "fat_mvm_prep_py_params",
]
