# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

FAT_MVM_SCRIPTER_PY_METADATA = Metadata(
    id="9b3bc9fd729815c1d4263ce94ba8f03463293f18.boutiques",
    name="fat_mvm_scripter.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


FatMvmScripterPyParameters = typing.TypedDict('FatMvmScripterPyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/fat_mvm_scripter.py"]],
    "prefix": str,
    "table": InputPathType,
    "log": InputPathType,
    "vars": typing.NotRequired[str | None],
    "file_vars": typing.NotRequired[InputPathType | None],
    "Pars": typing.NotRequired[str | None],
    "file_Pars": typing.NotRequired[InputPathType | None],
    "rois": typing.NotRequired[str | None],
    "file_rois": typing.NotRequired[InputPathType | None],
    "no_posthoc": bool,
    "NA_warn_off": bool,
    "subnet_pref": typing.NotRequired[str | None],
    "cat_pair_off": bool,
})
FatMvmScripterPyParametersTagged = typing.TypedDict('FatMvmScripterPyParametersTagged', {
    "@type": typing.Literal["afni/fat_mvm_scripter.py"],
    "prefix": str,
    "table": InputPathType,
    "log": InputPathType,
    "vars": typing.NotRequired[str | None],
    "file_vars": typing.NotRequired[InputPathType | None],
    "Pars": typing.NotRequired[str | None],
    "file_Pars": typing.NotRequired[InputPathType | None],
    "rois": typing.NotRequired[str | None],
    "file_rois": typing.NotRequired[InputPathType | None],
    "no_posthoc": bool,
    "NA_warn_off": bool,
    "subnet_pref": typing.NotRequired[str | None],
    "cat_pair_off": bool,
})


class FatMvmScripterPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `FatMvmScripterPyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    generated_script: OutputPathType
    """Script for running 3dMVM, using the prescribed variables along with each
    individual parameter."""
    results_file: OutputPathType
    """Text file of the test results."""


def fat_mvm_scripter_py_params(
    prefix: str,
    table: InputPathType,
    log: InputPathType,
    vars_: str | None = None,
    file_vars: InputPathType | None = None,
    pars: str | None = None,
    file_pars: InputPathType | None = None,
    rois: str | None = None,
    file_rois: InputPathType | None = None,
    no_posthoc: bool = False,
    na_warn_off: bool = False,
    subnet_pref: str | None = None,
    cat_pair_off: bool = False,
) -> FatMvmScripterPyParametersTagged:
    """
    Build parameters.
    
    Args:
        prefix: Output prefix for the script file, which will ultimately create\
            a PREFIX_MVM.txt file of statistical results from 3dMVM.
        table: Text file containing columns of subject data, one subject per\
            row, formatted as a *_MVMtbl.txt output by fat_mvm_prep.py.
        log: File formatted according to fat_mvm_prep.py containing commented\
            headings and lists of cross-group ROIs and parameters.
        vars_: List of variables for the 3dMVM model. Names must be separated\
            with whitespace. Categorical variables will be detected automatically\
            by the presence of nonnumeric characters in their columns.
        file_vars: Second method for supplying a list of variables for 3dMVM.\
            VAR_FILE is a text file with a single column of variable names.
        pars: List of parameters (names of matrices) to run in distinct 3dMVM\
            models. Names must be separated with whitespace.
        file_pars: Second method for supplying a list of parameters for 3dMVM\
            runs. PAR_FILE is a text file with a single column of parameter names.
        rois: Optional command to select a subset of available network ROIs.\
            Names must be separated with whitespace.
        file_rois: Second method for supplying a subset of ROIs for 3dMVM runs.\
            ROI_FILE is a text file with a single column of variable names.
        no_posthoc: Switch to turn off the automatic generation of per-ROI post\
            hoc tests.
        na_warn_off: Switch to turn off the automatic warnings as the data\
            table is created. 3dMVM will excise subjects with NA values, so there\
            shouldn't be NA values in columns you want to model.
        subnet_pref: Name SUBPR for the new table file that is created when a\
            subnetwork list of ROIs is used.
        cat_pair_off: Switch to turn off the test for categorical variables\
            undergoing posthoc testing.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/fat_mvm_scripter.py",
        "prefix": prefix,
        "table": table,
        "log": log,
        "no_posthoc": no_posthoc,
        "NA_warn_off": na_warn_off,
        "cat_pair_off": cat_pair_off,
    }
    if vars_ is not None:
        params["vars"] = vars_
    if file_vars is not None:
        params["file_vars"] = file_vars
    if pars is not None:
        params["Pars"] = pars
    if file_pars is not None:
        params["file_Pars"] = file_pars
    if rois is not None:
        params["rois"] = rois
    if file_rois is not None:
        params["file_rois"] = file_rois
    if subnet_pref is not None:
        params["subnet_pref"] = subnet_pref
    return params


def fat_mvm_scripter_py_cargs(
    params: FatMvmScripterPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("fat_mvm_scripter.py")
    cargs.extend([
        "--prefix",
        params.get("prefix", None)
    ])
    cargs.extend([
        "--table",
        execution.input_file(params.get("table", None))
    ])
    cargs.extend([
        "--log",
        execution.input_file(params.get("log", None))
    ])
    if params.get("vars", None) is not None:
        cargs.extend([
            "--vars",
            params.get("vars", None)
        ])
    if params.get("file_vars", None) is not None:
        cargs.extend([
            "--file_vars",
            execution.input_file(params.get("file_vars", None))
        ])
    if params.get("Pars", None) is not None:
        cargs.extend([
            "--Pars",
            params.get("Pars", None)
        ])
    if params.get("file_Pars", None) is not None:
        cargs.extend([
            "--File_Pars",
            execution.input_file(params.get("file_Pars", None))
        ])
    if params.get("rois", None) is not None:
        cargs.extend([
            "--rois",
            params.get("rois", None)
        ])
    if params.get("file_rois", None) is not None:
        cargs.extend([
            "--file_rois",
            execution.input_file(params.get("file_rois", None))
        ])
    if params.get("no_posthoc", False):
        cargs.append("--no_posthoc")
    if params.get("NA_warn_off", False):
        cargs.append("--NA_warn_off")
    if params.get("subnet_pref", None) is not None:
        cargs.extend([
            "--subnet_pref",
            params.get("subnet_pref", None)
        ])
    if params.get("cat_pair_off", False):
        cargs.append("--cat_pair_off")
    return cargs


def fat_mvm_scripter_py_outputs(
    params: FatMvmScripterPyParameters,
    execution: Execution,
) -> FatMvmScripterPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = FatMvmScripterPyOutputs(
        root=execution.output_file("."),
        generated_script=execution.output_file(params.get("prefix", None) + "_scri.tcsh"),
        results_file=execution.output_file(params.get("prefix", None) + "_MVM.txt"),
    )
    return ret


def fat_mvm_scripter_py_execute(
    params: FatMvmScripterPyParameters,
    runner: Runner | None = None,
) -> FatMvmScripterPyOutputs:
    """
    fat_mvm_scripter.py
    
    Automated tool to create command scripts for 3dMVM statistical modeling.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `FatMvmScripterPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(FAT_MVM_SCRIPTER_PY_METADATA)
    params = execution.params(params)
    cargs = fat_mvm_scripter_py_cargs(params, execution)
    ret = fat_mvm_scripter_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def fat_mvm_scripter_py(
    prefix: str,
    table: InputPathType,
    log: InputPathType,
    vars_: str | None = None,
    file_vars: InputPathType | None = None,
    pars: str | None = None,
    file_pars: InputPathType | None = None,
    rois: str | None = None,
    file_rois: InputPathType | None = None,
    no_posthoc: bool = False,
    na_warn_off: bool = False,
    subnet_pref: str | None = None,
    cat_pair_off: bool = False,
    runner: Runner | None = None,
) -> FatMvmScripterPyOutputs:
    """
    fat_mvm_scripter.py
    
    Automated tool to create command scripts for 3dMVM statistical modeling.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        prefix: Output prefix for the script file, which will ultimately create\
            a PREFIX_MVM.txt file of statistical results from 3dMVM.
        table: Text file containing columns of subject data, one subject per\
            row, formatted as a *_MVMtbl.txt output by fat_mvm_prep.py.
        log: File formatted according to fat_mvm_prep.py containing commented\
            headings and lists of cross-group ROIs and parameters.
        vars_: List of variables for the 3dMVM model. Names must be separated\
            with whitespace. Categorical variables will be detected automatically\
            by the presence of nonnumeric characters in their columns.
        file_vars: Second method for supplying a list of variables for 3dMVM.\
            VAR_FILE is a text file with a single column of variable names.
        pars: List of parameters (names of matrices) to run in distinct 3dMVM\
            models. Names must be separated with whitespace.
        file_pars: Second method for supplying a list of parameters for 3dMVM\
            runs. PAR_FILE is a text file with a single column of parameter names.
        rois: Optional command to select a subset of available network ROIs.\
            Names must be separated with whitespace.
        file_rois: Second method for supplying a subset of ROIs for 3dMVM runs.\
            ROI_FILE is a text file with a single column of variable names.
        no_posthoc: Switch to turn off the automatic generation of per-ROI post\
            hoc tests.
        na_warn_off: Switch to turn off the automatic warnings as the data\
            table is created. 3dMVM will excise subjects with NA values, so there\
            shouldn't be NA values in columns you want to model.
        subnet_pref: Name SUBPR for the new table file that is created when a\
            subnetwork list of ROIs is used.
        cat_pair_off: Switch to turn off the test for categorical variables\
            undergoing posthoc testing.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `FatMvmScripterPyOutputs`).
    """
    params = fat_mvm_scripter_py_params(
        prefix=prefix,
        table=table,
        log=log,
        vars_=vars_,
        file_vars=file_vars,
        pars=pars,
        file_pars=file_pars,
        rois=rois,
        file_rois=file_rois,
        no_posthoc=no_posthoc,
        na_warn_off=na_warn_off,
        subnet_pref=subnet_pref,
        cat_pair_off=cat_pair_off,
    )
    return fat_mvm_scripter_py_execute(params, runner)


__all__ = [
    "FAT_MVM_SCRIPTER_PY_METADATA",
    "FatMvmScripterPyOutputs",
    "fat_mvm_scripter_py",
    "fat_mvm_scripter_py_execute",
    "fat_mvm_scripter_py_params",
]
