# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

FAT_PROC_IMIT2W_FROM_T1W_METADATA = Metadata(
    id="6e4b31f9dba6fea968d8d0b43da6d2ef2dfdf294.boutiques",
    name="fat_proc_imit2w_from_t1w",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


FatProcImit2wFromT1wParameters = typing.TypedDict('FatProcImit2wFromT1wParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/fat_proc_imit2w_from_t1w"]],
    "t1_file": InputPathType,
    "prefix": str,
    "workdir": typing.NotRequired[str | None],
    "mask": typing.NotRequired[InputPathType | None],
    "ss_blur_fwhm": typing.NotRequired[float | None],
    "no_clean": bool,
    "no_qc_view": bool,
    "qc_prefix": typing.NotRequired[str | None],
})
FatProcImit2wFromT1wParametersTagged = typing.TypedDict('FatProcImit2wFromT1wParametersTagged', {
    "@type": typing.Literal["afni/fat_proc_imit2w_from_t1w"],
    "t1_file": InputPathType,
    "prefix": str,
    "workdir": typing.NotRequired[str | None],
    "mask": typing.NotRequired[InputPathType | None],
    "ss_blur_fwhm": typing.NotRequired[float | None],
    "no_clean": bool,
    "no_qc_view": bool,
    "qc_prefix": typing.NotRequired[str | None],
})


class FatProcImit2wFromT1wOutputs(typing.NamedTuple):
    """
    Output object returned when calling `FatProcImit2wFromT1wParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    t2w_contrast_volume: OutputPathType
    """Volume with T2w-like tissue contrast from T1w"""
    cleaned_t1w_volume: OutputPathType
    """Cleaned/processed version of the input T1w volume with scaled skull and
    noise outside the brain"""
    skull_stripped_t1w: OutputPathType
    """Skull-stripped version of the T1w volume"""


def fat_proc_imit2w_from_t1w_params(
    t1_file: InputPathType,
    prefix: str,
    workdir: str | None = None,
    mask: InputPathType | None = None,
    ss_blur_fwhm: float | None = None,
    no_clean: bool = False,
    no_qc_view: bool = False,
    qc_prefix: str | None = None,
) -> FatProcImit2wFromT1wParametersTagged:
    """
    Build parameters.
    
    Args:
        t1_file: Full name of the input T1w volume.
        prefix: Output prefix for files and snapshots.
        workdir: Specify a working directory, which can be removed (default:\
            __WORKING_imit2w_from_t1w).
        mask: Optional input of a pre-skullstripped T1_FILE (either mask or\
            skull-stripped volume).
        ss_blur_fwhm: Optional, add in blurring during the 3dSkullStrip part\
            (in mm, default: 2 FWHM).
        no_clean: Optional switch to NOT remove working directory\
            '__WORKING_imit2w_from_t1w' (default: remove working dir).
        no_qc_view: Turn off the automatic creation of QC montages (default:\
            on).
        qc_prefix: Change the prefix of the QC images (default: use prefix of\
            volumes).
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/fat_proc_imit2w_from_t1w",
        "t1_file": t1_file,
        "prefix": prefix,
        "no_clean": no_clean,
        "no_qc_view": no_qc_view,
    }
    if workdir is not None:
        params["workdir"] = workdir
    if mask is not None:
        params["mask"] = mask
    if ss_blur_fwhm is not None:
        params["ss_blur_fwhm"] = ss_blur_fwhm
    if qc_prefix is not None:
        params["qc_prefix"] = qc_prefix
    return params


def fat_proc_imit2w_from_t1w_cargs(
    params: FatProcImit2wFromT1wParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("fat_proc_imit2w_from_t1w")
    cargs.extend([
        "-inset",
        execution.input_file(params.get("t1_file", None))
    ])
    cargs.extend([
        "-prefix",
        params.get("prefix", None)
    ])
    if params.get("workdir", None) is not None:
        cargs.extend([
            "-workdir",
            params.get("workdir", None)
        ])
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask", None))
        ])
    if params.get("ss_blur_fwhm", None) is not None:
        cargs.extend([
            "-ss_blur_fwhm",
            str(params.get("ss_blur_fwhm", None))
        ])
    if params.get("no_clean", False):
        cargs.append("-no_clean")
    if params.get("no_qc_view", False):
        cargs.append("-no_qc_view")
    if params.get("qc_prefix", None) is not None:
        cargs.extend([
            "-qc_prefix",
            params.get("qc_prefix", None)
        ])
    return cargs


def fat_proc_imit2w_from_t1w_outputs(
    params: FatProcImit2wFromT1wParameters,
    execution: Execution,
) -> FatProcImit2wFromT1wOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = FatProcImit2wFromT1wOutputs(
        root=execution.output_file("."),
        t2w_contrast_volume=execution.output_file(params.get("prefix", None) + ".nii.gz"),
        cleaned_t1w_volume=execution.output_file(params.get("prefix", None) + "_orig.nii.gz"),
        skull_stripped_t1w=execution.output_file(params.get("prefix", None) + "_orig_ss.nii.gz"),
    )
    return ret


def fat_proc_imit2w_from_t1w_execute(
    params: FatProcImit2wFromT1wParameters,
    runner: Runner | None = None,
) -> FatProcImit2wFromT1wOutputs:
    """
    fat_proc_imit2w_from_t1w
    
    Process T1w anatomical images to generate an imitation T2w-contrast image.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `FatProcImit2wFromT1wOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(FAT_PROC_IMIT2W_FROM_T1W_METADATA)
    params = execution.params(params)
    cargs = fat_proc_imit2w_from_t1w_cargs(params, execution)
    ret = fat_proc_imit2w_from_t1w_outputs(params, execution)
    execution.run(cargs)
    return ret


def fat_proc_imit2w_from_t1w(
    t1_file: InputPathType,
    prefix: str,
    workdir: str | None = None,
    mask: InputPathType | None = None,
    ss_blur_fwhm: float | None = None,
    no_clean: bool = False,
    no_qc_view: bool = False,
    qc_prefix: str | None = None,
    runner: Runner | None = None,
) -> FatProcImit2wFromT1wOutputs:
    """
    fat_proc_imit2w_from_t1w
    
    Process T1w anatomical images to generate an imitation T2w-contrast image.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        t1_file: Full name of the input T1w volume.
        prefix: Output prefix for files and snapshots.
        workdir: Specify a working directory, which can be removed (default:\
            __WORKING_imit2w_from_t1w).
        mask: Optional input of a pre-skullstripped T1_FILE (either mask or\
            skull-stripped volume).
        ss_blur_fwhm: Optional, add in blurring during the 3dSkullStrip part\
            (in mm, default: 2 FWHM).
        no_clean: Optional switch to NOT remove working directory\
            '__WORKING_imit2w_from_t1w' (default: remove working dir).
        no_qc_view: Turn off the automatic creation of QC montages (default:\
            on).
        qc_prefix: Change the prefix of the QC images (default: use prefix of\
            volumes).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `FatProcImit2wFromT1wOutputs`).
    """
    params = fat_proc_imit2w_from_t1w_params(
        t1_file=t1_file,
        prefix=prefix,
        workdir=workdir,
        mask=mask,
        ss_blur_fwhm=ss_blur_fwhm,
        no_clean=no_clean,
        no_qc_view=no_qc_view,
        qc_prefix=qc_prefix,
    )
    return fat_proc_imit2w_from_t1w_execute(params, runner)


__all__ = [
    "FAT_PROC_IMIT2W_FROM_T1W_METADATA",
    "FatProcImit2wFromT1wOutputs",
    "fat_proc_imit2w_from_t1w",
    "fat_proc_imit2w_from_t1w_execute",
    "fat_proc_imit2w_from_t1w_params",
]
