# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

FAT_ROI_ROW_PY_METADATA = Metadata(
    id="962a18899af088da3ff1ac68aa693ceff0dc586c.boutiques",
    name="fat_roi_row.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


FatRoiRowPyParameters = typing.TypedDict('FatRoiRowPyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/fat_roi_row.py"]],
    "roi": str,
    "matrix_files": typing.NotRequired[str | None],
    "list_file": typing.NotRequired[InputPathType | None],
    "extern_labs_no": bool,
})
FatRoiRowPyParametersTagged = typing.TypedDict('FatRoiRowPyParametersTagged', {
    "@type": typing.Literal["afni/fat_roi_row.py"],
    "roi": str,
    "matrix_files": typing.NotRequired[str | None],
    "list_file": typing.NotRequired[InputPathType | None],
    "extern_labs_no": bool,
})


class FatRoiRowPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `FatRoiRowPyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType
    """Selected ROI row output file in .row format."""


def fat_roi_row_py_params(
    roi: str,
    matrix_files: str | None = None,
    list_file: InputPathType | None = None,
    extern_labs_no: bool = False,
) -> FatRoiRowPyParametersTagged:
    """
    Build parameters.
    
    Args:
        roi: Specify which ROI's row of connectivity you want to select out. If\
            labeltables were used, you may select the ROI by either the string\
            label or the ROI mask number.
        matrix_files: Provide the set of matrix (*.grid or *.netcc) files by\
            searchable path. This can be a globbable entry in quotes containing\
            wildcard characters.
        list_file: Provide the set of matrix (*.grid or *.netcc) files by\
            explicit path in a text file. The LIST text file must contain at least\
            one column with the path to subject matrix file.
        extern_labs_no: Switch to turn off the writing/usage of user-defined\
            labels in the *.grid/*.netcc files.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/fat_roi_row.py",
        "roi": roi,
        "extern_labs_no": extern_labs_no,
    }
    if matrix_files is not None:
        params["matrix_files"] = matrix_files
    if list_file is not None:
        params["list_file"] = list_file
    return params


def fat_roi_row_py_cargs(
    params: FatRoiRowPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("fat_roi_row.py")
    cargs.extend([
        "-r",
        params.get("roi", None)
    ])
    if params.get("matrix_files", None) is not None:
        cargs.extend([
            "-m",
            params.get("matrix_files", None)
        ])
    if params.get("list_file", None) is not None:
        cargs.extend([
            "-l",
            execution.input_file(params.get("list_file", None))
        ])
    if params.get("extern_labs_no", False):
        cargs.append("-E")
    return cargs


def fat_roi_row_py_outputs(
    params: FatRoiRowPyParameters,
    execution: Execution,
) -> FatRoiRowPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = FatRoiRowPyOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file(params.get("roi", None) + "_selected.row"),
    )
    return ret


def fat_roi_row_py_execute(
    params: FatRoiRowPyParameters,
    runner: Runner | None = None,
) -> FatRoiRowPyOutputs:
    """
    fat_roi_row.py
    
    Select a single ROI's row out of a connectivity matrix file (*.grid or
    *.netcc) for viewing and/or further analysis.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `FatRoiRowPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(FAT_ROI_ROW_PY_METADATA)
    params = execution.params(params)
    cargs = fat_roi_row_py_cargs(params, execution)
    ret = fat_roi_row_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def fat_roi_row_py(
    roi: str,
    matrix_files: str | None = None,
    list_file: InputPathType | None = None,
    extern_labs_no: bool = False,
    runner: Runner | None = None,
) -> FatRoiRowPyOutputs:
    """
    fat_roi_row.py
    
    Select a single ROI's row out of a connectivity matrix file (*.grid or
    *.netcc) for viewing and/or further analysis.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        roi: Specify which ROI's row of connectivity you want to select out. If\
            labeltables were used, you may select the ROI by either the string\
            label or the ROI mask number.
        matrix_files: Provide the set of matrix (*.grid or *.netcc) files by\
            searchable path. This can be a globbable entry in quotes containing\
            wildcard characters.
        list_file: Provide the set of matrix (*.grid or *.netcc) files by\
            explicit path in a text file. The LIST text file must contain at least\
            one column with the path to subject matrix file.
        extern_labs_no: Switch to turn off the writing/usage of user-defined\
            labels in the *.grid/*.netcc files.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `FatRoiRowPyOutputs`).
    """
    params = fat_roi_row_py_params(
        roi=roi,
        matrix_files=matrix_files,
        list_file=list_file,
        extern_labs_no=extern_labs_no,
    )
    return fat_roi_row_py_execute(params, runner)


__all__ = [
    "FAT_ROI_ROW_PY_METADATA",
    "FatRoiRowPyOutputs",
    "fat_roi_row_py",
    "fat_roi_row_py_execute",
    "fat_roi_row_py_params",
]
