# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

FATCAT_MATPLOT_METADATA = Metadata(
    id="ea9e34c417e4d60f8cb488d20b44ee9b288b0053.boutiques",
    name="FATCAT_matplot",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


FatcatMatplotParameters = typing.TypedDict('FatcatMatplotParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/FATCAT_matplot"]],
    "directory": str,
    "shiny_folder": bool,
})
FatcatMatplotParametersTagged = typing.TypedDict('FatcatMatplotParametersTagged', {
    "@type": typing.Literal["afni/FATCAT_matplot"],
    "directory": str,
    "shiny_folder": bool,
})


class FatcatMatplotOutputs(typing.NamedTuple):
    """
    Output object returned when calling `FatcatMatplotParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def fatcat_matplot_params(
    directory: str,
    shiny_folder: bool = False,
) -> FatcatMatplotParametersTagged:
    """
    Build parameters.
    
    Args:
        directory: Path to a folder containing .netcc and/or .grid files.
        shiny_folder: Use a custom shiny folder (for testing purposes).
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/FATCAT_matplot",
        "directory": directory,
        "shiny_folder": shiny_folder,
    }
    return params


def fatcat_matplot_cargs(
    params: FatcatMatplotParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("FATCAT_matplot")
    cargs.append(params.get("directory", None))
    if params.get("shiny_folder", False):
        cargs.append("-ShinyFolder")
    return cargs


def fatcat_matplot_outputs(
    params: FatcatMatplotParameters,
    execution: Execution,
) -> FatcatMatplotOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = FatcatMatplotOutputs(
        root=execution.output_file("."),
    )
    return ret


def fatcat_matplot_execute(
    params: FatcatMatplotParameters,
    runner: Runner | None = None,
) -> FatcatMatplotOutputs:
    """
    FATCAT_matplot
    
    Launch a shiny app to visualize .netcc and/or .grid files.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `FatcatMatplotOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(FATCAT_MATPLOT_METADATA)
    params = execution.params(params)
    cargs = fatcat_matplot_cargs(params, execution)
    ret = fatcat_matplot_outputs(params, execution)
    execution.run(cargs)
    return ret


def fatcat_matplot(
    directory: str,
    shiny_folder: bool = False,
    runner: Runner | None = None,
) -> FatcatMatplotOutputs:
    """
    FATCAT_matplot
    
    Launch a shiny app to visualize .netcc and/or .grid files.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        directory: Path to a folder containing .netcc and/or .grid files.
        shiny_folder: Use a custom shiny folder (for testing purposes).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `FatcatMatplotOutputs`).
    """
    params = fatcat_matplot_params(
        directory=directory,
        shiny_folder=shiny_folder,
    )
    return fatcat_matplot_execute(params, runner)


__all__ = [
    "FATCAT_MATPLOT_METADATA",
    "FatcatMatplotOutputs",
    "fatcat_matplot",
    "fatcat_matplot_execute",
    "fatcat_matplot_params",
]
